/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Aspects;
import imagescience.image.Axes;
import imagescience.image.Borders;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.transform.Prefilter;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Rotate {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int CUBIC = 2;
    public static final int BSPLINE3 = 3;
    public static final int OMOMS3 = 4;
    public static final int BSPLINE5 = 5;
    public double background = 0.0;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private final Prefilter prefilter = new Prefilter();
    private Dimensions idims;
    private Dimensions odims;
    private int imaxx;
    private int imaxy;
    private int imaxz;
    private int interpolation;
    private double ixc;
    private double iyc;
    private double izc;
    private double ivx;
    private double ivy;
    private double ivz;
    private double oxc;
    private double oyc;
    private double ozc;
    private double ovx;
    private double ovy;
    private double ovz;
    private double zangle;
    private double yangle;
    private double xangle;
    private double cosax;
    private double sinax;
    private double cosay;
    private double sinay;
    private double cosaz;
    private double sinaz;
    private double invxx;
    private double invxy;
    private double invxz;
    private double invyx;
    private double invyy;
    private double invyz;
    private double invzx;
    private double invzy;
    private double invzz;
    private Borders borders;
    private boolean antialias;
    private String component = "";
    private static final double D1O2 = 0.5;
    private static final double D1O4 = 0.25;
    private static final double D1O6 = 0.16666666666666666;
    private static final double D1O12 = 0.08333333333333333;
    private static final double D1O14 = 0.07142857142857142;
    private static final double D1O24 = 0.041666666666666664;
    private static final double D1O42 = 0.023809523809523808;
    private static final double D1O120 = 0.008333333333333333;
    private static final double D2O3 = 0.6666666666666666;
    private static final double D3O2 = 1.5;
    private static final double D5O2 = 2.5;
    private static final double D11O20 = 0.55;
    private static final double D13O21 = 0.6190476190476191;
    private static final double DM1O2 = -0.5;
    private static final double BSPLINE3X0 = 0.666666666667;
    private static final double BSPLINE5X0 = 0.55;
    private static final double OMOMS3X0 = 0.619047619048;

    public synchronized Image run(Image image, double d, double d2, double d3, int n, boolean bl, boolean bl2, boolean bl3) {
        this.messenger.log(ImageScience.prelude() + "Rotate");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.initialize(image, d, d2, d3, n, bl, bl2, bl3);
        this.messenger.log("Rotating " + image.type());
        Image image2 = null;
        if (image instanceof ColorImage) {
            this.messenger.log("Processing RGB-color components separately");
            ColorImage colorImage = (ColorImage)image;
            this.progressor.range(0.0, 0.33);
            this.component = " red component";
            this.messenger.log("Rotating" + this.component);
            colorImage.component(1);
            Image image3 = colorImage.get();
            image3 = this.rotate(image3);
            ColorImage colorImage2 = new ColorImage(image3.dimensions());
            colorImage2.component(1);
            colorImage2.set(image3);
            this.progressor.range(0.33, 0.67);
            this.component = " green component";
            this.messenger.log("Rotating" + this.component);
            colorImage.component(2);
            image3 = colorImage.get();
            image3 = this.rotate(image3);
            colorImage2.component(2);
            colorImage2.set(image3);
            this.progressor.range(0.67, 1.0);
            this.component = " blue component";
            this.messenger.log("Rotating" + this.component);
            colorImage.component(3);
            image3 = colorImage.get();
            image3 = this.rotate(image3);
            colorImage2.component(3);
            colorImage2.set(image3);
            image2 = colorImage2;
        } else {
            this.component = "";
            this.progressor.range(0.0, 1.0);
            image2 = this.rotate(image);
        }
        image2.name(image.name() + " rotated");
        image2.aspects(new Aspects(this.ovx, this.ovy, this.ovz, image.aspects().t, image.aspects().c));
        timer.stop();
        return image2;
    }

    private Image rotate(Image image) {
        boolean bl;
        boolean bl2 = this.xangle == 0.0;
        boolean bl3 = this.yangle == 0.0;
        boolean bl4 = this.zangle == 0.0;
        boolean bl5 = this.ovx == this.ivx;
        boolean bl6 = this.ovy == this.ivy;
        boolean bl7 = bl = this.ovz == this.ivz;
        if (bl2 && bl3 && bl4 && bl5 && bl6 && bl) {
            this.messenger.log("No interpolation is needed");
            this.messenger.log("Returning a copy of the input image");
            return image.duplicate();
        }
        Image image2 = image;
        if (this.interpolation == 1 || this.interpolation == 2) {
            this.messenger.log("Creating bordered copy of input image");
            image2 = image.border(this.borders);
        } else if (this.interpolation == 3 || this.interpolation == 4 || this.interpolation == 5) {
            this.messenger.log("Creating bordered floating-point copy of input image");
            image2 = new FloatImage(image, this.borders);
        }
        this.messenger.log("Allocating memory for output image");
        Image image3 = Image.create(this.odims, image.type());
        switch (this.interpolation) {
            case 0: {
                if (bl2 && bl3 && bl) {
                    this.rotate_nearest_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_nearest_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_nearest_x(image2, image3);
                    break;
                }
                this.rotate_nearest_zyx(image2, image3);
                break;
            }
            case 1: {
                if (bl2 && bl3 && bl) {
                    this.rotate_linear_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_linear_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_linear_x(image2, image3);
                    break;
                }
                this.rotate_linear_zyx(image2, image3);
                break;
            }
            case 2: {
                if (bl2 && bl3 && bl) {
                    this.rotate_cubic_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_cubic_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_cubic_x(image2, image3);
                    break;
                }
                this.rotate_cubic_zyx(image2, image3);
                break;
            }
            case 3: {
                if (bl2 && bl3 && bl) {
                    this.rotate_bspline3_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_bspline3_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_bspline3_x(image2, image3);
                    break;
                }
                this.rotate_bspline3_zyx(image2, image3);
                break;
            }
            case 4: {
                if (bl2 && bl3 && bl) {
                    this.rotate_omoms3_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_omoms3_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_omoms3_x(image2, image3);
                    break;
                }
                this.rotate_omoms3_zyx(image2, image3);
                break;
            }
            case 5: {
                if (bl2 && bl3 && bl) {
                    this.rotate_bspline5_z(image2, image3);
                    break;
                }
                if (bl2 && bl4 && bl6) {
                    this.rotate_bspline5_y(image2, image3);
                    break;
                }
                if (bl3 && bl4 && bl5) {
                    this.rotate_bspline5_x(image2, image3);
                    break;
                }
                this.rotate_bspline5_zyx(image2, image3);
            }
        }
        return image3;
    }

    private void initialize(Image image, double d, double d2, double d3, int n, boolean bl, boolean bl2, boolean bl3) {
        double d4;
        this.zangle = d;
        this.yangle = d2;
        this.xangle = d3;
        this.messenger.log("Rotation angle around z-axes: " + d);
        this.messenger.log("Rotation angle around y-axes: " + d2);
        this.messenger.log("Rotation angle around x-axes: " + d3);
        this.ovx = this.ivx = image.aspects().x;
        this.ovy = this.ivy = image.aspects().y;
        this.ovz = this.ivz = image.aspects().z;
        if (this.ivx <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (this.ivy <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (this.ivz <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        if (bl2) {
            d4 = this.ivx < this.ivy ? this.ivx : this.ivy;
            this.ovy = this.ovz = (d4 = this.ivz < d4 ? this.ivz : d4);
            this.ovx = this.ovz;
        }
        this.idims = image.dimensions();
        this.imaxx = this.idims.x - 1;
        this.imaxy = this.idims.y - 1;
        this.imaxz = this.idims.z - 1;
        this.ixc = 0.5 * this.ivx * (double)this.imaxx;
        this.iyc = 0.5 * this.ivy * (double)this.imaxy;
        this.izc = 0.5 * this.ivz * (double)this.imaxz;
        d4 = d3 * Math.PI / 180.0;
        double d5 = d2 * Math.PI / 180.0;
        double d6 = d * Math.PI / 180.0;
        this.cosax = Math.cos(d4);
        this.sinax = Math.sin(d4);
        this.cosay = Math.cos(d5);
        this.sinay = Math.sin(d5);
        this.cosaz = Math.cos(d6);
        this.sinaz = Math.sin(d6);
        this.invxx = this.cosay * this.cosaz;
        this.invxy = this.cosaz * this.sinax * this.sinay + this.cosax * this.sinaz;
        this.invxz = -this.cosax * this.cosaz * this.sinay + this.sinax * this.sinaz;
        this.invyx = -this.cosay * this.sinaz;
        this.invyy = this.cosax * this.cosaz - this.sinax * this.sinay * this.sinaz;
        this.invyz = this.cosaz * this.sinax + this.cosax * this.sinay * this.sinaz;
        this.invzx = this.sinay;
        this.invzy = -this.cosay * this.sinax;
        this.invzz = this.cosax * this.cosay;
        double d7 = -0.5 * this.ovx;
        double d8 = -0.5 * this.ovy;
        double d9 = -0.5 * this.ovz;
        double d10 = ((double)this.imaxx + 0.5) * this.ovx;
        double d11 = ((double)this.imaxy + 0.5) * this.ovy;
        double d12 = ((double)this.imaxz + 0.5) * this.ovz;
        if (bl) {
            this.messenger.log("Adjusting output image dimensions to fit result");
            double d13 = -this.ixc - 0.5 * this.ivx;
            double d14 = -this.iyc - 0.5 * this.ivy;
            double d15 = -this.izc - 0.5 * this.ivz;
            double d16 = -d13;
            double d17 = d14;
            double d18 = d15;
            double d19 = d13;
            double d20 = -d14;
            double d21 = d15;
            double d22 = -d13;
            double d23 = -d14;
            double d24 = d15;
            double d25 = d13;
            double d26 = d14;
            double d27 = -d15;
            double d28 = -d13;
            double d29 = d14;
            double d30 = -d15;
            double d31 = d13;
            double d32 = -d14;
            double d33 = -d15;
            double d34 = -d13;
            double d35 = -d14;
            double d36 = -d15;
            double d37 = this.cosay * this.cosaz;
            double d38 = -this.cosay * this.sinaz;
            double d39 = this.sinay;
            double d40 = this.cosaz * this.sinax * this.sinay + this.cosax * this.sinaz;
            double d41 = this.cosax * this.cosaz - this.sinax * this.sinay * this.sinaz;
            double d42 = -this.cosay * this.sinax;
            double d43 = -this.cosax * this.cosaz * this.sinay + this.sinax * this.sinaz;
            double d44 = this.cosaz * this.sinax + this.cosax * this.sinay * this.sinaz;
            double d45 = this.cosax * this.cosay;
            double d46 = d13 * d37 + d14 * d38 + d15 * d39;
            double d47 = d13 * d40 + d14 * d41 + d15 * d42;
            double d48 = d13 * d43 + d14 * d44 + d15 * d45;
            double d49 = d16 * d37 + d17 * d38 + d18 * d39;
            double d50 = d16 * d40 + d17 * d41 + d18 * d42;
            double d51 = d16 * d43 + d17 * d44 + d18 * d45;
            double d52 = d19 * d37 + d20 * d38 + d21 * d39;
            double d53 = d19 * d40 + d20 * d41 + d21 * d42;
            double d54 = d19 * d43 + d20 * d44 + d21 * d45;
            double d55 = d22 * d37 + d23 * d38 + d24 * d39;
            double d56 = d22 * d40 + d23 * d41 + d24 * d42;
            double d57 = d22 * d43 + d23 * d44 + d24 * d45;
            double d58 = d25 * d37 + d26 * d38 + d27 * d39;
            double d59 = d25 * d40 + d26 * d41 + d27 * d42;
            double d60 = d25 * d43 + d26 * d44 + d27 * d45;
            double d61 = d28 * d37 + d29 * d38 + d30 * d39;
            double d62 = d28 * d40 + d29 * d41 + d30 * d42;
            double d63 = d28 * d43 + d29 * d44 + d30 * d45;
            double d64 = d31 * d37 + d32 * d38 + d33 * d39;
            double d65 = d31 * d40 + d32 * d41 + d33 * d42;
            double d66 = d31 * d43 + d32 * d44 + d33 * d45;
            double d67 = d34 * d37 + d35 * d38 + d36 * d39;
            double d68 = d34 * d40 + d35 * d41 + d36 * d42;
            double d69 = d34 * d43 + d35 * d44 + d36 * d45;
            d7 = FMath.min(d46, d49, d52, d55, d58, d61, d64, d67);
            d8 = FMath.min(d47, d50, d53, d56, d59, d62, d65, d68);
            d9 = FMath.min(d48, d51, d54, d57, d60, d63, d66, d69);
            d10 = FMath.max(d46, d49, d52, d55, d58, d61, d64, d67);
            d11 = FMath.max(d47, d50, d53, d56, d59, d62, d65, d68);
            d12 = FMath.max(d48, d51, d54, d57, d60, d63, d66, d69);
        } else {
            this.messenger.log("Not adjusting image dimensions");
        }
        this.odims = new Dimensions(FMath.round((d10 - d7) / this.ovx), FMath.round((d11 - d8) / this.ovy), FMath.round((d12 - d9) / this.ovz), this.idims.t, this.idims.c);
        this.oxc = 0.5 * this.ovx * (double)(this.odims.x - 1);
        this.oyc = 0.5 * this.ovy * (double)(this.odims.y - 1);
        this.ozc = 0.5 * this.ovz * (double)(this.odims.z - 1);
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + this.idims.x + "," + this.idims.y + "," + this.idims.z + "," + this.idims.t + "," + this.idims.c + ")");
        this.messenger.log("Output image dimensions: (x,y,z,t,c) = (" + this.odims.x + "," + this.odims.y + "," + this.odims.z + "," + this.odims.t + "," + this.odims.c + ")");
        this.messenger.log("Resampling output image on " + (bl2 ? "isotropic" : "input") + " grid");
        this.messenger.log("Input voxel dimensions: (x,y,z) = (" + this.ivx + "," + this.ivy + "," + this.ivz + ")");
        this.messenger.log("Output voxel dimensions: (x,y,z) = (" + this.ovx + "," + this.ovy + "," + this.ovz + ")");
        this.antialias = bl3;
        if (bl3) {
            this.messenger.log("Anti-aliasing image-background transitions");
        }
        this.messenger.log("Selecting " + this.schemes(n));
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Non-supported interpolation scheme");
        }
        this.interpolation = n;
        this.messenger.log("Background filling with value " + this.background);
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
            }
        }
        this.borders = d3 == 0.0 && d2 == 0.0 && this.ovz == this.ivz ? new Borders(n2, n2, 0) : (d3 == 0.0 && d == 0.0 && this.ovy == this.ivy ? new Borders(n2, 0, n2) : (d2 == 0.0 && d == 0.0 && this.ovx == this.ivx ? new Borders(0, n2, n2) : new Borders(n2, n2, n2)));
    }

    private void rotate_nearest_z(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            coordinates.x = FMath.round((d2 + d4 * this.cosaz) / this.ivx);
                            coordinates.y = FMath.round((d3 - d4 * this.sinaz) / this.ivy);
                            dArray[i] = coordinates.x < 0 || coordinates.x > this.imaxx || coordinates.y < 0 || coordinates.y > this.imaxy ? this.background : image.get(coordinates);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_nearest_y(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            coordinates.x = FMath.round((d2 + d4 * this.cosay) / this.ivx);
                            coordinates.z = FMath.round((d3 + d4 * this.sinay) / this.ivz);
                            dArray[i] = coordinates.x < 0 || coordinates.x > this.imaxx || coordinates.z < 0 || coordinates.z > this.imaxz ? this.background : image.get(coordinates);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_nearest_x(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        int n;
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        coordinates.y = FMath.round((d2 + d4 * this.cosax) / this.ivy);
                        coordinates.z = FMath.round((d3 - d4 * this.sinax) / this.ivz);
                        coordinates.x = 0;
                        if (coordinates.y < 0 || coordinates.y > this.imaxy || coordinates.z < 0 || coordinates.z > this.imaxz) {
                            for (n = 0; n < this.odims.x; ++n) {
                                dArray[n] = this.background;
                            }
                        } else {
                            n = 0;
                            while (n < this.odims.x) {
                                dArray[n] = image.get(coordinates);
                                ++n;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_nearest_zyx(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            coordinates.x = FMath.round((d6 + d9 * this.invxx) / this.ivx);
                            coordinates.y = FMath.round((d7 + d9 * this.invyx) / this.ivy);
                            coordinates.z = FMath.round((d8 + d9 * this.invzx) / this.ivz);
                            dArray[i] = coordinates.x < 0 || coordinates.x > this.imaxx || coordinates.y < 0 || coordinates.y > this.imaxy || coordinates.z < 0 || coordinates.z > this.imaxz ? this.background : image.get(coordinates);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_linear_z(Image image, Image image2) {
        this.messenger.log("Linear sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosaz) / this.ivx;
                            double d6 = (d3 - d4 * this.sinaz) / this.ivy;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = d6 - (double)n2;
                            double d9 = 1.0 - d7;
                            double d10 = 1.0 - d8;
                            coordinates.x = this.borders.x + n;
                            coordinates.y = this.borders.y + n2;
                            double d11 = image.get(coordinates);
                            ++coordinates.x;
                            double d12 = image.get(coordinates);
                            ++coordinates.y;
                            double d13 = image.get(coordinates);
                            --coordinates.x;
                            double d14 = image.get(coordinates);
                            dArray[i] = d10 * d9 * d11 + d10 * d7 * d12 + d8 * d9 * d14 + d8 * d7 * d13;
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_linear_y(Image image, Image image2) {
        this.messenger.log("Linear sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosay) / this.ivx;
                            double d6 = (d3 + d4 * this.sinay) / this.ivz;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = d6 - (double)n2;
                            double d9 = 1.0 - d7;
                            double d10 = 1.0 - d8;
                            coordinates.x = this.borders.x + n;
                            coordinates.z = this.borders.z + n2;
                            double d11 = image.get(coordinates);
                            ++coordinates.x;
                            double d12 = image.get(coordinates);
                            ++coordinates.z;
                            double d13 = image.get(coordinates);
                            --coordinates.x;
                            double d14 = image.get(coordinates);
                            dArray[i] = d10 * d9 * d11 + d10 * d7 * d12 + d8 * d9 * d14 + d8 * d7 * d13;
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_linear_x(Image image, Image image2) {
        this.messenger.log("Linear sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d5 = (d2 + d4 * this.cosax) / this.ivy;
                        double d6 = (d3 - d4 * this.sinax) / this.ivz;
                        int n = FMath.floor(d5);
                        int n2 = FMath.floor(d6);
                        if (n < -1 || n > this.imaxy || n2 < -1 || n2 > this.imaxz) {
                            for (int i = 0; i < this.odims.x; ++i) {
                                dArray[i] = this.background;
                            }
                        } else {
                            double d7 = d5 - (double)n;
                            double d8 = d6 - (double)n2;
                            double d9 = 1.0 - d7;
                            double d10 = 1.0 - d8;
                            coordinates.y = this.borders.y + n;
                            coordinates.z = this.borders.z + n2;
                            coordinates.x = 0;
                            int n3 = 0;
                            while (n3 < this.odims.x) {
                                double d11 = image.get(coordinates);
                                ++coordinates.y;
                                double d12 = image.get(coordinates);
                                ++coordinates.z;
                                double d13 = image.get(coordinates);
                                --coordinates.y;
                                double d14 = image.get(coordinates);
                                --coordinates.z;
                                dArray[n3] = d10 * d9 * d11 + d10 * d7 * d12 + d8 * d9 * d14 + d8 * d7 * d13;
                                ++n3;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_linear_zyx(Image image, Image image2) {
        this.messenger.log("Linear sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            double d10 = (d6 + d9 * this.invxx) / this.ivx;
                            double d11 = (d7 + d9 * this.invyx) / this.ivy;
                            double d12 = (d8 + d9 * this.invzx) / this.ivz;
                            int n = FMath.floor(d10);
                            int n2 = FMath.floor(d11);
                            int n3 = FMath.floor(d12);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy || n3 < -1 || n3 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d13 = d10 - (double)n;
                            double d14 = d11 - (double)n2;
                            double d15 = d12 - (double)n3;
                            double d16 = 1.0 - d13;
                            double d17 = 1.0 - d14;
                            double d18 = 1.0 - d15;
                            coordinates.x = this.borders.x + n;
                            coordinates.y = this.borders.y + n2;
                            coordinates.z = this.borders.z + n3;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.y;
                            double d21 = image.get(coordinates);
                            --coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.z;
                            double d23 = image.get(coordinates);
                            ++coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.y;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            dArray[i] = d18 * d17 * d16 * d19 + d18 * d17 * d13 * d20 + d18 * d14 * d16 * d22 + d18 * d14 * d13 * d21 + d15 * d17 * d16 * d26 + d15 * d17 * d13 * d25 + d15 * d14 * d16 * d23 + d15 * d14 * d13 * d24;
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_cubic_z(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosaz) / this.ivx;
                            double d6 = (d3 - d4 * this.sinaz) / this.ivy;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = -0.5 * d7 * d8 * d8;
                            double d10 = 1.0 + (1.5 * d7 - 2.5) * d7 * d7;
                            double d11 = 1.0 + (1.5 * d8 - 2.5) * d8 * d8;
                            double d12 = -0.5 * d8 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = -0.5 * d13 * d14 * d14;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = 1.0 + (1.5 * d14 - 2.5) * d14 * d14;
                            double d18 = -0.5 * d14 * d13 * d13;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.y;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.y;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.y;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_cubic_y(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosay) / this.ivx;
                            double d6 = (d3 + d4 * this.sinay) / this.ivz;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = -0.5 * d7 * d8 * d8;
                            double d10 = 1.0 + (1.5 * d7 - 2.5) * d7 * d7;
                            double d11 = 1.0 + (1.5 * d8 - 2.5) * d8 * d8;
                            double d12 = -0.5 * d8 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = -0.5 * d13 * d14 * d14;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = 1.0 + (1.5 * d14 - 2.5) * d14 * d14;
                            double d18 = -0.5 * d14 * d13 * d13;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.z;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.z;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.z;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_cubic_x(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d5 = (d2 + d4 * this.cosax) / this.ivy;
                        double d6 = (d3 - d4 * this.sinax) / this.ivz;
                        int n = FMath.floor(d5);
                        int n2 = FMath.floor(d6);
                        if (n < -1 || n > this.imaxy || n2 < -1 || n2 > this.imaxz) {
                            for (int i = 0; i < this.odims.x; ++i) {
                                dArray[i] = this.background;
                            }
                        } else {
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = -0.5 * d7 * d8 * d8;
                            double d10 = 1.0 + (1.5 * d7 - 2.5) * d7 * d7;
                            double d11 = 1.0 + (1.5 * d8 - 2.5) * d8 * d8;
                            double d12 = -0.5 * d8 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = -0.5 * d13 * d14 * d14;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = 1.0 + (1.5 * d14 - 2.5) * d14 * d14;
                            double d18 = -0.5 * d14 * d13 * d13;
                            coordinates.y = this.borders.y + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            coordinates.x = 0;
                            int n3 = 0;
                            while (n3 < this.odims.x) {
                                double d19 = image.get(coordinates);
                                ++coordinates.y;
                                double d20 = image.get(coordinates);
                                ++coordinates.y;
                                double d21 = image.get(coordinates);
                                ++coordinates.y;
                                double d22 = image.get(coordinates);
                                ++coordinates.z;
                                double d23 = image.get(coordinates);
                                --coordinates.y;
                                double d24 = image.get(coordinates);
                                --coordinates.y;
                                double d25 = image.get(coordinates);
                                --coordinates.y;
                                double d26 = image.get(coordinates);
                                ++coordinates.z;
                                double d27 = image.get(coordinates);
                                ++coordinates.y;
                                double d28 = image.get(coordinates);
                                ++coordinates.y;
                                double d29 = image.get(coordinates);
                                ++coordinates.y;
                                double d30 = image.get(coordinates);
                                ++coordinates.z;
                                double d31 = image.get(coordinates);
                                --coordinates.y;
                                double d32 = image.get(coordinates);
                                --coordinates.y;
                                double d33 = image.get(coordinates);
                                --coordinates.y;
                                double d34 = image.get(coordinates);
                                coordinates.z -= 3;
                                dArray[n3] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                                ++n3;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_cubic_zyx(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            double d10 = (d6 + d9 * this.invxx) / this.ivx;
                            double d11 = (d7 + d9 * this.invyx) / this.ivy;
                            double d12 = (d8 + d9 * this.invzx) / this.ivz;
                            int n = FMath.floor(d10);
                            int n2 = FMath.floor(d11);
                            int n3 = FMath.floor(d12);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy || n3 < -1 || n3 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d13 = d10 - (double)n;
                            double d14 = 1.0 - d13;
                            double d15 = -0.5 * d13 * d14 * d14;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = 1.0 + (1.5 * d14 - 2.5) * d14 * d14;
                            double d18 = -0.5 * d14 * d13 * d13;
                            double d19 = d11 - (double)n2;
                            double d20 = 1.0 - d19;
                            double d21 = -0.5 * d19 * d20 * d20;
                            double d22 = 1.0 + (1.5 * d19 - 2.5) * d19 * d19;
                            double d23 = 1.0 + (1.5 * d20 - 2.5) * d20 * d20;
                            double d24 = -0.5 * d20 * d19 * d19;
                            double d25 = d12 - (double)n3;
                            double d26 = 1.0 - d25;
                            double d27 = -0.5 * d25 * d26 * d26;
                            double d28 = 1.0 + (1.5 * d25 - 2.5) * d25 * d25;
                            double d29 = 1.0 + (1.5 * d26 - 2.5) * d26 * d26;
                            double d30 = -0.5 * d26 * d25 * d25;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d31 = image.get(coordinates);
                            ++coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.x;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.y;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            ++coordinates.y;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.y;
                            double d43 = image.get(coordinates);
                            --coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.x;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            ++coordinates.z;
                            double d47 = image.get(coordinates);
                            ++coordinates.x;
                            double d48 = image.get(coordinates);
                            ++coordinates.x;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            --coordinates.y;
                            double d51 = image.get(coordinates);
                            --coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.x;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.y;
                            double d55 = image.get(coordinates);
                            ++coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.x;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.y;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            ++coordinates.z;
                            double d63 = image.get(coordinates);
                            ++coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.x;
                            double d65 = image.get(coordinates);
                            ++coordinates.x;
                            double d66 = image.get(coordinates);
                            ++coordinates.y;
                            double d67 = image.get(coordinates);
                            --coordinates.x;
                            double d68 = image.get(coordinates);
                            --coordinates.x;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            ++coordinates.y;
                            double d71 = image.get(coordinates);
                            ++coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.x;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.y;
                            double d75 = image.get(coordinates);
                            --coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.x;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            ++coordinates.z;
                            double d79 = image.get(coordinates);
                            ++coordinates.x;
                            double d80 = image.get(coordinates);
                            ++coordinates.x;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            --coordinates.y;
                            double d83 = image.get(coordinates);
                            --coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.x;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.y;
                            double d87 = image.get(coordinates);
                            ++coordinates.x;
                            double d88 = image.get(coordinates);
                            ++coordinates.x;
                            double d89 = image.get(coordinates);
                            ++coordinates.x;
                            double d90 = image.get(coordinates);
                            --coordinates.y;
                            double d91 = image.get(coordinates);
                            --coordinates.x;
                            double d92 = image.get(coordinates);
                            --coordinates.x;
                            double d93 = image.get(coordinates);
                            --coordinates.x;
                            double d94 = image.get(coordinates);
                            dArray[i] = d27 * (d21 * (d15 * d31 + d16 * d32 + d17 * d33 + d18 * d34) + d22 * (d15 * d38 + d16 * d37 + d17 * d36 + d18 * d35) + d23 * (d15 * d39 + d16 * d40 + d17 * d41 + d18 * d42) + d24 * (d15 * d46 + d16 * d45 + d17 * d44 + d18 * d43)) + d28 * (d21 * (d15 * d62 + d16 * d61 + d17 * d60 + d18 * d59) + d22 * (d15 * d55 + d16 * d56 + d17 * d57 + d18 * d58) + d23 * (d15 * d54 + d16 * d53 + d17 * d52 + d18 * d51) + d24 * (d15 * d47 + d16 * d48 + d17 * d49 + d18 * d50)) + d29 * (d21 * (d15 * d63 + d16 * d64 + d17 * d65 + d18 * d66) + d22 * (d15 * d70 + d16 * d69 + d17 * d68 + d18 * d67) + d23 * (d15 * d71 + d16 * d72 + d17 * d73 + d18 * d74) + d24 * (d15 * d78 + d16 * d77 + d17 * d76 + d18 * d75)) + d30 * (d21 * (d15 * d94 + d16 * d93 + d17 * d92 + d18 * d91) + d22 * (d15 * d87 + d16 * d88 + d17 * d89 + d18 * d90) + d23 * (d15 * d86 + d16 * d85 + d17 * d84 + d18 * d83) + d24 * (d15 * d79 + d16 * d80 + d17 * d81 + d18 * d82));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline3_z(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.y == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosaz) / this.ivx;
                            double d6 = (d3 - d4 * this.sinaz) / this.ivy;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = 0.16666666666666666 * d8 * d8 * d8;
                            double d10 = 0.6666666666666666 + (0.5 * d7 - 1.0) * d7 * d7;
                            double d11 = 0.6666666666666666 + (0.5 * d8 - 1.0) * d8 * d8;
                            double d12 = 0.16666666666666666 * d7 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = 0.16666666666666666 * d14 * d14 * d14;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.6666666666666666 + (0.5 * d14 - 1.0) * d14 * d14;
                            double d18 = 0.16666666666666666 * d13 * d13 * d13;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.y;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.y;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.y;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline3_y(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(true, false, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.z == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosay) / this.ivx;
                            double d6 = (d3 + d4 * this.sinay) / this.ivz;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = 0.16666666666666666 * d8 * d8 * d8;
                            double d10 = 0.6666666666666666 + (0.5 * d7 - 1.0) * d7 * d7;
                            double d11 = 0.6666666666666666 + (0.5 * d8 - 1.0) * d8 * d8;
                            double d12 = 0.16666666666666666 * d7 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = 0.16666666666666666 * d14 * d14 * d14;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.6666666666666666 + (0.5 * d14 - 1.0) * d14 * d14;
                            double d18 = 0.16666666666666666 * d13 * d13 * d13;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.z;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.z;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.z;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline3_x(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(false, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.y == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.z == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d5 = (d2 + d4 * this.cosax) / this.ivy;
                        double d6 = (d3 - d4 * this.sinax) / this.ivz;
                        int n = FMath.floor(d5);
                        int n2 = FMath.floor(d6);
                        if (n < -1 || n > this.imaxy || n2 < -1 || n2 > this.imaxz) {
                            for (int i = 0; i < this.odims.x; ++i) {
                                dArray[i] = this.background;
                            }
                        } else {
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = 0.16666666666666666 * d8 * d8 * d8;
                            double d10 = 0.6666666666666666 + (0.5 * d7 - 1.0) * d7 * d7;
                            double d11 = 0.6666666666666666 + (0.5 * d8 - 1.0) * d8 * d8;
                            double d12 = 0.16666666666666666 * d7 * d7 * d7;
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = 0.16666666666666666 * d14 * d14 * d14;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.6666666666666666 + (0.5 * d14 - 1.0) * d14 * d14;
                            double d18 = 0.16666666666666666 * d13 * d13 * d13;
                            coordinates.y = this.borders.y + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            coordinates.x = 0;
                            int n3 = 0;
                            while (n3 < this.odims.x) {
                                double d19 = image.get(coordinates);
                                ++coordinates.y;
                                double d20 = image.get(coordinates);
                                ++coordinates.y;
                                double d21 = image.get(coordinates);
                                ++coordinates.y;
                                double d22 = image.get(coordinates);
                                ++coordinates.z;
                                double d23 = image.get(coordinates);
                                --coordinates.y;
                                double d24 = image.get(coordinates);
                                --coordinates.y;
                                double d25 = image.get(coordinates);
                                --coordinates.y;
                                double d26 = image.get(coordinates);
                                ++coordinates.z;
                                double d27 = image.get(coordinates);
                                ++coordinates.y;
                                double d28 = image.get(coordinates);
                                ++coordinates.y;
                                double d29 = image.get(coordinates);
                                ++coordinates.y;
                                double d30 = image.get(coordinates);
                                ++coordinates.z;
                                double d31 = image.get(coordinates);
                                --coordinates.y;
                                double d32 = image.get(coordinates);
                                --coordinates.y;
                                double d33 = image.get(coordinates);
                                --coordinates.y;
                                double d34 = image.get(coordinates);
                                coordinates.z -= 3;
                                dArray[n3] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                                ++n3;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline3_zyx(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.y == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.z == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            double d10 = (d6 + d9 * this.invxx) / this.ivx;
                            double d11 = (d7 + d9 * this.invyx) / this.ivy;
                            double d12 = (d8 + d9 * this.invzx) / this.ivz;
                            int n = FMath.floor(d10);
                            int n2 = FMath.floor(d11);
                            int n3 = FMath.floor(d12);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy || n3 < -1 || n3 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d13 = d10 - (double)n;
                            double d14 = 1.0 - d13;
                            double d15 = 0.16666666666666666 * d14 * d14 * d14;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.6666666666666666 + (0.5 * d14 - 1.0) * d14 * d14;
                            double d18 = 0.16666666666666666 * d13 * d13 * d13;
                            double d19 = d11 - (double)n2;
                            double d20 = 1.0 - d19;
                            double d21 = 0.16666666666666666 * d20 * d20 * d20;
                            double d22 = 0.6666666666666666 + (0.5 * d19 - 1.0) * d19 * d19;
                            double d23 = 0.6666666666666666 + (0.5 * d20 - 1.0) * d20 * d20;
                            double d24 = 0.16666666666666666 * d19 * d19 * d19;
                            double d25 = d12 - (double)n3;
                            double d26 = 1.0 - d25;
                            double d27 = 0.16666666666666666 * d26 * d26 * d26;
                            double d28 = 0.6666666666666666 + (0.5 * d25 - 1.0) * d25 * d25;
                            double d29 = 0.6666666666666666 + (0.5 * d26 - 1.0) * d26 * d26;
                            double d30 = 0.16666666666666666 * d25 * d25 * d25;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d31 = image.get(coordinates);
                            ++coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.x;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.y;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            ++coordinates.y;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.y;
                            double d43 = image.get(coordinates);
                            --coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.x;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            ++coordinates.z;
                            double d47 = image.get(coordinates);
                            ++coordinates.x;
                            double d48 = image.get(coordinates);
                            ++coordinates.x;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            --coordinates.y;
                            double d51 = image.get(coordinates);
                            --coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.x;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.y;
                            double d55 = image.get(coordinates);
                            ++coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.x;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.y;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            ++coordinates.z;
                            double d63 = image.get(coordinates);
                            ++coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.x;
                            double d65 = image.get(coordinates);
                            ++coordinates.x;
                            double d66 = image.get(coordinates);
                            ++coordinates.y;
                            double d67 = image.get(coordinates);
                            --coordinates.x;
                            double d68 = image.get(coordinates);
                            --coordinates.x;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            ++coordinates.y;
                            double d71 = image.get(coordinates);
                            ++coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.x;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.y;
                            double d75 = image.get(coordinates);
                            --coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.x;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            ++coordinates.z;
                            double d79 = image.get(coordinates);
                            ++coordinates.x;
                            double d80 = image.get(coordinates);
                            ++coordinates.x;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            --coordinates.y;
                            double d83 = image.get(coordinates);
                            --coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.x;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.y;
                            double d87 = image.get(coordinates);
                            ++coordinates.x;
                            double d88 = image.get(coordinates);
                            ++coordinates.x;
                            double d89 = image.get(coordinates);
                            ++coordinates.x;
                            double d90 = image.get(coordinates);
                            --coordinates.y;
                            double d91 = image.get(coordinates);
                            --coordinates.x;
                            double d92 = image.get(coordinates);
                            --coordinates.x;
                            double d93 = image.get(coordinates);
                            --coordinates.x;
                            double d94 = image.get(coordinates);
                            dArray[i] = d27 * (d21 * (d15 * d31 + d16 * d32 + d17 * d33 + d18 * d34) + d22 * (d15 * d38 + d16 * d37 + d17 * d36 + d18 * d35) + d23 * (d15 * d39 + d16 * d40 + d17 * d41 + d18 * d42) + d24 * (d15 * d46 + d16 * d45 + d17 * d44 + d18 * d43)) + d28 * (d21 * (d15 * d62 + d16 * d61 + d17 * d60 + d18 * d59) + d22 * (d15 * d55 + d16 * d56 + d17 * d57 + d18 * d58) + d23 * (d15 * d54 + d16 * d53 + d17 * d52 + d18 * d51) + d24 * (d15 * d47 + d16 * d48 + d17 * d49 + d18 * d50)) + d29 * (d21 * (d15 * d63 + d16 * d64 + d17 * d65 + d18 * d66) + d22 * (d15 * d70 + d16 * d69 + d17 * d68 + d18 * d67) + d23 * (d15 * d71 + d16 * d72 + d17 * d73 + d18 * d74) + d24 * (d15 * d78 + d16 * d77 + d17 * d76 + d18 * d75)) + d30 * (d21 * (d15 * d94 + d16 * d93 + d17 * d92 + d18 * d91) + d22 * (d15 * d87 + d16 * d88 + d17 * d89 + d18 * d90) + d23 * (d15 * d86 + d16 * d85 + d17 * d84 + d18 * d83) + d24 * (d15 * d79 + d16 * d80 + d17 * d81 + d18 * d82));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_omoms3_z(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.y == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosaz) / this.ivx;
                            double d6 = (d3 - d4 * this.sinaz) / this.ivy;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = d8 * (0.023809523809523808 + 0.16666666666666666 * d8 * d8);
                            double d10 = 0.6190476190476191 + d7 * (0.07142857142857142 + d7 * (0.5 * d7 - 1.0));
                            double d11 = 0.6190476190476191 + d8 * (0.07142857142857142 + d8 * (0.5 * d8 - 1.0));
                            double d12 = d7 * (0.023809523809523808 + 0.16666666666666666 * d7 * d7);
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = d14 * (0.023809523809523808 + 0.16666666666666666 * d14 * d14);
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = 0.6190476190476191 + d14 * (0.07142857142857142 + d14 * (0.5 * d14 - 1.0));
                            double d18 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.y;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.y;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.y;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_omoms3_y(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(true, false, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.z == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosay) / this.ivx;
                            double d6 = (d3 + d4 * this.sinay) / this.ivz;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = d8 * (0.023809523809523808 + 0.16666666666666666 * d8 * d8);
                            double d10 = 0.6190476190476191 + d7 * (0.07142857142857142 + d7 * (0.5 * d7 - 1.0));
                            double d11 = 0.6190476190476191 + d8 * (0.07142857142857142 + d8 * (0.5 * d8 - 1.0));
                            double d12 = d7 * (0.023809523809523808 + 0.16666666666666666 * d7 * d7);
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = d14 * (0.023809523809523808 + 0.16666666666666666 * d14 * d14);
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = 0.6190476190476191 + d14 * (0.07142857142857142 + d14 * (0.5 * d14 - 1.0));
                            double d18 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.x;
                            double d22 = image.get(coordinates);
                            ++coordinates.z;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            --coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.z;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.z;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            dArray[i] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_omoms3_x(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(false, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.y == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.z == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d5 = (d2 + d4 * this.cosax) / this.ivy;
                        double d6 = (d3 - d4 * this.sinax) / this.ivz;
                        int n = FMath.floor(d5);
                        int n2 = FMath.floor(d6);
                        if (n < -1 || n > this.imaxy || n2 < -1 || n2 > this.imaxz) {
                            for (int i = 0; i < this.odims.x; ++i) {
                                dArray[i] = this.background;
                            }
                        } else {
                            double d7 = d5 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = d8 * (0.023809523809523808 + 0.16666666666666666 * d8 * d8);
                            double d10 = 0.6190476190476191 + d7 * (0.07142857142857142 + d7 * (0.5 * d7 - 1.0));
                            double d11 = 0.6190476190476191 + d8 * (0.07142857142857142 + d8 * (0.5 * d8 - 1.0));
                            double d12 = d7 * (0.023809523809523808 + 0.16666666666666666 * d7 * d7);
                            double d13 = d6 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = d14 * (0.023809523809523808 + 0.16666666666666666 * d14 * d14);
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = 0.6190476190476191 + d14 * (0.07142857142857142 + d14 * (0.5 * d14 - 1.0));
                            double d18 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            coordinates.y = this.borders.y + n - 1;
                            coordinates.z = this.borders.z + n2 - 1;
                            coordinates.x = 0;
                            int n3 = 0;
                            while (n3 < this.odims.x) {
                                double d19 = image.get(coordinates);
                                ++coordinates.y;
                                double d20 = image.get(coordinates);
                                ++coordinates.y;
                                double d21 = image.get(coordinates);
                                ++coordinates.y;
                                double d22 = image.get(coordinates);
                                ++coordinates.z;
                                double d23 = image.get(coordinates);
                                --coordinates.y;
                                double d24 = image.get(coordinates);
                                --coordinates.y;
                                double d25 = image.get(coordinates);
                                --coordinates.y;
                                double d26 = image.get(coordinates);
                                ++coordinates.z;
                                double d27 = image.get(coordinates);
                                ++coordinates.y;
                                double d28 = image.get(coordinates);
                                ++coordinates.y;
                                double d29 = image.get(coordinates);
                                ++coordinates.y;
                                double d30 = image.get(coordinates);
                                ++coordinates.z;
                                double d31 = image.get(coordinates);
                                --coordinates.y;
                                double d32 = image.get(coordinates);
                                --coordinates.y;
                                double d33 = image.get(coordinates);
                                --coordinates.y;
                                double d34 = image.get(coordinates);
                                coordinates.z -= 3;
                                dArray[n3] = d15 * (d9 * d19 + d10 * d20 + d11 * d21 + d12 * d22) + d16 * (d9 * d26 + d10 * d25 + d11 * d24 + d12 * d23) + d17 * (d9 * d27 + d10 * d28 + d11 * d29 + d12 * d30) + d18 * (d9 * d34 + d10 * d33 + d11 * d32 + d12 * d31);
                                ++n3;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_omoms3_zyx(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.y == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.z == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            double d10 = (d6 + d9 * this.invxx) / this.ivx;
                            double d11 = (d7 + d9 * this.invyx) / this.ivy;
                            double d12 = (d8 + d9 * this.invzx) / this.ivz;
                            int n = FMath.floor(d10);
                            int n2 = FMath.floor(d11);
                            int n3 = FMath.floor(d12);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy || n3 < -1 || n3 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d13 = d10 - (double)n;
                            double d14 = 1.0 - d13;
                            double d15 = d14 * (0.023809523809523808 + 0.16666666666666666 * d14 * d14);
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = 0.6190476190476191 + d14 * (0.07142857142857142 + d14 * (0.5 * d14 - 1.0));
                            double d18 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            double d19 = d11 - (double)n2;
                            double d20 = 1.0 - d19;
                            double d21 = d20 * (0.023809523809523808 + 0.16666666666666666 * d20 * d20);
                            double d22 = 0.6190476190476191 + d19 * (0.07142857142857142 + d19 * (0.5 * d19 - 1.0));
                            double d23 = 0.6190476190476191 + d20 * (0.07142857142857142 + d20 * (0.5 * d20 - 1.0));
                            double d24 = d19 * (0.023809523809523808 + 0.16666666666666666 * d19 * d19);
                            double d25 = d12 - (double)n3;
                            double d26 = 1.0 - d25;
                            double d27 = d26 * (0.023809523809523808 + 0.16666666666666666 * d26 * d26);
                            double d28 = 0.6190476190476191 + d25 * (0.07142857142857142 + d25 * (0.5 * d25 - 1.0));
                            double d29 = 0.6190476190476191 + d26 * (0.07142857142857142 + d26 * (0.5 * d26 - 1.0));
                            double d30 = d25 * (0.023809523809523808 + 0.16666666666666666 * d25 * d25);
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d31 = image.get(coordinates);
                            ++coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.x;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.y;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            ++coordinates.y;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.y;
                            double d43 = image.get(coordinates);
                            --coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.x;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            ++coordinates.z;
                            double d47 = image.get(coordinates);
                            ++coordinates.x;
                            double d48 = image.get(coordinates);
                            ++coordinates.x;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            --coordinates.y;
                            double d51 = image.get(coordinates);
                            --coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.x;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.y;
                            double d55 = image.get(coordinates);
                            ++coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.x;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.y;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            ++coordinates.z;
                            double d63 = image.get(coordinates);
                            ++coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.x;
                            double d65 = image.get(coordinates);
                            ++coordinates.x;
                            double d66 = image.get(coordinates);
                            ++coordinates.y;
                            double d67 = image.get(coordinates);
                            --coordinates.x;
                            double d68 = image.get(coordinates);
                            --coordinates.x;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            ++coordinates.y;
                            double d71 = image.get(coordinates);
                            ++coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.x;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.y;
                            double d75 = image.get(coordinates);
                            --coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.x;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            ++coordinates.z;
                            double d79 = image.get(coordinates);
                            ++coordinates.x;
                            double d80 = image.get(coordinates);
                            ++coordinates.x;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            --coordinates.y;
                            double d83 = image.get(coordinates);
                            --coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.x;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.y;
                            double d87 = image.get(coordinates);
                            ++coordinates.x;
                            double d88 = image.get(coordinates);
                            ++coordinates.x;
                            double d89 = image.get(coordinates);
                            ++coordinates.x;
                            double d90 = image.get(coordinates);
                            --coordinates.y;
                            double d91 = image.get(coordinates);
                            --coordinates.x;
                            double d92 = image.get(coordinates);
                            --coordinates.x;
                            double d93 = image.get(coordinates);
                            --coordinates.x;
                            double d94 = image.get(coordinates);
                            dArray[i] = d27 * (d21 * (d15 * d31 + d16 * d32 + d17 * d33 + d18 * d34) + d22 * (d15 * d38 + d16 * d37 + d17 * d36 + d18 * d35) + d23 * (d15 * d39 + d16 * d40 + d17 * d41 + d18 * d42) + d24 * (d15 * d46 + d16 * d45 + d17 * d44 + d18 * d43)) + d28 * (d21 * (d15 * d62 + d16 * d61 + d17 * d60 + d18 * d59) + d22 * (d15 * d55 + d16 * d56 + d17 * d57 + d18 * d58) + d23 * (d15 * d54 + d16 * d53 + d17 * d52 + d18 * d51) + d24 * (d15 * d47 + d16 * d48 + d17 * d49 + d18 * d50)) + d29 * (d21 * (d15 * d63 + d16 * d64 + d17 * d65 + d18 * d66) + d22 * (d15 * d70 + d16 * d69 + d17 * d68 + d18 * d67) + d23 * (d15 * d71 + d16 * d72 + d17 * d73 + d18 * d74) + d24 * (d15 * d78 + d16 * d77 + d17 * d76 + d18 * d75)) + d30 * (d21 * (d15 * d94 + d16 * d93 + d17 * d92 + d18 * d91) + d22 * (d15 * d87 + d16 * d88 + d17 * d89 + d18 * d90) + d23 * (d15 * d86 + d16 * d85 + d17 * d84 + d18 * d83) + d24 * (d15 * d79 + d16 * d80 + d17 * d81 + d18 * d82));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline5_z(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in x-y");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.55;
            }
            if (this.idims.y == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                coordinates.z = 0;
                while (coordinates2.z < this.odims.z) {
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d = (double)coordinates2.y * this.ovy - this.oyc;
                        double d2 = this.ixc + d * this.sinaz;
                        double d3 = this.iyc + d * this.cosaz;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosaz) / this.ivx;
                            double d6 = (d3 - d4 * this.sinaz) / this.ivy;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = d7 * d7;
                            double d9 = 1.0 - d7;
                            double d10 = d9 * d9;
                            double d11 = 0.008333333333333333 * d10 * d10 * d9;
                            double d12 = 0.008333333333333333 + 0.041666666666666664 * d9 * (1.0 + d9 * (2.0 + d9 * (2.0 + d9 - d10)));
                            double d13 = 0.55 + d8 * ((0.25 - 0.08333333333333333 * d7) * d8 - 0.5);
                            double d14 = 0.55 + d10 * ((0.25 - 0.08333333333333333 * d9) * d10 - 0.5);
                            double d15 = 0.008333333333333333 + 0.041666666666666664 * d7 * (1.0 + d7 * (2.0 + d7 * (2.0 + d7 - d8)));
                            double d16 = 0.008333333333333333 * d8 * d8 * d7;
                            double d17 = d6 - (double)n2;
                            double d18 = d17 * d17;
                            double d19 = 1.0 - d17;
                            double d20 = d19 * d19;
                            double d21 = 0.008333333333333333 * d20 * d20 * d19;
                            double d22 = 0.008333333333333333 + 0.041666666666666664 * d19 * (1.0 + d19 * (2.0 + d19 * (2.0 + d19 - d20)));
                            double d23 = 0.55 + d18 * ((0.25 - 0.08333333333333333 * d17) * d18 - 0.5);
                            double d24 = 0.55 + d20 * ((0.25 - 0.08333333333333333 * d19) * d20 - 0.5);
                            double d25 = 0.008333333333333333 + 0.041666666666666664 * d17 * (1.0 + d17 * (2.0 + d17 * (2.0 + d17 - d18)));
                            double d26 = 0.008333333333333333 * d18 * d18 * d17;
                            coordinates.x = this.borders.x + n - 2;
                            coordinates.y = this.borders.y + n2 - 2;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.x;
                            double d31 = image.get(coordinates);
                            ++coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.y;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            --coordinates.x;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            ++coordinates.y;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.x;
                            double d44 = image.get(coordinates);
                            ++coordinates.y;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.x;
                            double d49 = image.get(coordinates);
                            --coordinates.x;
                            double d50 = image.get(coordinates);
                            ++coordinates.y;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            ++coordinates.x;
                            double d53 = image.get(coordinates);
                            ++coordinates.x;
                            double d54 = image.get(coordinates);
                            ++coordinates.x;
                            double d55 = image.get(coordinates);
                            ++coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.y;
                            double d57 = image.get(coordinates);
                            --coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.x;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            dArray[i] = d21 * (d11 * d27 + d12 * d28 + d13 * d29 + d14 * d30 + d15 * d31 + d16 * d32) + d22 * (d11 * d38 + d12 * d37 + d13 * d36 + d14 * d35 + d15 * d34 + d16 * d33) + d23 * (d11 * d39 + d12 * d40 + d13 * d41 + d14 * d42 + d15 * d43 + d16 * d44) + d24 * (d11 * d50 + d12 * d49 + d13 * d48 + d14 * d47 + d15 * d46 + d16 * d45) + d25 * (d11 * d51 + d12 * d52 + d13 * d53 + d14 * d54 + d15 * d55 + d16 * d56) + d26 * (d11 * d62 + d12 * d61 + d13 * d60 + d14 * d59 + d15 * d58 + d16 * d57);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline5_y(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in x-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(true, false, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.55;
            }
            if (this.idims.z == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc - d * this.sinay;
                    double d3 = this.izc + d * this.cosay;
                    coordinates.y = 0;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d4 = (double)i * this.ovx - this.oxc;
                            double d5 = (d2 + d4 * this.cosay) / this.ivx;
                            double d6 = (d3 + d4 * this.sinay) / this.ivz;
                            int n = FMath.floor(d5);
                            int n2 = FMath.floor(d6);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxz) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d5 - (double)n;
                            double d8 = d7 * d7;
                            double d9 = 1.0 - d7;
                            double d10 = d9 * d9;
                            double d11 = 0.008333333333333333 * d10 * d10 * d9;
                            double d12 = 0.008333333333333333 + 0.041666666666666664 * d9 * (1.0 + d9 * (2.0 + d9 * (2.0 + d9 - d10)));
                            double d13 = 0.55 + d8 * ((0.25 - 0.08333333333333333 * d7) * d8 - 0.5);
                            double d14 = 0.55 + d10 * ((0.25 - 0.08333333333333333 * d9) * d10 - 0.5);
                            double d15 = 0.008333333333333333 + 0.041666666666666664 * d7 * (1.0 + d7 * (2.0 + d7 * (2.0 + d7 - d8)));
                            double d16 = 0.008333333333333333 * d8 * d8 * d7;
                            double d17 = d6 - (double)n2;
                            double d18 = d17 * d17;
                            double d19 = 1.0 - d17;
                            double d20 = d19 * d19;
                            double d21 = 0.008333333333333333 * d20 * d20 * d19;
                            double d22 = 0.008333333333333333 + 0.041666666666666664 * d19 * (1.0 + d19 * (2.0 + d19 * (2.0 + d19 - d20)));
                            double d23 = 0.55 + d18 * ((0.25 - 0.08333333333333333 * d17) * d18 - 0.5);
                            double d24 = 0.55 + d20 * ((0.25 - 0.08333333333333333 * d19) * d20 - 0.5);
                            double d25 = 0.008333333333333333 + 0.041666666666666664 * d17 * (1.0 + d17 * (2.0 + d17 * (2.0 + d17 - d18)));
                            double d26 = 0.008333333333333333 * d18 * d18 * d17;
                            coordinates.x = this.borders.x + n - 2;
                            coordinates.z = this.borders.z + n2 - 2;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.x;
                            double d31 = image.get(coordinates);
                            ++coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.z;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            --coordinates.x;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            ++coordinates.z;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.x;
                            double d44 = image.get(coordinates);
                            ++coordinates.z;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.x;
                            double d49 = image.get(coordinates);
                            --coordinates.x;
                            double d50 = image.get(coordinates);
                            ++coordinates.z;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            ++coordinates.x;
                            double d53 = image.get(coordinates);
                            ++coordinates.x;
                            double d54 = image.get(coordinates);
                            ++coordinates.x;
                            double d55 = image.get(coordinates);
                            ++coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.z;
                            double d57 = image.get(coordinates);
                            --coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.x;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            dArray[i] = d21 * (d11 * d27 + d12 * d28 + d13 * d29 + d14 * d30 + d15 * d31 + d16 * d32) + d22 * (d11 * d38 + d12 * d37 + d13 * d36 + d14 * d35 + d15 * d34 + d16 * d33) + d23 * (d11 * d39 + d12 * d40 + d13 * d41 + d14 * d42 + d15 * d43 + d16 * d44) + d24 * (d11 * d50 + d12 * d49 + d13 * d48 + d14 * d47 + d15 * d46 + d16 * d45) + d25 * (d11 * d51 + d12 * d52 + d13 * d53 + d14 * d54 + d15 * d55 + d16 * d56) + d26 * (d11 * d62 + d12 * d61 + d13 * d60 + d14 * d59 + d15 * d58 + d16 * d57);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                        ++coordinates.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline5_x(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(false, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.y == 1) {
                d /= 0.55;
            }
            if (this.idims.z == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.iyc + d * this.sinax;
                    double d3 = this.izc + d * this.cosax;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d4 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d5 = (d2 + d4 * this.cosax) / this.ivy;
                        double d6 = (d3 - d4 * this.sinax) / this.ivz;
                        int n = FMath.floor(d5);
                        int n2 = FMath.floor(d6);
                        if (n < -1 || n > this.imaxy || n2 < -1 || n2 > this.imaxz) {
                            for (int i = 0; i < this.odims.x; ++i) {
                                dArray[i] = this.background;
                            }
                        } else {
                            double d7 = d5 - (double)n;
                            double d8 = d7 * d7;
                            double d9 = 1.0 - d7;
                            double d10 = d9 * d9;
                            double d11 = 0.008333333333333333 * d10 * d10 * d9;
                            double d12 = 0.008333333333333333 + 0.041666666666666664 * d9 * (1.0 + d9 * (2.0 + d9 * (2.0 + d9 - d10)));
                            double d13 = 0.55 + d8 * ((0.25 - 0.08333333333333333 * d7) * d8 - 0.5);
                            double d14 = 0.55 + d10 * ((0.25 - 0.08333333333333333 * d9) * d10 - 0.5);
                            double d15 = 0.008333333333333333 + 0.041666666666666664 * d7 * (1.0 + d7 * (2.0 + d7 * (2.0 + d7 - d8)));
                            double d16 = 0.008333333333333333 * d8 * d8 * d7;
                            double d17 = d6 - (double)n2;
                            double d18 = d17 * d17;
                            double d19 = 1.0 - d17;
                            double d20 = d19 * d19;
                            double d21 = 0.008333333333333333 * d20 * d20 * d19;
                            double d22 = 0.008333333333333333 + 0.041666666666666664 * d19 * (1.0 + d19 * (2.0 + d19 * (2.0 + d19 - d20)));
                            double d23 = 0.55 + d18 * ((0.25 - 0.08333333333333333 * d17) * d18 - 0.5);
                            double d24 = 0.55 + d20 * ((0.25 - 0.08333333333333333 * d19) * d20 - 0.5);
                            double d25 = 0.008333333333333333 + 0.041666666666666664 * d17 * (1.0 + d17 * (2.0 + d17 * (2.0 + d17 - d18)));
                            double d26 = 0.008333333333333333 * d18 * d18 * d17;
                            coordinates.y = this.borders.y + n - 2;
                            coordinates.z = this.borders.z + n2 - 2;
                            coordinates.x = 0;
                            int n3 = 0;
                            while (n3 < this.odims.x) {
                                double d27 = image.get(coordinates);
                                ++coordinates.y;
                                double d28 = image.get(coordinates);
                                ++coordinates.y;
                                double d29 = image.get(coordinates);
                                ++coordinates.y;
                                double d30 = image.get(coordinates);
                                ++coordinates.y;
                                double d31 = image.get(coordinates);
                                ++coordinates.y;
                                double d32 = image.get(coordinates);
                                ++coordinates.z;
                                double d33 = image.get(coordinates);
                                --coordinates.y;
                                double d34 = image.get(coordinates);
                                --coordinates.y;
                                double d35 = image.get(coordinates);
                                --coordinates.y;
                                double d36 = image.get(coordinates);
                                --coordinates.y;
                                double d37 = image.get(coordinates);
                                --coordinates.y;
                                double d38 = image.get(coordinates);
                                ++coordinates.z;
                                double d39 = image.get(coordinates);
                                ++coordinates.y;
                                double d40 = image.get(coordinates);
                                ++coordinates.y;
                                double d41 = image.get(coordinates);
                                ++coordinates.y;
                                double d42 = image.get(coordinates);
                                ++coordinates.y;
                                double d43 = image.get(coordinates);
                                ++coordinates.y;
                                double d44 = image.get(coordinates);
                                ++coordinates.z;
                                double d45 = image.get(coordinates);
                                --coordinates.y;
                                double d46 = image.get(coordinates);
                                --coordinates.y;
                                double d47 = image.get(coordinates);
                                --coordinates.y;
                                double d48 = image.get(coordinates);
                                --coordinates.y;
                                double d49 = image.get(coordinates);
                                --coordinates.y;
                                double d50 = image.get(coordinates);
                                ++coordinates.z;
                                double d51 = image.get(coordinates);
                                ++coordinates.y;
                                double d52 = image.get(coordinates);
                                ++coordinates.y;
                                double d53 = image.get(coordinates);
                                ++coordinates.y;
                                double d54 = image.get(coordinates);
                                ++coordinates.y;
                                double d55 = image.get(coordinates);
                                ++coordinates.y;
                                double d56 = image.get(coordinates);
                                ++coordinates.z;
                                double d57 = image.get(coordinates);
                                --coordinates.y;
                                double d58 = image.get(coordinates);
                                --coordinates.y;
                                double d59 = image.get(coordinates);
                                --coordinates.y;
                                double d60 = image.get(coordinates);
                                --coordinates.y;
                                double d61 = image.get(coordinates);
                                --coordinates.y;
                                double d62 = image.get(coordinates);
                                coordinates.z -= 5;
                                dArray[n3] = d21 * (d11 * d27 + d12 * d28 + d13 * d29 + d14 * d30 + d15 * d31 + d16 * d32) + d22 * (d11 * d38 + d12 * d37 + d13 * d36 + d14 * d35 + d15 * d34 + d16 * d33) + d23 * (d11 * d39 + d12 * d40 + d13 * d41 + d14 * d42 + d15 * d43 + d16 * d44) + d24 * (d11 * d50 + d12 * d49 + d13 * d48 + d14 * d47 + d15 * d46 + d16 * d45) + d25 * (d11 * d51 + d12 * d52 + d13 * d53 + d14 * d54 + d15 * d55 + d16 * d56) + d26 * (d11 * d62 + d12 * d61 + d13 * d60 + d14 * d59 + d15 * d58 + d16 * d57);
                                ++n3;
                                ++coordinates.x;
                            }
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void rotate_bspline5_zyx(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in x-y-z");
        this.progressor.status("Rotating" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.55;
            }
            if (this.idims.y == 1) {
                d /= 0.55;
            }
            if (this.idims.z == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[][][] dArray = new double[6][6][6];
        double[] dArray2 = new double[this.odims.x];
        image.axes(7);
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.ozc;
                    double d2 = this.ixc + d * this.invxz;
                    double d3 = this.iyc + d * this.invyz;
                    double d4 = this.izc + d * this.invzz;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d5 = (double)coordinates2.y * this.ovy - this.oyc;
                        double d6 = d2 + d5 * this.invxy;
                        double d7 = d3 + d5 * this.invyy;
                        double d8 = d4 + d5 * this.invzy;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d9 = (double)i * this.ovx - this.oxc;
                            double d10 = (d6 + d9 * this.invxx) / this.ivx;
                            double d11 = (d7 + d9 * this.invyx) / this.ivy;
                            double d12 = (d8 + d9 * this.invzx) / this.ivz;
                            int n = FMath.floor(d10);
                            int n2 = FMath.floor(d11);
                            int n3 = FMath.floor(d12);
                            if (n < -1 || n > this.imaxx || n2 < -1 || n2 > this.imaxy || n3 < -1 || n3 > this.imaxz) {
                                dArray2[i] = this.background;
                                continue;
                            }
                            double d13 = d10 - (double)n;
                            double d14 = d13 * d13;
                            double d15 = 1.0 - d13;
                            double d16 = d15 * d15;
                            double d17 = 0.008333333333333333 * d16 * d16 * d15;
                            double d18 = 0.008333333333333333 + 0.041666666666666664 * d15 * (1.0 + d15 * (2.0 + d15 * (2.0 + d15 - d16)));
                            double d19 = 0.55 + d14 * ((0.25 - 0.08333333333333333 * d13) * d14 - 0.5);
                            double d20 = 0.55 + d16 * ((0.25 - 0.08333333333333333 * d15) * d16 - 0.5);
                            double d21 = 0.008333333333333333 + 0.041666666666666664 * d13 * (1.0 + d13 * (2.0 + d13 * (2.0 + d13 - d14)));
                            double d22 = 0.008333333333333333 * d14 * d14 * d13;
                            double d23 = d11 - (double)n2;
                            double d24 = d23 * d23;
                            double d25 = 1.0 - d23;
                            double d26 = d25 * d25;
                            double d27 = 0.008333333333333333 * d26 * d26 * d25;
                            double d28 = 0.008333333333333333 + 0.041666666666666664 * d25 * (1.0 + d25 * (2.0 + d25 * (2.0 + d25 - d26)));
                            double d29 = 0.55 + d24 * ((0.25 - 0.08333333333333333 * d23) * d24 - 0.5);
                            double d30 = 0.55 + d26 * ((0.25 - 0.08333333333333333 * d25) * d26 - 0.5);
                            double d31 = 0.008333333333333333 + 0.041666666666666664 * d23 * (1.0 + d23 * (2.0 + d23 * (2.0 + d23 - d24)));
                            double d32 = 0.008333333333333333 * d24 * d24 * d23;
                            double d33 = d12 - (double)n3;
                            double d34 = d33 * d33;
                            double d35 = 1.0 - d33;
                            double d36 = d35 * d35;
                            double d37 = 0.008333333333333333 * d36 * d36 * d35;
                            double d38 = 0.008333333333333333 + 0.041666666666666664 * d35 * (1.0 + d35 * (2.0 + d35 * (2.0 + d35 - d36)));
                            double d39 = 0.55 + d34 * ((0.25 - 0.08333333333333333 * d33) * d34 - 0.5);
                            double d40 = 0.55 + d36 * ((0.25 - 0.08333333333333333 * d35) * d36 - 0.5);
                            double d41 = 0.008333333333333333 + 0.041666666666666664 * d33 * (1.0 + d33 * (2.0 + d33 * (2.0 + d33 - d34)));
                            double d42 = 0.008333333333333333 * d34 * d34 * d33;
                            coordinates.x = this.borders.x + n - 2;
                            coordinates.y = this.borders.y + n2 - 2;
                            coordinates.z = this.borders.z + n3 - 2;
                            image.get(coordinates, dArray);
                            dArray2[i] = d37 * (d27 * (d17 * dArray[0][0][0] + d18 * dArray[0][0][1] + d19 * dArray[0][0][2] + d20 * dArray[0][0][3] + d21 * dArray[0][0][4] + d22 * dArray[0][0][5]) + d28 * (d17 * dArray[0][1][0] + d18 * dArray[0][1][1] + d19 * dArray[0][1][2] + d20 * dArray[0][1][3] + d21 * dArray[0][1][4] + d22 * dArray[0][1][5]) + d29 * (d17 * dArray[0][2][0] + d18 * dArray[0][2][1] + d19 * dArray[0][2][2] + d20 * dArray[0][2][3] + d21 * dArray[0][2][4] + d22 * dArray[0][2][5]) + d30 * (d17 * dArray[0][3][0] + d18 * dArray[0][3][1] + d19 * dArray[0][3][2] + d20 * dArray[0][3][3] + d21 * dArray[0][3][4] + d22 * dArray[0][3][5]) + d31 * (d17 * dArray[0][4][0] + d18 * dArray[0][4][1] + d19 * dArray[0][4][2] + d20 * dArray[0][4][3] + d21 * dArray[0][4][4] + d22 * dArray[0][4][5]) + d32 * (d17 * dArray[0][5][0] + d18 * dArray[0][5][1] + d19 * dArray[0][5][2] + d20 * dArray[0][5][3] + d21 * dArray[0][5][4] + d22 * dArray[0][5][5])) + d38 * (d27 * (d17 * dArray[1][0][0] + d18 * dArray[1][0][1] + d19 * dArray[1][0][2] + d20 * dArray[1][0][3] + d21 * dArray[1][0][4] + d22 * dArray[1][0][5]) + d28 * (d17 * dArray[1][1][0] + d18 * dArray[1][1][1] + d19 * dArray[1][1][2] + d20 * dArray[1][1][3] + d21 * dArray[1][1][4] + d22 * dArray[1][1][5]) + d29 * (d17 * dArray[1][2][0] + d18 * dArray[1][2][1] + d19 * dArray[1][2][2] + d20 * dArray[1][2][3] + d21 * dArray[1][2][4] + d22 * dArray[1][2][5]) + d30 * (d17 * dArray[1][3][0] + d18 * dArray[1][3][1] + d19 * dArray[1][3][2] + d20 * dArray[1][3][3] + d21 * dArray[1][3][4] + d22 * dArray[1][3][5]) + d31 * (d17 * dArray[1][4][0] + d18 * dArray[1][4][1] + d19 * dArray[1][4][2] + d20 * dArray[1][4][3] + d21 * dArray[1][4][4] + d22 * dArray[1][4][5]) + d32 * (d17 * dArray[1][5][0] + d18 * dArray[1][5][1] + d19 * dArray[1][5][2] + d20 * dArray[1][5][3] + d21 * dArray[1][5][4] + d22 * dArray[1][5][5])) + d39 * (d27 * (d17 * dArray[2][0][0] + d18 * dArray[2][0][1] + d19 * dArray[2][0][2] + d20 * dArray[2][0][3] + d21 * dArray[2][0][4] + d22 * dArray[2][0][5]) + d28 * (d17 * dArray[2][1][0] + d18 * dArray[2][1][1] + d19 * dArray[2][1][2] + d20 * dArray[2][1][3] + d21 * dArray[2][1][4] + d22 * dArray[2][1][5]) + d29 * (d17 * dArray[2][2][0] + d18 * dArray[2][2][1] + d19 * dArray[2][2][2] + d20 * dArray[2][2][3] + d21 * dArray[2][2][4] + d22 * dArray[2][2][5]) + d30 * (d17 * dArray[2][3][0] + d18 * dArray[2][3][1] + d19 * dArray[2][3][2] + d20 * dArray[2][3][3] + d21 * dArray[2][3][4] + d22 * dArray[2][3][5]) + d31 * (d17 * dArray[2][4][0] + d18 * dArray[2][4][1] + d19 * dArray[2][4][2] + d20 * dArray[2][4][3] + d21 * dArray[2][4][4] + d22 * dArray[2][4][5]) + d32 * (d17 * dArray[2][5][0] + d18 * dArray[2][5][1] + d19 * dArray[2][5][2] + d20 * dArray[2][5][3] + d21 * dArray[2][5][4] + d22 * dArray[2][5][5])) + d40 * (d27 * (d17 * dArray[3][0][0] + d18 * dArray[3][0][1] + d19 * dArray[3][0][2] + d20 * dArray[3][0][3] + d21 * dArray[3][0][4] + d22 * dArray[3][0][5]) + d28 * (d17 * dArray[3][1][0] + d18 * dArray[3][1][1] + d19 * dArray[3][1][2] + d20 * dArray[3][1][3] + d21 * dArray[3][1][4] + d22 * dArray[3][1][5]) + d29 * (d17 * dArray[3][2][0] + d18 * dArray[3][2][1] + d19 * dArray[3][2][2] + d20 * dArray[3][2][3] + d21 * dArray[3][2][4] + d22 * dArray[3][2][5]) + d30 * (d17 * dArray[3][3][0] + d18 * dArray[3][3][1] + d19 * dArray[3][3][2] + d20 * dArray[3][3][3] + d21 * dArray[3][3][4] + d22 * dArray[3][3][5]) + d31 * (d17 * dArray[3][4][0] + d18 * dArray[3][4][1] + d19 * dArray[3][4][2] + d20 * dArray[3][4][3] + d21 * dArray[3][4][4] + d22 * dArray[3][4][5]) + d32 * (d17 * dArray[3][5][0] + d18 * dArray[3][5][1] + d19 * dArray[3][5][2] + d20 * dArray[3][5][3] + d21 * dArray[3][5][4] + d22 * dArray[3][5][5])) + d41 * (d27 * (d17 * dArray[4][0][0] + d18 * dArray[4][0][1] + d19 * dArray[4][0][2] + d20 * dArray[4][0][3] + d21 * dArray[4][0][4] + d22 * dArray[4][0][5]) + d28 * (d17 * dArray[4][1][0] + d18 * dArray[4][1][1] + d19 * dArray[4][1][2] + d20 * dArray[4][1][3] + d21 * dArray[4][1][4] + d22 * dArray[4][1][5]) + d29 * (d17 * dArray[4][2][0] + d18 * dArray[4][2][1] + d19 * dArray[4][2][2] + d20 * dArray[4][2][3] + d21 * dArray[4][2][4] + d22 * dArray[4][2][5]) + d30 * (d17 * dArray[4][3][0] + d18 * dArray[4][3][1] + d19 * dArray[4][3][2] + d20 * dArray[4][3][3] + d21 * dArray[4][3][4] + d22 * dArray[4][3][5]) + d31 * (d17 * dArray[4][4][0] + d18 * dArray[4][4][1] + d19 * dArray[4][4][2] + d20 * dArray[4][4][3] + d21 * dArray[4][4][4] + d22 * dArray[4][4][5]) + d32 * (d17 * dArray[4][5][0] + d18 * dArray[4][5][1] + d19 * dArray[4][5][2] + d20 * dArray[4][5][3] + d21 * dArray[4][5][4] + d22 * dArray[4][5][5])) + d42 * (d27 * (d17 * dArray[5][0][0] + d18 * dArray[5][0][1] + d19 * dArray[5][0][2] + d20 * dArray[5][0][3] + d21 * dArray[5][0][4] + d22 * dArray[5][0][5]) + d28 * (d17 * dArray[5][1][0] + d18 * dArray[5][1][1] + d19 * dArray[5][1][2] + d20 * dArray[5][1][3] + d21 * dArray[5][1][4] + d22 * dArray[5][1][5]) + d29 * (d17 * dArray[5][2][0] + d18 * dArray[5][2][1] + d19 * dArray[5][2][2] + d20 * dArray[5][2][3] + d21 * dArray[5][2][4] + d22 * dArray[5][2][5]) + d30 * (d17 * dArray[5][3][0] + d18 * dArray[5][3][1] + d19 * dArray[5][3][2] + d20 * dArray[5][3][3] + d21 * dArray[5][3][4] + d22 * dArray[5][3][5]) + d31 * (d17 * dArray[5][4][0] + d18 * dArray[5][4][1] + d19 * dArray[5][4][2] + d20 * dArray[5][4][3] + d21 * dArray[5][4][4] + d22 * dArray[5][4][5]) + d32 * (d17 * dArray[5][5][0] + d18 * dArray[5][5][1] + d19 * dArray[5][5][2] + d20 * dArray[5][5][3] + d21 * dArray[5][5][4] + d22 * dArray[5][5][5]));
                        }
                        image2.set(coordinates2, dArray2);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private String schemes(int n) {
        switch (n) {
            case 0: {
                return "nearest-neighbor interpolation";
            }
            case 1: {
                return "linear interpolation";
            }
            case 2: {
                return "cubic convolution interpolation";
            }
            case 3: {
                return "cubic B-spline interpolation";
            }
            case 4: {
                return "cubic O-MOMS interpolation";
            }
            case 5: {
                return "quintic B-spline interpolation";
            }
        }
        return "unknown interpolation";
    }
}

