/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.image.Axes;
import imagescience.image.Borders;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;

public class Prefilter {
    private static final double BSPLINE3POLE1 = -0.2679491937160492;
    private static final double BSPLINE3SCALE = 6.0;
    private static final double BSPLINE5POLE1 = -0.43057534098625183;
    private static final double BSPLINE5POLE2 = -0.04309628903865814;
    private static final double BSPLINE5SCALE = 120.0;
    private static final double OMOMS3POLE1 = -0.34413114190101624;
    private static final double OMOMS3SCALE = 5.25;
    private static final int HORIZON = 25;

    public void bspline3(double[] dArray, int n) {
        if (dArray.length - 2 * n > 1) {
            this.prefilter(dArray, n, -0.2679491937160492);
            this.scale(dArray, n, 6.0);
        }
    }

    public Image bspline3(Image image, Axes axes, Borders borders) {
        Coordinates coordinates;
        double[] dArray;
        Image image2;
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates2 = new Coordinates(borders.x, borders.y, borders.z, borders.t, borders.c);
        Coordinates coordinates3 = new Coordinates(dimensions.x - borders.x - 1, dimensions.y - borders.y - 1, dimensions.z - borders.z - 1, dimensions.t - borders.t - 1, dimensions.c - borders.c - 1);
        Image image3 = image2 = image instanceof FloatImage ? image : new FloatImage(image);
        if (axes.x && dimensions.x - 2 * borders.x > 1) {
            image2.axes(1);
            dArray = new double[dimensions.x];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.y = coordinates2.y;
                        while (coordinates.y <= coordinates3.y) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.x, -0.2679491937160492);
                            this.scale(dArray, borders.x, 6.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.y && dimensions.y - 2 * borders.y > 1) {
            image2.axes(2);
            dArray = new double[dimensions.y];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.y, -0.2679491937160492);
                            this.scale(dArray, borders.y, 6.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.z && dimensions.z - 2 * borders.z > 1) {
            image2.axes(4);
            dArray = new double[dimensions.z];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.z, -0.2679491937160492);
                            this.scale(dArray, borders.z, 6.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.t && dimensions.t - 2 * borders.t > 1) {
            image2.axes(8);
            dArray = new double[dimensions.t];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.t, -0.2679491937160492);
                            this.scale(dArray, borders.t, 6.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.c;
            }
        }
        if (axes.c && dimensions.c - 2 * borders.c > 1) {
            image2.axes(16);
            dArray = new double[dimensions.c];
            coordinates = new Coordinates();
            coordinates.t = coordinates2.t;
            while (coordinates.t <= coordinates3.t) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.c, -0.2679491937160492);
                            this.scale(dArray, borders.c, 6.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
        }
        return image2;
    }

    public void omoms3(double[] dArray, int n) {
        if (dArray.length - 2 * n > 1) {
            this.prefilter(dArray, n, -0.34413114190101624);
            this.scale(dArray, n, 5.25);
        }
    }

    public Image omoms3(Image image, Axes axes, Borders borders) {
        Coordinates coordinates;
        double[] dArray;
        Image image2;
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates2 = new Coordinates(borders.x, borders.y, borders.z, borders.t, borders.c);
        Coordinates coordinates3 = new Coordinates(dimensions.x - borders.x - 1, dimensions.y - borders.y - 1, dimensions.z - borders.z - 1, dimensions.t - borders.t - 1, dimensions.c - borders.c - 1);
        Image image3 = image2 = image instanceof FloatImage ? image : new FloatImage(image);
        if (axes.x && dimensions.x - 2 * borders.x > 1) {
            image2.axes(1);
            dArray = new double[dimensions.x];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.y = coordinates2.y;
                        while (coordinates.y <= coordinates3.y) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.x, -0.34413114190101624);
                            this.scale(dArray, borders.x, 5.25);
                            image2.set(coordinates, dArray);
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.y && dimensions.y - 2 * borders.y > 1) {
            image2.axes(2);
            dArray = new double[dimensions.y];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.y, -0.34413114190101624);
                            this.scale(dArray, borders.y, 5.25);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.z && dimensions.z - 2 * borders.z > 1) {
            image2.axes(4);
            dArray = new double[dimensions.z];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.z, -0.34413114190101624);
                            this.scale(dArray, borders.z, 5.25);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.t && dimensions.t - 2 * borders.t > 1) {
            image2.axes(8);
            dArray = new double[dimensions.t];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.t, -0.34413114190101624);
                            this.scale(dArray, borders.t, 5.25);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.c;
            }
        }
        if (axes.c && dimensions.c - 2 * borders.c > 1) {
            image2.axes(16);
            dArray = new double[dimensions.c];
            coordinates = new Coordinates();
            coordinates.t = coordinates2.t;
            while (coordinates.t <= coordinates3.t) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.c, -0.34413114190101624);
                            this.scale(dArray, borders.c, 5.25);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
        }
        return image2;
    }

    public void bspline5(double[] dArray, int n) {
        if (dArray.length - 2 * n > 1) {
            this.prefilter(dArray, n, -0.43057534098625183);
            this.prefilter(dArray, n, -0.04309628903865814);
            this.scale(dArray, n, 120.0);
        }
    }

    public Image bspline5(Image image, Axes axes, Borders borders) {
        Coordinates coordinates;
        double[] dArray;
        Image image2;
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates2 = new Coordinates(borders.x, borders.y, borders.z, borders.t, borders.c);
        Coordinates coordinates3 = new Coordinates(dimensions.x - borders.x - 1, dimensions.y - borders.y - 1, dimensions.z - borders.z - 1, dimensions.t - borders.t - 1, dimensions.c - borders.c - 1);
        Image image3 = image2 = image instanceof FloatImage ? image : new FloatImage(image);
        if (axes.x && dimensions.x - 2 * borders.x > 1) {
            image2.axes(1);
            dArray = new double[dimensions.x];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.y = coordinates2.y;
                        while (coordinates.y <= coordinates3.y) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.x, -0.43057534098625183);
                            this.prefilter(dArray, borders.x, -0.04309628903865814);
                            this.scale(dArray, borders.x, 120.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.y && dimensions.y - 2 * borders.y > 1) {
            image2.axes(2);
            dArray = new double[dimensions.y];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.z = coordinates2.z;
                    while (coordinates.z <= coordinates3.z) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.y, -0.43057534098625183);
                            this.prefilter(dArray, borders.y, -0.04309628903865814);
                            this.scale(dArray, borders.y, 120.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.z && dimensions.z - 2 * borders.z > 1) {
            image2.axes(4);
            dArray = new double[dimensions.z];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.t = coordinates2.t;
                while (coordinates.t <= coordinates3.t) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.z, -0.43057534098625183);
                            this.prefilter(dArray, borders.z, -0.04309628903865814);
                            this.scale(dArray, borders.z, 120.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.t && dimensions.t - 2 * borders.t > 1) {
            image2.axes(8);
            dArray = new double[dimensions.t];
            coordinates = new Coordinates();
            coordinates.c = coordinates2.c;
            while (coordinates.c <= coordinates3.c) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.t, -0.43057534098625183);
                            this.prefilter(dArray, borders.t, -0.04309628903865814);
                            this.scale(dArray, borders.t, 120.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.c;
            }
        }
        if (axes.c && dimensions.c - 2 * borders.c > 1) {
            image2.axes(16);
            dArray = new double[dimensions.c];
            coordinates = new Coordinates();
            coordinates.t = coordinates2.t;
            while (coordinates.t <= coordinates3.t) {
                coordinates.z = coordinates2.z;
                while (coordinates.z <= coordinates3.z) {
                    coordinates.y = coordinates2.y;
                    while (coordinates.y <= coordinates3.y) {
                        coordinates.x = coordinates2.x;
                        while (coordinates.x <= coordinates3.x) {
                            image2.get(coordinates, dArray);
                            this.prefilter(dArray, borders.c, -0.43057534098625183);
                            this.prefilter(dArray, borders.c, -0.04309628903865814);
                            this.scale(dArray, borders.c, 120.0);
                            image2.set(coordinates, dArray);
                            ++coordinates.x;
                        }
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
        }
        return image2;
    }

    private void prefilter(double[] dArray, int n, double d) {
        int n2 = dArray.length - 2 * n;
        int n3 = n;
        int n4 = n3 + n2 - 1;
        double d2 = -d / (1.0 - d * d);
        double d3 = 1.0 / d;
        if (n2 < 25) {
            int n5;
            double d4 = dArray[n4];
            double d5 = d;
            double d6 = Math.pow(d, n2 - 1);
            double d7 = dArray[n3] + d6 * dArray[n4];
            d6 = d6 * d6 * d3;
            for (n5 = n3 + 1; n5 < n4; ++n5) {
                d7 += (d5 + d6) * dArray[n5];
                d5 *= d;
                d6 *= d3;
            }
            dArray[n3] = d7 /= 1.0 - d5 * d5;
            for (n5 = n3 + 1; n5 <= n4; ++n5) {
                int n6 = n5;
                dArray[n6] = dArray[n6] + d * dArray[n5 - 1];
            }
            dArray[n4] = d2 * (2.0 * dArray[n4] - d4);
            for (n5 = n4 - 1; n5 >= n3; --n5) {
                dArray[n5] = d * (dArray[n5 + 1] - dArray[n5]);
            }
        } else {
            int n7;
            double d8 = dArray[n4];
            double d9 = dArray[n3];
            double d10 = d;
            for (n7 = n3 + 1; n7 < n3 + 25; ++n7) {
                d9 += d10 * dArray[n7];
                d10 *= d;
            }
            dArray[n3] = d9;
            for (n7 = n3 + 1; n7 <= n4; ++n7) {
                int n8 = n7;
                dArray[n8] = dArray[n8] + d * dArray[n7 - 1];
            }
            dArray[n4] = d2 * (2.0 * dArray[n4] - d8);
            for (n7 = n4 - 1; n7 >= n3; --n7) {
                dArray[n7] = d * (dArray[n7 + 1] - dArray[n7]);
            }
        }
    }

    private void scale(double[] dArray, int n, double d) {
        int n2 = n;
        int n3 = dArray.length - n - 1;
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = n4++;
            dArray[n5] = dArray[n5] * d;
        }
    }
}

