/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Embed {
    public static final int ZERO = 0;
    public static final int MINIMUM = 1;
    public static final int MAXIMUM = 2;
    public static final int BACKGROUND = 3;
    public static final int REPEAT = 4;
    public static final int MIRROR = 5;
    public static final int CLAMP = 6;
    public double background = 0.0;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();

    public Image run(Image image, Dimensions dimensions, Coordinates coordinates, int n) {
        double d;
        this.messenger.log(ImageScience.prelude() + "Embed");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        Dimensions dimensions2 = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions2.x + "," + dimensions2.y + "," + dimensions2.z + "," + dimensions2.t + "," + dimensions2.c + ")");
        this.messenger.log("Output image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        if (coordinates.x < 0 || coordinates.x + dimensions2.x > dimensions.x) {
            throw new IllegalArgumentException("Input image does not fit in x-dimension");
        }
        if (coordinates.y < 0 || coordinates.y + dimensions2.y > dimensions.y) {
            throw new IllegalArgumentException("Input image does not fit in y-dimension");
        }
        if (coordinates.z < 0 || coordinates.z + dimensions2.z > dimensions.z) {
            throw new IllegalArgumentException("Input image does not fit in z-dimension");
        }
        if (coordinates.t < 0 || coordinates.t + dimensions2.t > dimensions.t) {
            throw new IllegalArgumentException("Input image does not fit in t-dimension");
        }
        if (coordinates.c < 0 || coordinates.c + dimensions2.c > dimensions.c) {
            throw new IllegalArgumentException("Input image does not fit in c-dimension");
        }
        this.messenger.log("Position of input image: (x,y,z,t,c) = (" + coordinates.x + "," + coordinates.y + "," + coordinates.z + "," + coordinates.t + "," + coordinates.c + ")");
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("Non-supported type of background filling");
        }
        this.messenger.log("Embedding " + image.type());
        Image image2 = Image.create(dimensions, image.type());
        image.axes(1);
        image2.axes(1);
        this.progressor.status("Embedding...");
        switch (n) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                d = image.minimum();
                break;
            }
            case 2: {
                d = image.maximum();
                break;
            }
            case 3: {
                d = this.background;
                break;
            }
            default: {
                d = this.background;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.messenger.log("Background filling with value " + d);
                this.progressor.steps(dimensions2.c * dimensions2.t * dimensions2.z * dimensions2.y);
                Coordinates coordinates2 = new Coordinates();
                Coordinates coordinates3 = coordinates.duplicate();
                double[] dArray = new double[dimensions2.x];
                image2.set(d);
                this.progressor.start();
                coordinates2.c = 0;
                coordinates3.c = coordinates.c;
                while (coordinates2.c < dimensions2.c) {
                    coordinates2.t = 0;
                    coordinates3.t = coordinates.t;
                    while (coordinates2.t < dimensions2.t) {
                        coordinates2.z = 0;
                        coordinates3.z = coordinates.z;
                        while (coordinates2.z < dimensions2.z) {
                            coordinates2.y = 0;
                            coordinates3.y = coordinates.y;
                            while (coordinates2.y < dimensions2.y) {
                                image.get(coordinates2, dArray);
                                image2.set(coordinates3, dArray);
                                this.progressor.step();
                                ++coordinates2.y;
                                ++coordinates3.y;
                            }
                            ++coordinates2.z;
                            ++coordinates3.z;
                        }
                        ++coordinates2.t;
                        ++coordinates3.t;
                    }
                    ++coordinates2.c;
                    ++coordinates3.c;
                }
                break;
            }
            case 4: {
                this.messenger.log("Background filling by repeating the input image");
                this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
                Coordinates coordinates4 = new Coordinates();
                Coordinates coordinates5 = new Coordinates();
                Coordinates coordinates6 = new Coordinates(coordinates.x - 1, coordinates.y - 1, coordinates.z - 1, coordinates.t - 1, coordinates.c - 1);
                Coordinates coordinates7 = new Coordinates(coordinates.x + dimensions2.x, coordinates.y + dimensions2.y, coordinates.z + dimensions2.z, coordinates.t + dimensions2.t, coordinates.c + dimensions2.c);
                Coordinates coordinates8 = new Coordinates(coordinates7.x - 1, coordinates7.y - 1, coordinates7.z - 1, coordinates7.t - 1, coordinates7.c - 1);
                double[] dArray = new double[dimensions.x];
                this.progressor.start();
                coordinates4.x = -coordinates.x;
                coordinates4.c = 0;
                coordinates5.c = coordinates.c;
                while (coordinates4.c < dimensions2.c) {
                    coordinates4.t = 0;
                    coordinates5.t = coordinates.t;
                    while (coordinates4.t < dimensions2.t) {
                        coordinates4.z = 0;
                        coordinates5.z = coordinates.z;
                        while (coordinates4.z < dimensions2.z) {
                            coordinates4.y = 0;
                            coordinates5.y = coordinates.y;
                            while (coordinates4.y < dimensions2.y) {
                                image.get(coordinates4, dArray);
                                int n2 = coordinates6.x;
                                int n3 = coordinates8.x;
                                while (n2 >= 0) {
                                    dArray[n2] = dArray[n3];
                                    --n2;
                                    --n3;
                                }
                                n2 = coordinates7.x;
                                n3 = coordinates.x;
                                while (n2 < dimensions.x) {
                                    dArray[n2] = dArray[n3];
                                    ++n2;
                                    ++n3;
                                }
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    ++coordinates4.c;
                    ++coordinates5.c;
                }
                coordinates4.x = 0;
                coordinates4.c = coordinates5.c = coordinates.c;
                while (coordinates5.c < coordinates7.c) {
                    coordinates4.t = coordinates5.t = coordinates.t;
                    while (coordinates5.t < coordinates7.t) {
                        coordinates4.z = coordinates5.z = coordinates.z;
                        while (coordinates5.z < coordinates7.z) {
                            coordinates4.y = coordinates8.y;
                            coordinates5.y = coordinates6.y;
                            while (coordinates5.y >= 0) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                --coordinates4.y;
                                --coordinates5.y;
                            }
                            coordinates4.y = coordinates.y;
                            coordinates5.y = coordinates7.y;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    ++coordinates4.c;
                    ++coordinates5.c;
                }
                coordinates4.c = coordinates5.c = coordinates.c;
                while (coordinates5.c < coordinates7.c) {
                    coordinates4.t = coordinates5.t = coordinates.t;
                    while (coordinates5.t < coordinates7.t) {
                        coordinates4.z = coordinates8.z;
                        coordinates5.z = coordinates6.z;
                        while (coordinates5.z >= 0) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            --coordinates4.z;
                            --coordinates5.z;
                        }
                        coordinates4.z = coordinates.z;
                        coordinates5.z = coordinates7.z;
                        while (coordinates5.z < dimensions.z) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    ++coordinates4.c;
                    ++coordinates5.c;
                }
                coordinates4.c = coordinates5.c = coordinates.c;
                while (coordinates5.c < coordinates7.c) {
                    coordinates4.t = coordinates8.t;
                    coordinates5.t = coordinates6.t;
                    while (coordinates5.t >= 0) {
                        coordinates5.z = 0;
                        coordinates4.z = 0;
                        while (coordinates5.z < dimensions.z) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        --coordinates4.t;
                        --coordinates5.t;
                    }
                    coordinates4.t = coordinates.t;
                    coordinates5.t = coordinates7.t;
                    while (coordinates5.t < dimensions.t) {
                        coordinates5.z = 0;
                        coordinates4.z = 0;
                        while (coordinates5.z < dimensions.z) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    ++coordinates4.c;
                    ++coordinates5.c;
                }
                coordinates4.c = coordinates8.c;
                coordinates5.c = coordinates6.c;
                while (coordinates5.c >= 0) {
                    coordinates5.t = 0;
                    coordinates4.t = 0;
                    while (coordinates5.t < dimensions.t) {
                        coordinates5.z = 0;
                        coordinates4.z = 0;
                        while (coordinates5.z < dimensions.z) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    --coordinates4.c;
                    --coordinates5.c;
                }
                coordinates4.c = coordinates.c;
                coordinates5.c = coordinates7.c;
                while (coordinates5.c < dimensions.c) {
                    coordinates5.t = 0;
                    coordinates4.t = 0;
                    while (coordinates5.t < dimensions.t) {
                        coordinates5.z = 0;
                        coordinates4.z = 0;
                        while (coordinates5.z < dimensions.z) {
                            coordinates5.y = 0;
                            coordinates4.y = 0;
                            while (coordinates5.y < dimensions.y) {
                                image2.get(coordinates4, dArray);
                                image2.set(coordinates5, dArray);
                                this.progressor.step();
                                ++coordinates4.y;
                                ++coordinates5.y;
                            }
                            ++coordinates4.z;
                            ++coordinates5.z;
                        }
                        ++coordinates4.t;
                        ++coordinates5.t;
                    }
                    ++coordinates4.c;
                    ++coordinates5.c;
                }
                break;
            }
            case 5: {
                int n4;
                int n5;
                this.messenger.log("Background filling by mirroring the input image");
                this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
                Coordinates coordinates9 = new Coordinates();
                Coordinates coordinates10 = new Coordinates();
                Coordinates coordinates11 = new Coordinates(coordinates.x - 1, coordinates.y - 1, coordinates.z - 1, coordinates.t - 1, coordinates.c - 1);
                Coordinates coordinates12 = new Coordinates(coordinates.x + dimensions2.x, coordinates.y + dimensions2.y, coordinates.z + dimensions2.z, coordinates.t + dimensions2.t, coordinates.c + dimensions2.c);
                Coordinates coordinates13 = new Coordinates(dimensions2.x - 1, dimensions2.y - 1, dimensions2.z - 1, dimensions2.t - 1, dimensions2.c - 1);
                double[] dArray = new double[dimensions.x];
                int n6 = 2;
                int n7 = 2;
                int n8 = 2;
                int n9 = 2;
                int n10 = 2;
                this.progressor.start();
                if (dimensions2.x == 1) {
                    ++coordinates13.x;
                    n6 = 1;
                }
                if (dimensions2.y == 1) {
                    ++coordinates13.y;
                    n7 = 1;
                }
                if (dimensions2.z == 1) {
                    ++coordinates13.z;
                    n8 = 1;
                }
                if (dimensions2.t == 1) {
                    ++coordinates13.t;
                    n9 = 1;
                }
                if (dimensions2.c == 1) {
                    ++coordinates13.c;
                    n10 = 1;
                }
                coordinates9.x = -coordinates.x;
                coordinates9.c = 0;
                coordinates10.c = coordinates.c;
                while (coordinates9.c < dimensions2.c) {
                    coordinates9.t = 0;
                    coordinates10.t = coordinates.t;
                    while (coordinates9.t < dimensions2.t) {
                        coordinates9.z = 0;
                        coordinates10.z = coordinates.z;
                        while (coordinates9.z < dimensions2.z) {
                            coordinates9.y = 0;
                            coordinates10.y = coordinates.y;
                            while (coordinates9.y < dimensions2.y) {
                                int n11;
                                image.get(coordinates9, dArray);
                                for (n5 = coordinates11.x; n5 >= 0; --n5) {
                                    n4 = n5 - coordinates.x;
                                    n11 = n4 / coordinates13.x;
                                    n11 += n11 % n6;
                                    dArray[n5] = dArray[coordinates.x + Math.abs(n4 - n11 * coordinates13.x)];
                                }
                                for (n5 = coordinates12.x; n5 < dimensions.x; ++n5) {
                                    n4 = n5 - coordinates.x;
                                    n11 = n4 / coordinates13.x;
                                    n11 += n11 % n6;
                                    dArray[n5] = dArray[coordinates.x + Math.abs(n4 - n11 * coordinates13.x)];
                                }
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        ++coordinates9.t;
                        ++coordinates10.t;
                    }
                    ++coordinates9.c;
                    ++coordinates10.c;
                }
                coordinates9.x = 0;
                coordinates9.c = coordinates10.c = coordinates.c;
                while (coordinates10.c < coordinates12.c) {
                    coordinates9.t = coordinates10.t = coordinates.t;
                    while (coordinates10.t < coordinates12.t) {
                        coordinates9.z = coordinates10.z = coordinates.z;
                        while (coordinates10.z < coordinates12.z) {
                            coordinates10.y = coordinates11.y;
                            while (coordinates10.y >= 0) {
                                n5 = coordinates10.y - coordinates.y;
                                n4 = n5 / coordinates13.y;
                                n4 += n4 % n7;
                                coordinates9.y = coordinates.y + Math.abs(n5 - n4 * coordinates13.y);
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                --coordinates10.y;
                            }
                            coordinates10.y = coordinates12.y;
                            while (coordinates10.y < dimensions.y) {
                                n5 = coordinates10.y - coordinates.y;
                                n4 = n5 / coordinates13.y;
                                n4 += n4 % n7;
                                coordinates9.y = coordinates.y + Math.abs(n5 - n4 * coordinates13.y);
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        ++coordinates9.t;
                        ++coordinates10.t;
                    }
                    ++coordinates9.c;
                    ++coordinates10.c;
                }
                coordinates9.c = coordinates10.c = coordinates.c;
                while (coordinates10.c < coordinates12.c) {
                    coordinates9.t = coordinates10.t = coordinates.t;
                    while (coordinates10.t < coordinates12.t) {
                        coordinates10.z = coordinates11.z;
                        while (coordinates10.z >= 0) {
                            n5 = coordinates10.z - coordinates.z;
                            n4 = n5 / coordinates13.z;
                            n4 += n4 % n8;
                            coordinates9.z = coordinates.z + Math.abs(n5 - n4 * coordinates13.z);
                            coordinates9.y = 0;
                            coordinates10.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            --coordinates10.z;
                        }
                        coordinates10.z = coordinates12.z;
                        while (coordinates10.z < dimensions.z) {
                            n5 = coordinates10.z - coordinates.z;
                            n4 = n5 / coordinates13.z;
                            n4 += n4 % n8;
                            coordinates9.z = coordinates.z + Math.abs(n5 - n4 * coordinates13.z);
                            coordinates9.y = 0;
                            coordinates10.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates10.z;
                        }
                        ++coordinates9.t;
                        ++coordinates10.t;
                    }
                    ++coordinates9.c;
                    ++coordinates10.c;
                }
                coordinates9.c = coordinates10.c = coordinates.c;
                while (coordinates10.c < coordinates12.c) {
                    coordinates10.t = coordinates11.t;
                    while (coordinates10.t >= 0) {
                        n5 = coordinates10.t - coordinates.t;
                        n4 = n5 / coordinates13.t;
                        n4 += n4 % n9;
                        coordinates9.t = coordinates.t + Math.abs(n5 - n4 * coordinates13.t);
                        coordinates10.z = 0;
                        coordinates9.z = 0;
                        while (coordinates10.z < dimensions.z) {
                            coordinates10.y = 0;
                            coordinates9.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        --coordinates10.t;
                    }
                    coordinates10.t = coordinates12.t;
                    while (coordinates10.t < dimensions.t) {
                        n5 = coordinates10.t - coordinates.t;
                        n4 = n5 / coordinates13.t;
                        n4 += n4 % n9;
                        coordinates9.t = coordinates.t + Math.abs(n5 - n4 * coordinates13.t);
                        coordinates10.z = 0;
                        coordinates9.z = 0;
                        while (coordinates10.z < dimensions.z) {
                            coordinates10.y = 0;
                            coordinates9.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        ++coordinates10.t;
                    }
                    ++coordinates9.c;
                    ++coordinates10.c;
                }
                coordinates10.c = coordinates11.c;
                while (coordinates10.c >= 0) {
                    n5 = coordinates10.c - coordinates.c;
                    n4 = n5 / coordinates13.c;
                    n4 += n4 % n10;
                    coordinates9.c = coordinates.c + Math.abs(n5 - n4 * coordinates13.c);
                    coordinates10.t = 0;
                    coordinates9.t = 0;
                    while (coordinates10.t < dimensions.t) {
                        coordinates10.z = 0;
                        coordinates9.z = 0;
                        while (coordinates10.z < dimensions.z) {
                            coordinates10.y = 0;
                            coordinates9.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        ++coordinates9.t;
                        ++coordinates10.t;
                    }
                    --coordinates10.c;
                }
                coordinates10.c = coordinates12.c;
                while (coordinates10.c < dimensions.c) {
                    n5 = coordinates10.c - coordinates.c;
                    n4 = n5 / coordinates13.c;
                    n4 += n4 % n10;
                    coordinates9.c = coordinates.c + Math.abs(n5 - n4 * coordinates13.c);
                    coordinates10.t = 0;
                    coordinates9.t = 0;
                    while (coordinates10.t < dimensions.t) {
                        coordinates10.z = 0;
                        coordinates9.z = 0;
                        while (coordinates10.z < dimensions.z) {
                            coordinates10.y = 0;
                            coordinates9.y = 0;
                            while (coordinates10.y < dimensions.y) {
                                image2.get(coordinates9, dArray);
                                image2.set(coordinates10, dArray);
                                this.progressor.step();
                                ++coordinates9.y;
                                ++coordinates10.y;
                            }
                            ++coordinates9.z;
                            ++coordinates10.z;
                        }
                        ++coordinates9.t;
                        ++coordinates10.t;
                    }
                    ++coordinates10.c;
                }
                break;
            }
            case 6: {
                this.messenger.log("Background filling by clamping the input image");
                this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
                Coordinates coordinates14 = new Coordinates();
                Coordinates coordinates15 = new Coordinates();
                Coordinates coordinates16 = new Coordinates(coordinates.x - 1, coordinates.y - 1, coordinates.z - 1, coordinates.t - 1, coordinates.c - 1);
                Coordinates coordinates17 = new Coordinates(coordinates.x + dimensions2.x, coordinates.y + dimensions2.y, coordinates.z + dimensions2.z, coordinates.t + dimensions2.t, coordinates.c + dimensions2.c);
                Coordinates coordinates18 = new Coordinates(coordinates17.x - 1, coordinates17.y - 1, coordinates17.z - 1, coordinates17.t - 1, coordinates17.c - 1);
                double[] dArray = new double[dimensions.x];
                this.progressor.start();
                coordinates14.x = -coordinates.x;
                coordinates14.c = 0;
                coordinates15.c = coordinates.c;
                while (coordinates14.c < dimensions2.c) {
                    coordinates14.t = 0;
                    coordinates15.t = coordinates.t;
                    while (coordinates14.t < dimensions2.t) {
                        coordinates14.z = 0;
                        coordinates15.z = coordinates.z;
                        while (coordinates14.z < dimensions2.z) {
                            coordinates14.y = 0;
                            coordinates15.y = coordinates.y;
                            while (coordinates14.y < dimensions2.y) {
                                int n12;
                                image.get(coordinates14, dArray);
                                double d2 = dArray[coordinates.x];
                                double d3 = dArray[coordinates18.x];
                                for (n12 = coordinates16.x; n12 >= 0; --n12) {
                                    dArray[n12] = d2;
                                }
                                for (n12 = coordinates17.x; n12 < dimensions.x; ++n12) {
                                    dArray[n12] = d3;
                                }
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        ++coordinates14.t;
                        ++coordinates15.t;
                    }
                    ++coordinates14.c;
                    ++coordinates15.c;
                }
                coordinates14.x = 0;
                coordinates14.c = coordinates.c;
                coordinates15.c = coordinates.c;
                while (coordinates15.c < coordinates17.c) {
                    coordinates14.t = coordinates15.t = coordinates.t;
                    while (coordinates15.t < coordinates17.t) {
                        coordinates14.z = coordinates15.z = coordinates.z;
                        while (coordinates15.z < coordinates17.z) {
                            coordinates14.y = coordinates.y;
                            image2.get(coordinates14, dArray);
                            coordinates15.y = coordinates16.y;
                            while (coordinates15.y >= 0) {
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                --coordinates15.y;
                            }
                            coordinates14.y = coordinates18.y;
                            image2.get(coordinates14, dArray);
                            coordinates15.y = coordinates17.y;
                            while (coordinates15.y < dimensions.y) {
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        ++coordinates14.t;
                        ++coordinates15.t;
                    }
                    ++coordinates14.c;
                    ++coordinates15.c;
                }
                coordinates14.c = coordinates15.c = coordinates.c;
                while (coordinates15.c < coordinates17.c) {
                    coordinates14.t = coordinates15.t = coordinates.t;
                    while (coordinates15.t < coordinates17.t) {
                        coordinates14.z = coordinates.z;
                        coordinates15.z = coordinates16.z;
                        while (coordinates15.z >= 0) {
                            coordinates15.y = 0;
                            coordinates14.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            --coordinates15.z;
                        }
                        coordinates14.z = coordinates18.z;
                        coordinates15.z = coordinates17.z;
                        while (coordinates15.z < dimensions.z) {
                            coordinates14.y = 0;
                            coordinates15.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates15.z;
                        }
                        ++coordinates14.t;
                        ++coordinates15.t;
                    }
                    ++coordinates14.c;
                    ++coordinates15.c;
                }
                coordinates14.c = coordinates15.c = coordinates.c;
                while (coordinates15.c < coordinates17.c) {
                    coordinates14.t = coordinates.t;
                    coordinates15.t = coordinates16.t;
                    while (coordinates15.t >= 0) {
                        coordinates15.z = 0;
                        coordinates14.z = 0;
                        while (coordinates15.z < dimensions.z) {
                            coordinates15.y = 0;
                            coordinates14.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        --coordinates15.t;
                    }
                    coordinates14.t = coordinates18.t;
                    coordinates15.t = coordinates17.t;
                    while (coordinates15.t < dimensions.t) {
                        coordinates15.z = 0;
                        coordinates14.z = 0;
                        while (coordinates15.z < dimensions.z) {
                            coordinates15.y = 0;
                            coordinates14.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        ++coordinates15.t;
                    }
                    ++coordinates14.c;
                    ++coordinates15.c;
                }
                coordinates14.c = coordinates.c;
                coordinates15.c = coordinates16.c;
                while (coordinates15.c >= 0) {
                    coordinates15.t = 0;
                    coordinates14.t = 0;
                    while (coordinates15.t < dimensions.t) {
                        coordinates15.z = 0;
                        coordinates14.z = 0;
                        while (coordinates15.z < dimensions.z) {
                            coordinates15.y = 0;
                            coordinates14.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        ++coordinates14.t;
                        ++coordinates15.t;
                    }
                    --coordinates15.c;
                }
                coordinates14.c = coordinates18.c;
                coordinates15.c = coordinates17.c;
                while (coordinates15.c < dimensions.c) {
                    coordinates15.t = 0;
                    coordinates14.t = 0;
                    while (coordinates15.t < dimensions.t) {
                        coordinates15.z = 0;
                        coordinates14.z = 0;
                        while (coordinates15.z < dimensions.z) {
                            coordinates15.y = 0;
                            coordinates14.y = 0;
                            while (coordinates15.y < dimensions.y) {
                                image2.get(coordinates14, dArray);
                                image2.set(coordinates15, dArray);
                                this.progressor.step();
                                ++coordinates14.y;
                                ++coordinates15.y;
                            }
                            ++coordinates14.z;
                            ++coordinates15.z;
                        }
                        ++coordinates14.t;
                        ++coordinates15.t;
                    }
                    ++coordinates15.c;
                }
                break;
            }
        }
        image2.name(image.name() + " embedded");
        image2.aspects(image.aspects().duplicate());
        this.progressor.stop();
        timer.stop();
        return image2;
    }
}

