/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Crop {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();

    public Image run(Image image, Coordinates coordinates, Coordinates coordinates2) {
        this.messenger.log(ImageScience.prelude() + "Crop");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        Dimensions dimensions = image.dimensions();
        if (coordinates.x < 0 || coordinates2.x >= dimensions.x || coordinates.x > coordinates2.x) {
            throw new IllegalArgumentException("Crop range invalid in x-dimension");
        }
        if (coordinates.y < 0 || coordinates2.y >= dimensions.y || coordinates.y > coordinates2.y) {
            throw new IllegalArgumentException("Crop range invalid in y-dimension");
        }
        if (coordinates.z < 0 || coordinates2.z >= dimensions.z || coordinates.z > coordinates2.z) {
            throw new IllegalArgumentException("Crop range invalid in z-dimension");
        }
        if (coordinates.t < 0 || coordinates2.t >= dimensions.t || coordinates.t > coordinates2.t) {
            throw new IllegalArgumentException("Crop range invalid in t-dimension");
        }
        if (coordinates.c < 0 || coordinates2.c >= dimensions.c || coordinates.c > coordinates2.c) {
            throw new IllegalArgumentException("Crop range invalid in c-dimension");
        }
        this.messenger.log("Crop range in x-dimension: [" + coordinates.x + "," + coordinates2.x + "]");
        this.messenger.log("Crop range in y-dimension: [" + coordinates.y + "," + coordinates2.y + "]");
        this.messenger.log("Crop range in z-dimension: [" + coordinates.z + "," + coordinates2.z + "]");
        this.messenger.log("Crop range in t-dimension: [" + coordinates.t + "," + coordinates2.t + "]");
        this.messenger.log("Crop range in c-dimension: [" + coordinates.c + "," + coordinates2.c + "]");
        Dimensions dimensions2 = new Dimensions(coordinates2.x - coordinates.x + 1, coordinates2.y - coordinates.y + 1, coordinates2.z - coordinates.z + 1, coordinates2.t - coordinates.t + 1, coordinates2.c - coordinates.c + 1);
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        this.messenger.log("Output image dimensions: (x,y,z,t,c) = (" + dimensions2.x + "," + dimensions2.y + "," + dimensions2.z + "," + dimensions2.t + "," + dimensions2.c + ")");
        this.messenger.log("Cropping " + image.type());
        Image image2 = Image.create(dimensions2, image.type());
        image.axes(1);
        image2.axes(1);
        Coordinates coordinates3 = new Coordinates();
        coordinates3.x = coordinates.x;
        Coordinates coordinates4 = new Coordinates();
        double[] dArray = new double[dimensions2.x];
        this.progressor.status("Cropping...");
        this.progressor.steps(dimensions2.c * dimensions2.t * dimensions2.z);
        this.progressor.start();
        coordinates3.c = coordinates.c;
        coordinates4.c = 0;
        while (coordinates3.c <= coordinates2.c) {
            coordinates3.t = coordinates.t;
            coordinates4.t = 0;
            while (coordinates3.t <= coordinates2.t) {
                coordinates3.z = coordinates.z;
                coordinates4.z = 0;
                while (coordinates3.z <= coordinates2.z) {
                    coordinates3.y = coordinates.y;
                    coordinates4.y = 0;
                    while (coordinates3.y <= coordinates2.y) {
                        image.get(coordinates3, dArray);
                        image2.set(coordinates4, dArray);
                        ++coordinates3.y;
                        ++coordinates4.y;
                    }
                    this.progressor.step();
                    ++coordinates3.z;
                    ++coordinates4.z;
                }
                ++coordinates3.t;
                ++coordinates4.t;
            }
            ++coordinates3.c;
            ++coordinates4.c;
        }
        image2.name(image.name() + " cropped");
        image2.aspects(image.aspects().duplicate());
        this.progressor.stop();
        timer.stop();
        return image2;
    }
}

