/*
 * Decompiled with CFR 0.152.
 */
package imagescience.transform;

import imagescience.ImageScience;
import imagescience.image.Aspects;
import imagescience.image.Axes;
import imagescience.image.Borders;
import imagescience.image.ColorImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.shape.Point;
import imagescience.transform.Prefilter;
import imagescience.transform.Transform;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Affine {
    public static final int NEAREST = 0;
    public static final int LINEAR = 1;
    public static final int CUBIC = 2;
    public static final int BSPLINE3 = 3;
    public static final int OMOMS3 = 4;
    public static final int BSPLINE5 = 5;
    public double background = 0.0;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private final Prefilter prefilter = new Prefilter();
    private Dimensions idims;
    private Dimensions odims;
    private Transform fwd;
    private Transform bwd;
    private String component = "";
    private Borders borders;
    private int interpolation;
    private double ivx;
    private double ivy;
    private double ivz;
    private double ovx;
    private double ovy;
    private double ovz;
    private Point ipc;
    private Point opc;
    private Point ipmax;
    private boolean doxy;
    private boolean antialias;
    private final double D1O2 = 0.5;
    private final double D1O4 = 0.25;
    private final double D1O6 = 0.16666666666666666;
    private final double D1O12 = 0.08333333333333333;
    private final double D1O14 = 0.07142857142857142;
    private final double D1O24 = 0.041666666666666664;
    private final double D1O42 = 0.023809523809523808;
    private final double D1O120 = 0.008333333333333333;
    private final double D2O3 = 0.6666666666666666;
    private final double D3O2 = 1.5;
    private final double D5O2 = 2.5;
    private final double D11O20 = 0.55;
    private final double D13O21 = 0.6190476190476191;
    private final double DM1O2 = -0.5;
    private final double BSPLINE3X0 = 0.666666666667;
    private final double BSPLINE5X0 = 0.55;
    private final double OMOMS3X0 = 0.619047619048;

    public synchronized Image run(Image image, Transform transform, int n, boolean bl, boolean bl2, boolean bl3) {
        this.messenger.log(ImageScience.prelude() + "Affine");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.initialize(image, transform, n, bl, bl2, bl3);
        this.messenger.log("Affine transforming " + image.type());
        Image image2 = null;
        if (image instanceof ColorImage) {
            this.messenger.log("Processing RGB-color components separately");
            ColorImage colorImage = (ColorImage)image;
            this.progressor.range(0.0, 0.33);
            this.component = " red component";
            this.messenger.log("Affine transforming" + this.component);
            colorImage.component(1);
            Image image3 = colorImage.get();
            image3 = this.affine(image3);
            ColorImage colorImage2 = new ColorImage(image3.dimensions());
            colorImage2.component(1);
            colorImage2.set(image3);
            this.progressor.range(0.33, 0.67);
            this.component = " green component";
            this.messenger.log("Affine transforming" + this.component);
            colorImage.component(2);
            image3 = colorImage.get();
            image3 = this.affine(image3);
            colorImage2.component(2);
            colorImage2.set(image3);
            this.progressor.range(0.67, 1.0);
            this.component = " blue component";
            this.messenger.log("Affine transforming" + this.component);
            colorImage.component(3);
            image3 = colorImage.get();
            image3 = this.affine(image3);
            colorImage2.component(3);
            colorImage2.set(image3);
            image2 = colorImage2;
        } else {
            this.component = "";
            this.progressor.range(0.0, 1.0);
            image2 = this.affine(image);
        }
        image2.name(image.name() + " affined");
        image2.aspects(new Aspects(this.ovx, this.ovy, this.ovz, image.aspects().t, image.aspects().c));
        timer.stop();
        return image2;
    }

    private Image affine(Image image) {
        boolean bl;
        boolean bl2 = this.ovx == this.ivx;
        boolean bl3 = this.ovy == this.ivy;
        boolean bl4 = bl = this.ovz == this.ivz;
        if (this.fwd.identity() && bl2 && bl3 && bl) {
            this.messenger.log("No interpolation is needed");
            this.messenger.log("Returning a copy of the input image");
            return image.duplicate();
        }
        Image image2 = image;
        if (this.interpolation == 1 || this.interpolation == 2) {
            this.messenger.log("Creating bordered copy of input image");
            image2 = image.border(this.borders);
        } else if (this.interpolation == 3 || this.interpolation == 4 || this.interpolation == 5) {
            this.messenger.log("Creating bordered floating-point copy of input image");
            image2 = new FloatImage(image, this.borders);
        }
        this.messenger.log("Allocating memory for output image");
        Image image3 = Image.create(this.odims, image.type());
        switch (this.interpolation) {
            case 0: {
                if (this.doxy) {
                    this.affine_nearest_xy(image2, image3);
                    break;
                }
                this.affine_nearest_xyz(image2, image3);
                break;
            }
            case 1: {
                if (this.doxy) {
                    this.affine_linear_xy(image2, image3);
                    break;
                }
                this.affine_linear_xyz(image2, image3);
                break;
            }
            case 2: {
                if (this.doxy) {
                    this.affine_cubic_xy(image2, image3);
                    break;
                }
                this.affine_cubic_xyz(image2, image3);
                break;
            }
            case 3: {
                if (this.doxy) {
                    this.affine_bspline3_xy(image2, image3);
                    break;
                }
                this.affine_bspline3_xyz(image2, image3);
                break;
            }
            case 4: {
                if (this.doxy) {
                    this.affine_omoms3_xy(image2, image3);
                    break;
                }
                this.affine_omoms3_xyz(image2, image3);
                break;
            }
            case 5: {
                if (this.doxy) {
                    this.affine_bspline5_xy(image2, image3);
                    break;
                }
                this.affine_bspline5_xyz(image2, image3);
            }
        }
        return image3;
    }

    private void initialize(Image image, Transform transform, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        this.fwd = transform.duplicate();
        if (bl) {
            this.messenger.log("Adjusting output image dimensions to fit result");
            this.messenger.log("Therefore ignoring any translation components");
            this.fwd.azt = 0.0;
            this.fwd.ayt = 0.0;
            this.fwd.axt = 0.0;
        }
        this.messenger.log("Forward affine transformation matrix:");
        this.messenger.log(this.fwd.string());
        double d = this.fwd.determinant();
        if (d == 0.0) {
            throw new IllegalArgumentException("Non-invertible transformation matrix");
        }
        this.bwd = this.fwd.duplicate();
        this.bwd.invert();
        this.messenger.log("Backward affine transformation matrix:");
        this.messenger.log(this.bwd.string());
        this.ovx = this.ivx = image.aspects().x;
        this.ovy = this.ivy = image.aspects().y;
        this.ovz = this.ivz = image.aspects().z;
        if (this.ivx <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (this.ivy <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (this.ivz <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        if (bl2) {
            double d2 = this.ivx < this.ivy ? this.ivx : this.ivy;
            this.ovy = this.ovz = (d2 = this.ivz < d2 ? this.ivz : d2);
            this.ovx = this.ovz;
        }
        this.idims = image.dimensions();
        this.ipmax = new Point(this.idims.x - 1, this.idims.y - 1, this.idims.z - 1);
        this.ipc = new Point(0.5 * this.ivx * this.ipmax.x, 0.5 * this.ivy * this.ipmax.y, 0.5 * this.ivz * this.ipmax.z);
        Point point = new Point(-0.5 * this.ovx, -0.5 * this.ovy, -0.5 * this.ovz);
        Point point2 = new Point((this.ipmax.x + 0.5) * this.ovx, (this.ipmax.y + 0.5) * this.ovy, (this.ipmax.z + 0.5) * this.ovz);
        if (bl) {
            Point point3 = new Point(-this.ipc.x - 0.5 * this.ivx, -this.ipc.y - 0.5 * this.ivy, -this.ipc.z - 0.5 * this.ivz);
            Point point4 = new Point(-point3.x, point3.y, point3.z);
            Point point5 = new Point(point3.x, -point3.y, point3.z);
            Point point6 = new Point(-point3.x, -point3.y, point3.z);
            Point point7 = new Point(point3.x, point3.y, -point3.z);
            Point point8 = new Point(-point3.x, point3.y, -point3.z);
            Point point9 = new Point(point3.x, -point3.y, -point3.z);
            Point point10 = new Point(-point3.x, -point3.y, -point3.z);
            this.fwd.transform(point3);
            this.fwd.transform(point4);
            this.fwd.transform(point5);
            this.fwd.transform(point6);
            this.fwd.transform(point7);
            this.fwd.transform(point8);
            this.fwd.transform(point9);
            this.fwd.transform(point10);
            point.x = FMath.min(point3.x, point4.x, point5.x, point6.x, point7.x, point8.x, point9.x, point10.x);
            point.y = FMath.min(point3.y, point4.y, point5.y, point6.y, point7.y, point8.y, point9.y, point10.y);
            point.z = FMath.min(point3.z, point4.z, point5.z, point6.z, point7.z, point8.z, point9.z, point10.z);
            point2.x = FMath.max(point3.x, point4.x, point5.x, point6.x, point7.x, point8.x, point9.x, point10.x);
            point2.y = FMath.max(point3.y, point4.y, point5.y, point6.y, point7.y, point8.y, point9.y, point10.y);
            point2.z = FMath.max(point3.z, point4.z, point5.z, point6.z, point7.z, point8.z, point9.z, point10.z);
        } else {
            this.messenger.log("Not adjusting image dimensions");
        }
        int n4 = FMath.round((point2.x - point.x) / this.ovx);
        if (n4 < 1) {
            n4 = 1;
        }
        if ((n3 = FMath.round((point2.y - point.y) / this.ovy)) < 1) {
            n3 = 1;
        }
        if ((n2 = FMath.round((point2.z - point.z) / this.ovz)) < 1) {
            n2 = 1;
        }
        this.odims = new Dimensions(n4, n3, n2, this.idims.t, this.idims.c);
        this.opc = new Point(0.5 * this.ovx * (double)(this.odims.x - 1), 0.5 * this.ovy * (double)(this.odims.y - 1), 0.5 * this.ovz * (double)(this.odims.z - 1));
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + this.idims.x + "," + this.idims.y + "," + this.idims.z + "," + this.idims.t + "," + this.idims.c + ")");
        this.messenger.log("Output image dimensions: (x,y,z,t,c) = (" + this.odims.x + "," + this.odims.y + "," + this.odims.z + "," + this.odims.t + "," + this.odims.c + ")");
        this.messenger.log("Resampling output image on " + (bl2 ? "isotropic" : "input") + " grid");
        this.messenger.log("Input voxel dimensions: (x,y,z) = (" + this.ivx + "," + this.ivy + "," + this.ivz + ")");
        this.messenger.log("Output voxel dimensions: (x,y,z) = (" + this.ovx + "," + this.ovy + "," + this.ovz + ")");
        this.antialias = bl3;
        if (bl3) {
            this.messenger.log("Anti-aliasing image-background transitions");
        }
        this.messenger.log("Selecting " + this.schemes(n));
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Non-supported interpolation scheme");
        }
        this.interpolation = n;
        this.messenger.log("Background filling with value " + this.background);
        int n5 = 0;
        switch (n) {
            case 0: {
                n5 = 0;
                break;
            }
            case 1: {
                n5 = 1;
                break;
            }
            case 2: {
                n5 = 2;
                break;
            }
            case 3: {
                n5 = 2;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            case 5: {
                n5 = 3;
            }
        }
        this.doxy = this.fwd.azx == 0.0 && this.fwd.azy == 0.0 && this.fwd.azz == 1.0 && this.fwd.azt == 0.0 && this.ovz == this.ivz;
        this.borders = this.doxy ? new Borders(n5, n5, 0) : new Borders(n5, n5, n5);
    }

    private void affine_nearest_xy(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            coordinates.x = FMath.round((this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx);
                            coordinates.y = FMath.round((this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy);
                            dArray[i] = coordinates.x < 0 || (double)coordinates.x > this.ipmax.x || coordinates.y < 0 || (double)coordinates.y > this.ipmax.y ? this.background : image.get(coordinates);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_nearest_xyz(Image image, Image image2) {
        this.messenger.log("Nearest-neighbor sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            coordinates.x = FMath.round((this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx);
                            coordinates.y = FMath.round((this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy);
                            coordinates.z = FMath.round((this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz);
                            dArray[i] = coordinates.x < 0 || (double)coordinates.x > this.ipmax.x || coordinates.y < 0 || (double)coordinates.y > this.ipmax.y || coordinates.z < 0 || (double)coordinates.z > this.ipmax.z ? this.background : image.get(coordinates);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_linear_xy(Image image, Image image2) {
        this.messenger.log("Linear sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d6 = d4 - (double)n;
                            double d7 = d5 - (double)n2;
                            double d8 = 1.0 - d6;
                            double d9 = 1.0 - d7;
                            coordinates.x = this.borders.x + n;
                            coordinates.y = this.borders.y + n2;
                            double d10 = image.get(coordinates);
                            ++coordinates.x;
                            double d11 = image.get(coordinates);
                            ++coordinates.y;
                            double d12 = image.get(coordinates);
                            --coordinates.x;
                            double d13 = image.get(coordinates);
                            dArray[i] = d9 * d8 * d10 + d9 * d6 * d11 + d7 * d8 * d13 + d7 * d6 * d12;
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_linear_xyz(Image image, Image image2) {
        this.messenger.log("Linear sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            double d6 = (this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            int n3 = FMath.floor(d6);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y || d6 < -1.0 || (double)n3 > this.ipmax.z) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d4 - (double)n;
                            double d8 = d5 - (double)n2;
                            double d9 = d6 - (double)n3;
                            double d10 = 1.0 - d7;
                            double d11 = 1.0 - d8;
                            double d12 = 1.0 - d9;
                            coordinates.x = this.borders.x + n;
                            coordinates.y = this.borders.y + n2;
                            coordinates.z = this.borders.z + n3;
                            double d13 = image.get(coordinates);
                            ++coordinates.x;
                            double d14 = image.get(coordinates);
                            ++coordinates.y;
                            double d15 = image.get(coordinates);
                            --coordinates.x;
                            double d16 = image.get(coordinates);
                            ++coordinates.z;
                            double d17 = image.get(coordinates);
                            ++coordinates.x;
                            double d18 = image.get(coordinates);
                            --coordinates.y;
                            double d19 = image.get(coordinates);
                            --coordinates.x;
                            double d20 = image.get(coordinates);
                            dArray[i] = d12 * d11 * d10 * d13 + d12 * d11 * d7 * d14 + d12 * d8 * d10 * d16 + d12 * d8 * d7 * d15 + d9 * d11 * d10 * d20 + d9 * d11 * d7 * d19 + d9 * d8 * d10 * d17 + d9 * d8 * d7 * d18;
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_cubic_xy(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d6 = d4 - (double)n;
                            double d7 = 1.0 - d6;
                            double d8 = -0.5 * d6 * d7 * d7;
                            double d9 = 1.0 + (1.5 * d6 - 2.5) * d6 * d6;
                            double d10 = 1.0 + (1.5 * d7 - 2.5) * d7 * d7;
                            double d11 = -0.5 * d7 * d6 * d6;
                            double d12 = d5 - (double)n2;
                            double d13 = 1.0 - d12;
                            double d14 = -0.5 * d12 * d13 * d13;
                            double d15 = 1.0 + (1.5 * d12 - 2.5) * d12 * d12;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = -0.5 * d13 * d12 * d12;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d18 = image.get(coordinates);
                            ++coordinates.x;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.y;
                            double d22 = image.get(coordinates);
                            --coordinates.x;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            ++coordinates.y;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.y;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            dArray[i] = d14 * (d8 * d18 + d9 * d19 + d10 * d20 + d11 * d21) + d15 * (d8 * d25 + d9 * d24 + d10 * d23 + d11 * d22) + d16 * (d8 * d26 + d9 * d27 + d10 * d28 + d11 * d29) + d17 * (d8 * d33 + d9 * d32 + d10 * d31 + d11 * d30);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_cubic_xyz(Image image, Image image2) {
        this.messenger.log("Cubic convolution sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        if (this.antialias) {
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            double d6 = (this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            int n3 = FMath.floor(d6);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y || d6 < -1.0 || (double)n3 > this.ipmax.z) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d4 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = -0.5 * d7 * d8 * d8;
                            double d10 = 1.0 + (1.5 * d7 - 2.5) * d7 * d7;
                            double d11 = 1.0 + (1.5 * d8 - 2.5) * d8 * d8;
                            double d12 = -0.5 * d8 * d7 * d7;
                            double d13 = d5 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = -0.5 * d13 * d14 * d14;
                            double d16 = 1.0 + (1.5 * d13 - 2.5) * d13 * d13;
                            double d17 = 1.0 + (1.5 * d14 - 2.5) * d14 * d14;
                            double d18 = -0.5 * d14 * d13 * d13;
                            double d19 = d6 - (double)n3;
                            double d20 = 1.0 - d19;
                            double d21 = -0.5 * d19 * d20 * d20;
                            double d22 = 1.0 + (1.5 * d19 - 2.5) * d19 * d19;
                            double d23 = 1.0 + (1.5 * d20 - 2.5) * d20 * d20;
                            double d24 = -0.5 * d20 * d19 * d19;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d25 = image.get(coordinates);
                            ++coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.y;
                            double d29 = image.get(coordinates);
                            --coordinates.x;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.y;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.x;
                            double d35 = image.get(coordinates);
                            ++coordinates.x;
                            double d36 = image.get(coordinates);
                            ++coordinates.y;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            --coordinates.x;
                            double d39 = image.get(coordinates);
                            --coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.z;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.y;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.y;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            ++coordinates.x;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.y;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.x;
                            double d55 = image.get(coordinates);
                            --coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.z;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            ++coordinates.x;
                            double d59 = image.get(coordinates);
                            ++coordinates.x;
                            double d60 = image.get(coordinates);
                            ++coordinates.y;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            --coordinates.x;
                            double d63 = image.get(coordinates);
                            --coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.x;
                            double d65 = image.get(coordinates);
                            ++coordinates.y;
                            double d66 = image.get(coordinates);
                            ++coordinates.x;
                            double d67 = image.get(coordinates);
                            ++coordinates.x;
                            double d68 = image.get(coordinates);
                            ++coordinates.y;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            --coordinates.x;
                            double d71 = image.get(coordinates);
                            --coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.z;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.x;
                            double d75 = image.get(coordinates);
                            ++coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.y;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            --coordinates.x;
                            double d79 = image.get(coordinates);
                            --coordinates.x;
                            double d80 = image.get(coordinates);
                            --coordinates.y;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            ++coordinates.x;
                            double d83 = image.get(coordinates);
                            ++coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.y;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.x;
                            double d87 = image.get(coordinates);
                            --coordinates.x;
                            double d88 = image.get(coordinates);
                            dArray[i] = d21 * (d15 * (d9 * d25 + d10 * d26 + d11 * d27 + d12 * d28) + d16 * (d9 * d32 + d10 * d31 + d11 * d30 + d12 * d29) + d17 * (d9 * d33 + d10 * d34 + d11 * d35 + d12 * d36) + d18 * (d9 * d40 + d10 * d39 + d11 * d38 + d12 * d37)) + d22 * (d15 * (d9 * d56 + d10 * d55 + d11 * d54 + d12 * d53) + d16 * (d9 * d49 + d10 * d50 + d11 * d51 + d12 * d52) + d17 * (d9 * d48 + d10 * d47 + d11 * d46 + d12 * d45) + d18 * (d9 * d41 + d10 * d42 + d11 * d43 + d12 * d44)) + d23 * (d15 * (d9 * d57 + d10 * d58 + d11 * d59 + d12 * d60) + d16 * (d9 * d65 + d10 * d63 + d11 * d62 + d12 * d61) + d17 * (d9 * d64 + d10 * d66 + d11 * d67 + d12 * d68) + d18 * (d9 * d72 + d10 * d71 + d11 * d70 + d12 * d69)) + d24 * (d15 * (d9 * d88 + d10 * d87 + d11 * d86 + d12 * d85) + d16 * (d9 * d81 + d10 * d82 + d11 * d83 + d12 * d84) + d17 * (d9 * d80 + d10 * d79 + d11 * d78 + d12 * d77) + d18 * (d9 * d73 + d10 * d74 + d11 * d75 + d12 * d76));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_bspline3_xy(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.y == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d6 = d4 - (double)n;
                            double d7 = 1.0 - d6;
                            double d8 = 0.16666666666666666 * d7 * d7 * d7;
                            double d9 = 0.6666666666666666 + (0.5 * d6 - 1.0) * d6 * d6;
                            double d10 = 0.6666666666666666 + (0.5 * d7 - 1.0) * d7 * d7;
                            double d11 = 0.16666666666666666 * d6 * d6 * d6;
                            double d12 = d5 - (double)n2;
                            double d13 = 1.0 - d12;
                            double d14 = 0.16666666666666666 * d13 * d13 * d13;
                            double d15 = 0.6666666666666666 + (0.5 * d12 - 1.0) * d12 * d12;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.16666666666666666 * d12 * d12 * d12;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d18 = image.get(coordinates);
                            ++coordinates.x;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.y;
                            double d22 = image.get(coordinates);
                            --coordinates.x;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            ++coordinates.y;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.y;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            dArray[i] = d14 * (d8 * d18 + d9 * d19 + d10 * d20 + d11 * d21) + d15 * (d8 * d25 + d9 * d24 + d10 * d23 + d11 * d22) + d16 * (d8 * d26 + d9 * d27 + d10 * d28 + d11 * d29) + d17 * (d8 * d33 + d9 * d32 + d10 * d31 + d11 * d30);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_bspline3_xyz(Image image, Image image2) {
        this.messenger.log("Cubic B-spline prefiltering and sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline3(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.y == 1) {
                d /= 0.666666666667;
            }
            if (this.idims.z == 1) {
                d /= 0.666666666667;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            double d6 = (this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            int n3 = FMath.floor(d6);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y || d6 < -1.0 || (double)n3 > this.ipmax.z) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d4 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = 0.16666666666666666 * d8 * d8 * d8;
                            double d10 = 0.6666666666666666 + (0.5 * d7 - 1.0) * d7 * d7;
                            double d11 = 0.6666666666666666 + (0.5 * d8 - 1.0) * d8 * d8;
                            double d12 = 0.16666666666666666 * d7 * d7 * d7;
                            double d13 = d5 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = 0.16666666666666666 * d14 * d14 * d14;
                            double d16 = 0.6666666666666666 + (0.5 * d13 - 1.0) * d13 * d13;
                            double d17 = 0.6666666666666666 + (0.5 * d14 - 1.0) * d14 * d14;
                            double d18 = 0.16666666666666666 * d13 * d13 * d13;
                            double d19 = d6 - (double)n3;
                            double d20 = 1.0 - d19;
                            double d21 = 0.16666666666666666 * d20 * d20 * d20;
                            double d22 = 0.6666666666666666 + (0.5 * d19 - 1.0) * d19 * d19;
                            double d23 = 0.6666666666666666 + (0.5 * d20 - 1.0) * d20 * d20;
                            double d24 = 0.16666666666666666 * d19 * d19 * d19;
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d25 = image.get(coordinates);
                            ++coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.y;
                            double d29 = image.get(coordinates);
                            --coordinates.x;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.y;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.x;
                            double d35 = image.get(coordinates);
                            ++coordinates.x;
                            double d36 = image.get(coordinates);
                            ++coordinates.y;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            --coordinates.x;
                            double d39 = image.get(coordinates);
                            --coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.z;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.y;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.y;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            ++coordinates.x;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.y;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.x;
                            double d55 = image.get(coordinates);
                            --coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.z;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            ++coordinates.x;
                            double d59 = image.get(coordinates);
                            ++coordinates.x;
                            double d60 = image.get(coordinates);
                            ++coordinates.y;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            --coordinates.x;
                            double d63 = image.get(coordinates);
                            --coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.y;
                            double d65 = image.get(coordinates);
                            ++coordinates.x;
                            double d66 = image.get(coordinates);
                            ++coordinates.x;
                            double d67 = image.get(coordinates);
                            ++coordinates.x;
                            double d68 = image.get(coordinates);
                            ++coordinates.y;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            --coordinates.x;
                            double d71 = image.get(coordinates);
                            --coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.z;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.x;
                            double d75 = image.get(coordinates);
                            ++coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.y;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            --coordinates.x;
                            double d79 = image.get(coordinates);
                            --coordinates.x;
                            double d80 = image.get(coordinates);
                            --coordinates.y;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            ++coordinates.x;
                            double d83 = image.get(coordinates);
                            ++coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.y;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.x;
                            double d87 = image.get(coordinates);
                            --coordinates.x;
                            double d88 = image.get(coordinates);
                            dArray[i] = d21 * (d15 * (d9 * d25 + d10 * d26 + d11 * d27 + d12 * d28) + d16 * (d9 * d32 + d10 * d31 + d11 * d30 + d12 * d29) + d17 * (d9 * d33 + d10 * d34 + d11 * d35 + d12 * d36) + d18 * (d9 * d40 + d10 * d39 + d11 * d38 + d12 * d37)) + d22 * (d15 * (d9 * d56 + d10 * d55 + d11 * d54 + d12 * d53) + d16 * (d9 * d49 + d10 * d50 + d11 * d51 + d12 * d52) + d17 * (d9 * d48 + d10 * d47 + d11 * d46 + d12 * d45) + d18 * (d9 * d41 + d10 * d42 + d11 * d43 + d12 * d44)) + d23 * (d15 * (d9 * d57 + d10 * d58 + d11 * d59 + d12 * d60) + d16 * (d9 * d64 + d10 * d63 + d11 * d62 + d12 * d61) + d17 * (d9 * d65 + d10 * d66 + d11 * d67 + d12 * d68) + d18 * (d9 * d72 + d10 * d71 + d11 * d70 + d12 * d69)) + d24 * (d15 * (d9 * d88 + d10 * d87 + d11 * d86 + d12 * d85) + d16 * (d9 * d81 + d10 * d82 + d11 * d83 + d12 * d84) + d17 * (d9 * d80 + d10 * d79 + d11 * d78 + d12 * d77) + d18 * (d9 * d73 + d10 * d74 + d11 * d75 + d12 * d76));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_omoms3_xy(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.y == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d6 = d4 - (double)n;
                            double d7 = 1.0 - d6;
                            double d8 = d7 * (0.023809523809523808 + 0.16666666666666666 * d7 * d7);
                            double d9 = 0.6190476190476191 + d6 * (0.07142857142857142 + d6 * (0.5 * d6 - 1.0));
                            double d10 = 0.6190476190476191 + d7 * (0.07142857142857142 + d7 * (0.5 * d7 - 1.0));
                            double d11 = d6 * (0.023809523809523808 + 0.16666666666666666 * d6 * d6);
                            double d12 = d5 - (double)n2;
                            double d13 = 1.0 - d12;
                            double d14 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            double d15 = 0.6190476190476191 + d12 * (0.07142857142857142 + d12 * (0.5 * d12 - 1.0));
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = d12 * (0.023809523809523808 + 0.16666666666666666 * d12 * d12);
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            double d18 = image.get(coordinates);
                            ++coordinates.x;
                            double d19 = image.get(coordinates);
                            ++coordinates.x;
                            double d20 = image.get(coordinates);
                            ++coordinates.x;
                            double d21 = image.get(coordinates);
                            ++coordinates.y;
                            double d22 = image.get(coordinates);
                            --coordinates.x;
                            double d23 = image.get(coordinates);
                            --coordinates.x;
                            double d24 = image.get(coordinates);
                            --coordinates.x;
                            double d25 = image.get(coordinates);
                            ++coordinates.y;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.y;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            dArray[i] = d14 * (d8 * d18 + d9 * d19 + d10 * d20 + d11 * d21) + d15 * (d8 * d25 + d9 * d24 + d10 * d23 + d11 * d22) + d16 * (d8 * d26 + d9 * d27 + d10 * d28 + d11 * d29) + d17 * (d8 * d33 + d9 * d32 + d10 * d31 + d11 * d30);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_omoms3_xyz(Image image, Image image2) {
        this.messenger.log("Cubic O-MOMS prefiltering and sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.omoms3(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.y == 1) {
                d /= 0.619047619048;
            }
            if (this.idims.z == 1) {
                d /= 0.619047619048;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            double d6 = (this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            int n3 = FMath.floor(d6);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y || d6 < -1.0 || (double)n3 > this.ipmax.z) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d7 = d4 - (double)n;
                            double d8 = 1.0 - d7;
                            double d9 = d8 * (0.023809523809523808 + 0.16666666666666666 * d8 * d8);
                            double d10 = 0.6190476190476191 + d7 * (0.07142857142857142 + d7 * (0.5 * d7 - 1.0));
                            double d11 = 0.6190476190476191 + d8 * (0.07142857142857142 + d8 * (0.5 * d8 - 1.0));
                            double d12 = d7 * (0.023809523809523808 + 0.16666666666666666 * d7 * d7);
                            double d13 = d5 - (double)n2;
                            double d14 = 1.0 - d13;
                            double d15 = d14 * (0.023809523809523808 + 0.16666666666666666 * d14 * d14);
                            double d16 = 0.6190476190476191 + d13 * (0.07142857142857142 + d13 * (0.5 * d13 - 1.0));
                            double d17 = 0.6190476190476191 + d14 * (0.07142857142857142 + d14 * (0.5 * d14 - 1.0));
                            double d18 = d13 * (0.023809523809523808 + 0.16666666666666666 * d13 * d13);
                            double d19 = d6 - (double)n3;
                            double d20 = 1.0 - d19;
                            double d21 = d20 * (0.023809523809523808 + 0.16666666666666666 * d20 * d20);
                            double d22 = 0.6190476190476191 + d19 * (0.07142857142857142 + d19 * (0.5 * d19 - 1.0));
                            double d23 = 0.6190476190476191 + d20 * (0.07142857142857142 + d20 * (0.5 * d20 - 1.0));
                            double d24 = d19 * (0.023809523809523808 + 0.16666666666666666 * d19 * d19);
                            coordinates.x = this.borders.x + n - 1;
                            coordinates.y = this.borders.y + n2 - 1;
                            coordinates.z = this.borders.z + n3 - 1;
                            double d25 = image.get(coordinates);
                            ++coordinates.x;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.y;
                            double d29 = image.get(coordinates);
                            --coordinates.x;
                            double d30 = image.get(coordinates);
                            --coordinates.x;
                            double d31 = image.get(coordinates);
                            --coordinates.x;
                            double d32 = image.get(coordinates);
                            ++coordinates.y;
                            double d33 = image.get(coordinates);
                            ++coordinates.x;
                            double d34 = image.get(coordinates);
                            ++coordinates.x;
                            double d35 = image.get(coordinates);
                            ++coordinates.x;
                            double d36 = image.get(coordinates);
                            ++coordinates.y;
                            double d37 = image.get(coordinates);
                            --coordinates.x;
                            double d38 = image.get(coordinates);
                            --coordinates.x;
                            double d39 = image.get(coordinates);
                            --coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.z;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.x;
                            double d44 = image.get(coordinates);
                            --coordinates.y;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.y;
                            double d49 = image.get(coordinates);
                            ++coordinates.x;
                            double d50 = image.get(coordinates);
                            ++coordinates.x;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            --coordinates.y;
                            double d53 = image.get(coordinates);
                            --coordinates.x;
                            double d54 = image.get(coordinates);
                            --coordinates.x;
                            double d55 = image.get(coordinates);
                            --coordinates.x;
                            double d56 = image.get(coordinates);
                            ++coordinates.z;
                            double d57 = image.get(coordinates);
                            ++coordinates.x;
                            double d58 = image.get(coordinates);
                            ++coordinates.x;
                            double d59 = image.get(coordinates);
                            ++coordinates.x;
                            double d60 = image.get(coordinates);
                            ++coordinates.y;
                            double d61 = image.get(coordinates);
                            --coordinates.x;
                            double d62 = image.get(coordinates);
                            --coordinates.x;
                            double d63 = image.get(coordinates);
                            --coordinates.x;
                            double d64 = image.get(coordinates);
                            ++coordinates.y;
                            double d65 = image.get(coordinates);
                            ++coordinates.x;
                            double d66 = image.get(coordinates);
                            ++coordinates.x;
                            double d67 = image.get(coordinates);
                            ++coordinates.x;
                            double d68 = image.get(coordinates);
                            ++coordinates.y;
                            double d69 = image.get(coordinates);
                            --coordinates.x;
                            double d70 = image.get(coordinates);
                            --coordinates.x;
                            double d71 = image.get(coordinates);
                            --coordinates.x;
                            double d72 = image.get(coordinates);
                            ++coordinates.z;
                            double d73 = image.get(coordinates);
                            ++coordinates.x;
                            double d74 = image.get(coordinates);
                            ++coordinates.x;
                            double d75 = image.get(coordinates);
                            ++coordinates.x;
                            double d76 = image.get(coordinates);
                            --coordinates.y;
                            double d77 = image.get(coordinates);
                            --coordinates.x;
                            double d78 = image.get(coordinates);
                            --coordinates.x;
                            double d79 = image.get(coordinates);
                            --coordinates.x;
                            double d80 = image.get(coordinates);
                            --coordinates.y;
                            double d81 = image.get(coordinates);
                            ++coordinates.x;
                            double d82 = image.get(coordinates);
                            ++coordinates.x;
                            double d83 = image.get(coordinates);
                            ++coordinates.x;
                            double d84 = image.get(coordinates);
                            --coordinates.y;
                            double d85 = image.get(coordinates);
                            --coordinates.x;
                            double d86 = image.get(coordinates);
                            --coordinates.x;
                            double d87 = image.get(coordinates);
                            --coordinates.x;
                            double d88 = image.get(coordinates);
                            dArray[i] = d21 * (d15 * (d9 * d25 + d10 * d26 + d11 * d27 + d12 * d28) + d16 * (d9 * d32 + d10 * d31 + d11 * d30 + d12 * d29) + d17 * (d9 * d33 + d10 * d34 + d11 * d35 + d12 * d36) + d18 * (d9 * d40 + d10 * d39 + d11 * d38 + d12 * d37)) + d22 * (d15 * (d9 * d56 + d10 * d55 + d11 * d54 + d12 * d53) + d16 * (d9 * d49 + d10 * d50 + d11 * d51 + d12 * d52) + d17 * (d9 * d48 + d10 * d47 + d11 * d46 + d12 * d45) + d18 * (d9 * d41 + d10 * d42 + d11 * d43 + d12 * d44)) + d23 * (d15 * (d9 * d57 + d10 * d58 + d11 * d59 + d12 * d60) + d16 * (d9 * d64 + d10 * d63 + d11 * d62 + d12 * d61) + d17 * (d9 * d65 + d10 * d66 + d11 * d67 + d12 * d68) + d18 * (d9 * d72 + d10 * d71 + d11 * d70 + d12 * d69)) + d24 * (d15 * (d9 * d88 + d10 * d87 + d11 * d86 + d12 * d85) + d16 * (d9 * d81 + d10 * d82 + d11 * d83 + d12 * d84) + d17 * (d9 * d80 + d10 * d79 + d11 * d78 + d12 * d77) + d18 * (d9 * d73 + d10 * d74 + d11 * d75 + d12 * d76));
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_bspline5_xy(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in x-y");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(true, true, false), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.55;
            }
            if (this.idims.y == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[] dArray = new double[this.odims.x];
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates.z = 0;
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y) {
                                dArray[i] = this.background;
                                continue;
                            }
                            double d6 = d4 - (double)n;
                            double d7 = d6 * d6;
                            double d8 = 1.0 - d6;
                            double d9 = d8 * d8;
                            double d10 = 0.008333333333333333 * d9 * d9 * d8;
                            double d11 = 0.008333333333333333 + 0.041666666666666664 * d8 * (1.0 + d8 * (2.0 + d8 * (2.0 + d8 - d9)));
                            double d12 = 0.55 + d7 * ((0.25 - 0.08333333333333333 * d6) * d7 - 0.5);
                            double d13 = 0.55 + d9 * ((0.25 - 0.08333333333333333 * d8) * d9 - 0.5);
                            double d14 = 0.008333333333333333 + 0.041666666666666664 * d6 * (1.0 + d6 * (2.0 + d6 * (2.0 + d6 - d7)));
                            double d15 = 0.008333333333333333 * d7 * d7 * d6;
                            double d16 = d5 - (double)n2;
                            double d17 = d16 * d16;
                            double d18 = 1.0 - d16;
                            double d19 = d18 * d18;
                            double d20 = 0.008333333333333333 * d19 * d19 * d18;
                            double d21 = 0.008333333333333333 + 0.041666666666666664 * d18 * (1.0 + d18 * (2.0 + d18 * (2.0 + d18 - d19)));
                            double d22 = 0.55 + d17 * ((0.25 - 0.08333333333333333 * d16) * d17 - 0.5);
                            double d23 = 0.55 + d19 * ((0.25 - 0.08333333333333333 * d18) * d19 - 0.5);
                            double d24 = 0.008333333333333333 + 0.041666666666666664 * d16 * (1.0 + d16 * (2.0 + d16 * (2.0 + d16 - d17)));
                            double d25 = 0.008333333333333333 * d17 * d17 * d16;
                            coordinates.x = this.borders.x + n - 2;
                            coordinates.y = this.borders.y + n2 - 2;
                            double d26 = image.get(coordinates);
                            ++coordinates.x;
                            double d27 = image.get(coordinates);
                            ++coordinates.x;
                            double d28 = image.get(coordinates);
                            ++coordinates.x;
                            double d29 = image.get(coordinates);
                            ++coordinates.x;
                            double d30 = image.get(coordinates);
                            ++coordinates.x;
                            double d31 = image.get(coordinates);
                            ++coordinates.y;
                            double d32 = image.get(coordinates);
                            --coordinates.x;
                            double d33 = image.get(coordinates);
                            --coordinates.x;
                            double d34 = image.get(coordinates);
                            --coordinates.x;
                            double d35 = image.get(coordinates);
                            --coordinates.x;
                            double d36 = image.get(coordinates);
                            --coordinates.x;
                            double d37 = image.get(coordinates);
                            ++coordinates.y;
                            double d38 = image.get(coordinates);
                            ++coordinates.x;
                            double d39 = image.get(coordinates);
                            ++coordinates.x;
                            double d40 = image.get(coordinates);
                            ++coordinates.x;
                            double d41 = image.get(coordinates);
                            ++coordinates.x;
                            double d42 = image.get(coordinates);
                            ++coordinates.x;
                            double d43 = image.get(coordinates);
                            ++coordinates.y;
                            double d44 = image.get(coordinates);
                            --coordinates.x;
                            double d45 = image.get(coordinates);
                            --coordinates.x;
                            double d46 = image.get(coordinates);
                            --coordinates.x;
                            double d47 = image.get(coordinates);
                            --coordinates.x;
                            double d48 = image.get(coordinates);
                            --coordinates.x;
                            double d49 = image.get(coordinates);
                            ++coordinates.y;
                            double d50 = image.get(coordinates);
                            ++coordinates.x;
                            double d51 = image.get(coordinates);
                            ++coordinates.x;
                            double d52 = image.get(coordinates);
                            ++coordinates.x;
                            double d53 = image.get(coordinates);
                            ++coordinates.x;
                            double d54 = image.get(coordinates);
                            ++coordinates.x;
                            double d55 = image.get(coordinates);
                            ++coordinates.y;
                            double d56 = image.get(coordinates);
                            --coordinates.x;
                            double d57 = image.get(coordinates);
                            --coordinates.x;
                            double d58 = image.get(coordinates);
                            --coordinates.x;
                            double d59 = image.get(coordinates);
                            --coordinates.x;
                            double d60 = image.get(coordinates);
                            --coordinates.x;
                            double d61 = image.get(coordinates);
                            dArray[i] = d20 * (d10 * d26 + d11 * d27 + d12 * d28 + d13 * d29 + d14 * d30 + d15 * d31) + d21 * (d10 * d37 + d11 * d36 + d12 * d35 + d13 * d34 + d14 * d33 + d15 * d32) + d22 * (d10 * d38 + d11 * d39 + d12 * d40 + d13 * d41 + d14 * d42 + d15 * d43) + d23 * (d10 * d49 + d11 * d48 + d12 * d47 + d13 * d46 + d14 * d45 + d15 * d44) + d24 * (d10 * d50 + d11 * d51 + d12 * d52 + d13 * d53 + d14 * d54 + d15 * d55) + d25 * (d10 * d61 + d11 * d60 + d12 * d59 + d13 * d58 + d14 * d57 + d15 * d56);
                        }
                        image2.set(coordinates2, dArray);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                    ++coordinates.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private void affine_bspline5_xyz(Image image, Image image2) {
        this.messenger.log("Quintic B-spline prefiltering and sampling in x-y-z");
        this.progressor.status("Affine transforming" + this.component + "...");
        this.progressor.steps(this.odims.c * this.odims.t * this.odims.z * this.odims.y);
        this.prefilter.bspline5(image, new Axes(true, true, true), this.borders);
        if (this.antialias) {
            double d = 1.0;
            if (this.idims.x == 1) {
                d /= 0.55;
            }
            if (this.idims.y == 1) {
                d /= 0.55;
            }
            if (this.idims.z == 1) {
                d /= 0.55;
            }
            if (d != 1.0) {
                this.messenger.log("Correction scaling with factor " + d);
                image.multiply(d);
            }
            image.set(this.borders, this.background);
        } else {
            image.mirror(this.borders);
        }
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        double[][][] dArray = new double[6][6][6];
        double[] dArray2 = new double[this.odims.x];
        image.axes(7);
        image2.axes(1);
        this.progressor.start();
        coordinates.c = 0;
        coordinates2.c = 0;
        while (coordinates2.c < this.odims.c) {
            coordinates.t = 0;
            coordinates2.t = 0;
            while (coordinates2.t < this.odims.t) {
                coordinates2.z = 0;
                while (coordinates2.z < this.odims.z) {
                    double d = (double)coordinates2.z * this.ovz - this.opc.z;
                    coordinates2.y = 0;
                    while (coordinates2.y < this.odims.y) {
                        double d2 = (double)coordinates2.y * this.ovy - this.opc.y;
                        for (int i = 0; i < this.odims.x; ++i) {
                            double d3 = (double)i * this.ovx - this.opc.x;
                            double d4 = (this.ipc.x + d3 * this.bwd.axx + d2 * this.bwd.axy + d * this.bwd.axz + this.bwd.axt) / this.ivx;
                            double d5 = (this.ipc.y + d3 * this.bwd.ayx + d2 * this.bwd.ayy + d * this.bwd.ayz + this.bwd.ayt) / this.ivy;
                            double d6 = (this.ipc.z + d3 * this.bwd.azx + d2 * this.bwd.azy + d * this.bwd.azz + this.bwd.azt) / this.ivz;
                            int n = FMath.floor(d4);
                            int n2 = FMath.floor(d5);
                            int n3 = FMath.floor(d6);
                            if (d4 < -1.0 || (double)n > this.ipmax.x || d5 < -1.0 || (double)n2 > this.ipmax.y || d6 < -1.0 || (double)n3 > this.ipmax.z) {
                                dArray2[i] = this.background;
                                continue;
                            }
                            double d7 = d4 - (double)n;
                            double d8 = d7 * d7;
                            double d9 = 1.0 - d7;
                            double d10 = d9 * d9;
                            double d11 = 0.008333333333333333 * d10 * d10 * d9;
                            double d12 = 0.008333333333333333 + 0.041666666666666664 * d9 * (1.0 + d9 * (2.0 + d9 * (2.0 + d9 - d10)));
                            double d13 = 0.55 + d8 * ((0.25 - 0.08333333333333333 * d7) * d8 - 0.5);
                            double d14 = 0.55 + d10 * ((0.25 - 0.08333333333333333 * d9) * d10 - 0.5);
                            double d15 = 0.008333333333333333 + 0.041666666666666664 * d7 * (1.0 + d7 * (2.0 + d7 * (2.0 + d7 - d8)));
                            double d16 = 0.008333333333333333 * d8 * d8 * d7;
                            double d17 = d5 - (double)n2;
                            double d18 = d17 * d17;
                            double d19 = 1.0 - d17;
                            double d20 = d19 * d19;
                            double d21 = 0.008333333333333333 * d20 * d20 * d19;
                            double d22 = 0.008333333333333333 + 0.041666666666666664 * d19 * (1.0 + d19 * (2.0 + d19 * (2.0 + d19 - d20)));
                            double d23 = 0.55 + d18 * ((0.25 - 0.08333333333333333 * d17) * d18 - 0.5);
                            double d24 = 0.55 + d20 * ((0.25 - 0.08333333333333333 * d19) * d20 - 0.5);
                            double d25 = 0.008333333333333333 + 0.041666666666666664 * d17 * (1.0 + d17 * (2.0 + d17 * (2.0 + d17 - d18)));
                            double d26 = 0.008333333333333333 * d18 * d18 * d17;
                            double d27 = d6 - (double)n3;
                            double d28 = d27 * d27;
                            double d29 = 1.0 - d27;
                            double d30 = d29 * d29;
                            double d31 = 0.008333333333333333 * d30 * d30 * d29;
                            double d32 = 0.008333333333333333 + 0.041666666666666664 * d29 * (1.0 + d29 * (2.0 + d29 * (2.0 + d29 - d30)));
                            double d33 = 0.55 + d28 * ((0.25 - 0.08333333333333333 * d27) * d28 - 0.5);
                            double d34 = 0.55 + d30 * ((0.25 - 0.08333333333333333 * d29) * d30 - 0.5);
                            double d35 = 0.008333333333333333 + 0.041666666666666664 * d27 * (1.0 + d27 * (2.0 + d27 * (2.0 + d27 - d28)));
                            double d36 = 0.008333333333333333 * d28 * d28 * d27;
                            coordinates.x = this.borders.x + n - 2;
                            coordinates.y = this.borders.y + n2 - 2;
                            coordinates.z = this.borders.z + n3 - 2;
                            image.get(coordinates, dArray);
                            dArray2[i] = d31 * (d21 * (d11 * dArray[0][0][0] + d12 * dArray[0][0][1] + d13 * dArray[0][0][2] + d14 * dArray[0][0][3] + d15 * dArray[0][0][4] + d16 * dArray[0][0][5]) + d22 * (d11 * dArray[0][1][0] + d12 * dArray[0][1][1] + d13 * dArray[0][1][2] + d14 * dArray[0][1][3] + d15 * dArray[0][1][4] + d16 * dArray[0][1][5]) + d23 * (d11 * dArray[0][2][0] + d12 * dArray[0][2][1] + d13 * dArray[0][2][2] + d14 * dArray[0][2][3] + d15 * dArray[0][2][4] + d16 * dArray[0][2][5]) + d24 * (d11 * dArray[0][3][0] + d12 * dArray[0][3][1] + d13 * dArray[0][3][2] + d14 * dArray[0][3][3] + d15 * dArray[0][3][4] + d16 * dArray[0][3][5]) + d25 * (d11 * dArray[0][4][0] + d12 * dArray[0][4][1] + d13 * dArray[0][4][2] + d14 * dArray[0][4][3] + d15 * dArray[0][4][4] + d16 * dArray[0][4][5]) + d26 * (d11 * dArray[0][5][0] + d12 * dArray[0][5][1] + d13 * dArray[0][5][2] + d14 * dArray[0][5][3] + d15 * dArray[0][5][4] + d16 * dArray[0][5][5])) + d32 * (d21 * (d11 * dArray[1][0][0] + d12 * dArray[1][0][1] + d13 * dArray[1][0][2] + d14 * dArray[1][0][3] + d15 * dArray[1][0][4] + d16 * dArray[1][0][5]) + d22 * (d11 * dArray[1][1][0] + d12 * dArray[1][1][1] + d13 * dArray[1][1][2] + d14 * dArray[1][1][3] + d15 * dArray[1][1][4] + d16 * dArray[1][1][5]) + d23 * (d11 * dArray[1][2][0] + d12 * dArray[1][2][1] + d13 * dArray[1][2][2] + d14 * dArray[1][2][3] + d15 * dArray[1][2][4] + d16 * dArray[1][2][5]) + d24 * (d11 * dArray[1][3][0] + d12 * dArray[1][3][1] + d13 * dArray[1][3][2] + d14 * dArray[1][3][3] + d15 * dArray[1][3][4] + d16 * dArray[1][3][5]) + d25 * (d11 * dArray[1][4][0] + d12 * dArray[1][4][1] + d13 * dArray[1][4][2] + d14 * dArray[1][4][3] + d15 * dArray[1][4][4] + d16 * dArray[1][4][5]) + d26 * (d11 * dArray[1][5][0] + d12 * dArray[1][5][1] + d13 * dArray[1][5][2] + d14 * dArray[1][5][3] + d15 * dArray[1][5][4] + d16 * dArray[1][5][5])) + d33 * (d21 * (d11 * dArray[2][0][0] + d12 * dArray[2][0][1] + d13 * dArray[2][0][2] + d14 * dArray[2][0][3] + d15 * dArray[2][0][4] + d16 * dArray[2][0][5]) + d22 * (d11 * dArray[2][1][0] + d12 * dArray[2][1][1] + d13 * dArray[2][1][2] + d14 * dArray[2][1][3] + d15 * dArray[2][1][4] + d16 * dArray[2][1][5]) + d23 * (d11 * dArray[2][2][0] + d12 * dArray[2][2][1] + d13 * dArray[2][2][2] + d14 * dArray[2][2][3] + d15 * dArray[2][2][4] + d16 * dArray[2][2][5]) + d24 * (d11 * dArray[2][3][0] + d12 * dArray[2][3][1] + d13 * dArray[2][3][2] + d14 * dArray[2][3][3] + d15 * dArray[2][3][4] + d16 * dArray[2][3][5]) + d25 * (d11 * dArray[2][4][0] + d12 * dArray[2][4][1] + d13 * dArray[2][4][2] + d14 * dArray[2][4][3] + d15 * dArray[2][4][4] + d16 * dArray[2][4][5]) + d26 * (d11 * dArray[2][5][0] + d12 * dArray[2][5][1] + d13 * dArray[2][5][2] + d14 * dArray[2][5][3] + d15 * dArray[2][5][4] + d16 * dArray[2][5][5])) + d34 * (d21 * (d11 * dArray[3][0][0] + d12 * dArray[3][0][1] + d13 * dArray[3][0][2] + d14 * dArray[3][0][3] + d15 * dArray[3][0][4] + d16 * dArray[3][0][5]) + d22 * (d11 * dArray[3][1][0] + d12 * dArray[3][1][1] + d13 * dArray[3][1][2] + d14 * dArray[3][1][3] + d15 * dArray[3][1][4] + d16 * dArray[3][1][5]) + d23 * (d11 * dArray[3][2][0] + d12 * dArray[3][2][1] + d13 * dArray[3][2][2] + d14 * dArray[3][2][3] + d15 * dArray[3][2][4] + d16 * dArray[3][2][5]) + d24 * (d11 * dArray[3][3][0] + d12 * dArray[3][3][1] + d13 * dArray[3][3][2] + d14 * dArray[3][3][3] + d15 * dArray[3][3][4] + d16 * dArray[3][3][5]) + d25 * (d11 * dArray[3][4][0] + d12 * dArray[3][4][1] + d13 * dArray[3][4][2] + d14 * dArray[3][4][3] + d15 * dArray[3][4][4] + d16 * dArray[3][4][5]) + d26 * (d11 * dArray[3][5][0] + d12 * dArray[3][5][1] + d13 * dArray[3][5][2] + d14 * dArray[3][5][3] + d15 * dArray[3][5][4] + d16 * dArray[3][5][5])) + d35 * (d21 * (d11 * dArray[4][0][0] + d12 * dArray[4][0][1] + d13 * dArray[4][0][2] + d14 * dArray[4][0][3] + d15 * dArray[4][0][4] + d16 * dArray[4][0][5]) + d22 * (d11 * dArray[4][1][0] + d12 * dArray[4][1][1] + d13 * dArray[4][1][2] + d14 * dArray[4][1][3] + d15 * dArray[4][1][4] + d16 * dArray[4][1][5]) + d23 * (d11 * dArray[4][2][0] + d12 * dArray[4][2][1] + d13 * dArray[4][2][2] + d14 * dArray[4][2][3] + d15 * dArray[4][2][4] + d16 * dArray[4][2][5]) + d24 * (d11 * dArray[4][3][0] + d12 * dArray[4][3][1] + d13 * dArray[4][3][2] + d14 * dArray[4][3][3] + d15 * dArray[4][3][4] + d16 * dArray[4][3][5]) + d25 * (d11 * dArray[4][4][0] + d12 * dArray[4][4][1] + d13 * dArray[4][4][2] + d14 * dArray[4][4][3] + d15 * dArray[4][4][4] + d16 * dArray[4][4][5]) + d26 * (d11 * dArray[4][5][0] + d12 * dArray[4][5][1] + d13 * dArray[4][5][2] + d14 * dArray[4][5][3] + d15 * dArray[4][5][4] + d16 * dArray[4][5][5])) + d36 * (d21 * (d11 * dArray[5][0][0] + d12 * dArray[5][0][1] + d13 * dArray[5][0][2] + d14 * dArray[5][0][3] + d15 * dArray[5][0][4] + d16 * dArray[5][0][5]) + d22 * (d11 * dArray[5][1][0] + d12 * dArray[5][1][1] + d13 * dArray[5][1][2] + d14 * dArray[5][1][3] + d15 * dArray[5][1][4] + d16 * dArray[5][1][5]) + d23 * (d11 * dArray[5][2][0] + d12 * dArray[5][2][1] + d13 * dArray[5][2][2] + d14 * dArray[5][2][3] + d15 * dArray[5][2][4] + d16 * dArray[5][2][5]) + d24 * (d11 * dArray[5][3][0] + d12 * dArray[5][3][1] + d13 * dArray[5][3][2] + d14 * dArray[5][3][3] + d15 * dArray[5][3][4] + d16 * dArray[5][3][5]) + d25 * (d11 * dArray[5][4][0] + d12 * dArray[5][4][1] + d13 * dArray[5][4][2] + d14 * dArray[5][4][3] + d15 * dArray[5][4][4] + d16 * dArray[5][4][5]) + d26 * (d11 * dArray[5][5][0] + d12 * dArray[5][5][1] + d13 * dArray[5][5][2] + d14 * dArray[5][5][3] + d15 * dArray[5][5][4] + d16 * dArray[5][5][5]));
                        }
                        image2.set(coordinates2, dArray2);
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.z;
                }
                ++coordinates2.t;
                ++coordinates.t;
            }
            ++coordinates2.c;
            ++coordinates.c;
        }
        this.progressor.stop();
    }

    private String schemes(int n) {
        switch (n) {
            case 0: {
                return "nearest-neighbor interpolation";
            }
            case 1: {
                return "linear interpolation";
            }
            case 2: {
                return "cubic convolution interpolation";
            }
            case 3: {
                return "cubic B-spline interpolation";
            }
            case 4: {
                return "cubic O-MOMS interpolation";
            }
            case 5: {
                return "quintic B-spline interpolation";
            }
        }
        return "unknown interpolation";
    }
}

