/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class Spline
implements Shape {
    private static final double PERIMETER_ERROR = 0.001;
    private static final int CONTOUR_RESOLUTION = 10;
    private GeneralPath contour = null;
    private static final int MINCAP = 10;
    private Point[] p = new Point[10];
    private Point[] c = null;
    private int np = 0;
    private static final double CBSP = -0.267949192431;
    private static final double CBSF = 6.0;
    private static final double D1O2 = 0.5;
    private static final double D1O6 = 0.16666666666666666;
    private static final double D2O3 = 0.6666666666666666;
    private static final double G01 = -0.3402777777777778;
    private static final double G02 = -0.07777777777777778;
    private static final double G03 = -0.001388888888888889;

    public Spline() {
    }

    public Spline(Vector<Point> vector) {
        this.set(vector);
    }

    public Spline(Spline spline) {
        this.np = spline.np;
        int n = this.np + 1;
        if (n > this.p.length) {
            this.p = new Point[n + 10];
        }
        for (int i = 0; i < this.np; ++i) {
            this.p[i] = spline.p[i].duplicate();
        }
        this.update();
    }

    public void set(Vector<Point> vector) {
        if (vector == null) {
            throw new NullPointerException("Vertices is null");
        }
        this.np = vector.size();
        int n = this.np + 1;
        if (n > this.p.length) {
            this.p = new Point[n + 10];
        }
        for (int i = 0; i < this.np; ++i) {
            Point point = vector.get(i);
            if (point == null) {
                throw new NullPointerException("Vertex " + i + " is null");
            }
            this.p[i] = point;
        }
        this.update();
    }

    public void vertices(Vector<Point> vector) {
        this.set(vector);
    }

    public Vector<Point> vertices() {
        Vector<Point> vector = new Vector<Point>(this.np);
        for (int i = 0; i < this.np; ++i) {
            vector.add(this.p[i]);
        }
        return vector;
    }

    @Override
    public Shape duplicate() {
        return new Spline(this);
    }

    public void translate(double d, double d2) {
        for (int i = 0; i < this.np; ++i) {
            this.p[i].translate(d, d2);
        }
        this.update();
    }

    public double perimeter() {
        double d = 0.0;
        if (this.np > 1) {
            Point point = this.p[0];
            Point point2 = this.c[2];
            this.p[this.np] = point;
            double d2 = 0.001 / (double)this.np;
            for (int i = 1; i <= this.np; ++i) {
                Point point3 = this.p[i];
                Point point4 = this.c[i + 2];
                d += this.length(point.x, point.y, (2.0 * point2.x + point4.x) / 3.0, (2.0 * point2.y + point4.y) / 3.0, (point2.x + 2.0 * point4.x) / 3.0, (point2.y + 2.0 * point4.y) / 3.0, point3.x, point3.y, d2);
                point = point3;
                point2 = point4;
            }
        }
        return d;
    }

    private double length(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = 0.0;
        double d11 = (d3 + d5) / 2.0;
        double d12 = (d4 + d6) / 2.0;
        double d13 = (d + d3) / 2.0;
        double d14 = (d2 + d4) / 2.0;
        double d15 = (d13 + d11) / 2.0;
        double d16 = (d14 + d12) / 2.0;
        double d17 = (d5 + d7) / 2.0;
        double d18 = (d6 + d8) / 2.0;
        double d19 = (d11 + d17) / 2.0;
        double d20 = (d12 + d18) / 2.0;
        double d21 = (d15 + d19) / 2.0;
        double d22 = (d16 + d20) / 2.0;
        double d23 = d21 - d;
        double d24 = d22 - d2;
        double d25 = Math.sqrt(d23 * d23 + d24 * d24);
        double d26 = d13 - d;
        double d27 = d14 - d2;
        double d28 = d15 - d13;
        double d29 = d16 - d14;
        double d30 = d21 - d15;
        double d31 = d22 - d16;
        double d32 = Math.sqrt(d26 * d26 + d27 * d27) + Math.sqrt(d28 * d28 + d29 * d29) + Math.sqrt(d30 * d30 + d31 * d31);
        d10 = d32 - d25 < d9 ? (d10 += (d25 + d32) / 2.0) : (d10 += this.length(d, d2, d13, d14, d15, d16, d21, d22, d9 / 2.0));
        d23 = d7 - d21;
        d24 = d8 - d22;
        d25 = Math.sqrt(d23 * d23 + d24 * d24);
        d26 = d19 - d21;
        d27 = d20 - d22;
        d28 = d17 - d19;
        d29 = d18 - d20;
        d30 = d7 - d17;
        d31 = d8 - d18;
        d32 = Math.sqrt(d26 * d26 + d27 * d27) + Math.sqrt(d28 * d28 + d29 * d29) + Math.sqrt(d30 * d30 + d31 * d31);
        d10 = d32 - d25 < d9 ? (d10 += (d25 + d32) / 2.0) : (d10 += this.length(d21, d22, d19, d20, d17, d18, d7, d8, d9 / 2.0));
        return d10;
    }

    public double area() {
        double d = 0.0;
        if (this.np > 2) {
            int n = this.np + 1;
            for (int i = 2; i <= n; ++i) {
                double d2 = 0.0;
                int n2 = 2;
                int n3 = n2 - i;
                while (n2 <= n) {
                    d2 += this.c[n2].y * (this.g0(n3) + this.g0(n3 - this.np) + this.g0(n3 + this.np));
                    ++n2;
                    ++n3;
                }
                d += this.c[i].x * d2;
            }
        }
        return d < 0.0 ? -d : d;
    }

    private double g0(int n) {
        switch (n) {
            case -3: {
                return 0.001388888888888889;
            }
            case -2: {
                return 0.07777777777777778;
            }
            case -1: {
                return 0.3402777777777778;
            }
            case 1: {
                return -0.3402777777777778;
            }
            case 2: {
                return -0.07777777777777778;
            }
            case 3: {
                return -0.001388888888888889;
            }
        }
        return 0.0;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        return this.contour.contains(d, d2);
    }

    public GeneralPath contour() {
        GeneralPath generalPath = new GeneralPath();
        if (this.np > 0) {
            Point point;
            this.p[this.np] = point = this.p[0];
            Point point2 = this.c[2];
            generalPath.moveTo((float)point.x, (float)point.y);
            for (int i = 1; i <= this.np; ++i) {
                point = this.p[i];
                Point point3 = this.c[i + 2];
                generalPath.curveTo((float)(2.0 * point2.x + point3.x) / 3.0f, (float)(2.0 * point2.y + point3.y) / 3.0f, (float)(point2.x + 2.0 * point3.x) / 3.0f, (float)(point2.y + 2.0 * point3.y) / 3.0f, (float)point.x, (float)point.y);
                point2 = point3;
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    @Override
    public Image bitmap(boolean bl) {
        Bounds bounds = this.bounds();
        int n = FMath.floor(bounds.lower.x);
        int n2 = FMath.floor(bounds.lower.y);
        int n3 = 1 + FMath.floor(bounds.upper.x) - n;
        int n4 = 1 + FMath.floor(bounds.upper.y) - n2;
        ByteImage byteImage = new ByteImage(new Dimensions(n3, n4));
        if (this.np > 2) {
            Coordinates coordinates = new Coordinates();
            double[] dArray = new double[n3];
            byteImage.axes(1);
            coordinates.y = 0;
            while (coordinates.y < n4) {
                double d = (double)(n2 + coordinates.y) + 0.5;
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = this.contour.contains((double)(n + i) + 0.5, d) ? 255.0 : 0.0;
                }
                byteImage.set(coordinates, dArray);
                ++coordinates.y;
            }
            if (!bl) {
                Point point;
                this.p[this.np] = point = this.p[0];
                Point point2 = this.c[1];
                Point point3 = this.c[2];
                Point point4 = this.c[3];
                double[] dArray2 = new double[10];
                for (int i = 0; i < 10; ++i) {
                    dArray2[i] = ((double)i + 1.0) / 11.0;
                }
                Coordinates coordinates2 = new Coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
                Coordinates coordinates3 = new Coordinates();
                Coordinates coordinates4 = new Coordinates();
                for (int i = 1; i <= this.np; ++i) {
                    Point point5 = this.p[i];
                    Point point6 = this.c[i + 3];
                    double d = this.length(point.x, point.y, (2.0 * point3.x + point4.x) / 3.0, (2.0 * point3.y + point4.y) / 3.0, (point3.x + 2.0 * point4.x) / 3.0, (point3.y + 2.0 * point4.y) / 3.0, point5.x, point5.y, 0.05);
                    if (d > 0.0) {
                        int n5 = FMath.ceil(10.0 * d);
                        double d2 = 1.0 / (double)n5;
                        for (int j = 0; j < n5; ++j) {
                            double d3 = (double)j * d2;
                            double d4 = 1.0 - d3;
                            double d5 = 0.16666666666666666 * d4 * d4 * d4;
                            double d6 = 0.6666666666666666 + (0.5 * d3 - 1.0) * d3 * d3;
                            double d7 = 0.6666666666666666 + (0.5 * d4 - 1.0) * d4 * d4;
                            double d8 = 0.16666666666666666 * d3 * d3 * d3;
                            coordinates3.x = FMath.floor(d5 * point2.x + d6 * point3.x + d7 * point4.x + d8 * point6.x);
                            coordinates3.y = FMath.floor(d5 * point2.y + d6 * point3.y + d7 * point4.y + d8 * point6.y);
                            if (coordinates3.x == coordinates2.x && coordinates3.y == coordinates2.y) continue;
                            int n6 = 0;
                            for (int k = 0; k < 10; ++k) {
                                double d9 = (double)coordinates3.y + dArray2[k];
                                for (int i2 = 0; i2 < 10; ++i2) {
                                    if (!this.contour.contains((double)coordinates3.x + dArray2[i2], d9)) continue;
                                    ++n6;
                                }
                            }
                            coordinates4.x = coordinates3.x - n;
                            coordinates4.y = coordinates3.y - n2;
                            byteImage.set(coordinates4, (double)(255 * n6) / 100.0);
                            coordinates2.x = coordinates3.x;
                            coordinates2.y = coordinates3.y;
                        }
                    }
                    point = point5;
                    point2 = point3;
                    point3 = point4;
                    point4 = point6;
                }
            }
        }
        return byteImage;
    }

    @Override
    public Bounds bounds() {
        Point point = new Point();
        Point point2 = new Point();
        if (this.np > 0) {
            this.p[this.np] = this.p[0];
            Point point3 = this.p[0];
            Point point4 = this.c[1];
            Point point5 = this.c[2];
            Point point6 = this.c[3];
            point.x = point2.x = point3.x;
            point.y = point2.y = point3.y;
            for (int i = 1; i <= this.np; ++i) {
                double d;
                double d2;
                Point point7 = this.p[i];
                Point point8 = this.c[i + 3];
                if (point7.x > point2.x) {
                    point2.x = point7.x;
                } else if (point7.x < point.x) {
                    point.x = point7.x;
                }
                if (point7.y > point2.y) {
                    point2.y = point7.y;
                } else if (point7.y < point.y) {
                    point.y = point7.y;
                }
                double d3 = (point4.x + 4.0 * point5.x + point6.x) / 6.0;
                double d4 = (point4.y + 4.0 * point5.y + point6.y) / 6.0;
                double d5 = (point6.x - point4.x) / 2.0;
                double d6 = (point6.y - point4.y) / 2.0;
                double d7 = (point4.x - 2.0 * point5.x + point6.x) / 2.0;
                double d8 = (point4.y - 2.0 * point5.y + point6.y) / 2.0;
                double d9 = (point8.x - point4.x + 3.0 * (point5.x - point6.x)) / 6.0;
                double d10 = (point8.y - point4.y + 3.0 * (point5.y - point6.y)) / 6.0;
                double d11 = 3.0 * d9;
                double d12 = 3.0 * d10;
                double d13 = 2.0 * d7;
                double d14 = 2.0 * d8;
                double d15 = d5;
                double d16 = d6;
                double d17 = ((double)(d13 > 0.0 ? -1 : 1) * Math.sqrt(d13 * d13 - 4.0 * d11 * d15) - d13) / 2.0;
                double d18 = ((double)(d14 > 0.0 ? -1 : 1) * Math.sqrt(d14 * d14 - 4.0 * d12 * d16) - d14) / 2.0;
                double d19 = d11 != 0.0 ? d17 / d11 : -1.0;
                double d20 = d12 != 0.0 ? d18 / d12 : -1.0;
                double d21 = d17 != 0.0 ? d15 / d17 : -1.0;
                double d22 = d2 = d18 != 0.0 ? d16 / d18 : -1.0;
                if (d19 > 0.0 && d19 < 1.0) {
                    d = d3 + d19 * (d5 + d19 * (d7 + d19 * d9));
                    if (d > point2.x) {
                        point2.x = d;
                    } else if (d < point.x) {
                        point.x = d;
                    }
                }
                if (d20 > 0.0 && d20 < 1.0) {
                    d = d4 + d20 * (d6 + d20 * (d8 + d20 * d10));
                    if (d > point2.y) {
                        point2.y = d;
                    } else if (d < point.y) {
                        point.y = d;
                    }
                }
                if (d21 > 0.0 && d21 < 1.0) {
                    d = d3 + d21 * (d5 + d21 * (d7 + d21 * d9));
                    if (d > point2.x) {
                        point2.x = d;
                    } else if (d < point.x) {
                        point.x = d;
                    }
                }
                if (d2 > 0.0 && d2 < 1.0) {
                    d = d4 + d2 * (d6 + d2 * (d8 + d2 * d10));
                    if (d > point2.y) {
                        point2.y = d;
                    } else if (d < point.y) {
                        point.y = d;
                    }
                }
                point4 = point5;
                point5 = point6;
                point6 = point8;
            }
        }
        return new Bounds(point, point2);
    }

    @Override
    public boolean equals(Shape shape) {
        if (shape != null && shape instanceof Spline) {
            Spline spline = (Spline)shape;
            if (spline.np == this.np) {
                int n = 0;
                int n2 = 2;
                while (n < this.np) {
                    if (!spline.p[n].equals(this.p[n]) || !spline.c[n2].equals(this.c[n2])) {
                        return false;
                    }
                    ++n;
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean empty() {
        return this.area() == 0.0;
    }

    public void update() {
        if (this.np == 0) {
            this.recontrol(4);
            for (int i = 0; i < 4; ++i) {
                this.c[i].x = 0.0;
                this.c[i].y = 0.0;
            }
        } else if (this.np == 1) {
            this.recontrol(5);
            for (int i = 0; i < 5; ++i) {
                this.c[i].x = this.p[0].x;
                this.c[i].y = this.p[0].y;
            }
        } else {
            int n;
            this.recontrol(this.np + 4);
            int n2 = this.np - 1;
            for (int i = 0; i <= n2; ++i) {
                this.c[i].x = this.p[i].x;
                this.c[i].y = this.p[i].y;
            }
            double d = -0.267949192431 * this.c[n2].x;
            double d2 = -0.267949192431 * this.c[n2].y;
            double d3 = -0.267949192431 * this.c[0].x;
            double d4 = -0.267949192431 * this.c[0].y;
            double d5 = -0.267949192431;
            for (int i = 1; i <= n2; ++i) {
                d += (d5 *= -0.267949192431) * this.c[n2 - i].x;
                d2 += d5 * this.c[n2 - i].y;
                d3 += d5 * this.c[i].x;
                d4 += d5 * this.c[i].y;
            }
            double d6 = 1.0 - d5;
            double d7 = 0.9282032302755749 * d6;
            this.c[0].x += d / d6;
            this.c[0].y += d2 / d6;
            for (n = 1; n < n2; ++n) {
                this.c[n].x += -0.267949192431 * this.c[n - 1].x;
                this.c[n].y += -0.267949192431 * this.c[n - 1].y;
            }
            this.c[n2].x = -(d + -0.267949192431 * d3) / d7;
            this.c[n2].y = -(d2 + -0.267949192431 * d4) / d7;
            for (n = n2 - 1; n >= 0; --n) {
                this.c[n].x = -0.267949192431 * (this.c[n + 1].x - this.c[n].x);
                this.c[n].y = -0.267949192431 * (this.c[n + 1].y - this.c[n].y);
            }
            n = n2;
            int n3 = n2 + 2;
            while (n >= 0) {
                this.c[n3].x = 6.0 * this.c[n].x;
                this.c[n3].y = 6.0 * this.c[n].y;
                --n;
                --n3;
            }
            this.c[0].x = this.c[this.np].x;
            this.c[0].y = this.c[this.np].y;
            this.c[1].x = this.c[this.np + 1].x;
            this.c[1].y = this.c[this.np + 1].y;
            this.c[this.np + 2].x = this.c[2].x;
            this.c[this.np + 2].y = this.c[2].y;
            this.c[this.np + 3].x = this.c[3].x;
            this.c[this.np + 3].y = this.c[3].y;
        }
        this.contour = this.contour();
    }

    private void recontrol(int n) {
        if (this.c == null || n > this.c.length) {
            int n2 = n + 10;
            this.c = new Point[n2];
            for (int i = 0; i < n2; ++i) {
                this.c[i] = new Point();
            }
        }
    }
}

