/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class Ellipse
implements Shape {
    private double x = 0.0;
    private double y = 0.0;
    private double major = 1.0;
    private double minor = 1.0;
    private double angle = 0.0;
    private static final int CONTOUR_RESOLUTION = 10;

    public Ellipse() {
    }

    public Ellipse(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Major radius less than 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Minor radius less than 0");
        }
        this.x = d;
        this.y = d2;
        this.major = d3;
        this.minor = d4;
        this.angle = d5;
    }

    public Ellipse(Ellipse ellipse) {
        this.x = ellipse.x;
        this.y = ellipse.y;
        this.major = ellipse.major;
        this.minor = ellipse.minor;
        this.angle = ellipse.angle;
    }

    public void x(double d) {
        this.x = d;
    }

    public double x() {
        return this.x;
    }

    public void y(double d) {
        this.y = d;
    }

    public double y() {
        return this.y;
    }

    public void center(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void position(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void major(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Major radius less than 0");
        }
        this.major = d;
    }

    public double major() {
        return this.major;
    }

    public void minor(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Minor radius less than 0");
        }
        this.minor = d;
    }

    public double minor() {
        return this.minor;
    }

    public void radii(double d, double d2) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Major radius less than 0");
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Minor radius less than 0");
        }
        this.major = d;
        this.minor = d2;
    }

    public void angle(double d) {
        this.angle = d;
    }

    public double angle() {
        return this.angle;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void rotate(double d) {
        this.angle += d;
    }

    @Override
    public Shape duplicate() {
        return new Ellipse(this);
    }

    public void set(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Major radius less than 0");
        }
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Minor radius less than 0");
        }
        this.x = d;
        this.y = d2;
        this.major = d3;
        this.minor = d4;
        this.angle = d5;
    }

    public double eccentricity() {
        double d = this.major;
        double d2 = this.minor;
        if (this.minor > this.major) {
            d = this.minor;
            d2 = this.major;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return Math.sqrt(1.0 - d2 * d2 / (d * d));
    }

    public double perimeter() {
        double d = this.major + this.minor;
        double d2 = this.major - this.minor;
        if (d == 0.0) {
            return 0.0;
        }
        double d3 = d2 * d2 / (d * d);
        return Math.PI * d * (1.0 + 3.0 * d3 / (10.0 + Math.sqrt(4.0 - 3.0 * d3)));
    }

    public double area() {
        return Math.PI * this.major * this.minor;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        double d5 = Math.sin(this.angle);
        double d6 = Math.cos(this.angle);
        double d7 = d6 * d3 + d5 * d4;
        double d8 = d6 * d4 - d5 * d3;
        if (this.major > 0.0 && this.minor > 0.0) {
            return d7 * d7 / (this.major * this.major) + d8 * d8 / (this.minor * this.minor) <= 1.0;
        }
        if (this.major > 0.0) {
            return d8 == 0.0 && d7 * d7 <= this.major * this.major;
        }
        if (this.minor > 0.0) {
            return d7 == 0.0 && d8 * d8 <= this.minor * this.minor;
        }
        return d7 == 0.0 && d8 == 0.0;
    }

    public GeneralPath contour() {
        GeneralPath generalPath = new GeneralPath(new Ellipse2D.Double(this.x - this.major, this.y - this.minor, 2.0 * this.major, 2.0 * this.minor));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(this.angle, this.x, this.y);
        generalPath.transform(affineTransform);
        return generalPath;
    }

    @Override
    public Image bitmap(boolean bl) {
        Bounds bounds = this.bounds();
        int n = FMath.floor(bounds.lower.x);
        int n2 = FMath.floor(bounds.lower.y);
        int n3 = 1 + FMath.floor(bounds.upper.x) - n;
        int n4 = 1 + FMath.floor(bounds.upper.y) - n2;
        ByteImage byteImage = new ByteImage(new Dimensions(n3, n4));
        if (this.major > 0.0 && this.minor > 0.0) {
            double d;
            double d2;
            double d3;
            double d4 = Math.sin(this.angle);
            double d5 = Math.cos(this.angle);
            double d6 = this.major * this.major;
            double d7 = this.minor * this.minor;
            double d8 = this.x - (double)n - 0.5;
            double d9 = this.y - (double)n2 - 0.5;
            Coordinates coordinates = new Coordinates();
            double[] dArray = new double[n3];
            byteImage.axes(1);
            int n5 = 0;
            while (n5 < n4) {
                d3 = (double)n5 - d9;
                double d10 = d4 * d3;
                double d11 = d5 * d3;
                for (int i = 0; i < n3; ++i) {
                    double d12 = (double)i - d8;
                    d2 = d5 * d12 + d10;
                    d = d11 - d4 * d12;
                    dArray[i] = d2 * d2 / d6 + d * d / d7 <= 1.0 ? 255.0 : 0.0;
                }
                byteImage.set(coordinates, dArray);
                ++n5;
                ++coordinates.y;
            }
            if (!bl) {
                n5 = FMath.ceil(10.0 * this.perimeter());
                d3 = Math.PI * 2 / (double)n5;
                double[] dArray2 = new double[10];
                for (int i = 0; i < 10; ++i) {
                    dArray2[i] = ((double)i + 1.0) / 11.0;
                }
                Coordinates coordinates2 = new Coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
                Coordinates coordinates3 = new Coordinates();
                Coordinates coordinates4 = new Coordinates();
                for (int i = 0; i < n5; ++i) {
                    d2 = d3 * (double)i;
                    d = this.major * Math.cos(d2);
                    double d13 = this.minor * Math.sin(d2);
                    coordinates3.x = FMath.floor(this.x + d5 * d - d4 * d13);
                    coordinates3.y = FMath.floor(this.y + d4 * d + d5 * d13);
                    if (coordinates3.x == coordinates2.x && coordinates3.y == coordinates2.y) continue;
                    int n6 = 0;
                    for (int j = 0; j < 10; ++j) {
                        double d14 = (double)coordinates3.y + dArray2[j] - this.y;
                        for (int k = 0; k < 10; ++k) {
                            double d15 = (double)coordinates3.x + dArray2[k] - this.x;
                            double d16 = d5 * d15 + d4 * d14;
                            double d17 = d5 * d14 - d4 * d15;
                            if (!(d16 * d16 / d6 + d17 * d17 / d7 <= 1.0)) continue;
                            ++n6;
                        }
                    }
                    coordinates4.x = coordinates3.x - n;
                    coordinates4.y = coordinates3.y - n2;
                    byteImage.set(coordinates4, (double)(255 * n6) / 100.0);
                    coordinates2.x = coordinates3.x;
                    coordinates2.y = coordinates3.y;
                }
            }
        }
        return byteImage;
    }

    @Override
    public Bounds bounds() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.angle == 0.0 || this.angle == Math.PI) {
            d = this.major;
            d2 = this.minor;
        } else if (this.major == 0.0) {
            d = this.minor * Math.sin(this.angle);
            d2 = this.minor * Math.cos(this.angle);
        } else if (this.minor == 0.0) {
            d = this.major * Math.cos(this.angle);
            d2 = this.major * Math.sin(this.angle);
        } else {
            double d3 = Math.tan(this.angle);
            double d4 = Math.atan(-this.minor * d3 / this.major);
            double d5 = Math.atan(this.minor / (d3 * this.major));
            double d6 = Math.sin(this.angle);
            double d7 = Math.cos(this.angle);
            d = this.major * d7 * Math.cos(d4) - this.minor * d6 * Math.sin(d4);
            d2 = this.major * d6 * Math.cos(d5) + this.minor * d7 * Math.sin(d5);
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        Bounds bounds = new Bounds();
        bounds.lower.x = this.x - d;
        bounds.lower.y = this.y - d2;
        bounds.upper.x = this.x + d;
        bounds.upper.y = this.y + d2;
        return bounds;
    }

    @Override
    public boolean equals(Shape shape) {
        if (shape != null && shape instanceof Ellipse) {
            Ellipse ellipse = (Ellipse)shape;
            if (this.x == ellipse.x && this.y == ellipse.y && this.major == ellipse.major && this.minor == ellipse.minor && this.angle == ellipse.angle) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean empty() {
        return this.area() == 0.0;
    }
}

