/*
 * Decompiled with CFR 0.152.
 */
package imagescience.shape;

import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.shape.Bounds;
import imagescience.shape.Point;
import imagescience.shape.Shape;
import imagescience.utility.FMath;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class Circle
implements Shape {
    private double x = 0.0;
    private double y = 0.0;
    private double radius = 1.0;
    private static final int CONTOUR_RESOLUTION = 10;

    public Circle() {
    }

    public Circle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Radius less than 0");
        }
        this.x = d;
        this.y = d2;
        this.radius = d3;
    }

    public Circle(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public void x(double d) {
        this.x = d;
    }

    public void y(double d) {
        this.y = d;
    }

    public void center(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void position(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    @Override
    public Shape duplicate() {
        return new Circle(this);
    }

    public void set(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("Radius less than 0");
        }
        this.x = d;
        this.y = d2;
        this.radius = d3;
    }

    public void radius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Radius less than 0");
        }
        this.radius = d;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double radius() {
        return this.radius;
    }

    public double perimeter() {
        return Math.PI * 2 * this.radius;
    }

    public double area() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        double d5 = d3 * d3 + d4 * d4;
        double d6 = this.radius * this.radius;
        return d5 <= d6;
    }

    public GeneralPath contour() {
        return new GeneralPath(new Ellipse2D.Double(this.x - this.radius, this.y - this.radius, 2.0 * this.radius, 2.0 * this.radius));
    }

    @Override
    public Image bitmap(boolean bl) {
        Bounds bounds = this.bounds();
        int n = FMath.floor(bounds.lower.x);
        int n2 = FMath.floor(bounds.lower.y);
        int n3 = 1 + FMath.floor(bounds.upper.x) - n;
        int n4 = 1 + FMath.floor(bounds.upper.y) - n2;
        ByteImage byteImage = new ByteImage(new Dimensions(n3, n4));
        if (this.radius > 0.0) {
            double d;
            double d2 = this.x - (double)n - 0.5;
            double d3 = this.y - (double)n2 - 0.5;
            double d4 = this.radius * this.radius;
            Coordinates coordinates = new Coordinates();
            double[] dArray = new double[n3];
            byteImage.axes(1);
            int n5 = 0;
            while (n5 < n4) {
                d = (double)n5 - d3;
                double d5 = d * d;
                for (int i = 0; i < n3; ++i) {
                    double d6 = (double)i - d2;
                    dArray[i] = d6 * d6 + d5 <= d4 ? 255.0 : 0.0;
                }
                byteImage.set(coordinates, dArray);
                ++n5;
                ++coordinates.y;
            }
            if (!bl) {
                n5 = FMath.ceil(10.0 * this.perimeter());
                d = Math.PI * 2 / (double)n5;
                double[] dArray2 = new double[10];
                for (int i = 0; i < 10; ++i) {
                    dArray2[i] = ((double)i + 1.0) / 11.0;
                }
                Coordinates coordinates2 = new Coordinates(Integer.MIN_VALUE, Integer.MIN_VALUE);
                Coordinates coordinates3 = new Coordinates();
                Coordinates coordinates4 = new Coordinates();
                for (int i = 0; i < n5; ++i) {
                    double d7 = d * (double)i;
                    coordinates3.x = FMath.floor(this.x + this.radius * Math.cos(d7));
                    coordinates3.y = FMath.floor(this.y + this.radius * Math.sin(d7));
                    if (coordinates3.x == coordinates2.x && coordinates3.y == coordinates2.y) continue;
                    int n6 = 0;
                    for (int j = 0; j < 10; ++j) {
                        double d8 = (double)coordinates3.y + dArray2[j] - this.y;
                        double d9 = d8 * d8;
                        for (int k = 0; k < 10; ++k) {
                            double d10 = (double)coordinates3.x + dArray2[k] - this.x;
                            if (!(d10 * d10 + d9 <= d4)) continue;
                            ++n6;
                        }
                    }
                    coordinates4.x = coordinates3.x - n;
                    coordinates4.y = coordinates3.y - n2;
                    byteImage.set(coordinates4, (double)(255 * n6) / 100.0);
                    coordinates2.x = coordinates3.x;
                    coordinates2.y = coordinates3.y;
                }
            }
        }
        return byteImage;
    }

    @Override
    public Bounds bounds() {
        Bounds bounds = new Bounds();
        bounds.lower.x = this.x - this.radius;
        bounds.upper.x = this.x + this.radius;
        bounds.lower.y = this.y - this.radius;
        bounds.upper.y = this.y + this.radius;
        return bounds;
    }

    @Override
    public boolean equals(Shape shape) {
        if (shape != null && shape instanceof Circle) {
            Circle circle = (Circle)shape;
            if (this.x == circle.x && this.y == circle.y && this.radius == circle.radius) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean empty() {
        return this.area() == 0.0;
    }
}

