/*
 * Decompiled with CFR 0.152.
 */
package imagescience.segment;

import imagescience.ImageScience;
import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.segment.Candidates;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Thresholder {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private static final double ON = 10.0;
    private static final double OFF = 0.0;
    private static final double CAND = 2.0;
    private static final double QUEUED = 9.0;
    private static final double ABOVE = 255.0;
    private static final double BELOW = 0.0;

    public void hard(Image image, double d) {
        this.messenger.log(ImageScience.prelude() + "Thresholder");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Hard thresholding " + image.type() + " at value " + d);
        this.progressor.status("Applying hard thresholding...");
        Dimensions dimensions = image.dimensions();
        double[] dArray = new double[dimensions.x];
        Coordinates coordinates = new Coordinates();
        this.progressor.steps(dimensions.c * dimensions.t * dimensions.z);
        this.progressor.start();
        image.axes(1);
        coordinates.c = 0;
        while (coordinates.c < dimensions.c) {
            coordinates.t = 0;
            while (coordinates.t < dimensions.t) {
                coordinates.z = 0;
                while (coordinates.z < dimensions.z) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        image.get(coordinates, dArray);
                        for (int i = 0; i < dimensions.x; ++i) {
                            dArray[i] = dArray[i] >= d ? 255.0 : 0.0;
                        }
                        image.set(coordinates, dArray);
                        ++coordinates.y;
                    }
                    this.progressor.step();
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
            ++coordinates.c;
        }
        image.name(image.name() + " hard thresholded");
        this.progressor.stop();
        timer.stop();
    }

    public void hysteresis(Image image, double d, double d2) {
        this.messenger.log(ImageScience.prelude() + "Thresholder");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Hysteresis thresholding " + image.type() + " in range [" + d + "," + d2 + "]");
        this.progressor.status("Applying hysteresis thresholding...");
        Dimensions dimensions = image.dimensions();
        double[] dArray = new double[dimensions.x];
        double[] dArray2 = new double[dimensions.x + 2];
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates();
        Coordinates coordinates3 = new Coordinates();
        Candidates candidates = new Candidates();
        image.axes(1);
        this.progressor.steps(3 * dimensions.c * dimensions.t * dimensions.z * dimensions.y);
        this.progressor.start();
        if (dimensions.z == 1) {
            Dimensions dimensions2 = new Dimensions(dimensions.x + 2, dimensions.y + 2, dimensions.z, dimensions.t, dimensions.c);
            ByteImage byteImage = new ByteImage(dimensions2);
            byteImage.axes(1);
            coordinates2.c = 0;
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates2.t = 0;
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    coordinates2.y = 1;
                    while (coordinates.y < dimensions.y) {
                        coordinates.x = 0;
                        image.get(coordinates, dArray);
                        coordinates2.x = 1;
                        while (coordinates.x < dimensions.x) {
                            dArray2[coordinates2.x] = dArray[coordinates.x] >= d2 ? 10.0 : (dArray[coordinates.x] >= d ? 2.0 : 0.0);
                            ++coordinates.x;
                            ++coordinates2.x;
                        }
                        coordinates2.x = 0;
                        byteImage.set(coordinates2, dArray2);
                        this.progressor.step();
                        ++coordinates.y;
                        ++coordinates2.y;
                    }
                    ++coordinates.t;
                    ++coordinates2.t;
                }
                ++coordinates.c;
                ++coordinates2.c;
            }
            coordinates2.c = 0;
            while (coordinates2.c < dimensions.c) {
                coordinates2.t = 0;
                while (coordinates2.t < dimensions.t) {
                    coordinates2.y = 1;
                    while (coordinates2.y <= dimensions.y) {
                        coordinates2.x = 0;
                        byteImage.get(coordinates2, dArray2);
                        coordinates2.x = 1;
                        while (coordinates2.x <= dimensions.x) {
                            if (dArray2[coordinates2.x] == 10.0) {
                                candidates.push(coordinates2);
                                while (candidates.size > 0) {
                                    candidates.pop(coordinates3);
                                    byteImage.set(coordinates3, 10.0);
                                    ++coordinates3.x;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    ++coordinates3.y;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    --coordinates3.x;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    --coordinates3.x;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    --coordinates3.y;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    --coordinates3.y;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    ++coordinates3.x;
                                    if (byteImage.get(coordinates3) == 2.0) {
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                    ++coordinates3.x;
                                    if (byteImage.get(coordinates3) != 2.0) continue;
                                    candidates.push(coordinates3);
                                    byteImage.set(coordinates3, 9.0);
                                }
                            }
                            ++coordinates2.x;
                        }
                        this.progressor.step();
                        ++coordinates2.y;
                    }
                    ++coordinates2.t;
                }
                ++coordinates2.c;
            }
            coordinates2.c = 0;
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates2.t = 0;
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    coordinates2.y = 1;
                    while (coordinates.y < dimensions.y) {
                        coordinates2.x = 0;
                        byteImage.get(coordinates2, dArray2);
                        coordinates.x = 0;
                        coordinates2.x = 1;
                        while (coordinates.x < dimensions.x) {
                            dArray[coordinates.x] = dArray2[coordinates2.x] == 10.0 ? 255.0 : 0.0;
                            ++coordinates.x;
                            ++coordinates2.x;
                        }
                        coordinates.x = 0;
                        image.set(coordinates, dArray);
                        this.progressor.step();
                        ++coordinates.y;
                        ++coordinates2.y;
                    }
                    ++coordinates.t;
                    ++coordinates2.t;
                }
                ++coordinates.c;
                ++coordinates2.c;
            }
        } else {
            Dimensions dimensions3 = new Dimensions(dimensions.x + 2, dimensions.y + 2, dimensions.z + 2, dimensions.t, dimensions.c);
            ByteImage byteImage = new ByteImage(dimensions3);
            byteImage.axes(1);
            coordinates2.c = 0;
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates2.t = 0;
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    coordinates2.z = 1;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        coordinates2.y = 1;
                        while (coordinates.y < dimensions.y) {
                            coordinates.x = 0;
                            image.get(coordinates, dArray);
                            coordinates2.x = 1;
                            while (coordinates.x < dimensions.x) {
                                dArray2[coordinates2.x] = dArray[coordinates.x] >= d2 ? 10.0 : (dArray[coordinates.x] >= d ? 2.0 : 0.0);
                                ++coordinates.x;
                                ++coordinates2.x;
                            }
                            coordinates2.x = 0;
                            byteImage.set(coordinates2, dArray2);
                            this.progressor.step();
                            ++coordinates.y;
                            ++coordinates2.y;
                        }
                        ++coordinates.z;
                        ++coordinates2.z;
                    }
                    ++coordinates.t;
                    ++coordinates2.t;
                }
                ++coordinates.c;
                ++coordinates2.c;
            }
            coordinates2.c = 0;
            while (coordinates2.c < dimensions.c) {
                coordinates2.t = 0;
                while (coordinates2.t < dimensions.t) {
                    coordinates2.z = 1;
                    while (coordinates2.z <= dimensions.z) {
                        coordinates2.y = 1;
                        while (coordinates2.y <= dimensions.y) {
                            coordinates2.x = 0;
                            byteImage.get(coordinates2, dArray2);
                            coordinates2.x = 1;
                            while (coordinates2.x <= dimensions.x) {
                                if (dArray2[coordinates2.x] == 10.0) {
                                    candidates.push(coordinates2);
                                    while (candidates.size > 0) {
                                        candidates.pop(coordinates3);
                                        byteImage.set(coordinates3, 10.0);
                                        ++coordinates3.z;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.z;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.z;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.x;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        --coordinates3.y;
                                        if (byteImage.get(coordinates3) == 2.0) {
                                            candidates.push(coordinates3);
                                            byteImage.set(coordinates3, 9.0);
                                        }
                                        ++coordinates3.x;
                                        ++coordinates3.y;
                                        if (byteImage.get(coordinates3) != 2.0) continue;
                                        candidates.push(coordinates3);
                                        byteImage.set(coordinates3, 9.0);
                                    }
                                }
                                ++coordinates2.x;
                            }
                            this.progressor.step();
                            ++coordinates2.y;
                        }
                        ++coordinates2.z;
                    }
                    ++coordinates2.t;
                }
                ++coordinates2.c;
            }
            coordinates2.c = 0;
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates2.t = 0;
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    coordinates2.z = 1;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        coordinates2.y = 1;
                        while (coordinates.y < dimensions.y) {
                            coordinates2.x = 0;
                            byteImage.get(coordinates2, dArray2);
                            coordinates.x = 0;
                            coordinates2.x = 1;
                            while (coordinates.x < dimensions.x) {
                                dArray[coordinates.x] = dArray2[coordinates2.x] == 10.0 ? 255.0 : 0.0;
                                ++coordinates.x;
                                ++coordinates2.x;
                            }
                            coordinates.x = 0;
                            image.set(coordinates, dArray);
                            this.progressor.step();
                            ++coordinates.y;
                            ++coordinates2.y;
                        }
                        ++coordinates.z;
                        ++coordinates2.z;
                    }
                    ++coordinates.t;
                    ++coordinates2.t;
                }
                ++coordinates.c;
                ++coordinates2.c;
            }
        }
        image.name(image.name() + " hysteresis thresholded");
        this.progressor.stop();
        timer.stop();
    }
}

