/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.Randomizer;

public class UniformGenerator
implements RandomGenerator {
    private static final int N = 624;
    private static final int M = 397;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int[] mag01 = new int[]{0, -1727483681};
    private final int[] mt = new int[624];
    private int mti;
    private final double min;
    private final double max;

    public UniformGenerator() {
        this(0.0, 1.0, (int)Randomizer.seeder.next());
    }

    public UniformGenerator(int n) {
        this(0.0, 1.0, n);
    }

    public UniformGenerator(double d, double d2) {
        this(d, d2, (int)Randomizer.seeder.next());
    }

    public UniformGenerator(double d, double d2, int n) {
        this.min = d;
        this.max = d2;
        this.initialize(n);
    }

    private void initialize(int n) {
        this.mt[0] = n;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    @Override
    public double next() {
        return this.next(this.min, this.max);
    }

    public double next(double d, double d2) {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ mag01[n & 1];
            }
            for (n2 = 227; n2 < 623; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ mag01[n & 1];
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return d + (d2 - d) * ((double)((long)n & 0xFFFFFFFFL) + 0.5) / 4.294967296E9;
    }
}

