/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.ImageScience;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.random.BinomialGenerator;
import imagescience.random.ExponentialGenerator;
import imagescience.random.GammaGenerator;
import imagescience.random.GaussianGenerator;
import imagescience.random.PoissonGenerator;
import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Randomizer {
    static final UniformGenerator seeder = new UniformGenerator(-2.147483648E9, 2.147483647E9, (int)System.currentTimeMillis());
    public static final int ADDITIVE = 0;
    public static final int MULTIPLICATIVE = 1;
    public static final int MODULATORY = 2;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();

    public Image gaussian(Image image, double d, double d2, int n, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for Gaussian randomization");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Standard deviation less than 0");
        }
        this.messenger.log("Initializing Gaussian random number generator");
        this.messenger.log("Mean = " + d);
        this.messenger.log("Standard deviation = " + d2);
        this.messenger.log(">> Variance = " + d2 * d2);
        GaussianGenerator gaussianGenerator = new GaussianGenerator(d, d2);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n) + " Gaussian noise");
        this.insert(image2, gaussianGenerator, n);
        timer.stop();
        return image2;
    }

    public Image binomial(Image image, int n, double d, int n2, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for binomial randomization");
        if (n < 0) {
            throw new IllegalArgumentException("Number of trials less than 0");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Probability outside range [0,1]");
        }
        this.messenger.log("Initializing binomial random number generator");
        this.messenger.log("Trials = " + n);
        this.messenger.log("Probability = " + d);
        double d2 = (double)n * d;
        double d3 = d2 * (1.0 - d);
        this.messenger.log(">> Mean = " + d2);
        this.messenger.log(">> Variance = " + d3);
        this.messenger.log(">> Standard deviation = " + Math.sqrt(d3));
        BinomialGenerator binomialGenerator = new BinomialGenerator(n, d);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n2) + " binomial noise");
        this.insert(image2, binomialGenerator, n2);
        timer.stop();
        return image2;
    }

    public Image gamma(Image image, int n, int n2, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for gamma randomization");
        if (n <= 0) {
            throw new IllegalArgumentException("Order less than or equal to 0");
        }
        this.messenger.log("Initializing gamma random number generator");
        this.messenger.log("Order = " + n);
        this.messenger.log(">> Mean = " + n);
        this.messenger.log(">> Variance = " + n);
        this.messenger.log(">> Standard deviation = " + Math.sqrt(n));
        GammaGenerator gammaGenerator = new GammaGenerator(n);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n2) + " gamma noise");
        this.insert(image2, gammaGenerator, n2);
        timer.stop();
        return image2;
    }

    public Image uniform(Image image, double d, double d2, int n, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for uniform randomization");
        if (d >= d2) {
            throw new IllegalArgumentException("Maximum must be larger than minimum");
        }
        this.messenger.log("Initializing uniform random number generator");
        this.messenger.log("Minimum = " + d);
        this.messenger.log("Maximum = " + d2);
        double d3 = 0.5 * (d + d2);
        double d4 = (d2 - d) / Math.sqrt(12.0);
        this.messenger.log(">> Mean = " + d3);
        this.messenger.log(">> Variance = " + d4 * d4);
        this.messenger.log(">> Standard deviation = " + d4);
        UniformGenerator uniformGenerator = new UniformGenerator(d, d2);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n) + " uniform noise");
        this.insert(image2, uniformGenerator, n);
        timer.stop();
        return image2;
    }

    public Image exponential(Image image, double d, int n, boolean bl) {
        double d2;
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for exponential randomization");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Lambda less than or equal to 0");
        }
        this.messenger.log("Initializing exponential random number generator");
        this.messenger.log("Lambda = " + d);
        double d3 = d2 = 1.0 / d;
        this.messenger.log(">> Mean = " + d2);
        this.messenger.log(">> Variance = " + d3 * d3);
        this.messenger.log(">> Standard deviation = " + d3);
        ExponentialGenerator exponentialGenerator = new ExponentialGenerator(d);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n) + " exponential noise");
        this.insert(image2, exponentialGenerator, n);
        timer.stop();
        return image2;
    }

    public Image poisson(Image image, double d, int n, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Randomizer");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments for Poisson randomization");
        if (d < 0.0) {
            throw new IllegalArgumentException("Mean less than 0");
        }
        this.messenger.log("Initializing Poisson random number generator");
        if (n == 0 || n == 1) {
            this.messenger.log("Mean = " + d);
            this.messenger.log(">> Variance = " + d);
            this.messenger.log(">> Standard deviation = " + Math.sqrt(d));
        }
        PoissonGenerator poissonGenerator = new PoissonGenerator(d);
        Image image2 = bl ? image.duplicate() : image;
        image2.name(image.name() + " with " + this.insertion(n) + " Poisson noise");
        this.insert(image2, poissonGenerator, n);
        timer.stop();
        return image2;
    }

    private void insert(Image image, RandomGenerator randomGenerator, int n) {
        this.messenger.log("Randomizing " + image.type());
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates = new Coordinates();
        this.progressor.status("Randomizing...");
        this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
        double[] dArray = new double[dimensions.x];
        image.axes(1);
        this.progressor.start();
        switch (n) {
            case 0: {
                this.messenger.log("Inserting random numbers by addition");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        while (coordinates.z < dimensions.z) {
                            coordinates.y = 0;
                            while (coordinates.y < dimensions.y) {
                                image.get(coordinates, dArray);
                                int n2 = 0;
                                while (n2 < dimensions.x) {
                                    int n3 = n2++;
                                    dArray[n3] = dArray[n3] + randomGenerator.next();
                                }
                                image.set(coordinates, dArray);
                                this.progressor.step();
                                ++coordinates.y;
                            }
                            ++coordinates.z;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
                break;
            }
            case 1: {
                this.messenger.log("Inserting random numbers by multiplication");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        while (coordinates.z < dimensions.z) {
                            coordinates.y = 0;
                            while (coordinates.y < dimensions.y) {
                                image.get(coordinates, dArray);
                                int n4 = 0;
                                while (n4 < dimensions.x) {
                                    int n5 = n4++;
                                    dArray[n5] = dArray[n5] * randomGenerator.next();
                                }
                                image.set(coordinates, dArray);
                                this.progressor.step();
                                ++coordinates.y;
                            }
                            ++coordinates.z;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
                break;
            }
            case 2: {
                if (!(randomGenerator instanceof PoissonGenerator)) {
                    throw new IllegalArgumentException("Invalid type of insertion");
                }
                PoissonGenerator poissonGenerator = (PoissonGenerator)randomGenerator;
                this.messenger.log("Inserting random numbers by modulation");
                coordinates.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        while (coordinates.z < dimensions.z) {
                            coordinates.y = 0;
                            while (coordinates.y < dimensions.y) {
                                image.get(coordinates, dArray);
                                for (int i = 0; i < dimensions.x; ++i) {
                                    dArray[i] = poissonGenerator.next(dArray[i]);
                                }
                                image.set(coordinates, dArray);
                                this.progressor.step();
                                ++coordinates.y;
                            }
                            ++coordinates.z;
                        }
                        ++coordinates.t;
                    }
                    ++coordinates.c;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type of insertion");
            }
        }
        this.progressor.stop();
    }

    private String insertion(int n) {
        switch (n) {
            case 0: {
                return "additive";
            }
            case 1: {
                return "multiplicative";
            }
            case 2: {
                return "modulatory";
            }
        }
        return null;
    }
}

