/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;
import imagescience.utility.FMath;

public class PoissonGenerator
implements RandomGenerator {
    private final double mean;
    private final UniformGenerator unigen;
    private double premean = -1.0;
    private double sqrt2mean;
    private double logmean;
    private double comp;

    public PoissonGenerator() {
        this(1.0);
    }

    public PoissonGenerator(int n) {
        this(1.0, n);
    }

    public PoissonGenerator(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Mean less than 0");
        }
        this.mean = d;
        this.unigen = new UniformGenerator();
    }

    public PoissonGenerator(double d, int n) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Mean less than 0");
        }
        this.mean = d;
        this.unigen = new UniformGenerator(n);
    }

    @Override
    public double next() {
        return this.next(this.mean);
    }

    public double next(double d) {
        double d2;
        if (d < 0.0) {
            throw new IllegalArgumentException("Mean less than 0");
        }
        if (d < 12.0) {
            if (d != this.premean) {
                this.premean = d;
                this.comp = Math.exp(-d);
            }
            double d3 = -1.0;
            double d4 = 1.0;
            do {
                d3 += 1.0;
            } while ((d4 *= this.unigen.next()) > this.comp);
            return d3;
        }
        if (d != this.premean) {
            this.premean = d;
            this.sqrt2mean = Math.sqrt(2.0 * d);
            this.logmean = Math.log(d);
            this.comp = d * this.logmean - FMath.lngamma(d + 1.0);
        }
        while (true) {
            double d5;
            if ((d2 = this.sqrt2mean * (d5 = Math.tan(Math.PI * this.unigen.next())) + d) < 0.0) {
                continue;
            }
            d2 = Math.floor(d2);
            if (!(this.unigen.next() > 0.9 * (1.0 + d5 * d5) * Math.exp(d2 * this.logmean - FMath.lngamma(d2 + 1.0) - this.comp))) break;
        }
        return d2;
    }
}

