/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;

public class GaussianGenerator
implements RandomGenerator {
    private final double mean;
    private final double stdev;
    private final UniformGenerator unigen;
    private double cache;
    private boolean cached = false;

    public GaussianGenerator() {
        this(0.0, 1.0);
    }

    public GaussianGenerator(int n) {
        this(0.0, 1.0, n);
    }

    public GaussianGenerator(double d, double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Standard deviation less than 0");
        }
        this.mean = d;
        this.stdev = d2;
        this.unigen = new UniformGenerator(-1.0, 1.0);
    }

    public GaussianGenerator(double d, double d2, int n) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Standard deviation less than 0");
        }
        this.mean = d;
        this.stdev = d2;
        this.unigen = new UniformGenerator(-1.0, 1.0, n);
    }

    @Override
    public double next() {
        return this.next(this.mean, this.stdev);
    }

    public double next(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (this.cached) {
            this.cached = false;
            return d + d2 * this.cache;
        }
        while ((d5 = (d4 = this.unigen.next()) * d4 + (d3 = this.unigen.next()) * d3) >= 1.0) {
        }
        double d6 = Math.sqrt(-2.0 * Math.log(d5) / d5);
        this.cache = d4 * d6;
        this.cached = true;
        return d + d2 * d3 * d6;
    }
}

