/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;

public class GammaGenerator
implements RandomGenerator {
    private final int order;
    private final UniformGenerator unigen;

    public GammaGenerator() {
        this(1);
    }

    public GammaGenerator(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Order less than or equal to 0");
        }
        this.order = n;
        this.unigen = new UniformGenerator(0.0, 1.0);
    }

    public GammaGenerator(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Order less than or equal to 0");
        }
        this.order = n;
        this.unigen = new UniformGenerator(0.0, 1.0, n2);
    }

    @Override
    public double next() {
        return this.next(this.order);
    }

    public double next(int n) {
        double d;
        if (n < 6) {
            double d2 = 1.0;
            for (int i = 0; i < n; ++i) {
                d2 *= this.unigen.next();
            }
            return -Math.log(d2);
        }
        while (true) {
            double d3;
            double d4;
            if ((d4 = this.unigen.next()) * d4 + (d3 = 2.0 * this.unigen.next() - 1.0) * d3 > 1.0) {
                continue;
            }
            double d5 = d3 / d4;
            double d6 = n - 1;
            double d7 = Math.sqrt(2.0 * d6 + 1.0);
            d = d7 * d5 + d6;
            if (!(d <= 0.0) && !(this.unigen.next() > (1.0 + d5 * d5) * Math.exp(d6 * Math.log(d / d6) - d7 * d5))) break;
        }
        return d;
    }
}

