/*
 * Decompiled with CFR 0.152.
 */
package imagescience.random;

import imagescience.random.RandomGenerator;
import imagescience.random.UniformGenerator;

public class ExponentialGenerator
implements RandomGenerator {
    private final double lambda;
    private final UniformGenerator unigen;

    public ExponentialGenerator() {
        this(1.0);
    }

    public ExponentialGenerator(int n) {
        this(1.0, n);
    }

    public ExponentialGenerator(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Lambda less than or equal to 0");
        }
        this.lambda = d;
        this.unigen = new UniformGenerator();
    }

    public ExponentialGenerator(double d, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Lambda less than or equal to 0");
        }
        this.lambda = d;
        this.unigen = new UniformGenerator(n);
    }

    @Override
    public double next() {
        return -Math.log(this.unigen.next()) / this.lambda;
    }

    public double next(double d) {
        return -Math.log(this.unigen.next()) / d;
    }
}

