/*
 * Decompiled with CFR 0.152.
 */
package imagescience.mesh;

import java.util.Vector;
import javax.vecmath.Point3f;

public class Cone {
    private Point3f[] v = null;
    private int[] t = null;
    private int lod = 0;
    private boolean cap = true;

    public Cone(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Level of detail less than 0");
        }
        this.lod = n;
        this.cap = bl;
        int n2 = 16 * (int)Math.pow(2.0, n);
        int n3 = bl ? 2 : 1;
        int n4 = n2 + n3;
        int n5 = 3 * n2 * n3;
        this.v = new Point3f[n4];
        int n6 = 0;
        this.t = new int[n5];
        int n7 = 0;
        this.v[n6++] = new Point3f(1.0f, 0.0f, 0.0f);
        if (bl) {
            this.v[n6++] = new Point3f(0.0f, 0.0f, 0.0f);
        }
        double d = Math.PI * 2 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d2 = (double)i * d;
            float f = (float)Math.cos(d2);
            float f2 = (float)Math.sin(d2);
            this.v[n6++] = new Point3f(0.0f, f, f2);
            if (i <= 0) continue;
            this.t[n7++] = n6 - 2;
            this.t[n7++] = n6 - 1;
            this.t[n7++] = 0;
            if (!bl) continue;
            this.t[n7++] = n6 - 1;
            this.t[n7++] = n6 - 2;
            this.t[n7++] = 1;
        }
        this.t[n7++] = n6 - 1;
        this.t[n7++] = n3;
        this.t[n7++] = 0;
        if (bl) {
            this.t[n7++] = n6 - 1;
            this.t[n7++] = 1;
            this.t[n7++] = 2;
        }
    }

    public Vector<Point3f> render(Point3f point3f, float f, Point3f point3f2) {
        Object object;
        int n;
        if (f < 0.0f) {
            throw new IllegalArgumentException("Radius less than 0");
        }
        int n2 = this.v.length;
        Point3f[] point3fArray = new Point3f[n2];
        double d = point3f2.x - point3f.x;
        double d2 = point3f2.y - point3f.y;
        double d3 = point3f2.z - point3f.z;
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d6 = Math.atan2(d2, d);
        double d7 = Math.atan2(d3, d4);
        float f2 = (float)Math.cos(d6);
        float f3 = (float)Math.sin(d6);
        float f4 = (float)Math.cos(d7);
        float f5 = (float)Math.sin(d7);
        point3fArray[0] = new Point3f(point3f2);
        if (this.cap) {
            point3fArray[1] = new Point3f(point3f);
        }
        int n3 = n = this.cap ? 2 : 1;
        while (n < n2) {
            object = new Point3f(this.v[n]);
            ((Point3f)object).x = (float)((double)((Point3f)object).x * d5);
            ((Point3f)object).y *= f;
            ((Point3f)object).z *= f;
            float f6 = ((Point3f)object).x * f4 - ((Point3f)object).z * f5;
            float f7 = ((Point3f)object).z * f4 + ((Point3f)object).x * f5;
            ((Point3f)object).x = f6;
            ((Point3f)object).z = f7;
            f6 = ((Point3f)object).x * f2 - ((Point3f)object).y * f3;
            float f8 = ((Point3f)object).x * f3 + ((Point3f)object).y * f2;
            ((Point3f)object).x = f6;
            ((Point3f)object).y = f8;
            ((Point3f)object).x += point3f.x;
            ((Point3f)object).y += point3f.y;
            ((Point3f)object).z += point3f.z;
            point3fArray[n] = object;
            ++n;
        }
        n = this.t.length;
        object = new Vector(n);
        for (int i = 0; i < n; ++i) {
            ((Vector)object).add(point3fArray[this.t[i]]);
        }
        return object;
    }
}

