/*
 * Decompiled with CFR 0.152.
 */
package imagescience.fourier;

import imagescience.ImageScience;
import imagescience.image.Axes;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.Image;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class FFT {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    private static final double TWOPI = Math.PI * 2;

    public void forward(Image image, Image image2, Axes axes) {
        this.messenger.log(ImageScience.prelude() + "Forward FFT");
        this.fft(image, image2, axes, -1);
    }

    public void inverse(Image image, Image image2, Axes axes) {
        this.messenger.log(ImageScience.prelude() + "Inverse FFT");
        this.fft(image, image2, axes, 1);
    }

    private void fft(Image image, Image image2, Axes axes, int n) {
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.check(image, image2, axes);
        Coordinates coordinates = new Coordinates();
        Dimensions dimensions = image.dimensions();
        if (n == -1) {
            this.progressor.status("Forward FFT...");
        } else {
            this.progressor.status("Inverse FFT...");
        }
        double[] dArray = null;
        double[] dArray2 = null;
        double d = 1.0;
        this.progressor.steps((axes.x ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0) + (axes.y ? dimensions.c * dimensions.t * dimensions.z * dimensions.x : 0) + (axes.z ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0) + (axes.t ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0) + (axes.c ? dimensions.c * dimensions.t * dimensions.z * dimensions.y : 0));
        this.progressor.start();
        if (axes.x) {
            this.messenger.log("   FFT in x-dimension...");
            d *= (double)dimensions.x;
            coordinates.reset();
            image.axes(1);
            image2.axes(1);
            dArray = new double[dimensions.x];
            dArray2 = new double[dimensions.x];
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            image.get(coordinates, dArray);
                            image2.get(coordinates, dArray2);
                            this.fft(dArray, dArray2, n);
                            image.set(coordinates, dArray);
                            image2.set(coordinates, dArray2);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.y) {
            this.messenger.log("   FFT in y-dimension...");
            d *= (double)dimensions.y;
            coordinates.reset();
            image.axes(2);
            image2.axes(2);
            dArray = new double[dimensions.y];
            dArray2 = new double[dimensions.y];
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            image.get(coordinates, dArray);
                            image2.get(coordinates, dArray2);
                            this.fft(dArray, dArray2, n);
                            image.set(coordinates, dArray);
                            image2.set(coordinates, dArray2);
                            this.progressor.step();
                            ++coordinates.x;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.z) {
            this.messenger.log("   FFT in z-dimension...");
            d *= (double)dimensions.z;
            coordinates.reset();
            image.axes(4);
            image2.axes(4);
            dArray = new double[dimensions.z];
            dArray2 = new double[dimensions.z];
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            image.get(coordinates, dArray);
                            image2.get(coordinates, dArray2);
                            this.fft(dArray, dArray2, n);
                            image.set(coordinates, dArray);
                            image2.set(coordinates, dArray2);
                            ++coordinates.x;
                        }
                        this.progressor.step(dimensions.z);
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
        }
        if (axes.t) {
            this.messenger.log("   FFT in t-dimension...");
            d *= (double)dimensions.t;
            coordinates.reset();
            image.axes(8);
            image2.axes(8);
            dArray = new double[dimensions.t];
            dArray2 = new double[dimensions.t];
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.z = 0;
                while (coordinates.z < dimensions.z) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            image.get(coordinates, dArray);
                            image2.get(coordinates, dArray2);
                            this.fft(dArray, dArray2, n);
                            image.set(coordinates, dArray);
                            image2.set(coordinates, dArray2);
                            ++coordinates.x;
                        }
                        this.progressor.step(dimensions.t);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.c;
            }
        }
        if (axes.c) {
            this.messenger.log("   FFT in c-dimension...");
            d *= (double)dimensions.c;
            coordinates.reset();
            image.axes(16);
            image2.axes(16);
            dArray = new double[dimensions.c];
            dArray2 = new double[dimensions.c];
            coordinates.t = 0;
            while (coordinates.t < dimensions.t) {
                coordinates.z = 0;
                while (coordinates.z < dimensions.z) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        coordinates.x = 0;
                        while (coordinates.x < dimensions.x) {
                            image.get(coordinates, dArray);
                            image2.get(coordinates, dArray2);
                            this.fft(dArray, dArray2, n);
                            image.set(coordinates, dArray);
                            image2.set(coordinates, dArray2);
                            ++coordinates.x;
                        }
                        this.progressor.step(dimensions.c);
                        ++coordinates.y;
                    }
                    ++coordinates.z;
                }
                ++coordinates.t;
            }
        }
        if (n == 1) {
            this.messenger.log("   Scale correction...");
            image.divide(d);
            image2.divide(d);
        }
        this.messenger.log("Done");
        this.progressor.stop();
        timer.stop();
    }

    private void check(Image image, Image image2, Axes axes) {
        this.messenger.log("Real input image of type " + image.type());
        this.messenger.log("Imaginary input image of type " + image2.type());
        Dimensions dimensions = image.dimensions();
        Dimensions dimensions2 = image2.dimensions();
        if (!dimensions.equals(dimensions2)) {
            throw new IllegalStateException("Real and imaginary images have different dimensions");
        }
        if (axes.x && !FMath.power2(dimensions.x)) {
            throw new IllegalStateException("Real and imaginary x-size not a power of 2");
        }
        if (axes.y && !FMath.power2(dimensions.y)) {
            throw new IllegalStateException("Real and imaginary y-size not a power of 2");
        }
        if (axes.z && !FMath.power2(dimensions.z)) {
            throw new IllegalStateException("Real and imaginary z-size not a power of 2");
        }
        if (axes.t && !FMath.power2(dimensions.t)) {
            throw new IllegalStateException("Real and imaginary t-size not a power of 2");
        }
        if (axes.c && !FMath.power2(dimensions.c)) {
            throw new IllegalStateException("Real and imaginary c-size not a power of 2");
        }
    }

    private void fft(double[] dArray, double[] dArray2, int n) {
        double d;
        int n2;
        int n3 = dArray.length;
        int n4 = n3 / 2;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6;
            if (n5 > n2) {
                double d2 = dArray[n5];
                dArray[n5] = dArray[n2];
                dArray[n2] = d2;
                d = dArray2[n5];
                dArray2[n5] = dArray2[n2];
                dArray2[n2] = d;
            }
            for (n6 = n4; n6 >= 2 && n5 >= n6; n5 -= n6, n6 >>= 1) {
            }
            n5 += n6;
        }
        n5 = 1;
        for (n2 = 2; n2 <= n3; n2 <<= 1) {
            double d3 = (double)n * (Math.PI * 2) / (double)n2;
            d = Math.sin(0.5 * d3);
            double d4 = -2.0 * d * d;
            double d5 = Math.sin(d3);
            double d6 = 1.0;
            double d7 = 0.0;
            for (int i = 0; i < n5; ++i) {
                int n7 = i;
                int n8 = i + n5;
                while (n7 < n3) {
                    double d8 = d6 * dArray[n8] - d7 * dArray2[n8];
                    double d9 = d6 * dArray2[n8] + d7 * dArray[n8];
                    dArray[n8] = dArray[n7] - d8;
                    dArray2[n8] = dArray2[n7] - d9;
                    int n9 = n7;
                    dArray[n9] = dArray[n9] + d8;
                    int n10 = n7;
                    dArray2[n10] = dArray2[n10] + d9;
                    n7 += n2;
                    n8 += n2;
                }
                d = d6;
                d6 += d * d4 - d7 * d5;
                d7 += d7 * d4 + d * d5;
            }
            n5 = n2;
        }
    }
}

