/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.feature.Differentiator;
import imagescience.image.Aspects;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;
import java.util.Vector;

public class Structure {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    public final Differentiator differentiator = new Differentiator();
    private static final double TWOPI = Math.PI * 2;

    public Vector<Image> run(Image image, double d, double d2) {
        this.messenger.log(ImageScience.prelude() + "Structure");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Smoothing scale less than or equal to 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Integration scale less than or equal to 0");
        }
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        Aspects aspects = image.aspects();
        this.messenger.log("Element aspect ratios: (" + aspects.x + "," + aspects.y + "," + aspects.z + "," + aspects.t + "," + aspects.c + ")");
        if (aspects.x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (aspects.y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (aspects.z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        Image image2 = image instanceof FloatImage ? image : new FloatImage(image);
        Vector<Image> vector = null;
        String string = image.name();
        this.differentiator.messenger.log(this.messenger.log());
        this.differentiator.progressor.parent(this.progressor);
        if (dimensions.z == 1) {
            double[] dArray = new double[]{0.0, 0.2, 0.4, 0.45, 0.63, 0.8, 0.95, 1.0};
            int n = 0;
            this.logus("Computing Ix");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image3 = this.differentiator.run(image2.duplicate(), d, 1, 0, 0);
            this.logus("Computing Iy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image4 = this.differentiator.run(image2, d, 0, 1, 0);
            this.progressor.range(dArray[n], dArray[++n]);
            this.progressor.steps(3L);
            this.progressor.start();
            Image image5 = image3.duplicate();
            this.logus("Computing IxIy");
            image5.multiply(image4);
            this.progressor.step();
            this.logus("Squaring Ix");
            image3.square();
            this.progressor.step();
            this.logus("Squaring Iy");
            image4.square();
            this.progressor.step();
            this.progressor.stop();
            this.messenger.log("Gaussian integration at scale " + d2);
            this.logus("Integrating IxIx");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image3, d2, 0, 0, 0);
            this.logus("Integrating IxIy");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image5, d2, 0, 0, 0);
            this.logus("Integrating IyIy");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image4, d2, 0, 0, 0);
            this.logus("Computing eigenimages");
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.y);
            this.progressor.range(dArray[n], dArray[++n]);
            image3.axes(1);
            image5.axes(1);
            image4.axes(1);
            double[] dArray2 = new double[dimensions.x];
            double[] dArray3 = new double[dimensions.x];
            double[] dArray4 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.messenger.log("Comparing and storing eigenvalues");
            this.progressor.start();
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        image3.get(coordinates, dArray2);
                        image5.get(coordinates, dArray3);
                        image4.get(coordinates, dArray4);
                        for (int i = 0; i < dimensions.x; ++i) {
                            double d3;
                            double d4;
                            double d5;
                            double d6 = -(dArray2[i] + dArray4[i]);
                            double d7 = -0.5 * (d6 + (double)(d6 < 0.0 ? -1 : 1) * Math.sqrt(d6 * d6 - 4.0 * (d5 = dArray2[i] * dArray4[i] - dArray3[i] * dArray3[i])));
                            if (d7 == 0.0) {
                                d4 = 0.0;
                                d3 = 0.0;
                            } else {
                                d4 = Math.abs(d7);
                                d3 = Math.abs(d5 / d7);
                            }
                            if (d4 > d3) {
                                dArray2[i] = d4;
                                dArray4[i] = d3;
                                continue;
                            }
                            dArray2[i] = d3;
                            dArray4[i] = d4;
                        }
                        image3.set(coordinates, dArray2);
                        image4.set(coordinates, dArray4);
                        this.progressor.step();
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
            this.progressor.stop();
            image3.name(string + " largest structure eigenvalues");
            image4.name(string + " smallest structure eigenvalues");
            image3.aspects(aspects.duplicate());
            image4.aspects(aspects.duplicate());
            vector = new Vector<Image>(2);
            vector.add(image3);
            vector.add(image4);
        } else {
            double[] dArray = new double[]{0.0, 0.1, 0.2, 0.3, 0.34, 0.4, 0.46, 0.52, 0.58, 0.64, 0.7, 1.0};
            int n = 0;
            this.logus("Computing Ix");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image6 = this.differentiator.run(image2.duplicate(), d, 1, 0, 0);
            this.logus("Computing Iy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image7 = this.differentiator.run(image2.duplicate(), d, 0, 1, 0);
            this.logus("Computing Iz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image8 = this.differentiator.run(image2, d, 0, 0, 1);
            this.progressor.range(dArray[n], dArray[++n]);
            this.progressor.steps(6L);
            this.progressor.start();
            this.logus("Computing IxIy");
            Image image9 = image6.duplicate();
            image9.multiply(image7);
            this.progressor.step();
            this.logus("Computing IxIz");
            Image image10 = image6.duplicate();
            image10.multiply(image8);
            this.progressor.step();
            this.logus("Computing IyIz");
            Image image11 = image7.duplicate();
            image11.multiply(image8);
            this.progressor.step();
            this.logus("Squaring Ix");
            image6.square();
            this.progressor.step();
            this.logus("Squaring Iy");
            image7.square();
            this.progressor.step();
            this.logus("Squaring Iz");
            image8.square();
            this.progressor.step();
            this.progressor.stop();
            this.messenger.log("Gaussian integration at scale " + d2);
            this.logus("Integrating IxIx");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image6, d2, 0, 0, 0);
            this.logus("Integrating IxIy");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image9, d2, 0, 0, 0);
            this.logus("Integrating IxIz");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image10, d2, 0, 0, 0);
            this.logus("Integrating IyIy");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image7, d2, 0, 0, 0);
            this.logus("Integrating IyIz");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image11, d2, 0, 0, 0);
            this.logus("Integrating IzIz");
            this.progressor.range(dArray[n], dArray[++n]);
            this.differentiator.run(image8, d2, 0, 0, 0);
            this.logus("Computing eigenimages");
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
            this.progressor.range(dArray[n], dArray[++n]);
            image6.axes(1);
            image9.axes(1);
            image10.axes(1);
            image7.axes(1);
            image11.axes(1);
            image8.axes(1);
            double[] dArray5 = new double[dimensions.x];
            double[] dArray6 = new double[dimensions.x];
            double[] dArray7 = new double[dimensions.x];
            double[] dArray8 = new double[dimensions.x];
            double[] dArray9 = new double[dimensions.x];
            double[] dArray10 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.messenger.log("Comparing and storing eigenvalues");
            this.progressor.start();
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            image6.get(coordinates, dArray5);
                            image9.get(coordinates, dArray6);
                            image10.get(coordinates, dArray7);
                            image7.get(coordinates, dArray8);
                            image11.get(coordinates, dArray9);
                            image8.get(coordinates, dArray10);
                            for (int i = 0; i < dimensions.x; ++i) {
                                double d8;
                                double d9;
                                double d10;
                                double d11;
                                double d12;
                                double d13 = dArray5[i];
                                double d14 = dArray6[i];
                                double d15 = dArray7[i];
                                double d16 = dArray8[i];
                                double d17 = dArray9[i];
                                double d18 = dArray10[i];
                                double d19 = -(d13 + d16 + d18);
                                double d20 = d13 * d16 + d13 * d18 + d16 * d18 - d14 * d14 - d15 * d15 - d17 * d17;
                                double d21 = d13 * (d17 * d17 - d16 * d18) + d16 * d15 * d15 + d18 * d14 * d14 - 2.0 * d14 * d15 * d17;
                                double d22 = (d19 * d19 - 3.0 * d20) / 9.0;
                                double d23 = (d19 * d19 * d19 - 4.5 * d19 * d20 + 13.5 * d21) / 27.0;
                                double d24 = d22 > 0.0 ? Math.sqrt(d22) : 0.0;
                                double d25 = d24 * d24 * d24;
                                if (d25 == 0.0) {
                                    d12 = 0.0;
                                    d11 = 0.0;
                                    d10 = 0.0;
                                } else {
                                    d9 = d23 / d25;
                                    d8 = d9 * d9 <= 1.0 ? Math.acos(d9) : Math.acos(d9 < 0.0 ? -1.0 : 1.0);
                                    d12 = Math.abs(-2.0 * d24 * Math.cos(d8 / 3.0) - d19 / 3.0);
                                    d11 = Math.abs(-2.0 * d24 * Math.cos((d8 + Math.PI * 2) / 3.0) - d19 / 3.0);
                                    d10 = Math.abs(-2.0 * d24 * Math.cos((d8 - Math.PI * 2) / 3.0) - d19 / 3.0);
                                }
                                if (d11 < d10) {
                                    d9 = d11;
                                    d11 = d10;
                                    d10 = d9;
                                }
                                if (d12 < d11) {
                                    d9 = d12;
                                    d12 = d11;
                                    d11 = d9;
                                    if (d11 < d10) {
                                        d8 = d11;
                                        d11 = d10;
                                        d10 = d8;
                                    }
                                }
                                dArray5[i] = d12;
                                dArray8[i] = d11;
                                dArray10[i] = d10;
                            }
                            image6.set(coordinates, dArray5);
                            image7.set(coordinates, dArray8);
                            image8.set(coordinates, dArray10);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
            this.progressor.stop();
            image6.name(string + " largest structure eigenvalues");
            image7.name(string + " middle structure eigenvalues");
            image8.name(string + " smallest structure eigenvalues");
            image6.aspects(aspects.duplicate());
            image7.aspects(aspects.duplicate());
            image8.aspects(aspects.duplicate());
            vector = new Vector(3);
            vector.add(image6);
            vector.add(image7);
            vector.add(image8);
        }
        this.messenger.status("");
        timer.stop();
        return vector;
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

