/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.image.ByteImage;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Statistics {
    public static final int MINIMUM = 1;
    public static final int MAXIMUM = 2;
    public static final int MEAN = 4;
    public static final int MEDIAN = 8;
    public static final int ELEMENTS = 16;
    public static final int MASS = 32;
    public static final int VARIANCE = 64;
    public static final int MODE = 128;
    public static final int SDEVIATION = 256;
    public static final int ADEVIATION = 512;
    public static final int L1NORM = 1024;
    public static final int L2NORM = 2048;
    public static final int SKEWNESS = 4096;
    public static final int KURTOSIS = 8192;
    private double dMinimum;
    private double dMaximum;
    private double dMean;
    private double dMedian;
    private double dElements;
    private double dMass;
    private double dVariance;
    private double dMode;
    private double dSDeviation;
    private double dADeviation;
    private double dL1norm;
    private double dL2norm;
    private double dSkewness;
    private double dKurtosis;
    private static final int BINS = 100000;
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();

    public double get(int n) {
        switch (n) {
            case 1: {
                return this.dMinimum;
            }
            case 2: {
                return this.dMaximum;
            }
            case 4: {
                return this.dMean;
            }
            case 8: {
                return this.dMedian;
            }
            case 16: {
                return this.dElements;
            }
            case 32: {
                return this.dMass;
            }
            case 64: {
                return this.dVariance;
            }
            case 128: {
                return this.dMode;
            }
            case 256: {
                return this.dSDeviation;
            }
            case 512: {
                return this.dADeviation;
            }
            case 1024: {
                return this.dL1norm;
            }
            case 2048: {
                return this.dL2norm;
            }
            case 4096: {
                return this.dSkewness;
            }
            case 8192: {
                return this.dKurtosis;
            }
        }
        throw new IllegalArgumentException("Non-supported statistic");
    }

    public void run(Image image) {
        Dimensions dimensions = image.dimensions();
        Coordinates coordinates = new Coordinates();
        Coordinates coordinates2 = new Coordinates(dimensions.x - 1, dimensions.y - 1, dimensions.z - 1, dimensions.t - 1, dimensions.c - 1);
        this.run(image, coordinates, coordinates2);
    }

    public void run(Image image, Coordinates coordinates, Coordinates coordinates2) {
        ByteImage byteImage = new ByteImage(new Dimensions());
        byteImage.set(new Coordinates(), 1.0);
        this.run(image, coordinates, coordinates2, byteImage);
    }

    public void run(Image image, Coordinates coordinates, Coordinates coordinates2, Image image2) {
        int n;
        int n2;
        double d;
        double d2;
        this.messenger.log(ImageScience.prelude() + "Statistics");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        int n3 = coordinates2.x - coordinates.x + 1;
        int n4 = coordinates2.y - coordinates.y + 1;
        int n5 = coordinates2.z - coordinates.z + 1;
        int n6 = coordinates2.t - coordinates.t + 1;
        int n7 = coordinates2.c - coordinates.c + 1;
        Dimensions dimensions = image.dimensions();
        Dimensions dimensions2 = image2.dimensions();
        if (coordinates.x > coordinates2.x || coordinates.x < 0 || coordinates2.x >= dimensions.x || coordinates.y > coordinates2.y || coordinates.y < 0 || coordinates2.y >= dimensions.y || coordinates.z > coordinates2.z || coordinates.z < 0 || coordinates2.z >= dimensions.z || coordinates.t > coordinates2.t || coordinates.t < 0 || coordinates2.t >= dimensions.t || coordinates.c > coordinates2.c || coordinates.c < 0 || coordinates2.c >= dimensions.c) {
            throw new IllegalArgumentException("Invalid min and max coordinates for region of interest");
        }
        if (dimensions2.x != n3 && dimensions2.x != 1 || dimensions2.y != n4 && dimensions2.y != 1 || dimensions2.z != n5 && dimensions2.z != 1 || dimensions2.t != n6 && dimensions2.t != 1 || dimensions2.c != n7 && dimensions2.c != 1) {
            throw new IllegalArgumentException("Invalid mask size for region of interest");
        }
        Coordinates coordinates3 = new Coordinates();
        coordinates3.x = coordinates.x;
        Coordinates coordinates4 = new Coordinates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[dimensions2.x];
        image.axes(1);
        image2.axes(1);
        int n8 = dimensions2.c == 1 ? 0 : 1;
        int n9 = dimensions2.t == 1 ? 0 : 1;
        int n10 = dimensions2.z == 1 ? 0 : 1;
        int n11 = dimensions2.y == 1 ? 0 : 1;
        int n12 = dimensions2.x == 1 ? 0 : 1;
        this.messenger.log("Computing statistics");
        this.progressor.status("Computing statistics...");
        this.progressor.steps(2 * n7 * n6 * n5);
        this.progressor.start();
        this.dElements = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        this.dMinimum = Double.MAX_VALUE;
        this.dMaximum = -1.7976931348623157E308;
        coordinates3.c = coordinates.c;
        coordinates4.c = 0;
        while (coordinates3.c <= coordinates2.c) {
            coordinates3.t = coordinates.t;
            coordinates4.t = 0;
            while (coordinates3.t <= coordinates2.t) {
                coordinates3.z = coordinates.z;
                coordinates4.z = 0;
                while (coordinates3.z <= coordinates2.z) {
                    coordinates3.y = coordinates.y;
                    coordinates4.y = 0;
                    while (coordinates3.y <= coordinates2.y) {
                        image.get(coordinates3, dArray);
                        image2.get(coordinates4, dArray2);
                        int n13 = 0;
                        int n14 = 0;
                        while (n13 < n3) {
                            if (dArray2[n14] != 0.0) {
                                this.dElements += 1.0;
                                d2 = dArray[n13];
                                d = d2 * d2;
                                d3 += d2;
                                d4 += d;
                                d5 += d2 * d;
                                d6 += d * d;
                                d7 += Math.abs(d2);
                                if (d2 < this.dMinimum) {
                                    this.dMinimum = d2;
                                }
                                if (d2 > this.dMaximum) {
                                    this.dMaximum = d2;
                                }
                            }
                            ++n13;
                            n14 += n12;
                        }
                        ++coordinates3.y;
                        coordinates4.y += n11;
                    }
                    this.progressor.step();
                    ++coordinates3.z;
                    coordinates4.z += n10;
                }
                ++coordinates3.t;
                coordinates4.t += n9;
            }
            ++coordinates3.c;
            coordinates4.c += n8;
        }
        this.dMass = d3;
        this.dMean = d3 / this.dElements;
        double d8 = this.dMean * this.dMean;
        this.dVariance = d4 / this.dElements - d8;
        this.dSDeviation = Math.sqrt(this.dVariance);
        this.dL1norm = d7;
        this.dL2norm = Math.sqrt(d4);
        this.dSkewness = ((d5 - 3.0 * this.dMean * d4) / this.dElements + 2.0 * this.dMean * d8) / (this.dVariance * this.dSDeviation);
        this.dKurtosis = ((d6 - 4.0 * this.dMean * d5 + 6.0 * d8 * d4) / this.dElements - 3.0 * d8 * d8) / (this.dVariance * this.dVariance) - 3.0;
        d2 = 0.0;
        d = this.dMaximum - this.dMinimum;
        double d9 = d == 0.0 ? 1.0 : d;
        int[] nArray = new int[100001];
        coordinates3.c = coordinates.c;
        coordinates4.c = 0;
        while (coordinates3.c <= coordinates2.c) {
            coordinates3.t = coordinates.t;
            coordinates4.t = 0;
            while (coordinates3.t <= coordinates2.t) {
                coordinates3.z = coordinates.z;
                coordinates4.z = 0;
                while (coordinates3.z <= coordinates2.z) {
                    coordinates3.y = coordinates.y;
                    coordinates4.y = 0;
                    while (coordinates3.y <= coordinates2.y) {
                        image.get(coordinates3, dArray);
                        image2.get(coordinates4, dArray2);
                        n2 = 0;
                        n = 0;
                        while (n2 < n3) {
                            if (dArray2[n] != 0.0) {
                                int n15 = (int)((dArray[n2] - this.dMinimum) / d9 * 100000.0);
                                nArray[n15] = nArray[n15] + 1;
                                d2 += Math.abs(dArray[n2] - this.dMean);
                            }
                            ++n2;
                            n += n12;
                        }
                        ++coordinates3.y;
                        coordinates4.y += n11;
                    }
                    this.progressor.step();
                    ++coordinates3.z;
                    coordinates4.z += n10;
                }
                ++coordinates3.t;
                coordinates4.t += n9;
            }
            ++coordinates3.c;
            coordinates4.c += n8;
        }
        this.dADeviation = d2 / this.dElements;
        nArray[99999] = nArray[99999] + nArray[100000];
        n2 = 0;
        n = 0;
        int n16 = (int)this.dElements;
        int n17 = n16 % 2 == 0 ? n16 / 2 : n16 / 2 + 1;
        for (int i = 0; i < 100000; ++i) {
            int n18 = nArray[i];
            if (n18 >= n2) {
                n2 = n18;
                this.dMode = i;
            }
            if (n >= n17) continue;
            this.dMedian = i;
            n += n18;
        }
        this.dMode = this.dMinimum + (this.dMode + 0.5) / 100000.0 * d;
        this.dMedian = this.dMinimum + (this.dMedian + 0.5) / 100000.0 * d;
        if (!(image instanceof FloatImage)) {
            this.dMode = FMath.round(this.dMode);
            this.dMedian = FMath.round(this.dMedian);
        }
        this.progressor.stop();
        timer.stop();
    }
}

