/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.feature.Differentiator;
import imagescience.image.Aspects;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Laplacian {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    public final Differentiator differentiator = new Differentiator();

    public Image run(Image image, double d) {
        this.messenger.log(ImageScience.prelude() + "Laplacian");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Smoothing scale less than or equal to 0");
        }
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        Aspects aspects = image.aspects();
        this.messenger.log("Element aspect ratios: (" + aspects.x + "," + aspects.y + "," + aspects.z + "," + aspects.t + "," + aspects.c + ")");
        if (aspects.x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (aspects.y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (aspects.z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        Image image2 = image instanceof FloatImage ? image : new FloatImage(image);
        String string = image.name();
        this.differentiator.messenger.log(this.messenger.log());
        this.differentiator.progressor.parent(this.progressor);
        if (dimensions.z == 1) {
            double[] dArray = new double[]{0.0, 0.55, 0.99, 1.0};
            int n = 0;
            this.logus("Computing Ixx");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image3 = this.differentiator.run(image2.duplicate(), d, 2, 0, 0);
            this.logus("Computing Iyy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image4 = this.differentiator.run(image2, d, 0, 2, 0);
            this.logus("Computing Laplacian");
            this.progressor.range(dArray[n], dArray[++n]);
            this.progressor.steps(1L);
            this.progressor.start();
            image2.add(image3);
            this.progressor.step();
        } else {
            double[] dArray = new double[]{0.0, 0.35, 0.7, 0.98, 1.0};
            int n = 0;
            this.logus("Computing Ixx");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image5 = this.differentiator.run(image2.duplicate(), d, 2, 0, 0);
            this.logus("Computing Iyy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image6 = this.differentiator.run(image2.duplicate(), d, 0, 2, 0);
            this.logus("Computing Izz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image7 = this.differentiator.run(image2, d, 0, 0, 2);
            this.logus("Computing Laplacian");
            this.progressor.range(dArray[n], dArray[++n]);
            this.progressor.steps(2L);
            this.progressor.start();
            image2.add(image6);
            this.progressor.step();
            image2.add(image5);
            this.progressor.step();
        }
        this.progressor.stop();
        timer.stop();
        image2.name(string + " Laplacian");
        return image2;
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

