/*
 * Decompiled with CFR 0.152.
 */
package imagescience.feature;

import imagescience.ImageScience;
import imagescience.feature.Differentiator;
import imagescience.image.Aspects;
import imagescience.image.Coordinates;
import imagescience.image.Dimensions;
import imagescience.image.FloatImage;
import imagescience.image.Image;
import imagescience.utility.FMath;
import imagescience.utility.Messenger;
import imagescience.utility.Progressor;
import imagescience.utility.Timer;

public class Edges {
    public final Messenger messenger = new Messenger();
    public final Progressor progressor = new Progressor();
    public final Differentiator differentiator = new Differentiator();

    public Image run(Image image, double d, boolean bl) {
        this.messenger.log(ImageScience.prelude() + "Edges");
        Timer timer = new Timer();
        timer.messenger.log(this.messenger.log());
        timer.start();
        this.messenger.log("Checking arguments");
        if (d <= 0.0) {
            throw new IllegalArgumentException("Smoothing scale less than or equal to 0");
        }
        Dimensions dimensions = image.dimensions();
        this.messenger.log("Input image dimensions: (x,y,z,t,c) = (" + dimensions.x + "," + dimensions.y + "," + dimensions.z + "," + dimensions.t + "," + dimensions.c + ")");
        Aspects aspects = image.aspects();
        this.messenger.log("Element aspect ratios: (" + aspects.x + "," + aspects.y + "," + aspects.z + "," + aspects.t + "," + aspects.c + ")");
        if (aspects.x <= 0.0) {
            throw new IllegalStateException("Aspect ratio in x-dimension less than or equal to 0");
        }
        if (aspects.y <= 0.0) {
            throw new IllegalStateException("Aspect ratio in y-dimension less than or equal to 0");
        }
        if (aspects.z <= 0.0) {
            throw new IllegalStateException("Aspect ratio in z-dimension less than or equal to 0");
        }
        String string = image.name();
        Image image2 = image instanceof FloatImage ? image : new FloatImage(image);
        this.differentiator.messenger.log(this.messenger.log());
        this.differentiator.progressor.parent(this.progressor);
        if (dimensions.z == 1) {
            double[] dArray = new double[]{0.0, 0.5, 0.98, 1.0};
            int n = 0;
            if (bl) {
                dArray = new double[]{0.0, 0.46, 0.9, 0.92, 1.0};
            }
            this.logus("Computing Ix");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image3 = this.differentiator.run(image2.duplicate(), d, 1, 0, 0);
            this.logus("Computing Iy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image4 = this.differentiator.run(image2, d, 0, 1, 0);
            this.logus("Computing gradient magnitude");
            this.progressor.range(dArray[n], dArray[++n]);
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.y);
            image2 = bl ? new FloatImage(dimensions) : image3;
            image3.axes(1);
            image4.axes(1);
            image2.axes(1);
            double[] dArray2 = new double[dimensions.x];
            double[] dArray3 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.progressor.start();
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.y = 0;
                    while (coordinates.y < dimensions.y) {
                        image3.get(coordinates, dArray2);
                        image4.get(coordinates, dArray3);
                        for (int i = 0; i < dimensions.x; ++i) {
                            dArray2[i] = Math.sqrt(dArray2[i] * dArray2[i] + dArray3[i] * dArray3[i]);
                        }
                        image2.set(coordinates, dArray2);
                        this.progressor.step();
                        ++coordinates.y;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
            this.progressor.stop();
            if (bl) {
                this.logus("Suppressing non-maxima");
                this.progressor.steps(dimensions.c * dimensions.t * dimensions.y);
                this.progressor.range(dArray[n], dArray[++n]);
                Image image5 = image3;
                double[][] dArray4 = new double[3][dimensions.x + 2];
                Coordinates coordinates2 = new Coordinates();
                coordinates2.x = -1;
                coordinates.reset();
                this.progressor.start();
                if (dimensions.y == 1) {
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates.t < dimensions.t) {
                            image3.get(coordinates, dArray2);
                            image4.get(coordinates, dArray3);
                            image2.get(coordinates2, dArray4[0]);
                            dArray4[1] = dArray4[0];
                            dArray4[2] = dArray4[1];
                            this.suppress2D(dArray4, dArray2, dArray3);
                            image5.set(coordinates, dArray2);
                            this.progressor.step();
                            ++coordinates.t;
                            ++coordinates2.t;
                        }
                        ++coordinates.c;
                        ++coordinates2.c;
                    }
                } else {
                    double[] dArray5 = null;
                    int n2 = dimensions.y - 1;
                    coordinates.c = 0;
                    coordinates2.c = 0;
                    while (coordinates.c < dimensions.c) {
                        coordinates.t = 0;
                        coordinates2.t = 0;
                        while (coordinates.t < dimensions.t) {
                            coordinates.y = 0;
                            image3.get(coordinates, dArray2);
                            image4.get(coordinates, dArray3);
                            coordinates2.y = 0;
                            image2.get(coordinates2, dArray4[1]);
                            coordinates2.y = 1;
                            image2.get(coordinates2, dArray4[0]);
                            image2.get(coordinates2, dArray4[2]);
                            this.suppress2D(dArray4, dArray2, dArray3);
                            image5.set(coordinates, dArray2);
                            this.progressor.step();
                            coordinates.y = 1;
                            coordinates2.y = 2;
                            while (coordinates.y < n2) {
                                image3.get(coordinates, dArray2);
                                image4.get(coordinates, dArray3);
                                dArray5 = dArray4[0];
                                dArray4[0] = dArray4[1];
                                dArray4[1] = dArray4[2];
                                dArray4[2] = dArray5;
                                image2.get(coordinates2, dArray4[2]);
                                this.suppress2D(dArray4, dArray2, dArray3);
                                image5.set(coordinates, dArray2);
                                this.progressor.step();
                                ++coordinates.y;
                                ++coordinates2.y;
                            }
                            image3.get(coordinates, dArray2);
                            image4.get(coordinates, dArray3);
                            dArray5 = dArray4[0];
                            dArray4[0] = dArray4[1];
                            dArray4[1] = dArray4[2];
                            dArray4[2] = dArray5;
                            coordinates2.y = dimensions.y - 2;
                            image2.get(coordinates2, dArray4[2]);
                            this.suppress2D(dArray4, dArray2, dArray3);
                            image5.set(coordinates, dArray2);
                            this.progressor.step();
                            ++coordinates.t;
                            ++coordinates2.t;
                        }
                        ++coordinates.c;
                        ++coordinates2.c;
                    }
                }
                this.progressor.stop();
                image2 = image5;
            }
        } else {
            double[] dArray = new double[]{0.0, 0.35, 0.7, 0.98, 1.0};
            int n = 0;
            if (bl) {
                dArray = new double[]{0.0, 0.32, 0.64, 0.9, 0.92, 1.0};
            }
            this.logus("Computing Ix");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image6 = this.differentiator.run(image2.duplicate(), d, 1, 0, 0);
            this.logus("Computing Iy");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image7 = this.differentiator.run(image2.duplicate(), d, 0, 1, 0);
            this.logus("Computing Iz");
            this.progressor.range(dArray[n], dArray[++n]);
            Image image8 = this.differentiator.run(image2, d, 0, 0, 1);
            this.logus("Computing gradient magnitude");
            this.progressor.steps(dimensions.c * dimensions.t * dimensions.z * dimensions.y);
            this.progressor.range(dArray[n], dArray[++n]);
            image2 = bl ? new FloatImage(dimensions) : image6;
            image6.axes(1);
            image7.axes(1);
            image8.axes(1);
            image2.axes(1);
            double[] dArray6 = new double[dimensions.x];
            double[] dArray7 = new double[dimensions.x];
            double[] dArray8 = new double[dimensions.x];
            Coordinates coordinates = new Coordinates();
            this.progressor.start();
            coordinates.c = 0;
            while (coordinates.c < dimensions.c) {
                coordinates.t = 0;
                while (coordinates.t < dimensions.t) {
                    coordinates.z = 0;
                    while (coordinates.z < dimensions.z) {
                        coordinates.y = 0;
                        while (coordinates.y < dimensions.y) {
                            image6.get(coordinates, dArray6);
                            image7.get(coordinates, dArray7);
                            image8.get(coordinates, dArray8);
                            for (int i = 0; i < dimensions.x; ++i) {
                                dArray6[i] = Math.sqrt(dArray6[i] * dArray6[i] + dArray7[i] * dArray7[i] + dArray8[i] * dArray8[i]);
                            }
                            image2.set(coordinates, dArray6);
                            this.progressor.step();
                            ++coordinates.y;
                        }
                        ++coordinates.z;
                    }
                    ++coordinates.t;
                }
                ++coordinates.c;
            }
            this.progressor.stop();
            if (bl) {
                this.logus("Suppressing non-maxima");
                this.progressor.steps(dimensions.c * dimensions.t * dimensions.z);
                this.progressor.range(dArray[n], dArray[++n]);
                image6.axes(3);
                image7.axes(3);
                image8.axes(3);
                Image image9 = image6;
                image2.axes(3);
                double[][][] dArray9 = new double[3][dimensions.y + 2][dimensions.x + 2];
                double[][] dArray10 = new double[dimensions.y][dimensions.x];
                double[][] dArray11 = new double[dimensions.y][dimensions.x];
                double[][] dArray12 = new double[dimensions.y][dimensions.x];
                Coordinates coordinates3 = new Coordinates();
                coordinates3.x = -1;
                coordinates3.y = -1;
                coordinates.reset();
                int n3 = dimensions.z - 1;
                double[][] dArray13 = null;
                this.progressor.start();
                coordinates.c = 0;
                coordinates3.c = 0;
                while (coordinates.c < dimensions.c) {
                    coordinates.t = 0;
                    coordinates3.t = 0;
                    while (coordinates.t < dimensions.t) {
                        coordinates.z = 0;
                        image6.get(coordinates, dArray10);
                        image7.get(coordinates, dArray11);
                        image8.get(coordinates, dArray12);
                        coordinates3.z = 0;
                        image2.get(coordinates3, dArray9[1]);
                        coordinates3.z = 1;
                        image2.get(coordinates3, dArray9[0]);
                        image2.get(coordinates3, dArray9[2]);
                        this.suppress3D(dArray9, dArray10, dArray11, dArray12);
                        image9.set(coordinates, dArray10);
                        this.progressor.step();
                        coordinates.z = 1;
                        coordinates3.z = 2;
                        while (coordinates.z < n3) {
                            image6.get(coordinates, dArray10);
                            image7.get(coordinates, dArray11);
                            image8.get(coordinates, dArray12);
                            dArray13 = dArray9[0];
                            dArray9[0] = dArray9[1];
                            dArray9[1] = dArray9[2];
                            dArray9[2] = dArray13;
                            image2.get(coordinates3, dArray9[2]);
                            this.suppress3D(dArray9, dArray10, dArray11, dArray12);
                            image9.set(coordinates, dArray10);
                            this.progressor.step();
                            ++coordinates.z;
                            ++coordinates3.z;
                        }
                        image6.get(coordinates, dArray10);
                        image7.get(coordinates, dArray11);
                        image8.get(coordinates, dArray12);
                        dArray13 = dArray9[0];
                        dArray9[0] = dArray9[1];
                        dArray9[1] = dArray9[2];
                        dArray9[2] = dArray13;
                        coordinates3.z = dimensions.z - 2;
                        image2.get(coordinates3, dArray9[2]);
                        this.suppress3D(dArray9, dArray10, dArray11, dArray12);
                        image9.set(coordinates, dArray10);
                        this.progressor.step();
                        ++coordinates.t;
                        ++coordinates3.t;
                    }
                    ++coordinates.c;
                    ++coordinates3.c;
                }
                this.progressor.stop();
                image2 = image9;
            }
        }
        timer.stop();
        image2.name(string + " edges");
        return image2;
    }

    private void suppress2D(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray2.length;
        int n2 = n + 1;
        int n3 = n - 1;
        if (n == 1) {
            dArray[0][0] = dArray[0][1];
            dArray[0][n2] = dArray[0][n];
            dArray[1][0] = dArray[1][1];
            dArray[1][n2] = dArray[1][n];
            dArray[2][0] = dArray[2][1];
            dArray[2][n2] = dArray[2][n];
        } else {
            dArray[0][0] = dArray[0][2];
            dArray[0][n2] = dArray[0][n3];
            dArray[1][0] = dArray[1][2];
            dArray[1][n2] = dArray[1][n3];
            dArray[2][0] = dArray[2][2];
            dArray[2][n2] = dArray[2][n3];
        }
        int n4 = 0;
        int n5 = 1;
        while (n4 < n) {
            double d = dArray[1][n5];
            if (d == 0.0) {
                dArray2[n4] = 0.0;
            } else {
                double d2 = (double)0.7f * dArray2[n4] / d;
                double d3 = (double)0.7f * dArray3[n4] / d;
                double d4 = (double)n5 + d2;
                double d5 = 1.0 + d3;
                int n6 = FMath.floor(d4);
                int n7 = FMath.floor(d5);
                int n8 = n6 + 1;
                int n9 = n7 + 1;
                double d6 = d4 - (double)n6;
                double d7 = d5 - (double)n7;
                double d8 = 1.0 - d6;
                double d9 = 1.0 - d7;
                double d10 = d9 * d8 * dArray[n7][n6] + d9 * d6 * dArray[n7][n8] + d7 * d8 * dArray[n9][n6] + d7 * d6 * dArray[n9][n8];
                d4 = (double)n5 - d2;
                d5 = 1.0 - d3;
                n6 = FMath.floor(d4);
                n7 = FMath.floor(d5);
                n8 = n6 + 1;
                n9 = n7 + 1;
                d6 = d4 - (double)n6;
                d7 = d5 - (double)n7;
                d8 = 1.0 - d6;
                d9 = 1.0 - d7;
                double d11 = d9 * d8 * dArray[n7][n6] + d9 * d6 * dArray[n7][n8] + d7 * d8 * dArray[n9][n6] + d7 * d6 * dArray[n9][n8];
                dArray2[n4] = d10 >= d || d11 >= d ? 0.0 : d;
            }
            ++n4;
            ++n5;
        }
    }

    private void suppress3D(double[][][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        double[] dArray5;
        int n;
        Object object;
        int n2;
        int n3 = dArray2.length;
        int n4 = n3 + 1;
        int n5 = n3 - 1;
        int n6 = dArray2[0].length;
        int n7 = n6 + 1;
        int n8 = n6 - 1;
        if (n6 == 1) {
            for (n2 = 0; n2 < 3; ++n2) {
                object = dArray[n2];
                for (n = 1; n < n4; ++n) {
                    object[n][0] = object[n][1];
                    object[n][n7] = object[n][n6];
                }
            }
        } else {
            for (n2 = 0; n2 < 3; ++n2) {
                object = dArray[n2];
                for (n = 1; n < n4; ++n) {
                    object[n][0] = object[n][2];
                    object[n][n7] = object[n][n8];
                }
            }
        }
        if (n3 == 1) {
            for (n2 = 0; n2 < 3; ++n2) {
                object = dArray[n2][0];
                double[] dArray6 = dArray[n2][1];
                dArray5 = dArray[n2][2];
                for (int i = 0; i <= n7; ++i) {
                    dArray5[i] = dArray6[i];
                    object[i] = (double[])dArray5[i];
                }
            }
        } else {
            for (n2 = 0; n2 < 3; ++n2) {
                object = dArray[n2][0];
                double[] dArray7 = dArray[n2][2];
                dArray5 = dArray[n2][n5];
                double[] dArray8 = dArray[n2][n4];
                for (int i = 0; i <= n7; ++i) {
                    object[i] = (double[])dArray7[i];
                    dArray8[i] = dArray5[i];
                }
            }
        }
        double[][] dArray9 = dArray[1];
        int n9 = 0;
        int n10 = 1;
        while (n9 < n3) {
            dArray5 = dArray9[n10];
            double[] dArray10 = dArray2[n9];
            double[] dArray11 = dArray3[n9];
            double[] dArray12 = dArray4[n9];
            int n11 = 0;
            int n12 = 1;
            while (n11 < n6) {
                double d = dArray5[n12];
                if (d == 0.0) {
                    dArray10[n11] = 0.0;
                } else {
                    double d2 = (double)0.7f * dArray10[n11] / d;
                    double d3 = (double)0.7f * dArray11[n11] / d;
                    double d4 = (double)0.7f * dArray12[n11] / d;
                    double d5 = (double)n12 + d2;
                    double d6 = (double)n10 + d3;
                    double d7 = 1.0 + d4;
                    int n13 = FMath.floor(d5);
                    int n14 = FMath.floor(d6);
                    int n15 = FMath.floor(d7);
                    int n16 = n13 + 1;
                    int n17 = n14 + 1;
                    int n18 = n15 + 1;
                    double d8 = d5 - (double)n13;
                    double d9 = d6 - (double)n14;
                    double d10 = d7 - (double)n15;
                    double d11 = 1.0 - d8;
                    double d12 = 1.0 - d9;
                    double d13 = 1.0 - d10;
                    double d14 = d13 * d12 * d11 * dArray[n15][n14][n13] + d13 * d12 * d8 * dArray[n15][n14][n16] + d13 * d9 * d11 * dArray[n15][n17][n13] + d13 * d9 * d8 * dArray[n15][n17][n16] + d10 * d12 * d11 * dArray[n18][n14][n13] + d10 * d12 * d8 * dArray[n18][n14][n16] + d10 * d9 * d11 * dArray[n18][n17][n13] + d10 * d9 * d8 * dArray[n18][n17][n16];
                    d5 = (double)n12 - d2;
                    d6 = (double)n10 - d3;
                    d7 = 1.0 - d4;
                    n13 = FMath.floor(d5);
                    n14 = FMath.floor(d6);
                    n15 = FMath.floor(d7);
                    n16 = n13 + 1;
                    n17 = n14 + 1;
                    n18 = n15 + 1;
                    d8 = d5 - (double)n13;
                    d9 = d6 - (double)n14;
                    d10 = d7 - (double)n15;
                    d11 = 1.0 - d8;
                    d12 = 1.0 - d9;
                    d13 = 1.0 - d10;
                    double d15 = d13 * d12 * d11 * dArray[n15][n14][n13] + d13 * d12 * d8 * dArray[n15][n14][n16] + d13 * d9 * d11 * dArray[n15][n17][n13] + d13 * d9 * d8 * dArray[n15][n17][n16] + d10 * d12 * d11 * dArray[n18][n14][n13] + d10 * d12 * d8 * dArray[n18][n14][n16] + d10 * d9 * d11 * dArray[n18][n17][n13] + d10 * d9 * d8 * dArray[n18][n17][n16];
                    dArray10[n11] = d14 >= d || d15 >= d ? 0.0 : d;
                }
                ++n11;
                ++n12;
            }
            ++n9;
            ++n10;
        }
    }

    private void logus(String string) {
        this.messenger.log(string);
        this.progressor.status(string + "...");
    }
}

