/*
 * Decompiled with CFR 0.152.
 */
package imagescience.color;

import java.awt.Color;

public class Palette {
    private static final int SIZE = 100;
    private static final Color[] spectrum = new Color[]{new Color(9109525), new Color(12453153), new Color(0xFF0000), new Color(16209261), new Color(16747420), new Color(9124096), new Color(12472837), new Color(16738560), new Color(16226389), new Color(0xFFBB8B), new Color(9130752), new Color(12481541), new Color(0xFF9900), new Color(16234069), new Color(16765323), new Color(9137664), new Color(12490501), new Color(16763136), new Color(16242005), new Color(16770699), new Color(0x8B8800), new Color(12499461), new Color(0xFFFF00), new Color(16249685), new Color(16776331), new Color(7637760), new Color(10534405), new Color(14089984), new Color(14546773), new Color(15531915), new Color(5933824), new Color(8306181), new Color(10944256), new Color(12515157), new Color(14090123), new Color(2525952), new Color(3718661), new Color(65280), new Color(8517461), new Color(11272075), new Color(35650), new Color(376413), new Color(65401), new Color(5633954), new Color(9174978), new Color(35702), new Color(376483), new Color(65535), new Color(5634015), new Color(9175022), new Color(27787), new Color(366014), new Color(50943), new Color(5624567), new Color(9168383), new Color(21131), new Color(357054), new Color(38655), new Color(5616887), new Color(9162751), new Color(14475), new Color(348094), new Color(26367), new Color(5609207), new Color(9157119), new Color(7819), new Color(339134), new Color(14079), new Color(0x5577F7), new Color(9151743), new Color(907), new Color(330430), new Color(255), new Color(5593591), new Color(9146111), new Color(3211403), new Color(4588990), new Color(5832959), new Color(9328119), new Color(11832319), new Color(4915339), new Color(6882750), new Color(8978687), new Color(11294199), new Color(13208575), new Color(6619275), new Color(9110974), new Color(12124415), new Color(13260279), new Color(14650367), new Color(8323211), new Color(11404734), new Color(0xFF00FF), new Color(15291895), new Color(16092159), new Color(9109603), new Color(12453257), new Color(16711862), new Color(16209352), new Color(16747486)};
    private static final int[] arbitrary = new int[]{2, 22, 37, 47, 72, 92, 12, 86, 40, 14, 60, 34, 1, 4, 15, 83, 39, 45, 26, 7, 96, 68, 42, 8, 95, 64, 5, 32, 81, 94, 49, 35, 24, 6, 61, 90, 3, 75, 38, 23, 0, 98, 74, 25, 11, 88, 57, 36, 9, 66, 87, 51, 33, 54, 50, 13, 97, 80, 73, 48, 10, 17, 41, 56, 70, 93, 78, 52, 27, 65, 18, 30, 63, 76, 84, 62, 29, 16, 59, 82, 55, 28, 43, 69, 99, 53, 20, 71, 46, 19, 91, 67, 31, 21, 85, 77, 79, 89, 44, 58};
    public static final int SPECTRUM = 0;
    public static final int ARBITRARY = 1;
    private final Color[] colors = new Color[100];
    private final boolean[] used = new boolean[100];
    private final int mode;
    private int next;

    public Palette() {
        this(1);
    }

    public Palette(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                for (int i = 0; i < 100; ++i) {
                    this.colors[i] = spectrum[i];
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 100; ++i) {
                    this.colors[i] = spectrum[arbitrary[i]];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid palette mode");
            }
        }
        this.reset();
    }

    public int mode() {
        return this.mode;
    }

    public Color get(int n) {
        return this.colors[n < 0 ? (n + 1) % 100 + 99 : n % 100];
    }

    public int index(Color color) {
        int n = -1;
        for (int i = 0; i < 100; ++i) {
            if (!this.colors[i].equals(color)) continue;
            n = i;
            break;
        }
        return n;
    }

    public Color next() {
        while (true) {
            if (this.next == 100) {
                this.reset();
                break;
            }
            if (!this.used[this.next]) break;
            ++this.next;
        }
        this.used[this.next] = true;
        return this.colors[this.next++];
    }

    public void used(Color color) {
        for (int i = 0; i < 100; ++i) {
            if (!this.colors[i].equals(color)) continue;
            this.used[i] = true;
            break;
        }
    }

    public void reset() {
        for (int i = 0; i < 100; ++i) {
            this.used[i] = false;
        }
        this.next = 0;
    }
}

