/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class LongArray {
    private int capacity = 10;
    private int increment = 0;
    private long[] longs = null;
    private int length = 0;

    public LongArray() {
        this.longs = new long[this.capacity];
    }

    public LongArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.longs = new long[n];
        this.capacity = n;
    }

    public LongArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.longs = new long[n];
        this.capacity = n;
        this.increment = n2;
    }

    public LongArray(long[] lArray) {
        this.longs = lArray;
        this.capacity = this.length = lArray.length;
    }

    public long[] array() {
        return this.longs;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            long[] lArray = new long[n];
            for (int i = 0; i < this.length; ++i) {
                lArray[i] = this.longs[i];
            }
            this.longs = lArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public long[] get() {
        return this.longs;
    }

    public long get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.longs[n];
    }

    public long first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.longs[0];
    }

    public long last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.longs[this.length - 1];
    }

    public void add(long l) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.longs[this.length++] = l;
    }

    public void append(long l) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.longs[this.length++] = l;
    }

    public void insert(long l, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n; --i) {
            this.longs[i] = this.longs[i - 1];
        }
        this.longs[n] = l;
        ++this.length;
    }

    public void set(long l, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.longs[n] = l;
    }

    public void set(long[] lArray) {
        this.longs = lArray;
        this.capacity = this.length = lArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        long[] lArray = new long[this.length];
        for (int i = 0; i < this.length; ++i) {
            lArray[i] = this.longs[i];
        }
        this.longs = lArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.longs[i - 1] = this.longs[i];
        }
        --this.length;
    }

    public LongArray duplicate() {
        LongArray longArray = new LongArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            longArray.longs[i] = this.longs[i];
        }
        longArray.length = this.length;
        return longArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            long[] lArray = new long[n];
            for (int i = 0; i < this.length; ++i) {
                lArray[i] = this.longs[i];
            }
            this.longs = lArray;
        }
    }

    public boolean equals(LongArray longArray) {
        if (longArray != null && longArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (longArray.longs[i] == this.longs[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        long[] lArray = new long[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            lArray[i] = this.longs[i];
        }
        this.longs = lArray;
    }
}

