/*
 * Decompiled with CFR 0.152.
 */
package imagescience.array;

import java.util.NoSuchElementException;

public class ByteArray {
    private int capacity = 10;
    private int increment = 0;
    private byte[] bytes = null;
    private int length = 0;

    public ByteArray() {
        this.bytes = new byte[this.capacity];
    }

    public ByteArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.bytes = new byte[n];
        this.capacity = n;
    }

    public ByteArray(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity less than 0");
        }
        this.bytes = new byte[n];
        this.capacity = n;
        this.increment = n2;
    }

    public ByteArray(byte[] byArray) {
        this.bytes = byArray;
        this.capacity = this.length = byArray.length;
    }

    public byte[] array() {
        return this.bytes;
    }

    public int length() {
        return this.length;
    }

    public void length(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Length less than 0");
        }
        if (n <= this.capacity) {
            this.length = n;
        } else {
            byte[] byArray = new byte[n];
            for (int i = 0; i < this.length; ++i) {
                byArray[i] = this.bytes[i];
            }
            this.bytes = byArray;
            this.length = this.capacity = n;
        }
    }

    public int size() {
        return this.length;
    }

    public void size(int n) {
        this.length(n);
    }

    public boolean empty() {
        return this.length == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public int increment() {
        return this.increment;
    }

    public void increment(int n) {
        this.increment = n;
    }

    public byte[] get() {
        return this.bytes;
    }

    public byte get(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.bytes[n];
    }

    public byte first() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.bytes[0];
    }

    public byte last() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.length - 1];
    }

    public void add(byte by) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.bytes[this.length++] = by;
    }

    public void append(byte by) {
        if (this.length == this.capacity) {
            this.inccap();
        }
        this.bytes[this.length++] = by;
    }

    public void insert(byte by, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length == this.capacity) {
            this.inccap();
        }
        for (int i = this.length; i > n; --i) {
            this.bytes[i] = this.bytes[i - 1];
        }
        this.bytes[n] = by;
        ++this.length;
    }

    public void set(byte by, int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bytes[n] = by;
    }

    public void set(byte[] byArray) {
        this.bytes = byArray;
        this.capacity = this.length = byArray.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void clear() {
        this.length = 0;
    }

    public void trim() {
        byte[] byArray = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            byArray[i] = this.bytes[i];
        }
        this.bytes = byArray;
        this.capacity = this.length;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n + 1; i < this.length; ++i) {
            this.bytes[i - 1] = this.bytes[i];
        }
        --this.length;
    }

    public ByteArray duplicate() {
        ByteArray byteArray = new ByteArray(this.capacity, this.increment);
        for (int i = 0; i < this.length; ++i) {
            byteArray.bytes[i] = this.bytes[i];
        }
        byteArray.length = this.length;
        return byteArray;
    }

    public void ensure(int n) {
        if (this.capacity < n) {
            this.capacity = n;
            byte[] byArray = new byte[n];
            for (int i = 0; i < this.length; ++i) {
                byArray[i] = this.bytes[i];
            }
            this.bytes = byArray;
        }
    }

    public boolean equals(ByteArray byteArray) {
        if (byteArray != null && byteArray.length == this.length) {
            for (int i = 0; i < this.length; ++i) {
                if (byteArray.bytes[i] == this.bytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void inccap() {
        this.capacity = this.increment <= 0 ? (this.capacity *= 2) : (this.capacity += this.increment);
        byte[] byArray = new byte[this.capacity];
        for (int i = 0; i < this.length; ++i) {
            byArray[i] = this.bytes[i];
        }
        this.bytes = byArray;
    }
}

