# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Tuple, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._question_answering_client_enums import *


class AnswerSpan(msrest.serialization.Model):
    """Answer span object of QnA.

    :ivar text: Predicted text of answer span.
    :vartype text: str
    :ivar confidence_score: Predicted score of answer span, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar offset: The answer span offset from the start of answer.
    :vartype offset: int
    :ivar length: The length of the answer span.
    :vartype length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword text: Predicted text of answer span.
        :paramtype text: str
        :keyword confidence_score: Predicted score of answer span, value ranges from 0 to 1.
        :paramtype confidence_score: float
        :keyword offset: The answer span offset from the start of answer.
        :paramtype offset: int
        :keyword length: The length of the answer span.
        :paramtype length: int
        """
        super(AnswerSpan, self).__init__(**kwargs)
        self.text = text
        self.confidence_score = confidence_score
        self.offset = offset
        self.length = length


class AnswerSpanRequest(msrest.serialization.Model):
    """To configure Answer span prediction feature.

    :ivar enable: Enable or disable Answer Span prediction.
    :vartype enable: bool
    :ivar confidence_score_threshold: Minimum threshold score required to include an answer span,
     value ranges from 0 to 1.
    :vartype confidence_score_threshold: float
    :ivar top_answers_with_span: Number of Top answers to be considered for span prediction from 1
     to 10.
    :vartype top_answers_with_span: int
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
        "top_answers_with_span": {"maximum": 10, "minimum": 1},
    }

    _attribute_map = {
        "enable": {"key": "enable", "type": "bool"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "top_answers_with_span": {"key": "topAnswersWithSpan", "type": "int"},
    }

    def __init__(
        self,
        *,
        enable: Optional[bool] = None,
        confidence_score_threshold: Optional[float] = None,
        top_answers_with_span: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword enable: Enable or disable Answer Span prediction.
        :paramtype enable: bool
        :keyword confidence_score_threshold: Minimum threshold score required to include an answer
         span, value ranges from 0 to 1.
        :paramtype confidence_score_threshold: float
        :keyword top_answers_with_span: Number of Top answers to be considered for span prediction from
         1 to 10.
        :paramtype top_answers_with_span: int
        """
        super(AnswerSpanRequest, self).__init__(**kwargs)
        self.enable = enable
        self.confidence_score_threshold = confidence_score_threshold
        self.top_answers_with_span = top_answers_with_span


class Error(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "TooManyRequests", "InternalServerError", "ServiceUnavailable".
    :vartype code: str or ~azure.ai.language.questionanswering.models.ErrorCode
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.questionanswering.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "ErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[List["Error"]] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
         "TooManyRequests", "InternalServerError", "ServiceUnavailable".
        :paramtype code: str or ~azure.ai.language.questionanswering.models.ErrorCode
        :keyword message: Required. A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.language.questionanswering.models.Error]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
        """
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.ai.language.questionanswering.models.Error
    """

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: Optional["Error"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.ai.language.questionanswering.models.Error
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class InnerErrorModel(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes. Possible values include:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
    :vartype code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
    :ivar message: Required. Error message.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes. Possible values include:
         "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
         "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure".
        :paramtype code: str or ~azure.ai.language.questionanswering.models.InnerErrorCode
        :keyword message: Required. Error message.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.language.questionanswering.models.InnerErrorModel
        """
        super(InnerErrorModel, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class KnowledgeBaseAnswer(msrest.serialization.Model):
    """Represents knowledge base answer.

    :ivar questions: List of questions.
    :vartype questions: list[str]
    :ivar answer: The Answer.
    :vartype answer: str
    :ivar confidence_score: Answer confidence score, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar id: ID of the QnA result.
    :vartype id: int
    :ivar source: Source of QnA result.
    :vartype source: str
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Dialog associated with Answer.
    :vartype dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
    :ivar answer_span: Answer span object of QnA with respect to user's question.
    :vartype answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "questions": {"key": "questions", "type": "[str]"},
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "int"},
        "source": {"key": "source", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "dialog": {"key": "dialog", "type": "KnowledgeBaseAnswerDialog"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
    }

    def __init__(
        self,
        *,
        questions: Optional[List[str]] = None,
        answer: Optional[str] = None,
        confidence_score: Optional[float] = None,
        id: Optional[int] = None,
        source: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        dialog: Optional["KnowledgeBaseAnswerDialog"] = None,
        answer_span: Optional["AnswerSpan"] = None,
        **kwargs
    ):
        """
        :keyword questions: List of questions.
        :paramtype questions: list[str]
        :keyword answer: The Answer.
        :paramtype answer: str
        :keyword confidence_score: Answer confidence score, value ranges from 0 to 1.
        :paramtype confidence_score: float
        :keyword id: ID of the QnA result.
        :paramtype id: int
        :keyword source: Source of QnA result.
        :paramtype source: str
        :keyword metadata: Metadata associated with the answer, useful to categorize or filter question
         answers.
        :paramtype metadata: dict[str, str]
        :keyword dialog: Dialog associated with Answer.
        :paramtype dialog: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerDialog
        :keyword answer_span: Answer span object of QnA with respect to user's question.
        :paramtype answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
        """
        super(KnowledgeBaseAnswer, self).__init__(**kwargs)
        self.questions = questions
        self.answer = answer
        self.confidence_score = confidence_score
        self.id = id
        self.source = source
        self.metadata = metadata
        self.dialog = dialog
        self.answer_span = answer_span


class KnowledgeBaseAnswerDialog(msrest.serialization.Model):
    """Dialog associated with Answer.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :vartype is_context_only: bool
    :ivar prompts: List of 0 to 20 prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
    """

    _validation = {
        "prompts": {"max_items": 20, "min_items": 0},
    }

    _attribute_map = {
        "is_context_only": {"key": "isContextOnly", "type": "bool"},
        "prompts": {"key": "prompts", "type": "[KnowledgeBaseAnswerPrompt]"},
    }

    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[List["KnowledgeBaseAnswerPrompt"]] = None,
        **kwargs
    ):
        """
        :keyword is_context_only: To mark if a prompt is relevant only with a previous question or not.
         If true, do not include this QnA as search result for queries without context; otherwise, if
         false, ignores context and includes this QnA in search result.
        :paramtype is_context_only: bool
        :keyword prompts: List of 0 to 20 prompts associated with the answer.
        :paramtype prompts: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerPrompt]
        """
        super(KnowledgeBaseAnswerDialog, self).__init__(**kwargs)
        self.is_context_only = is_context_only
        self.prompts = prompts


class KnowledgeBaseAnswerPrompt(msrest.serialization.Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt - used in ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: QnA ID corresponding to the prompt.
    :vartype qna_id: int
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    _validation = {
        "display_text": {"max_length": 200, "min_length": 0},
    }

    _attribute_map = {
        "display_order": {"key": "displayOrder", "type": "int"},
        "qna_id": {"key": "qnaId", "type": "int"},
        "display_text": {"key": "displayText", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        display_text: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_order: Index of the prompt - used in ordering of the prompts.
        :paramtype display_order: int
        :keyword qna_id: QnA ID corresponding to the prompt.
        :paramtype qna_id: int
        :keyword display_text: Text displayed to represent a follow up question prompt.
        :paramtype display_text: str
        """
        super(KnowledgeBaseAnswerPrompt, self).__init__(**kwargs)
        self.display_order = display_order
        self.qna_id = qna_id
        self.display_text = display_text


class KnowledgeBaseAnswerRequestContext(msrest.serialization.Model):
    """Context object with previous QnA's information.

    All required parameters must be populated in order to send to Azure.

    :ivar previous_qna_id: Required. Previous turn top answer result QnA ID.
    :vartype previous_qna_id: int
    :ivar previous_user_query: Previous user query.
    :vartype previous_user_query: str
    """

    _validation = {
        "previous_qna_id": {"required": True},
    }

    _attribute_map = {
        "previous_qna_id": {"key": "previousQnaId", "type": "int"},
        "previous_user_query": {"key": "previousUserQuery", "type": "str"},
    }

    def __init__(self, *, previous_qna_id: int, previous_user_query: Optional[str] = None, **kwargs):
        """
        :keyword previous_qna_id: Required. Previous turn top answer result QnA ID.
        :paramtype previous_qna_id: int
        :keyword previous_user_query: Previous user query.
        :paramtype previous_user_query: str
        """
        super(KnowledgeBaseAnswerRequestContext, self).__init__(**kwargs)
        self.previous_qna_id = previous_qna_id
        self.previous_user_query = previous_user_query


class KnowledgeBaseAnswers(msrest.serialization.Model):
    """Represents List of Question Answers.

    :ivar answers: Represents Answer Result list.
    :vartype answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[KnowledgeBaseAnswer]"},
    }

    def __init__(self, *, answers: Optional[List["KnowledgeBaseAnswer"]] = None, **kwargs):
        """
        :keyword answers: Represents Answer Result list.
        :paramtype answers: list[~azure.ai.language.questionanswering.models.KnowledgeBaseAnswer]
        """
        super(KnowledgeBaseAnswers, self).__init__(**kwargs)
        self.answers = answers


class MetadataFilter(msrest.serialization.Model):
    """Find QnAs that are associated with the given list of metadata.

    :ivar metadata:
    :vartype metadata: list[tuple[str]]
    :ivar logical_operation: Operation used to join metadata filters. Possible values include:
     "AND", "OR".
    :vartype logical_operation: str or
     ~azure.ai.language.questionanswering.models.LogicalOperationKind
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "[[str]]"},
        "logical_operation": {"key": "logicalOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[List[Tuple[str]]] = None,
        logical_operation: Optional[Union[str, "LogicalOperationKind"]] = None,
        **kwargs
    ):
        """
        :keyword metadata:
        :paramtype metadata: list[tuple[str]]
        :keyword logical_operation: Operation used to join metadata filters. Possible values include:
         "AND", "OR".
        :paramtype logical_operation: str or
         ~azure.ai.language.questionanswering.models.LogicalOperationKind
        """
        super(MetadataFilter, self).__init__(**kwargs)
        self.metadata = metadata
        self.logical_operation = logical_operation


class QueryFilters(msrest.serialization.Model):
    """filters over knowledge base.

    :ivar metadata_filter: Find QnAs that are associated with the given list of metadata.
    :vartype metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
    :ivar source_filter: Find QnAs that are associated with the given list of sources in knowledge
     base.
    :vartype source_filter: list[str]
    :ivar logical_operation: Logical operation used to join metadata filters with source filters.
     Possible values include: "AND", "OR".
    :vartype logical_operation: str or
     ~azure.ai.language.questionanswering.models.LogicalOperationKind
    """

    _attribute_map = {
        "metadata_filter": {"key": "metadataFilter", "type": "MetadataFilter"},
        "source_filter": {"key": "sourceFilter", "type": "[str]"},
        "logical_operation": {"key": "logicalOperation", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata_filter: Optional["MetadataFilter"] = None,
        source_filter: Optional[List[str]] = None,
        logical_operation: Optional[Union[str, "LogicalOperationKind"]] = None,
        **kwargs
    ):
        """
        :keyword metadata_filter: Find QnAs that are associated with the given list of metadata.
        :paramtype metadata_filter: ~azure.ai.language.questionanswering.models.MetadataFilter
        :keyword source_filter: Find QnAs that are associated with the given list of sources in
         knowledge base.
        :paramtype source_filter: list[str]
        :keyword logical_operation: Logical operation used to join metadata filters with source
         filters. Possible values include: "AND", "OR".
        :paramtype logical_operation: str or
         ~azure.ai.language.questionanswering.models.LogicalOperationKind
        """
        super(QueryFilters, self).__init__(**kwargs)
        self.metadata_filter = metadata_filter
        self.source_filter = source_filter
        self.logical_operation = logical_operation


class QueryKnowledgeBaseOptions(msrest.serialization.Model):
    """The question parameters to answer using a knowledge base.

    :ivar qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :vartype qna_id: int
    :ivar question: User question to query against the knowledge base.
    :vartype question: str
    :ivar top: Max number of answers to be returned for the question.
    :vartype top: int
    :ivar user_id: Unique identifier for the user.
    :vartype user_id: str
    :ivar confidence_score_threshold: Minimum threshold score for answers, value ranges from 0 to
     1.
    :vartype confidence_score_threshold: float
    :ivar context: Context object with previous QnA's information.
    :vartype context: ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerRequestContext
    :ivar ranker_type: (Optional) Set to 'QuestionOnly' for using a question only Ranker. Possible
     values include: "Default", "QuestionOnly".
    :vartype ranker_type: str or ~azure.ai.language.questionanswering.models.RankerType
    :ivar filters: Filter QnAs based on give metadata list and knowledge base source names.
    :vartype filters: ~azure.ai.language.questionanswering.models.QueryFilters
    :ivar answer_span_request: To configure Answer span prediction feature.
    :vartype answer_span_request: ~azure.ai.language.questionanswering.models.AnswerSpanRequest
    :ivar include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :vartype include_unstructured_sources: bool
    """

    _validation = {
        "confidence_score_threshold": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "qna_id": {"key": "qnaId", "type": "int"},
        "question": {"key": "question", "type": "str"},
        "top": {"key": "top", "type": "int"},
        "user_id": {"key": "userId", "type": "str"},
        "confidence_score_threshold": {"key": "confidenceScoreThreshold", "type": "float"},
        "context": {"key": "context", "type": "KnowledgeBaseAnswerRequestContext"},
        "ranker_type": {"key": "rankerType", "type": "str"},
        "filters": {"key": "filters", "type": "QueryFilters"},
        "answer_span_request": {"key": "answerSpanRequest", "type": "AnswerSpanRequest"},
        "include_unstructured_sources": {"key": "includeUnstructuredSources", "type": "bool"},
    }

    def __init__(
        self,
        *,
        qna_id: Optional[int] = None,
        question: Optional[str] = None,
        top: Optional[int] = None,
        user_id: Optional[str] = None,
        confidence_score_threshold: Optional[float] = None,
        context: Optional["KnowledgeBaseAnswerRequestContext"] = None,
        ranker_type: Optional[Union[str, "RankerType"]] = None,
        filters: Optional["QueryFilters"] = None,
        answer_span_request: Optional["AnswerSpanRequest"] = None,
        include_unstructured_sources: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
         question.
        :paramtype qna_id: int
        :keyword question: User question to query against the knowledge base.
        :paramtype question: str
        :keyword top: Max number of answers to be returned for the question.
        :paramtype top: int
        :keyword user_id: Unique identifier for the user.
        :paramtype user_id: str
        :keyword confidence_score_threshold: Minimum threshold score for answers, value ranges from 0
         to 1.
        :paramtype confidence_score_threshold: float
        :keyword context: Context object with previous QnA's information.
        :paramtype context:
         ~azure.ai.language.questionanswering.models.KnowledgeBaseAnswerRequestContext
        :keyword ranker_type: (Optional) Set to 'QuestionOnly' for using a question only Ranker.
         Possible values include: "Default", "QuestionOnly".
        :paramtype ranker_type: str or ~azure.ai.language.questionanswering.models.RankerType
        :keyword filters: Filter QnAs based on give metadata list and knowledge base source names.
        :paramtype filters: ~azure.ai.language.questionanswering.models.QueryFilters
        :keyword answer_span_request: To configure Answer span prediction feature.
        :paramtype answer_span_request: ~azure.ai.language.questionanswering.models.AnswerSpanRequest
        :keyword include_unstructured_sources: (Optional) Flag to enable Query over Unstructured
         Sources.
        :paramtype include_unstructured_sources: bool
        """
        super(QueryKnowledgeBaseOptions, self).__init__(**kwargs)
        self.qna_id = qna_id
        self.question = question
        self.top = top
        self.user_id = user_id
        self.confidence_score_threshold = confidence_score_threshold
        self.context = context
        self.ranker_type = ranker_type
        self.filters = filters
        self.answer_span_request = answer_span_request
        self.include_unstructured_sources = include_unstructured_sources


class QueryTextOptions(msrest.serialization.Model):
    """The question and text record parameters to answer.

    All required parameters must be populated in order to send to Azure.

    :ivar question: Required. User question to query against the given text records.
    :vartype question: str
    :ivar records: Required. Text records to be searched for given question.
    :vartype records: list[~azure.ai.language.questionanswering.models.TextRecord]
    :ivar language: Language of the text records. This is BCP-47 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        "question": {"required": True},
        "records": {"required": True},
    }

    _attribute_map = {
        "question": {"key": "question", "type": "str"},
        "records": {"key": "records", "type": "[TextRecord]"},
        "language": {"key": "language", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(self, *, question: str, records: List["TextRecord"], language: Optional[str] = None, **kwargs):
        """
        :keyword question: Required. User question to query against the given text records.
        :paramtype question: str
        :keyword records: Required. Text records to be searched for given question.
        :paramtype records: list[~azure.ai.language.questionanswering.models.TextRecord]
        :keyword language: Language of the text records. This is BCP-47 representation of a language.
         For example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super(QueryTextOptions, self).__init__(**kwargs)
        self.question = question
        self.records = records
        self.language = language
        self.string_index_type = "UnicodeCodePoint"


class TextAnswer(msrest.serialization.Model):
    """Represents answer result.

    :ivar answer: Answer.
    :vartype answer: str
    :ivar confidence_score: answer confidence score, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar id: record ID.
    :vartype id: str
    :ivar answer_span: Answer span object with respect to user's question.
    :vartype answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
    :ivar offset: The sentence offset from the start of the document.
    :vartype offset: int
    :ivar length: The length of the sentence.
    :vartype length: int
    """

    _validation = {
        "confidence_score": {"maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "answer": {"key": "answer", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "id": {"key": "id", "type": "str"},
        "answer_span": {"key": "answerSpan", "type": "AnswerSpan"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        answer: Optional[str] = None,
        confidence_score: Optional[float] = None,
        id: Optional[str] = None,
        answer_span: Optional["AnswerSpan"] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword answer: Answer.
        :paramtype answer: str
        :keyword confidence_score: answer confidence score, value ranges from 0 to 1.
        :paramtype confidence_score: float
        :keyword id: record ID.
        :paramtype id: str
        :keyword answer_span: Answer span object with respect to user's question.
        :paramtype answer_span: ~azure.ai.language.questionanswering.models.AnswerSpan
        :keyword offset: The sentence offset from the start of the document.
        :paramtype offset: int
        :keyword length: The length of the sentence.
        :paramtype length: int
        """
        super(TextAnswer, self).__init__(**kwargs)
        self.answer = answer
        self.confidence_score = confidence_score
        self.id = id
        self.answer_span = answer_span
        self.offset = offset
        self.length = length


class TextAnswers(msrest.serialization.Model):
    """Represents the answer results.

    :ivar answers: Represents the answer results.
    :vartype answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
    """

    _attribute_map = {
        "answers": {"key": "answers", "type": "[TextAnswer]"},
    }

    def __init__(self, *, answers: Optional[List["TextAnswer"]] = None, **kwargs):
        """
        :keyword answers: Represents the answer results.
        :paramtype answers: list[~azure.ai.language.questionanswering.models.TextAnswer]
        """
        super(TextAnswers, self).__init__(**kwargs)
        self.answers = answers


class TextRecord(msrest.serialization.Model):
    """Represent input text record to be queried.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Unique identifier for the text record.
    :vartype id: str
    :ivar text: Required. Text contents of the record.
    :vartype text: str
    """

    _validation = {
        "id": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, id: str, text: str, **kwargs):
        """
        :keyword id: Required. Unique identifier for the text record.
        :paramtype id: str
        :keyword text: Required. Text contents of the record.
        :paramtype text: str
        """
        super(TextRecord, self).__init__(**kwargs)
        self.id = id
        self.text = text
