# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sql2json', 'sql2json.parameter']

package_data = \
{'': ['*']}

install_requires = \
['SQLAlchemy>=1.3.12,<2.0.0',
 'fire>=0.2.1,<0.3.0',
 'python-dateutil>=2.8.1,<3.0.0']

setup_kwargs = {
    'name': 'sql2json',
    'version': '0.1.10',
    'description': 'Tool to run a SQL query a convert result to JSON',
    'long_description': '# Sql2json: sql2json is a tool to query a sql database and write result in JSON or CSV format in standard output or external file\n\nsql2json help you to automate repetitive tasks.\nFor example i need a cronjob to extract yesterday sales and sent it to geckoboard.\n\nThis tool is focused to use to automate command line apps or cron jobs to extract data from sql databases\n\n## Why sql2json if you can write to csv and excel file\nGood question. That was true until version 0.1.9. After some time i need to support csv files too, but i don\'t want to change the library name(sql2what or sqltowhat). Or create some new like sql2csv and sql2excel.\n\n## How install sql2json\n* **python3**: pip3 install sql2json\n\n## Default output format\nThe default output format is json.\n\n## Limitations\n- CSV works only with output file flag --output\n\n## sql2json config file\n\nsql2json by default use a config file located at USER_HOME/.sql2json/config.json\n\nconfig.json structure:\n\n```\n{\n    "conections": {\n        "default": "sqlite:///test.db",\n        "postgress": "postgresql://scott:tiger@localhost:5432/mydatabase",\n        "mysql": "mysql://scott:tiger@localhost/foo"\n    },\n    "queries": {\n        "default": "SELECT 1 AS a, 2 AS b",\n        "sales_month_since": "SELECT inv.month, SUM(inv.amount) AS sales FROM invoices inv WHERE inv.date >= :date_from ",\n        "total_sales_since": "SELECT SUM(inv.amount) AS sales FROM invoices inv WHERE inv.date >= :date_from ",\n        "long_query": "@FULL_PATH_TO_SQL_FILE",\n\t\t"json": "SELECT JSON_OBJECT(\'id\', 87, \'name\', \'carrot\') AS json",\n\t\t"jsonarray": "SELECT JSON_ARRAY(1, \'abc\', NULL, TRUE) AS jsonarray, JSON_OBJECT(\'id\', 87, \'name\', \'carrot\') AS jsonobject",\n        "operation_parameters": "@/Users/myusername/myproject/my-super-query.sql"\n    }\n}\n```\n\n## Use a config.json in a different path\n\nYou can use sql2json --config PATH_TO_YOUR_CONFIG_FILE\n\n## Available variables to do your life easy:\n- START_CURRENT_MONTH: Date the first day of current month\n- CURRENT_DATE: Current Date\n- END_CURRENT_MONTH: Date the last day of current month\n- START_CURRENT_YEAR: First day of current year\n- END_CURRENT_YEAR: First day of current year\n\n## Operations in variables\n- You can use + or - operator in your querys with variables CURRENT_DATE, START_CURRENT_MONTH, END_CURRENT_MONTH\n- +1, -1 in CURRENT_DATE mean +1 day, -1 day\n- +1, -1 in START_CURRENT_MONTH, END_CURRENT_MONTH mean +1 month, -1 month\n- +1, -1 in START_CURRENT_YEAR, END_CURRENT_YEAR mean +1 year, -1 year\n\n## Date formats to CURRENT_DATE, START_CURRENT_MONTH, END_CURRENT_MONTH, START_CURRENT_YEAR, END_CURRENT_YEAR\nYou can use date format supported by python datetime.strftime function, default is %Y-%m-%d\n\n## How to run queries using sql2json:\n\n### Run query sales_month in database conection mysql:\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1"\n\nOutput:\n\n```\n[\n    {\n        "month": "January",\n        "sales": 5000\n    },\n    {\n        "month": "February",\n        "sales": 3000\n    }\n]\n```\n\n### I don\'t wat an array, i want an object with an atribute with the results, useful to generate in format to post to geckoboard\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1" --wrapper\n\nOutput:\n\n```\n{\n    "data": [\n        {\n            "month": "January",\n            "sales": 5000\n        },\n        {\n            "month": "February",\n            "sales": 3000\n        }\n    ]\n}\n```\n\n### Run query sales_month in database conection mysql, use month as key, sales as value:\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1" --key month --value sales\n\nOutput:\n\n```\n[\n    {\n        "January": 5000\n    },\n    {\n        "sales": 3000\n    }\n]\n```\n\n### Run query sales_month in database conection mysql, get the unique row and only sales amount:\n\npython3 -m sql2json --name mysql --query total_sales_since --date_from "CURRENT_DATE-10" --first --key sales\n\nOutput: 500 or the amount of money you sold since 10 days ago\n\n### When i use sql2json with result of JSON functions i get escaped strings as value\n\nsql2json as a flag to allow you specify your JSON columns\n\npython3 -m sql2json --name mysql --query json --jsonkeys "json, jsonarray"\n\nResult:\n\n```\n[\n    {\n        "json": {\n            "id":  87,\n            "name", "carrot"\n        }\n        "jsonarray": [1, "abc", null, true],\n    }\n]\n```\n\nThis is only a row i want first row only, no array.\n\npython3 -m sql2json --name mysql --query json --jsonkeys "json, jsonarray" --first\n\nResult:\n\n```\n    {\n        "json": {\n            "id":  87,\n            "name", "carrot"\n        }\n        "jsonarray": [1, "abc", null, true],\n    }\n```\n\n### Run query in external sql file:\n\nquery "operation_parameters"\nPath "Users/myusername/myproject/my-super-query.sql"\n\nContent of my-super-query.sql:\n\n```\nSELECT p.name, p.age\nFROM persons p\nWHERE p.age > :min_age\nAND p.creation_date > :min_date\nORDER BY p.age DESC\nLIMIT 10\n```\n\nmin_age: 18\nmin_date: Today YYYY-MM-DD 00:00:00\n\npython3 -m sql2json --name mysql --query operation_parameters --min_age 18 --min_date CURRENT_DATE|%Y-%m-%d 00:00:00\n\nmin_age: 18\nmin_date: First day, current year YYYY-01-01 00:00:00\n\npython3 -m sql2json --name mysql --query operation_parameters --min_age 18 --min_date START_CURRENT_YEAR|%Y-%m-%d 00:00:00\n\n### Run external SQL query not defined in config file\n\npython3 -m sql2json --name mysql --query "@/Users/myusername/myproject/my-super-query.sql" --min_age 18 --min_date START_CURRENT_YEAR|%Y-%m-%d 00:00:00\n\n### Run custom query inline\n\nYou do\'t need to have all your queries in config file\n\npython3 -m sql2json --name mysql --query "SELECT NOW() AS date" --first --key date\n\n### Write data to a csv file\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1" --format=csv --output Sales\n\n```\nOutput:\nSales.csv\n```\n\n### Write data to an excel file\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1" --format=excel --output Sales\n\n```\nOutput:\nSales.xls\n```\n\n### Write data to a json file\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH-1" --format=json --output Sales\n\nOutput:\n```\nSales.json\n```\n\n### Write data to a file with custom filename using formula\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "START_CURRENT_MONTH" --format=csv --output Sales_{START_CURRENT_MONTH}_{CURRENT_DATE}\n\nOutput:\n```\nIf Current Date is "2020-05-24"\n\nSales_2020-05-01_2020-05-24.csv\n```\n\n\npython3 -m sql2json --name mysql --query sales_month_since --date_from "CURRENT_DATE" --format=csv --output sales/Sales_{CURRENT_DATE}\n\nOutput:\n```\nIf Current Date is "2020-05-24"\n\nFile Sales_2020-05-24.csv inside folder sales. sales/Sales_2020-05-24.csv\n```\n\n**IMPORTANT**: The sales folder is not created. You need to create it in your own.\n',
    'author': 'Francisco Perez',
    'author_email': 'fsistemas@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fsistemas/sql2json',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
