import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..models.exploits_api_v1_report_date_retrieve_response_200_action_required_item import (
    ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem,
)
from ..models.exploits_api_v1_report_date_retrieve_response_200_no_action_item import (
    ExploitsApiV1ReportDateRetrieveResponse200NoActionItem,
)
from ..models.exploits_api_v1_report_date_retrieve_response_200_not_relevant_item import (
    ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem,
)
from ..types import UNSET, Unset

T = TypeVar("T", bound="ExploitsApiV1ReportDateRetrieveResponse200")


@attr.s(auto_attribs=True)
class ExploitsApiV1ReportDateRetrieveResponse200:
    """ """

    action_required: Union[
        Unset, List[ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem]
    ] = UNSET
    cutoff_date: Union[Unset, str] = UNSET
    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    evaluated_cves: Union[Unset, int] = UNSET
    no_action: Union[
        Unset, List[ExploitsApiV1ReportDateRetrieveResponse200NoActionItem]
    ] = UNSET
    not_relevant: Union[
        Unset, List[ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem]
    ] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        action_required: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.action_required, Unset):
            action_required = []
            for action_required_item_data in self.action_required:
                action_required_item: Dict[str, Any] = UNSET
                if not isinstance(action_required_item_data, Unset):
                    action_required_item = action_required_item_data.to_dict()

                action_required.append(action_required_item)

        cutoff_date = self.cutoff_date
        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env
        evaluated_cves = self.evaluated_cves
        no_action: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.no_action, Unset):
            no_action = []
            for no_action_item_data in self.no_action:
                no_action_item: Dict[str, Any] = UNSET
                if not isinstance(no_action_item_data, Unset):
                    no_action_item = no_action_item_data.to_dict()

                no_action.append(no_action_item)

        not_relevant: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.not_relevant, Unset):
            not_relevant = []
            for not_relevant_item_data in self.not_relevant:
                not_relevant_item: Dict[str, Any] = UNSET
                if not isinstance(not_relevant_item_data, Unset):
                    not_relevant_item = not_relevant_item_data.to_dict()

                not_relevant.append(not_relevant_item)

        revision = self.revision
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if action_required is not UNSET:
            field_dict["action_required"] = action_required
        if cutoff_date is not UNSET:
            field_dict["cutoff_date"] = cutoff_date
        if dt is not UNSET:
            field_dict["dt"] = dt
        if env is not UNSET:
            field_dict["env"] = env
        if evaluated_cves is not UNSET:
            field_dict["evaluated_cves"] = evaluated_cves
        if no_action is not UNSET:
            field_dict["no_action"] = no_action
        if not_relevant is not UNSET:
            field_dict["not_relevant"] = not_relevant
        if revision is not UNSET:
            field_dict["revision"] = revision
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        action_required = []
        _action_required = d.pop("action_required", UNSET)
        if _action_required is UNSET:
            action_required = UNSET
        else:
            for action_required_item_data in _action_required or []:
                _action_required_item = action_required_item_data
                action_required_item: ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem
                if isinstance(_action_required_item, Unset):
                    action_required_item = UNSET
                else:
                    action_required_item = ExploitsApiV1ReportDateRetrieveResponse200ActionRequiredItem.from_dict(
                        _action_required_item
                    )

                action_required.append(action_required_item)

        cutoff_date = d.pop("cutoff_date", UNSET)

        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        evaluated_cves = d.pop("evaluated_cves", UNSET)

        no_action = []
        _no_action = d.pop("no_action", UNSET)
        if _no_action is UNSET:
            no_action = UNSET
        else:
            for no_action_item_data in _no_action or []:
                _no_action_item = no_action_item_data
                no_action_item: ExploitsApiV1ReportDateRetrieveResponse200NoActionItem
                if isinstance(_no_action_item, Unset):
                    no_action_item = UNSET
                else:
                    no_action_item = ExploitsApiV1ReportDateRetrieveResponse200NoActionItem.from_dict(
                        _no_action_item
                    )

                no_action.append(no_action_item)

        not_relevant = []
        _not_relevant = d.pop("not_relevant", UNSET)
        if _not_relevant is UNSET:
            not_relevant = UNSET
        else:
            for not_relevant_item_data in _not_relevant or []:
                _not_relevant_item = not_relevant_item_data
                not_relevant_item: ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem
                if isinstance(_not_relevant_item, Unset):
                    not_relevant_item = UNSET
                else:
                    not_relevant_item = ExploitsApiV1ReportDateRetrieveResponse200NotRelevantItem.from_dict(
                        _not_relevant_item
                    )

                not_relevant.append(not_relevant_item)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_report_date_retrieve_response_200 = cls(
            action_required=action_required,
            cutoff_date=cutoff_date,
            dt=dt,
            env=env,
            evaluated_cves=evaluated_cves,
            no_action=no_action,
            not_relevant=not_relevant,
            revision=revision,
            version=version,
        )

        exploits_api_v1_report_date_retrieve_response_200.additional_properties = d
        return exploits_api_v1_report_date_retrieve_response_200

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
