import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

import attr
from dateutil.parser import isoparse

from ..models.exploits_api_v1_cve_map_retrieve_response_200_cves import (
    ExploitsApiV1CveMapRetrieveResponse200Cves,
)
from ..types import UNSET, Unset

T = TypeVar("T", bound="ExploitsApiV1CveMapRetrieveResponse200")


@attr.s(auto_attribs=True)
class ExploitsApiV1CveMapRetrieveResponse200:
    """ """

    cves: Union[Unset, ExploitsApiV1CveMapRetrieveResponse200Cves] = UNSET
    dt: Union[Unset, datetime.datetime] = UNSET
    env: Union[Unset, str] = UNSET
    page_size: Union[Unset, int] = UNSET
    revision: Union[Unset, str] = UNSET
    version: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        cves: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.cves, Unset):
            cves = self.cves.to_dict()

        dt: Union[Unset, str] = UNSET
        if not isinstance(self.dt, Unset):
            dt = self.dt.isoformat()

        env = self.env
        page_size = self.page_size
        revision = self.revision
        version = self.version

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        if cves is not UNSET:
            field_dict["cves"] = cves
        if dt is not UNSET:
            field_dict["dt"] = dt
        if env is not UNSET:
            field_dict["env"] = env
        if page_size is not UNSET:
            field_dict["page_size"] = page_size
        if revision is not UNSET:
            field_dict["revision"] = revision
        if version is not UNSET:
            field_dict["version"] = version

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        _cves = d.pop("cves", UNSET)
        cves: Union[Unset, ExploitsApiV1CveMapRetrieveResponse200Cves]
        if isinstance(_cves, Unset):
            cves = UNSET
        else:
            cves = ExploitsApiV1CveMapRetrieveResponse200Cves.from_dict(_cves)

        _dt = d.pop("dt", UNSET)
        dt: Union[Unset, datetime.datetime]
        if isinstance(_dt, Unset):
            dt = UNSET
        else:
            dt = isoparse(_dt)

        env = d.pop("env", UNSET)

        page_size = d.pop("page_size", UNSET)

        revision = d.pop("revision", UNSET)

        version = d.pop("version", UNSET)

        exploits_api_v1_cve_map_retrieve_response_200 = cls(
            cves=cves,
            dt=dt,
            env=env,
            page_size=page_size,
            revision=revision,
            version=version,
        )

        exploits_api_v1_cve_map_retrieve_response_200.additional_properties = d
        return exploits_api_v1_cve_map_retrieve_response_200

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
