# RTT data generator

JSON-configurable data generator can execute external binaries to generate data (e.g., Sage scripts) in conjunction with
CryptoStreams binary (e.g., to generate inputs / plaintexts for external binaries).

## Template substitution

- `{{CRYPTOSTREAMS_BIN}}` [cryptostreams](https://github.com/ph4r05/eacirc-streams) generator binary path
- `{{PYTHON_BIN}}` Python3 binary path running RTT worker
- `{{SAGE_BIN}}` SageMath binary path (if installed, otherwise defaults to `sage`)
- `{{RTT_EXEC}}` /rtt_backend/rtt_execution directory
- `{{OFILE}}` corresponds to argument `--data-path` of rtt-data-gen
- `{{FILE_X}}` input file defined in the configuration file, `X` is sanitized upper-cased name. Usage: cryptostreams config used in `exec` as plaintext feeder.
- `{{CSFILE_X}}` input file generated by cryptostreams generator according to the config defined in `cstream_files`. Usage: pre-generate encryption keys 

## Input files

JSON entry `input_files` in the json config root enables to specify a temporary files that can be used in exec template string.

Example:

```json
{
  "input_files": {
    "CONFIG1.JSON": {
      "data": {
        "json_example_cfg": {"tmp": 1}
      }
    },
    "CONFIG2.BIN": {
      "data": "0102030405",
      "dtype": "hex"
    }
  }
}
```

Then `{{FILE_CONFIG1.JSON}}` is substituted for a path to a temporary file defined in the key `CONFIG1.JSON`. Data is serialized json.

Similarly, `{{FILE_CONFIG2.BIN}}` is substituted for a path to a temp file, which contains 0102030405 binary string.

## Cryptostreams files

Usage: pre-generate temporary files with cryptostreams, e.g., encryption keys.
For plaintext generators better use pipe in the exec template so no large temp file is created.

Example:

```json
{
  "cstream_files": {
    "CSFILE1": {
      "data": {
        "seed": "4464a22651888b31", 
        "stdout": true
      }
    }
  }
}
```

## Examples

- Generate simple plaintext template in counter mode, width 32 B per plaintext block
- Plaintext: `01 | ... | 00 00 01`
- Pipe plaintext to a python script processing it, outputs on stdout. 

```json
{
  "stream": {
    "type": "shell",
    "direct_file": false,
    "exec": "{{CRYPTOSTREAMS_BIN}} -c={{FILE_CONFIG1.JSON}} | {{PYTHON_BIN}} {{RTT_EXEC}}/scripts/flipper.py -k=00"
  },
  "input_files": {
    "CONFIG1.JSON": {
      "note": "plaintext-ctr",
      "data": {
        "notes": "",
        "seed": "4464a22651888b31",
        "tv-size": null,
        "tv-count": null,
        "tv_size": 32,
        "tv_count": 6250000,
        "stdout": true,
        "file_name": "plain_ctr.bin",
        "stream": {
          "type": "xor_stream",
          "source": {
            "type": "tuple_stream",
            "sources": [
              {
                "type": "counter",
                "output_size": 32
              },
              {
                "type": "single_value_stream",
                "output_size": 32,
                "source": {
                  "type": "tuple_stream",
                  "sources": [
                    {
                      "type": "false_stream",
                      "output_size": 31
                    },
                    {
                      "type": "const_stream",
                      "output_size": 1,
                      "value": "01"
                    }
                  ]
                }
              }
            ]
          }
        }
      }
    }
  }
}
```
