# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/07_markdown.obsidian.tags.ipynb.

# %% auto 0
__all__ = ['to_tag_str', 'tag_without_hashtag', 'tag_is_auto_tag', 'strip_auto_from_tag']

# %% ../../../nbs/07_markdown.obsidian.tags.ipynb 3
def to_tag_str(tag_name):
    return f'#{tag_name}'

# %% ../../../nbs/07_markdown.obsidian.tags.ipynb 4
def tag_without_hashtag(tag):
    return tag[1:] if tag.startswith('#') else tag

# %% ../../../nbs/07_markdown.obsidian.tags.ipynb 5
def tag_is_auto_tag(tag):
    tag = tag_without_hashtag(tag)
    return tag.startswith('_auto/')

# %% ../../../nbs/07_markdown.obsidian.tags.ipynb 6
def strip_auto_from_tag(tag, with_hash_tag: bool = True) -> str:
    """Returns the tag without the `'_auto/'` prefix.
    
    This will essentially return the same tag if the tag does not
    have the `'_auto/'` prefix to begin with.
    
    **Parameters**
    - tag - str
    - with_has_tag - bool
        - If `True`, returns a str with a hash tag `'#'` in front.
        Defaults to `True`.
    """
    tag = tag_without_hashtag(tag)
    tag = tag[6:] if tag.startswith('_auto/') else tag
    if with_hash_tag:
        return f'#{tag}'
    else:
        return tag
