# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../../../nbs/22_markdown.obsidian.personal.machine_learninig.database_update.ipynb.

# %% auto 0
__all__ = ['max_ID', 'append_to_database']

# %% ../../../../../nbs/22_markdown.obsidian.personal.machine_learninig.database_update.ipynb 3
# from bisect import bisect_left, bisect_right
# from os import PathLike
# from random import sample, choices
# import re
# from typing import Union

# # from fastai.text.all import *
# import pandas as pd

# from trouver.helper import latex_indices, find_regex_in_text, current_time_formatted_to_minutes
# from trouver.markdown.markdown.file import MarkdownFile
# from trouver.markdown.obsidian.footnotes import (
#     remove_footnote_mentions_in_markdown_text
# )
import os
from os import PathLike
from pathlib import Path
import shutil

import pandas as pd

from ..note_processing import process_standard_information_note
# TODO: import the rest

# %% ../../../../../nbs/22_markdown.obsidian.personal.machine_learninig.database_update.ipynb 5
def max_ID(df: pd.DataFrame):
    "Return the largest value of `ID` in `df`"
    return df['ID'].to_numpy().max()

# %% ../../../../../nbs/22_markdown.obsidian.personal.machine_learninig.database_update.ipynb 7
def append_to_database(
        file: PathLike, # The path to a csv file
        df_to_append: pd.DataFrame, # The DataFrame to append
        cols: list[str], # All columns of the dataframe in the order that they should be presented.
        pivot_column: str, # If there are multiple rows with the same entry in this column, then only a single row with that entry should remain and that row should be updated appropraitely.
        columns_to_update: list[str], # The columns that should be updated if there are multiple rows with the same entry in the column `pivot_column`.
        backup: bool = True # If `True`, makes a copy of `file` in the same directory and with the same name, except with an added extension of `.bak`.
        ) -> None:
    """
    Either create a `csv` file containing data or append to
    an existing `csv` file.

    The columns of the database file should contain:

    - `Time added` - The time when the row was added.
    - `Time modified` - The time when the labels of the row 
      was derived.

    All timestamps are in UTC time and specify time to minutes
    (i.e. no seconds/microseconds).

    If `df_to_append` contains a row with the same entry in `pivot_column` as 
    an existing row, then only a single row with the entry in `pivot_column`
    should remain and the reset of the row should be updated appropriately.

    """
    
    file = Path(file)
    if backup and os.path.exists(file):
        shutil.copyfile(file, str(file) + '.bak')

    df = pd.read_csv(file) if os.path.exists(file) else None
    if df is None:
        df = df_to_append
    else:
        # TODO: I am going to have to replace this line because df.append
        # is deprecated Use pandas.concat instead.
        df.append(df_to_append)
    df.reset_index(drop=True, inplace=True)
    aggregation_dict = {
        'Time added': 'first',
        'Time modified': 'last'}
    for column in columns_to_update:
        aggregation_dict[column] = 'last'
    df1 = df.groupby([pivot_column], as_index=False, sort=False).agg(
        aggregation_dict)
    df1 = df1[cols]
    df1.to_csv(file, index=False)



