# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/08_markdown.obsidian.footnotes.ipynb.

# %% auto 0
__all__ = ['find_footnote_descriptions_in_markdown_text', 'find_footnote_mentions_in_markdown_text',
           'remove_footnote_mentions_in_markdown_text', 'embedded_note_of_footnote', 'footnote_is_simple_embedded_note']

# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 2
import os
from pathlib import Path
import re
from trouver.helper import (
    find_regex_in_text, replace_string_by_indices
)
from trouver.markdown.obsidian.links import (
    ObsidianLink
)

from typing import Union

# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 8
def find_footnote_descriptions_in_markdown_text(
        text: str
        ) -> list[tuple]: # Each tuple is of the form `(a,b)` where `text[a:b]` is the full substring of a markdown footnote description.
    """
    Return ranges in the markdown text string where footnote descriptions occur.
    
    By footnote descriptions, I mean some of the form
    `[^label]: some description of the footnote`.
    
    **Returns**

    - list[tuple]
        - Each tuple is of the form `(a,b)` where `text[a:b]` is the full substring of a markdown footnote description.
    """
    return find_regex_in_text(text, pattern=r'\[\^.+?\]:.*')

# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 13
def find_footnote_mentions_in_markdown_text(
        text: str
        ) -> list[tuple]: # Each tuple is of the form `(a,b)` where `text[a:b]` is a markdown footnote description.
    """Return ranges in the markdown text string where footnote
    mentions occur.
    
    By footnote mentions, I mean some of the form `[^label]` without
    any descriptions.
    
    **Returns**

    - list[tuple]
        - Each tuple is of the form `(a,b)` where `text[a:b]`
        is a markdown footnote description.
    """
    return find_regex_in_text(text, pattern=r'\[\^[^\[\]]+?\](?!:)')

# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 16
def remove_footnote_mentions_in_markdown_text(
        text: str
        ) -> str:
    """
    Remove all footnote mentions from `text`.
    """
    footnote_indices = find_footnote_mentions_in_markdown_text(text)
    return replace_string_by_indices(text, footnote_indices, ['']*len(footnote_indices))

# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 19
def embedded_note_of_footnote(
        footnote: str # The full footnote description. May start and end with `'\n'` and other whitespace characters
        ) -> Union[str, None]: # The name of the note of the footnote, if applicable. `None` otherwise.
    """
    Return the name of the note that the footnote description embeds
    assuming that the footnote only embeds a note.
    """
    footnote = footnote.strip()
    generic_embedded_link = ObsidianLink(True, -1, -1, -1)
    # print(generic_embedded_link.to_regex())
    match = re.fullmatch(fr'\[\^.+?\]: ?{generic_embedded_link.to_regex()}', footnote)
    if not match:
        return None
    else:
        return match.group(1)


# %% ../../../nbs/08_markdown.obsidian.footnotes.ipynb 21
def footnote_is_simple_embedded_note(
        footnote: str # The full footnote description. May start and end with `'\n'` and other whitespace characters.
        ) -> bool:
    """
    Return `True` if the footnote description is that of a simple embedded note.
    """
    return bool(embedded_note_of_footnote(footnote))
