# mypy-boto3-wafv2

[![PyPI - mypy-boto3-wafv2](https://img.shields.io/pypi/v/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WAFV2 1.16.1](https://boto3.amazonaws.com/v1/documentation/api/1.16.1/reference/services/wafv2.html#WAFV2) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-wafv2](#mypy-boto3-wafv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `WAFV2` service.

```bash
python -m pip install boto3-stubs[wafv2]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`
- Run `mypy` as usual

Type checking should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[wafv2]` in your environment: `python -m pip install 'boto3-stubs[wafv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WAFV2` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`WAFV2Client` provides annotations for `boto3.client("wafv2")`.

```python
import boto3

from mypy_boto3_wafv2 import WAFV2Client

client: WAFV2Client = boto3.client("wafv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WAFV2Client = session.client("wafv2")
```








### Typed dictionations

`mypy_boto3_wafv2.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_wafv2.type_defs import (
    AndStatementTypeDef,
    ByteMatchStatementTypeDef,
    CheckCapacityResponseTypeDef,
    CreateIPSetResponseTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    CreateRuleGroupResponseTypeDef,
    CreateWebACLResponseTypeDef,
    DefaultActionTypeDef,
    DeleteFirewallManagerRuleGroupsResponseTypeDef,
    DescribeManagedRuleGroupResponseTypeDef,
    ExcludedRuleTypeDef,
    FieldToMatchTypeDef,
    FirewallManagerRuleGroupTypeDef,
    FirewallManagerStatementTypeDef,
    ForwardedIPConfigTypeDef,
    GeoMatchStatementTypeDef,
    GetIPSetResponseTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedStatementManagedKeysResponseTypeDef,
    GetRegexPatternSetResponseTypeDef,
    GetRuleGroupResponseTypeDef,
    GetSampledRequestsResponseTypeDef,
    GetWebACLForResourceResponseTypeDef,
    GetWebACLResponseTypeDef,
    HTTPHeaderTypeDef,
    HTTPRequestTypeDef,
    IPSetForwardedIPConfigTypeDef,
    IPSetReferenceStatementTypeDef,
    IPSetSummaryTypeDef,
    IPSetTypeDef,
    ListAvailableManagedRuleGroupsResponseTypeDef,
    ListIPSetsResponseTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListResourcesForWebACLResponseTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebACLsResponseTypeDef,
    LoggingConfigurationTypeDef,
    ManagedRuleGroupStatementTypeDef,
    ManagedRuleGroupSummaryTypeDef,
    NotStatementTypeDef,
    OrStatementTypeDef,
    OverrideActionTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    RateBasedStatementManagedKeysIPSetTypeDef,
    RateBasedStatementTypeDef,
    RegexPatternSetReferenceStatementTypeDef,
    RegexPatternSetSummaryTypeDef,
    RegexPatternSetTypeDef,
    RegexTypeDef,
    RuleActionTypeDef,
    RuleGroupReferenceStatementTypeDef,
    RuleGroupSummaryTypeDef,
    RuleGroupTypeDef,
    RuleSummaryTypeDef,
    RuleTypeDef,
    SampledHTTPRequestTypeDef,
    SingleHeaderTypeDef,
    SingleQueryArgumentTypeDef,
    SizeConstraintStatementTypeDef,
    SqliMatchStatementTypeDef,
    StatementTypeDef,
    TagInfoForResourceTypeDef,
    TagTypeDef,
    TextTransformationTypeDef,
    TimeWindowTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateWebACLResponseTypeDef,
    VisibilityConfigTypeDef,
    WebACLSummaryTypeDef,
    WebACLTypeDef,
    XssMatchStatementTypeDef,
)

def get_structure() -> AndStatementTypeDef:
    return {
      ...
    }
```
