# Copyright 2020 The Merlin Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from merlin.util import valid_name_check, get_bucket_name, get_gcs_path
import pytest

import merlin.util as utils

@pytest.mark.unit
def test_name_check():
    invalid_names = [
        'test-name,', 'test,name', 'test.name'
        ]

    valid_names = [
        'test-name', 'testname'
    ]

    for name in invalid_names:
        result = valid_name_check(name)
        assert result == False
    for name in valid_names:
        result = valid_name_check(name)
        assert result == True

@pytest.mark.unit
def test_get_bucket_name():
    gcs_uri = 'gs://some-bucket/mlflow/81/ddd'
    assert get_bucket_name(gcs_uri) == 'some-bucket'


@pytest.mark.unit
def test_get_gcs_path():
    gcs_uri = 'gs://some-bucket/mlflow/81/ddd'
    assert get_gcs_path(gcs_uri) == 'mlflow/81/ddd'

    double_slash_uri_path = 'gs://some-bucket//mlflow/81/ddd'
    assert get_gcs_path(double_slash_uri_path) == 'mlflow/81/ddd'