from .affine_transform import AffineTransform
from .annotation import Annotation
from .annotation_ref import AnnotationRef
from .arc import Arc
from .basic_annotation import BasicAnnotation
from .bin_data import BinData
from .binary_file import BinaryFile
from .boolean_annotation import BooleanAnnotation
from .channel import Channel
from .channel_ref import ChannelRef
from .comment_annotation import CommentAnnotation
from .dataset import Dataset
from .dataset_ref import DatasetRef
from .detector import Detector
from .detector_settings import DetectorSettings
from .dichroic import Dichroic
from .dichroic_ref import DichroicRef
from .double_annotation import DoubleAnnotation
from .ellipse import Ellipse
from .experiment import Experiment
from .experiment_ref import ExperimentRef
from .experimenter import Experimenter
from .experimenter_group import ExperimenterGroup
from .experimenter_group_ref import ExperimenterGroupRef
from .experimenter_ref import ExperimenterRef
from .external import External
from .filament import Filament
from .file_annotation import FileAnnotation
from .filter import Filter
from .filter_ref import FilterRef
from .filter_set import FilterSet
from .filter_set_ref import FilterSetRef
from .folder import Folder
from .folder_ref import FolderRef
from .generic_excitation_source import GenericExcitationSource
from .image import Image
from .image_ref import ImageRef
from .imaging_environment import ImagingEnvironment
from .instrument import Instrument
from .instrument_ref import InstrumentRef
from .label import Label
from .laser import Laser
from .leader import Leader
from .light_emitting_diode import LightEmittingDiode
from .light_path import LightPath
from .light_source import LightSource
from .light_source_group import LightSourceGroup
from .light_source_settings import LightSourceSettings
from .line import Line
from .list_annotation import ListAnnotation
from .long_annotation import LongAnnotation
from .manufacturer_spec import ManufacturerSpec
from .map import Map
from .map_annotation import MapAnnotation
from .mask import Mask
from .microbeam_manipulation import MicrobeamManipulation
from .microbeam_manipulation_ref import MicrobeamManipulationRef
from .microscope import Microscope
from .numeric_annotation import NumericAnnotation
from .objective import Objective
from .objective_settings import ObjectiveSettings
from .ome import OME
from .pixels import Pixels
from .plane import Plane
from .plate import Plate
from .plate_acquisition import PlateAcquisition
from .point import Point
from .polygon import Polygon
from .polyline import Polyline
from .project import Project
from .project_ref import ProjectRef
from .pump import Pump
from .reagent import Reagent
from .reagent_ref import ReagentRef
from .rectangle import Rectangle
from .reference import Reference
from .rights import Rights
from .roi import ROI
from .roi_ref import ROIRef
from .screen import Screen
from .settings import Settings
from .shape import Shape
from .shape_group import ShapeGroup
from .stage_label import StageLabel
from .structured_annotations import StructuredAnnotations
from .tag_annotation import TagAnnotation
from .term_annotation import TermAnnotation
from .text_annotation import TextAnnotation
from .tiff_data import TiffData
from .timestamp_annotation import TimestampAnnotation
from .transmittance_range import TransmittanceRange
from .type_annotation import TypeAnnotation
from .well import Well
from .well_sample import WellSample
from .well_sample_ref import WellSampleRef
from .xml_annotation import XMLAnnotation


__all__ = [
    "AffineTransform",
    "Annotation",
    "AnnotationRef",
    "Arc",
    "BasicAnnotation",
    "BinData",
    "BinaryFile",
    "BooleanAnnotation",
    "Channel",
    "ChannelRef",
    "CommentAnnotation",
    "Dataset",
    "DatasetRef",
    "Detector",
    "DetectorSettings",
    "Dichroic",
    "DichroicRef",
    "DoubleAnnotation",
    "Ellipse",
    "Experiment",
    "ExperimentRef",
    "Experimenter",
    "ExperimenterGroup",
    "ExperimenterGroupRef",
    "ExperimenterRef",
    "External",
    "Filament",
    "FileAnnotation",
    "Filter",
    "FilterRef",
    "FilterSet",
    "FilterSetRef",
    "Folder",
    "FolderRef",
    "GenericExcitationSource",
    "Image",
    "ImageRef",
    "ImagingEnvironment",
    "Instrument",
    "InstrumentRef",
    "Label",
    "Laser",
    "Leader",
    "LightEmittingDiode",
    "LightPath",
    "LightSource",
    "LightSourceGroup",
    "LightSourceSettings",
    "Line",
    "ListAnnotation",
    "LongAnnotation",
    "ManufacturerSpec",
    "Map",
    "MapAnnotation",
    "Mask",
    "MicrobeamManipulation",
    "MicrobeamManipulationRef",
    "Microscope",
    "NumericAnnotation",
    "OME",
    "Objective",
    "ObjectiveSettings",
    "Pixels",
    "Plane",
    "Plate",
    "PlateAcquisition",
    "Point",
    "Polygon",
    "Polyline",
    "Project",
    "ProjectRef",
    "Pump",
    "ROI",
    "ROIRef",
    "Reagent",
    "ReagentRef",
    "Rectangle",
    "Reference",
    "Rights",
    "Screen",
    "Settings",
    "Shape",
    "ShapeGroup",
    "StageLabel",
    "StructuredAnnotations",
    "TagAnnotation",
    "TermAnnotation",
    "TextAnnotation",
    "TiffData",
    "TimestampAnnotation",
    "TransmittanceRange",
    "TypeAnnotation",
    "Well",
    "WellSample",
    "WellSampleRef",
    "XMLAnnotation",
]

_singular_to_plural = {
    ("Experiment", "microbeam_manipulation"): "microbeam_manipulations",
    ("Instrument", "detector"): "detectors",
    ("Instrument", "dichroic"): "dichroics",
    ("Instrument", "filter"): "filters",
    ("Instrument", "filter_set"): "filter_sets",
    ("Instrument", "objective"): "objectives",
    ("OME", "dataset"): "datasets",
    ("OME", "experiment"): "experiments",
    ("OME", "experimenter"): "experimenters",
    ("OME", "experimenter_group"): "experimenter_groups",
    ("OME", "folder"): "folders",
    ("OME", "image"): "images",
    ("OME", "instrument"): "instruments",
    ("OME", "plate"): "plates",
    ("OME", "project"): "projects",
    ("OME", "roi"): "rois",
    ("OME", "screen"): "screens",
    ("Pixels", "channel"): "channels",
    ("Pixels", "plane"): "planes",
    ("Pixels", "tiff_data"): "tiff_data_blocks",
    ("Plate", "plate_acquisition"): "plate_acquisitions",
    ("Plate", "well"): "wells",
    ("Screen", "reagent"): "reagents",
    ("StructuredAnnotations", "boolean_annotation"): "boolean_annotations",
    ("StructuredAnnotations", "comment_annotation"): "comment_annotations",
    ("StructuredAnnotations", "double_annotation"): "double_annotations",
    ("StructuredAnnotations", "file_annotation"): "file_annotations",
    ("StructuredAnnotations", "list_annotation"): "list_annotations",
    ("StructuredAnnotations", "long_annotation"): "long_annotations",
    ("StructuredAnnotations", "map_annotation"): "map_annotations",
    ("StructuredAnnotations", "tag_annotation"): "tag_annotations",
    ("StructuredAnnotations", "term_annotation"): "term_annotations",
    ("StructuredAnnotations", "timestamp_annotation"): "timestamp_annotations",
    ("StructuredAnnotations", "xml_annotation"): "xml_annotations",
    ("Well", "well_sample"): "well_samples",
}

_plural_to_singular = {
    "microbeam_manipulations": "microbeam_manipulation",
    "detectors": "detector",
    "dichroics": "dichroic",
    "filters": "filter",
    "filter_sets": "filter_set",
    "objectives": "objective",
    "datasets": "dataset",
    "experiments": "experiment",
    "experimenters": "experimenter",
    "experimenter_groups": "experimenter_group",
    "folders": "folder",
    "images": "image",
    "instruments": "instrument",
    "plates": "plate",
    "projects": "project",
    "rois": "roi",
    "screens": "screen",
    "channels": "channel",
    "planes": "plane",
    "tiff_data_blocks": "tiff_data",
    "plate_acquisitions": "plate_acquisition",
    "wells": "well",
    "reagents": "reagent",
    "boolean_annotations": "boolean_annotation",
    "comment_annotations": "comment_annotation",
    "double_annotations": "double_annotation",
    "file_annotations": "file_annotation",
    "list_annotations": "list_annotation",
    "long_annotations": "long_annotation",
    "map_annotations": "map_annotation",
    "tag_annotations": "tag_annotation",
    "term_annotations": "term_annotation",
    "timestamp_annotations": "timestamp_annotation",
    "xml_annotations": "xml_annotation",
    "well_samples": "well_sample",
}

_camel_to_snake = {
    "A00": "a00",
    "A01": "a01",
    "A02": "a02",
    "A10": "a10",
    "A11": "a11",
    "A12": "a12",
    "APD": "apd",
    "Achro": "achro",
    "Achromat": "achromat",
    "AcquisitionDate": "acquisition_date",
    "AcquisitionMode": "acquisition_mode",
    "AffineTransform": "affine_transform",
    "Ag": "ag",
    "Air": "air",
    "AirPressure": "air_pressure",
    "AirPressureUnit": "air_pressure_unit",
    "Alexandrite": "alexandrite",
    "AmplificationGain": "amplification_gain",
    "AnalogVideo": "analog_video",
    "Annotation": "annotation",
    "AnnotationRef": "annotation_ref",
    "Annotator": "annotator",
    "Apo": "apo",
    "Ar": "ar",
    "ArCl": "ar_cl",
    "ArFl": "ar_fl",
    "Arc": "arc",
    "Arrow": "arrow",
    "Attenuation": "attenuation",
    "BandPass": "band_pass",
    "BasicAnnotation": "basic_annotation",
    "BigEndian": "big_endian",
    "BinData": "bin_data",
    "BinaryFile": "binary_file",
    "BinaryOnly": "binary_only",
    "Binning": "binning",
    "Bold": "bold",
    "BoldItalic": "bold_italic",
    "BooleanAnnotation": "boolean_annotation",
    "BooleanAnnotations": "boolean_annotations",
    "BrightField": "bright_field",
    "Brightfield": "brightfield",
    "CCD": "ccd",
    "CMOS": "cmos",
    "CO": "co",
    "CO2": "co2",
    "CO2Percent": "co2_percent",
    "CW": "cw",
    "CalibratedMagnification": "calibrated_magnification",
    "Channel": "channel",
    "ChannelRef": "channel_ref",
    "Channels": "channels",
    "Colocalization": "colocalization",
    "Color": "color",
    "Column": "column",
    "ColumnNamingConvention": "column_naming_convention",
    "Columns": "columns",
    "CommentAnnotation": "comment_annotation",
    "CommentAnnotations": "comment_annotations",
    "Compression": "compression",
    "ContrastMethod": "contrast_method",
    "Correction": "correction",
    "CorrectionCollar": "correction_collar",
    "CorrelationSpectroscopy": "correlation_spectroscopy",
    "CoumarinC30": "coumarin_c30",
    "Creator": "creator",
    "Cu": "cu",
    "CutIn": "cut_in",
    "CutInTolerance": "cut_in_tolerance",
    "CutInToleranceUnit": "cut_in_tolerance_unit",
    "CutInUnit": "cut_in_unit",
    "CutOut": "cut_out",
    "CutOutTolerance": "cut_out_tolerance",
    "CutOutToleranceUnit": "cut_out_tolerance_unit",
    "CutOutUnit": "cut_out_unit",
    "DIC": "dic",
    "Darkfield": "darkfield",
    "Dataset": "dataset",
    "DatasetRef": "dataset_ref",
    "Datasets": "datasets",
    "DeltaT": "delta_t",
    "DeltaTUnit": "delta_t_unit",
    "Description": "description",
    "Detector": "detector",
    "DetectorSettings": "detector_settings",
    "Detectors": "detectors",
    "Dichroic": "dichroic",
    "DichroicRef": "dichroic_ref",
    "Dichroics": "dichroics",
    "DimensionOrder": "dimension_order",
    "Dissection": "dissection",
    "DoubleAnnotation": "double_annotation",
    "DoubleAnnotations": "double_annotations",
    "Dye": "dye",
    "EBCCD": "ebccd",
    "EMCCD": "emccd",
    "EMinus": "e_minus",
    "Electrophysiology": "electrophysiology",
    "Ellipse": "ellipse",
    "Email": "email",
    "EmissionFilterRef": "emission_filter_ref",
    "EmissionWavelength": "emission_wavelength",
    "EmissionWavelengthUnit": "emission_wavelength_unit",
    "EndTime": "end_time",
    "Epifluorescence": "epifluorescence",
    "ErGlass": "er_glass",
    "ErYAG": "er_yag",
    "EvenOdd": "even_odd",
    "Excimer": "excimer",
    "ExcitationFilterRef": "excitation_filter_ref",
    "ExcitationWavelength": "excitation_wavelength",
    "ExcitationWavelengthUnit": "excitation_wavelength_unit",
    "Experiment": "experiment",
    "ExperimentRef": "experiment_ref",
    "Experimenter": "experimenter",
    "ExperimenterGroup": "experimenter_group",
    "ExperimenterGroupRef": "experimenter_group_ref",
    "ExperimenterGroups": "experimenter_groups",
    "ExperimenterRef": "experimenter_ref",
    "Experimenters": "experimenters",
    "Experiments": "experiments",
    "ExposureTime": "exposure_time",
    "ExposureTimeUnit": "exposure_time_unit",
    "External": "external",
    "ExternalDescription": "external_description",
    "ExternalIdentifier": "external_identifier",
    "FISH": "fish",
    "FLIP": "flip",
    "FP": "fp",
    "FRAP": "frap",
    "FRET": "fret",
    "FSM": "fsm",
    "FTIR": "ftir",
    "FieldIndex": "field_index",
    "Filament": "filament",
    "FileAnnotation": "file_annotation",
    "FileAnnotations": "file_annotations",
    "FileName": "file_name",
    "FillColor": "fill_color",
    "FillRule": "fill_rule",
    "Filter": "filter",
    "FilterRef": "filter_ref",
    "FilterSet": "filter_set",
    "FilterSetRef": "filter_set_ref",
    "FilterSets": "filter_sets",
    "FilterWheel": "filter_wheel",
    "Filters": "filters",
    "FirstC": "first_c",
    "FirstName": "first_name",
    "FirstT": "first_t",
    "FirstZ": "first_z",
    "Fl": "fl",
    "Fluar": "fluar",
    "Fluor": "fluor",
    "Fluorescence": "fluorescence",
    "FluorescenceCorrelationSpectroscopy": "fluorescence_correlation_spectroscopy",
    "FluorescenceLifetime": "fluorescence_lifetime",
    "Fluotar": "fluotar",
    "Folder": "folder",
    "FolderRef": "folder_ref",
    "Folders": "folders",
    "FontFamily": "font_family",
    "FontSize": "font_size",
    "FontSizeUnit": "font_size_unit",
    "FontStyle": "font_style",
    "FourDPlus": "four_d_plus",
    "FreeElectron": "free_electron",
    "FrequencyMultiplication": "frequency_multiplication",
    "GaAlAs": "ga_al_as",
    "GaAs": "ga_as",
    "Gain": "gain",
    "Gas": "gas",
    "GenericExcitationSource": "generic_excitation_source",
    "Glycerol": "glycerol",
    "H2O": "h2_o",
    "HFl": "h_fl",
    "Halogen": "halogen",
    "HashSHA1": "hash_sha1",
    "HeCd": "he_cd",
    "HeNe": "he_ne",
    "Height": "height",
    "Hg": "hg",
    "HgXe": "hg_xe",
    "HoYAG": "ho_yag",
    "HoYLF": "ho_ylf",
    "HoffmanModulation": "hoffman_modulation",
    "Humidity": "humidity",
    "ID": "id",
    "IFD": "ifd",
    "IlluminationType": "illumination_type",
    "Image": "image",
    "ImageRef": "image_ref",
    "Images": "images",
    "ImagingEnvironment": "imaging_environment",
    "Immersion": "immersion",
    "Immunocytochemistry": "immunocytochemistry",
    "Immunofluorescence": "immunofluorescence",
    "Incandescent": "incandescent",
    "Index": "index",
    "Institution": "institution",
    "Instrument": "instrument",
    "InstrumentRef": "instrument_ref",
    "Instruments": "instruments",
    "Integration": "integration",
    "IntensifiedCCD": "intensified_ccd",
    "Interleaved": "interleaved",
    "InverseFRAP": "inverse_frap",
    "Inverted": "inverted",
    "IonImaging": "ion_imaging",
    "Iris": "iris",
    "Italic": "italic",
    "K": "k",
    "Kr": "kr",
    "KrCl": "kr_cl",
    "KrFl": "kr_fl",
    "LCM": "lcm",
    "Label": "label",
    "Laser": "laser",
    "LaserMedium": "laser_medium",
    "LaserScanningConfocalMicroscopy": "laser_scanning_confocal_microscopy",
    "LastName": "last_name",
    "Leader": "leader",
    "Length": "length",
    "LensNA": "lens_na",
    "LifetimeImaging": "lifetime_imaging",
    "LightEmittingDiode": "light_emitting_diode",
    "LightPath": "light_path",
    "LightSource": "light_source",
    "LightSourceGroup": "light_source_group",
    "LightSourceSettings": "light_source_settings",
    "Line": "line",
    "ListAnnotation": "list_annotation",
    "ListAnnotations": "list_annotations",
    "Locked": "locked",
    "LongAnnotation": "long_annotation",
    "LongAnnotations": "long_annotations",
    "LongPass": "long_pass",
    "LotNumber": "lot_number",
    "M": "m",
    "MIMEType": "mime_type",
    "Manufacturer": "manufacturer",
    "ManufacturerSpec": "manufacturer_spec",
    "Map": "map",
    "MapAnnotation": "map_annotation",
    "MapAnnotations": "map_annotations",
    "MarkerEnd": "marker_end",
    "MarkerStart": "marker_start",
    "Mask": "mask",
    "MaximumFieldCount": "maximum_field_count",
    "Medium": "medium",
    "MetadataFile": "metadata_file",
    "MetadataOnly": "metadata_only",
    "MetalVapor": "metal_vapor",
    "MicrobeamManipulation": "microbeam_manipulation",
    "MicrobeamManipulationRef": "microbeam_manipulation_ref",
    "MicrobeamManipulations": "microbeam_manipulations",
    "Microscope": "microscope",
    "MiddleName": "middle_name",
    "ModeLocked": "mode_locked",
    "Model": "model",
    "Multi": "multi",
    "MultiPass": "multi_pass",
    "MultiPhotonMicroscopy": "multi_photon_microscopy",
    "N": "n",
    "NDFilter": "nd_filter",
    "Name": "name",
    "Namespace": "namespace",
    "NdGlass": "nd_glass",
    "NdYAG": "nd_yag",
    "NearFieldScanningOpticalMicroscopy": "near_field_scanning_optical_microscopy",
    "Neofluar": "neofluar",
    "NeutralDensity": "neutral_density",
    "NominalMagnification": "nominal_magnification",
    "NonLinear": "non_linear",
    "NonZero": "non_zero",
    "Normal": "normal",
    "NumericAnnotation": "numeric_annotation",
    "OME": "ome",
    "Objective": "objective",
    "ObjectiveSettings": "objective_settings",
    "Objectives": "objectives",
    "Oblique": "oblique",
    "ObliqueIllumination": "oblique_illumination",
    "Offset": "offset",
    "Oil": "oil",
    "OpticalTrapping": "optical_trapping",
    "Other": "other",
    "PALM": "palm",
    "PGIDocumentation": "pgi_documentation",
    "PMT": "pmt",
    "Phase": "phase",
    "Photoablation": "photoablation",
    "Photoactivation": "photoactivation",
    "Photobleaching": "photobleaching",
    "Photodiode": "photodiode",
    "PhysicalSizeX": "physical_size_x",
    "PhysicalSizeXUnit": "physical_size_x_unit",
    "PhysicalSizeY": "physical_size_y",
    "PhysicalSizeYUnit": "physical_size_y_unit",
    "PhysicalSizeZ": "physical_size_z",
    "PhysicalSizeZUnit": "physical_size_z_unit",
    "PinholeSize": "pinhole_size",
    "PinholeSizeUnit": "pinhole_size_unit",
    "Pixels": "pixels",
    "PlanApo": "plan_apo",
    "PlanFluor": "plan_fluor",
    "PlanNeofluar": "plan_neofluar",
    "Plane": "plane",
    "PlaneCount": "plane_count",
    "Planes": "planes",
    "Plate": "plate",
    "PlateAcquisition": "plate_acquisition",
    "PlateAcquisitions": "plate_acquisitions",
    "PlateRef": "plate_ref",
    "Plates": "plates",
    "PockelCell": "pockel_cell",
    "PockelCellSetting": "pockel_cell_setting",
    "Point": "point",
    "Points": "points",
    "PolarizedLight": "polarized_light",
    "Polygon": "polygon",
    "Polyline": "polyline",
    "PositionX": "position_x",
    "PositionXUnit": "position_x_unit",
    "PositionY": "position_y",
    "PositionYUnit": "position_y_unit",
    "PositionZ": "position_z",
    "PositionZUnit": "position_z_unit",
    "Power": "power",
    "PowerUnit": "power_unit",
    "Project": "project",
    "ProjectRef": "project_ref",
    "Projects": "projects",
    "ProtocolDescription": "protocol_description",
    "ProtocolIdentifier": "protocol_identifier",
    "Pulse": "pulse",
    "Pump": "pump",
    "QSwitched": "q_switched",
    "ROI": "roi",
    "ROIRef": "roi_ref",
    "ROIs": "rois",
    "RadiusX": "radius_x",
    "RadiusY": "radius_y",
    "ReadOutRate": "read_out_rate",
    "ReadOutRateUnit": "read_out_rate_unit",
    "Reagent": "reagent",
    "ReagentIdentifier": "reagent_identifier",
    "ReagentRef": "reagent_ref",
    "ReagentSetDescription": "reagent_set_description",
    "ReagentSetIdentifier": "reagent_set_identifier",
    "Reagents": "reagents",
    "Rectangle": "rectangle",
    "Reference": "reference",
    "RefractiveIndex": "refractive_index",
    "RepetitionRate": "repetition_rate",
    "RepetitionRateUnit": "repetition_rate_unit",
    "Repetitive": "repetitive",
    "Rhodamine6G": "rhodamine6_g",
    "Rights": "rights",
    "RightsHeld": "rights_held",
    "RightsHolder": "rights_holder",
    "Row": "row",
    "RowNamingConvention": "row_naming_convention",
    "Rows": "rows",
    "Ruby": "ruby",
    "SHA1": "sha1",
    "SPIM": "spim",
    "STED": "sted",
    "STORM": "storm",
    "SamplesPerPixel": "samples_per_pixel",
    "Screen": "screen",
    "Screens": "screens",
    "SecondHarmonicGenerationImaging": "second_harmonic_generation_imaging",
    "Semiconductor": "semiconductor",
    "SerialNumber": "serial_number",
    "Settings": "settings",
    "Shape": "shape",
    "ShapeGroup": "shape_group",
    "ShortPass": "short_pass",
    "SignificantBits": "significant_bits",
    "Single": "single",
    "SingleMoleculeImaging": "single_molecule_imaging",
    "Size": "size",
    "SizeC": "size_c",
    "SizeT": "size_t",
    "SizeX": "size_x",
    "SizeY": "size_y",
    "SizeZ": "size_z",
    "SlitScanConfocal": "slit_scan_confocal",
    "SolidState": "solid_state",
    "SpectralImaging": "spectral_imaging",
    "Spectroscopy": "spectroscopy",
    "SpinningDiskConfocal": "spinning_disk_confocal",
    "StageLabel": "stage_label",
    "StartTime": "start_time",
    "Status": "status",
    "StrokeColor": "stroke_color",
    "StrokeDashArray": "stroke_dash_array",
    "StrokeWidth": "stroke_width",
    "StrokeWidthUnit": "stroke_width_unit",
    "StructuredAnnotations": "structured_annotations",
    "StructuredIllumination": "structured_illumination",
    "SuperFluor": "super_fluor",
    "SweptFieldConfocal": "swept_field_confocal",
    "TIRF": "tirf",
    "TagAnnotation": "tag_annotation",
    "TagAnnotations": "tag_annotations",
    "Temperature": "temperature",
    "TemperatureUnit": "temperature_unit",
    "TermAnnotation": "term_annotation",
    "TermAnnotations": "term_annotations",
    "Text": "text",
    "TextAnnotation": "text_annotation",
    "TheC": "the_c",
    "TheT": "the_t",
    "TheZ": "the_z",
    "TiSapphire": "ti_sapphire",
    "TiffData": "tiff_data",
    "TiffDataBlocks": "tiff_data_blocks",
    "TimeIncrement": "time_increment",
    "TimeIncrementUnit": "time_increment_unit",
    "TimeLapse": "time_lapse",
    "Timepoint": "timepoint",
    "TimestampAnnotation": "timestamp_annotation",
    "TimestampAnnotations": "timestamp_annotations",
    "TotalInternalReflection": "total_internal_reflection",
    "Transform": "transform",
    "Transmittance": "transmittance",
    "TransmittanceRange": "transmittance_range",
    "Transmitted": "transmitted",
    "Tuneable": "tuneable",
    "Type": "type",
    "TypeAnnotation": "type_annotation",
    "UUID": "uuid",
    "UV": "uv",
    "Uncaging": "uncaging",
    "Union": "union",
    "Upright": "upright",
    "UserName": "user_name",
    "Value": "value",
    "VioletCorrected": "violet_corrected",
    "Voltage": "voltage",
    "VoltageUnit": "voltage_unit",
    "Water": "water",
    "WaterDipping": "water_dipping",
    "Wavelength": "wavelength",
    "WavelengthUnit": "wavelength_unit",
    "Well": "well",
    "WellOriginX": "well_origin_x",
    "WellOriginXUnit": "well_origin_x_unit",
    "WellOriginY": "well_origin_y",
    "WellOriginYUnit": "well_origin_y_unit",
    "WellSample": "well_sample",
    "WellSampleRef": "well_sample_ref",
    "WellSamples": "well_samples",
    "Wells": "wells",
    "WideField": "wide_field",
    "Width": "width",
    "WorkingDistance": "working_distance",
    "WorkingDistanceUnit": "working_distance_unit",
    "X": "x",
    "X1": "x1",
    "X2": "x2",
    "XMLAnnotation": "xml_annotation",
    "XMLAnnotations": "xml_annotations",
    "XUnit": "x_unit",
    "XYCTZ": "xyctz",
    "XYCZT": "xyczt",
    "XYTCZ": "xytcz",
    "XYTZC": "xytzc",
    "XYZCT": "xyzct",
    "XYZTC": "xyztc",
    "Xe": "xe",
    "XeBr": "xe_br",
    "XeCl": "xe_cl",
    "XeFl": "xe_fl",
    "Y": "y",
    "Y1": "y1",
    "Y2": "y2",
    "YUnit": "y_unit",
    "Z": "z",
    "ZUnit": "z_unit",
    "Zoom": "zoom",
    "bzip2": "bzip2",
    "cursive": "cursive",
    "fantasy": "fantasy",
    "href": "href",
    "letter": "letter",
    "monospace": "monospace",
    "none": "none",
    "number": "number",
    "sans-serif": "sans-serif",
    "serif": "serif",
    "zlib": "zlib",
}

_snake_to_camel = {
    "a00": "A00",
    "a01": "A01",
    "a02": "A02",
    "a10": "A10",
    "a11": "A11",
    "a12": "A12",
    "apd": "APD",
    "achro": "Achro",
    "achromat": "Achromat",
    "acquisition_date": "AcquisitionDate",
    "acquisition_mode": "AcquisitionMode",
    "affine_transform": "AffineTransform",
    "ag": "Ag",
    "air": "Air",
    "air_pressure": "AirPressure",
    "air_pressure_unit": "AirPressureUnit",
    "alexandrite": "Alexandrite",
    "amplification_gain": "AmplificationGain",
    "analog_video": "AnalogVideo",
    "annotation": "Annotation",
    "annotation_ref": "AnnotationRef",
    "annotator": "Annotator",
    "apo": "Apo",
    "ar": "Ar",
    "ar_cl": "ArCl",
    "ar_fl": "ArFl",
    "arc": "Arc",
    "arrow": "Arrow",
    "attenuation": "Attenuation",
    "band_pass": "BandPass",
    "basic_annotation": "BasicAnnotation",
    "big_endian": "BigEndian",
    "bin_data": "BinData",
    "binary_file": "BinaryFile",
    "binary_only": "BinaryOnly",
    "binning": "Binning",
    "bold": "Bold",
    "bold_italic": "BoldItalic",
    "boolean_annotation": "BooleanAnnotation",
    "boolean_annotations": "BooleanAnnotations",
    "bright_field": "BrightField",
    "brightfield": "Brightfield",
    "ccd": "CCD",
    "cmos": "CMOS",
    "co": "CO",
    "co2": "CO2",
    "co2_percent": "CO2Percent",
    "cw": "CW",
    "calibrated_magnification": "CalibratedMagnification",
    "channel": "Channel",
    "channel_ref": "ChannelRef",
    "channels": "Channels",
    "colocalization": "Colocalization",
    "color": "Color",
    "column": "Column",
    "column_naming_convention": "ColumnNamingConvention",
    "columns": "Columns",
    "comment_annotation": "CommentAnnotation",
    "comment_annotations": "CommentAnnotations",
    "compression": "Compression",
    "contrast_method": "ContrastMethod",
    "correction": "Correction",
    "correction_collar": "CorrectionCollar",
    "correlation_spectroscopy": "CorrelationSpectroscopy",
    "coumarin_c30": "CoumarinC30",
    "creator": "Creator",
    "cu": "Cu",
    "cut_in": "CutIn",
    "cut_in_tolerance": "CutInTolerance",
    "cut_in_tolerance_unit": "CutInToleranceUnit",
    "cut_in_unit": "CutInUnit",
    "cut_out": "CutOut",
    "cut_out_tolerance": "CutOutTolerance",
    "cut_out_tolerance_unit": "CutOutToleranceUnit",
    "cut_out_unit": "CutOutUnit",
    "dic": "DIC",
    "darkfield": "Darkfield",
    "dataset": "Dataset",
    "dataset_ref": "DatasetRef",
    "datasets": "Datasets",
    "delta_t": "DeltaT",
    "delta_t_unit": "DeltaTUnit",
    "description": "Description",
    "detector": "Detector",
    "detector_settings": "DetectorSettings",
    "detectors": "Detectors",
    "dichroic": "Dichroic",
    "dichroic_ref": "DichroicRef",
    "dichroics": "Dichroics",
    "dimension_order": "DimensionOrder",
    "dissection": "Dissection",
    "double_annotation": "DoubleAnnotation",
    "double_annotations": "DoubleAnnotations",
    "dye": "Dye",
    "ebccd": "EBCCD",
    "emccd": "EMCCD",
    "e_minus": "EMinus",
    "electrophysiology": "Electrophysiology",
    "ellipse": "Ellipse",
    "email": "Email",
    "emission_filter_ref": "EmissionFilterRef",
    "emission_wavelength": "EmissionWavelength",
    "emission_wavelength_unit": "EmissionWavelengthUnit",
    "end_time": "EndTime",
    "epifluorescence": "Epifluorescence",
    "er_glass": "ErGlass",
    "er_yag": "ErYAG",
    "even_odd": "EvenOdd",
    "excimer": "Excimer",
    "excitation_filter_ref": "ExcitationFilterRef",
    "excitation_wavelength": "ExcitationWavelength",
    "excitation_wavelength_unit": "ExcitationWavelengthUnit",
    "experiment": "Experiment",
    "experiment_ref": "ExperimentRef",
    "experimenter": "Experimenter",
    "experimenter_group": "ExperimenterGroup",
    "experimenter_group_ref": "ExperimenterGroupRef",
    "experimenter_groups": "ExperimenterGroups",
    "experimenter_ref": "ExperimenterRef",
    "experimenters": "Experimenters",
    "experiments": "Experiments",
    "exposure_time": "ExposureTime",
    "exposure_time_unit": "ExposureTimeUnit",
    "external": "External",
    "external_description": "ExternalDescription",
    "external_identifier": "ExternalIdentifier",
    "fish": "FISH",
    "flip": "FLIP",
    "fp": "FP",
    "frap": "FRAP",
    "fret": "FRET",
    "fsm": "FSM",
    "ftir": "FTIR",
    "field_index": "FieldIndex",
    "filament": "Filament",
    "file_annotation": "FileAnnotation",
    "file_annotations": "FileAnnotations",
    "file_name": "FileName",
    "fill_color": "FillColor",
    "fill_rule": "FillRule",
    "filter": "Filter",
    "filter_ref": "FilterRef",
    "filter_set": "FilterSet",
    "filter_set_ref": "FilterSetRef",
    "filter_sets": "FilterSets",
    "filter_wheel": "FilterWheel",
    "filters": "Filters",
    "first_c": "FirstC",
    "first_name": "FirstName",
    "first_t": "FirstT",
    "first_z": "FirstZ",
    "fl": "Fl",
    "fluar": "Fluar",
    "fluor": "Fluor",
    "fluorescence": "Fluorescence",
    "fluorescence_correlation_spectroscopy": "FluorescenceCorrelationSpectroscopy",
    "fluorescence_lifetime": "FluorescenceLifetime",
    "fluotar": "Fluotar",
    "folder": "Folder",
    "folder_ref": "FolderRef",
    "folders": "Folders",
    "font_family": "FontFamily",
    "font_size": "FontSize",
    "font_size_unit": "FontSizeUnit",
    "font_style": "FontStyle",
    "four_d_plus": "FourDPlus",
    "free_electron": "FreeElectron",
    "frequency_multiplication": "FrequencyMultiplication",
    "ga_al_as": "GaAlAs",
    "ga_as": "GaAs",
    "gain": "Gain",
    "gas": "Gas",
    "generic_excitation_source": "GenericExcitationSource",
    "glycerol": "Glycerol",
    "h2_o": "H2O",
    "h_fl": "HFl",
    "halogen": "Halogen",
    "hash_sha1": "HashSHA1",
    "he_cd": "HeCd",
    "he_ne": "HeNe",
    "height": "Height",
    "hg": "Hg",
    "hg_xe": "HgXe",
    "ho_yag": "HoYAG",
    "ho_ylf": "HoYLF",
    "hoffman_modulation": "HoffmanModulation",
    "humidity": "Humidity",
    "id": "ID",
    "ifd": "IFD",
    "illumination_type": "IlluminationType",
    "image": "Image",
    "image_ref": "ImageRef",
    "images": "Images",
    "imaging_environment": "ImagingEnvironment",
    "immersion": "Immersion",
    "immunocytochemistry": "Immunocytochemistry",
    "immunofluorescence": "Immunofluorescence",
    "incandescent": "Incandescent",
    "index": "Index",
    "institution": "Institution",
    "instrument": "Instrument",
    "instrument_ref": "InstrumentRef",
    "instruments": "Instruments",
    "integration": "Integration",
    "intensified_ccd": "IntensifiedCCD",
    "interleaved": "Interleaved",
    "inverse_frap": "InverseFRAP",
    "inverted": "Inverted",
    "ion_imaging": "IonImaging",
    "iris": "Iris",
    "italic": "Italic",
    "k": "K",
    "kr": "Kr",
    "kr_cl": "KrCl",
    "kr_fl": "KrFl",
    "lcm": "LCM",
    "label": "Label",
    "laser": "Laser",
    "laser_medium": "LaserMedium",
    "laser_scanning_confocal_microscopy": "LaserScanningConfocalMicroscopy",
    "last_name": "LastName",
    "leader": "Leader",
    "length": "Length",
    "lens_na": "LensNA",
    "lifetime_imaging": "LifetimeImaging",
    "light_emitting_diode": "LightEmittingDiode",
    "light_path": "LightPath",
    "light_source": "LightSource",
    "light_source_group": "LightSourceGroup",
    "light_source_settings": "LightSourceSettings",
    "line": "Line",
    "list_annotation": "ListAnnotation",
    "list_annotations": "ListAnnotations",
    "locked": "Locked",
    "long_annotation": "LongAnnotation",
    "long_annotations": "LongAnnotations",
    "long_pass": "LongPass",
    "lot_number": "LotNumber",
    "m": "M",
    "mime_type": "MIMEType",
    "manufacturer": "Manufacturer",
    "manufacturer_spec": "ManufacturerSpec",
    "map": "Map",
    "map_annotation": "MapAnnotation",
    "map_annotations": "MapAnnotations",
    "marker_end": "MarkerEnd",
    "marker_start": "MarkerStart",
    "mask": "Mask",
    "maximum_field_count": "MaximumFieldCount",
    "medium": "Medium",
    "metadata_file": "MetadataFile",
    "metadata_only": "MetadataOnly",
    "metal_vapor": "MetalVapor",
    "microbeam_manipulation": "MicrobeamManipulation",
    "microbeam_manipulation_ref": "MicrobeamManipulationRef",
    "microbeam_manipulations": "MicrobeamManipulations",
    "microscope": "Microscope",
    "middle_name": "MiddleName",
    "mode_locked": "ModeLocked",
    "model": "Model",
    "multi": "Multi",
    "multi_pass": "MultiPass",
    "multi_photon_microscopy": "MultiPhotonMicroscopy",
    "n": "N",
    "nd_filter": "NDFilter",
    "name": "Name",
    "namespace": "Namespace",
    "nd_glass": "NdGlass",
    "nd_yag": "NdYAG",
    "near_field_scanning_optical_microscopy": "NearFieldScanningOpticalMicroscopy",
    "neofluar": "Neofluar",
    "neutral_density": "NeutralDensity",
    "nominal_magnification": "NominalMagnification",
    "non_linear": "NonLinear",
    "non_zero": "NonZero",
    "normal": "Normal",
    "numeric_annotation": "NumericAnnotation",
    "ome": "OME",
    "objective": "Objective",
    "objective_settings": "ObjectiveSettings",
    "objectives": "Objectives",
    "oblique": "Oblique",
    "oblique_illumination": "ObliqueIllumination",
    "offset": "Offset",
    "oil": "Oil",
    "optical_trapping": "OpticalTrapping",
    "other": "Other",
    "palm": "PALM",
    "pgi_documentation": "PGIDocumentation",
    "pmt": "PMT",
    "phase": "Phase",
    "photoablation": "Photoablation",
    "photoactivation": "Photoactivation",
    "photobleaching": "Photobleaching",
    "photodiode": "Photodiode",
    "physical_size_x": "PhysicalSizeX",
    "physical_size_x_unit": "PhysicalSizeXUnit",
    "physical_size_y": "PhysicalSizeY",
    "physical_size_y_unit": "PhysicalSizeYUnit",
    "physical_size_z": "PhysicalSizeZ",
    "physical_size_z_unit": "PhysicalSizeZUnit",
    "pinhole_size": "PinholeSize",
    "pinhole_size_unit": "PinholeSizeUnit",
    "pixels": "Pixels",
    "plan_apo": "PlanApo",
    "plan_fluor": "PlanFluor",
    "plan_neofluar": "PlanNeofluar",
    "plane": "Plane",
    "plane_count": "PlaneCount",
    "planes": "Planes",
    "plate": "Plate",
    "plate_acquisition": "PlateAcquisition",
    "plate_acquisitions": "PlateAcquisitions",
    "plate_ref": "PlateRef",
    "plates": "Plates",
    "pockel_cell": "PockelCell",
    "pockel_cell_setting": "PockelCellSetting",
    "point": "Point",
    "points": "Points",
    "polarized_light": "PolarizedLight",
    "polygon": "Polygon",
    "polyline": "Polyline",
    "position_x": "PositionX",
    "position_x_unit": "PositionXUnit",
    "position_y": "PositionY",
    "position_y_unit": "PositionYUnit",
    "position_z": "PositionZ",
    "position_z_unit": "PositionZUnit",
    "power": "Power",
    "power_unit": "PowerUnit",
    "project": "Project",
    "project_ref": "ProjectRef",
    "projects": "Projects",
    "protocol_description": "ProtocolDescription",
    "protocol_identifier": "ProtocolIdentifier",
    "pulse": "Pulse",
    "pump": "Pump",
    "q_switched": "QSwitched",
    "roi": "ROI",
    "roi_ref": "ROIRef",
    "rois": "ROIs",
    "radius_x": "RadiusX",
    "radius_y": "RadiusY",
    "read_out_rate": "ReadOutRate",
    "read_out_rate_unit": "ReadOutRateUnit",
    "reagent": "Reagent",
    "reagent_identifier": "ReagentIdentifier",
    "reagent_ref": "ReagentRef",
    "reagent_set_description": "ReagentSetDescription",
    "reagent_set_identifier": "ReagentSetIdentifier",
    "reagents": "Reagents",
    "rectangle": "Rectangle",
    "reference": "Reference",
    "refractive_index": "RefractiveIndex",
    "repetition_rate": "RepetitionRate",
    "repetition_rate_unit": "RepetitionRateUnit",
    "repetitive": "Repetitive",
    "rhodamine6_g": "Rhodamine6G",
    "rights": "Rights",
    "rights_held": "RightsHeld",
    "rights_holder": "RightsHolder",
    "row": "Row",
    "row_naming_convention": "RowNamingConvention",
    "rows": "Rows",
    "ruby": "Ruby",
    "sha1": "SHA1",
    "spim": "SPIM",
    "sted": "STED",
    "storm": "STORM",
    "samples_per_pixel": "SamplesPerPixel",
    "screen": "Screen",
    "screens": "Screens",
    "second_harmonic_generation_imaging": "SecondHarmonicGenerationImaging",
    "semiconductor": "Semiconductor",
    "serial_number": "SerialNumber",
    "settings": "Settings",
    "shape": "Shape",
    "shape_group": "ShapeGroup",
    "short_pass": "ShortPass",
    "significant_bits": "SignificantBits",
    "single": "Single",
    "single_molecule_imaging": "SingleMoleculeImaging",
    "size": "Size",
    "size_c": "SizeC",
    "size_t": "SizeT",
    "size_x": "SizeX",
    "size_y": "SizeY",
    "size_z": "SizeZ",
    "slit_scan_confocal": "SlitScanConfocal",
    "solid_state": "SolidState",
    "spectral_imaging": "SpectralImaging",
    "spectroscopy": "Spectroscopy",
    "spinning_disk_confocal": "SpinningDiskConfocal",
    "stage_label": "StageLabel",
    "start_time": "StartTime",
    "status": "Status",
    "stroke_color": "StrokeColor",
    "stroke_dash_array": "StrokeDashArray",
    "stroke_width": "StrokeWidth",
    "stroke_width_unit": "StrokeWidthUnit",
    "structured_annotations": "StructuredAnnotations",
    "structured_illumination": "StructuredIllumination",
    "super_fluor": "SuperFluor",
    "swept_field_confocal": "SweptFieldConfocal",
    "tirf": "TIRF",
    "tag_annotation": "TagAnnotation",
    "tag_annotations": "TagAnnotations",
    "temperature": "Temperature",
    "temperature_unit": "TemperatureUnit",
    "term_annotation": "TermAnnotation",
    "term_annotations": "TermAnnotations",
    "text": "Text",
    "text_annotation": "TextAnnotation",
    "the_c": "TheC",
    "the_t": "TheT",
    "the_z": "TheZ",
    "ti_sapphire": "TiSapphire",
    "tiff_data": "TiffData",
    "tiff_data_blocks": "TiffDataBlocks",
    "time_increment": "TimeIncrement",
    "time_increment_unit": "TimeIncrementUnit",
    "time_lapse": "TimeLapse",
    "timepoint": "Timepoint",
    "timestamp_annotation": "TimestampAnnotation",
    "timestamp_annotations": "TimestampAnnotations",
    "total_internal_reflection": "TotalInternalReflection",
    "transform": "Transform",
    "transmittance": "Transmittance",
    "transmittance_range": "TransmittanceRange",
    "transmitted": "Transmitted",
    "tuneable": "Tuneable",
    "type": "Type",
    "type_annotation": "TypeAnnotation",
    "uuid": "UUID",
    "uv": "UV",
    "uncaging": "Uncaging",
    "union": "Union",
    "upright": "Upright",
    "user_name": "UserName",
    "value": "Value",
    "violet_corrected": "VioletCorrected",
    "voltage": "Voltage",
    "voltage_unit": "VoltageUnit",
    "water": "Water",
    "water_dipping": "WaterDipping",
    "wavelength": "Wavelength",
    "wavelength_unit": "WavelengthUnit",
    "well": "Well",
    "well_origin_x": "WellOriginX",
    "well_origin_x_unit": "WellOriginXUnit",
    "well_origin_y": "WellOriginY",
    "well_origin_y_unit": "WellOriginYUnit",
    "well_sample": "WellSample",
    "well_sample_ref": "WellSampleRef",
    "well_samples": "WellSamples",
    "wells": "Wells",
    "wide_field": "WideField",
    "width": "Width",
    "working_distance": "WorkingDistance",
    "working_distance_unit": "WorkingDistanceUnit",
    "x": "X",
    "x1": "X1",
    "x2": "X2",
    "xml_annotation": "XMLAnnotation",
    "xml_annotations": "XMLAnnotations",
    "x_unit": "XUnit",
    "xyctz": "XYCTZ",
    "xyczt": "XYCZT",
    "xytcz": "XYTCZ",
    "xytzc": "XYTZC",
    "xyzct": "XYZCT",
    "xyztc": "XYZTC",
    "xe": "Xe",
    "xe_br": "XeBr",
    "xe_cl": "XeCl",
    "xe_fl": "XeFl",
    "y": "Y",
    "y1": "Y1",
    "y2": "Y2",
    "y_unit": "YUnit",
    "z": "Z",
    "z_unit": "ZUnit",
    "zoom": "Zoom",
    "bzip2": "bzip2",
    "cursive": "cursive",
    "fantasy": "fantasy",
    "href": "href",
    "letter": "letter",
    "monospace": "monospace",
    "none": "none",
    "number": "number",
    "sans-serif": "sans-serif",
    "serif": "serif",
    "zlib": "zlib",
}

_lists = {
    "Annotation": {"AnnotationRef"},
    "LightSource": {"AnnotationRef"},
    "Map": {"M"},
    "Shape": {"AnnotationRef"},
    "OME": {
        "Dataset",
        "Instrument",
        "Experimenter",
        "Experiment",
        "Folder",
        "ExperimenterGroup",
        "Project",
        "ROI",
        "Image",
        "Screen",
        "Plate",
    },
    "Image": {"MicrobeamManipulationRef", "ROIRef", "AnnotationRef"},
    "Pixels": {"TiffData", "Channel", "BinData", "Plane"},
    "Plane": {"AnnotationRef"},
    "Channel": {"AnnotationRef"},
    "MicrobeamManipulation": {"LightSourceSettings", "ROIRef", "Type"},
    "Instrument": {
        "Dichroic",
        "AnnotationRef",
        "Objective",
        "Detector",
        "Filter",
        "FilterSet",
    },
    "Project": {"AnnotationRef", "DatasetRef"},
    "ExperimenterGroup": {"Leader", "ExperimenterRef", "AnnotationRef"},
    "Dataset": {"ImageRef", "AnnotationRef"},
    "Experiment": {"MicrobeamManipulation", "Type"},
    "Experimenter": {"AnnotationRef"},
    "Folder": {"ImageRef", "ROIRef", "AnnotationRef", "FolderRef"},
    "Objective": {"AnnotationRef"},
    "Detector": {"AnnotationRef"},
    "FilterSet": {"ExcitationFilterRef", "EmissionFilterRef"},
    "Filter": {"AnnotationRef"},
    "Dichroic": {"AnnotationRef"},
    "LightPath": {"ExcitationFilterRef", "EmissionFilterRef", "AnnotationRef"},
    "ROI": {"AnnotationRef"},
    "Plate": {"AnnotationRef", "PlateAcquisition", "Well"},
    "Reagent": {"AnnotationRef"},
    "Screen": {"AnnotationRef", "PlateRef", "Reagent"},
    "PlateAcquisition": {"AnnotationRef", "WellSampleRef"},
    "Well": {"WellSample", "AnnotationRef"},
}
