"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/lambda/delete-old-lambda-layer-versions.lambda.ts
var delete_old_lambda_layer_versions_lambda_exports = {};
__export(delete_old_lambda_layer_versions_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(delete_old_lambda_layer_versions_lambda_exports);
var import_client_lambda = require("@aws-sdk/client-lambda");
var client = new import_client_lambda.LambdaClient({});
var handler = async (_event, _context) => {
  const retainVersionStr = process.env.RETAIN_VERSIONS;
  if (retainVersionStr === void 0 || !/^(0|[1-9]\d*)$/.test(retainVersionStr)) {
    throw new Error("Invalid RETAIN_VERSIONS environment variable value. It should be a string containing a positive integer.");
  }
  const retainVersions = parseInt(retainVersionStr, 10);
  try {
    const listAllLayersCmd = new import_client_lambda.ListLayersCommand({});
    const layers = await client.send(listAllLayersCmd);
    if (layers.Layers === void 0) {
      console.log("No layers found.");
      return;
    }
    layers.Layers.forEach(async (layer) => {
      if (layer.LayerName === void 0) {
        console.log("Layer name is undefined.");
        return;
      }
      const listLayerVersionsCmd = new import_client_lambda.ListLayerVersionsCommand({ LayerName: layer.LayerName });
      const layerVersions = await client.send(listLayerVersionsCmd);
      if (layerVersions.LayerVersions === void 0 || layerVersions.LayerVersions.length <= retainVersions) {
        console.log(`Layer: ${layer.LayerName} - Keeping all versions. No action needed.`);
        return;
      }
      const sortedVersions = layerVersions.LayerVersions.sort((a, b) => {
        const aVersion = a.Version ?? 0;
        const bVersion = b.Version ?? 0;
        return aVersion - bVersion;
      });
      const versionsToDelete = sortedVersions.slice(0, sortedVersions.length - retainVersions);
      versionsToDelete.forEach(async (version) => {
        if (version.Version === void 0) {
          console.log("Version number is undefined.");
          return;
        }
        const deleteLayerVersionCmd = new import_client_lambda.DeleteLayerVersionCommand({ LayerName: layer.LayerName, VersionNumber: version.Version });
        await client.send(deleteLayerVersionCmd);
        console.log(`Deleted version ${version.Version} of layer ${layer.LayerName}.`);
      });
    });
  } catch (error) {
    console.error("Error occurred:", error);
    throw error;
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
//# sourceMappingURL=index.js.map
