##########################################################
## ccAF:  setup.py                                      ##
##  ______     ______     __  __                        ##
## /\  __ \   /\  ___\   /\ \/\ \                       ##
## \ \  __ \  \ \___  \  \ \ \_\ \                      ##
##  \ \_\ \_\  \/\_____\  \ \_____\                     ##
##   \/_/\/_/   \/_____/   \/_____/                     ##
## @Developed by: Plaisier Lab                          ##
##   (https://plaisierlab.engineering.asu.edu/)         ##
##   Arizona State University                           ##
##   242 ISTB1, 550 E Orange St                         ##
##   Tempe, AZ  85281                                   ##
## @Author:  Chris Plaisier, Samantha O'Connor          ##
## @License:  GNU GPLv3                                 ##
##                                                      ##
## If this program is used in your analysis please      ##
## mention who built it. Thanks. :-)                    ##
##########################################################

import pathlib
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
long_description = (HERE / "README.md").read_text()

# This call to setup() does all the work
setup(
    name="ccAF",
    version="1.0.1",
    description="Classify scRNA-seq profiling with highly resolved cell cycle phases.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/plaisier-lab/ccAF",
    author="Christopher Plaisier",
    author_email="plaisier@asu.edu",
    license="GNU General Public License v3.0",
    classifiers=[
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Topic :: Scientific/Engineering :: Bio-Informatics",
        "Topic :: Scientific/Engineering :: Medical Science Apps.",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
    ],
    packages=["ccAF"],
    include_package_data=True,
    install_requires=["numpy", "scipy", "pandas", "tensorflow"],
)
