# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_core.ipynb (unless otherwise specified).

__all__ = ['map_dict_ex', 'D', 'tensor2shape', 'tensor2mu', 'TensorBatch', 'obj2tensor', 'BD']

# Cell
# Python native modules
import os,warnings
# Third party libs
from fastcore.all import *
from fastai.torch_core import *
from fastai.basics import *
import pandas as pd
import torch
import numpy as np
# Local modules

# Cell
def map_dict_ex(d,f,*args,gen=False,wise=None,**kwargs):
    "Like `map`, but for dicts and uses `bind`, and supports `str` and indexing"
    g = (bind(f,*args,**kwargs) if callable(f)
         else f.format if isinstance(f,str)
         else f.__getitem__)

    if wise is None:  return map(g,d.items())
    return ((k,g(v)) if wise=='value' else (g(k),v) for k,v in d.items())

# Cell
_error_msg='Found idxs: %s have values more than %s e.g.: %s'

class D(dict):
    "Improved version of `dict` with array handling abilities"
    def __init__(self,*args,mapping=False,**kwargs):
        self.mapping=mapping
        super().__init__(*args,**kwargs)

    def eq_k(self,o:'D',with_diff=False):
        eq=set(o.keys())==set(self.keys())
        if with_diff: return eq,set(o.keys()).symmetric_difference(set(self.keys()))
        return eq
    def _new(self,*args,**kwargs): return type(self)(*args,**kwargs)

    def map(self,f,*args,gen=False,**kwargs):
        return (self._new,noop)[gen](map_dict_ex(self,f,*args,**kwargs),mapping=True)
    def mapk(self,f,*args,gen=False,wise='key',**kwargs):
        return self.map(f,*args,gen=gen,wise=wise,**kwargs)
    def mapv(self,f,*args,gen=False,wise='value',**kwargs):
        return self.map(f,*args,gen=gen,wise=wise,**kwargs)

# Cell
def tensor2shape(k,t:'TensorBatch'):
    "Converts a tensor into a dict of shapes, or a 1d numpy array"
    return {
        k:t.numpy().reshape(-1,) if len(t.shape)==2 and t.shape[1]==1 else
        [str(t.shape)]*t.shape[0]
    }

# Cell
def tensor2mu(k,t:Tensor): return {f'{k}_mu':t.reshape(t.shape[0],-1).double().mean(axis=1)}
tensor2mu.__docs__="Returns a dict with key `k`_mu with the mean of `t` batchwise "

# Cell
class TensorBatch(TensorBase):
    "A tensor that maintains and propagates a batch dimension"
    def __new__(cls, x, bs=1,**kwargs):
        res=super(TensorBatch,cls).__new__(cls,x,**kwargs)

        if bs==1:
            if len(res.shape)<2:
                res=res.unsqueeze(0)
        else:
            if res.shape[0]!=bs and res.shape[1]==bs and len(res.shape)==2:
#                 print('tansposing',res,bs)
                res=torch.transpose(res,1,0)

        assert len(res.shape)>1,f'Tensor has shape {res.shape} while bs is {bs}'
        return res

    @property
    def bs(self): return self.shape[0]
    def get(self,*args):
#         print(self)
        res=self[args]
        if len(self.shape)>len(res.shape): res=res.unsqueeze(0)
        return res

    @classmethod
    def vstack(cls,*args):
        new_bs=sum(map(_get_bs,*args))
        return cls(torch.vstack(*args),bs=new_bs)

def obj2tensor(o):
    return (o if isinstance(o,TensorBatch) else
            TensorBatch(o) if isinstance(o,(L,list,np.ndarray,Tensor,TensorBatch)) else
            TensorBatch([o]))

def _get_bs(o): return o.bs if isinstance(o,TensorBatch) else TensorBatch(o).bs

# export
class BD(D):
    def __init__(self,*args,**kwargs):
        super().__init__(*args,**kwargs)
        if not self.mapping: self.update(self.mapv(obj2tensor))
        self.bs=list(self.values())[0].bs

    def __radd__(self,o): return self if isinstance(o,int) else self.__add__(o)
    def __add__(self,o):
#         print('add',self.bs)
        return BD({k:TensorBatch.vstack((self[k],o[k])) for k in self})

    def __getitem__(self,o):
        if is_listy(o) or isinstance(o,(TensorBatch,int,Tensor)):
            return type(self)({k:self[k].get(o) for k in self})
        return super().__getitem__(o)

    @classmethod
    def merge(cls,*ds,**kwargs): return cls(merge(*ds),**kwargs)
    @delegates(pd.DataFrame)
    def pandas(self,mu=False,**kwargs):
        "Turns a `BD` into a pandas Dataframe optionally showing `mu` of values."
        return pd.DataFrame(merge(
            *tuple(tensor2shape(k,v) for k,v in self.items()),
            *(tuple(tensor2mu(k,v) for k,v in self.items()) if mu else ())
        ),**kwargs)