import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::RDS::DBCluster`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export interface CfnDBClusterProps {
    /**
     * `AWS::RDS::DBCluster.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     */
    readonly engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     */
    readonly associatedRoles?: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     */
    readonly backtrackWindow?: number;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-copytagstosnapshot
     */
    readonly copyTagsToSnapshot?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     */
    readonly databaseName?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     */
    readonly dbClusterParameterGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     */
    readonly enableHttpEndpoint?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     */
    readonly engineMode?: string;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier
     */
    readonly globalClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBCluster.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     */
    readonly port?: number;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     */
    readonly replicationSourceIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     */
    readonly restoreType?: string;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     */
    readonly scalingConfiguration?: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     */
    readonly snapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     */
    readonly sourceDbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     */
    readonly useLatestRestorableTime?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export declare class CfnDBCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBCluster;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndpoint.Address
     */
    readonly attrReadEndpointAddress: string;
    /**
     * `AWS::RDS::DBCluster.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine
     */
    engine: string;
    /**
     * `AWS::RDS::DBCluster.AssociatedRoles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles
     */
    associatedRoles: Array<CfnDBCluster.DBClusterRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.AvailabilityZones`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.BacktrackWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow
     */
    backtrackWindow: number | undefined;
    /**
     * `AWS::RDS::DBCluster.BackupRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backuprententionperiod
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBCluster.CopyTagsToSnapshot`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-copytagstosnapshot
     */
    copyTagsToSnapshot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.DatabaseName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename
     */
    databaseName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBClusterParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname
     */
    dbClusterParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBCluster.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableHttpEndpoint`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint
     */
    enableHttpEndpoint: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EnableIAMDatabaseAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode
     */
    engineMode: string | undefined;
    /**
     * `AWS::RDS::DBCluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.GlobalClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier
     */
    globalClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUsername`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBCluster.MasterUserPassword`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBCluster.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port
     */
    port: number | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredBackupWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.PreferredMaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ReplicationSourceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier
     */
    replicationSourceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.RestoreType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype
     */
    restoreType: string | undefined;
    /**
     * `AWS::RDS::DBCluster.ScalingConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration
     */
    scalingConfiguration: CfnDBCluster.ScalingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.SnapshotIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier
     */
    snapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceDBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier
     */
    sourceDbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBCluster.SourceRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBCluster.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBCluster.UseLatestRestorableTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime
     */
    useLatestRestorableTime: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBCluster.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export declare namespace CfnDBCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html
     */
    interface DBClusterRoleProperty {
        /**
         * `CfnDBCluster.DBClusterRoleProperty.FeatureName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-featurename
         */
        readonly featureName?: string;
        /**
         * `CfnDBCluster.DBClusterRoleProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-dbclusterrole.html#cfn-rds-dbcluster-dbclusterrole-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
export declare namespace CfnDBCluster {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html
     */
    interface ScalingConfigurationProperty {
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.AutoPause`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-autopause
         */
        readonly autoPause?: boolean | cdk.IResolvable;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MaxCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-maxcapacity
         */
        readonly maxCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.MinCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-mincapacity
         */
        readonly minCapacity?: number;
        /**
         * `CfnDBCluster.ScalingConfigurationProperty.SecondsUntilAutoPause`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbcluster-scalingconfiguration.html#cfn-rds-dbcluster-scalingconfiguration-secondsuntilautopause
         */
        readonly secondsUntilAutoPause?: number;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBClusterParameterGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
export interface CfnDBClusterParameterGroupProps {
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     */
    readonly parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
export declare class CfnDBClusterParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBClusterParameterGroup;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-description
     */
    description: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-family
     */
    family: string;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-parameters
     */
    parameters: any | cdk.IResolvable;
    /**
     * `AWS::RDS::DBClusterParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html#cfn-rds-dbclusterparametergroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterParameterGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBInstance`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export interface CfnDBInstanceProps {
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     */
    readonly dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     */
    readonly allocatedStorage?: string;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     */
    readonly allowMajorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     */
    readonly associatedRoles?: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     */
    readonly caCertificateIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     */
    readonly characterSetName?: string;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     */
    readonly copyTagsToSnapshot?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     */
    readonly dbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     */
    readonly dbName?: string;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     */
    readonly dbParameterGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     */
    readonly dbSecurityGroups?: string[];
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     */
    readonly dbSnapshotIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     */
    readonly deleteAutomatedBackups?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     */
    readonly domain?: string;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     */
    readonly domainIamRoleName?: string;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     */
    readonly enableIamDatabaseAuthentication?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     */
    readonly enablePerformanceInsights?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     */
    readonly engine?: string;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::DBInstance.Iops`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     */
    readonly iops?: number;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     */
    readonly licenseModel?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     */
    readonly masterUsername?: string;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     */
    readonly masterUserPassword?: string;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     */
    readonly maxAllocatedStorage?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     */
    readonly monitoringInterval?: number;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     */
    readonly monitoringRoleArn?: string;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     */
    readonly multiAz?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     */
    readonly optionGroupName?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     */
    readonly performanceInsightsKmsKeyId?: string;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     */
    readonly performanceInsightsRetentionPeriod?: number;
    /**
     * `AWS::RDS::DBInstance.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     */
    readonly port?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     */
    readonly processorFeatures?: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     */
    readonly promotionTier?: number;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     */
    readonly publiclyAccessible?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     */
    readonly sourceDbInstanceIdentifier?: string;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     */
    readonly sourceRegion?: string;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::RDS::DBInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::RDS::DBInstance.Timezone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     */
    readonly timezone?: string;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     */
    readonly useDefaultProcessorFeatures?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     */
    readonly vpcSecurityGroups?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export declare class CfnDBInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBInstance;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Address
     */
    readonly attrEndpointAddress: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint.Port
     */
    readonly attrEndpointPort: string;
    /**
     * `AWS::RDS::DBInstance.DBInstanceClass`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceclass
     */
    dbInstanceClass: string;
    /**
     * `AWS::RDS::DBInstance.AllocatedStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allocatedstorage
     */
    allocatedStorage: string | undefined;
    /**
     * `AWS::RDS::DBInstance.AllowMajorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-allowmajorversionupgrade
     */
    allowMajorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AssociatedRoles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-associatedroles
     */
    associatedRoles: Array<CfnDBInstance.DBInstanceRoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.AvailabilityZone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.BackupRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-backupretentionperiod
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.CACertificateIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-cacertificateidentifier
     */
    caCertificateIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CharacterSetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-charactersetname
     */
    characterSetName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.CopyTagsToSnapshot`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-copytagstosnapshot
     */
    copyTagsToSnapshot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbclusteridentifier
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBInstanceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbinstanceidentifier
     */
    dbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbname
     */
    dbName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBParameterGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbparametergroupname
     */
    dbParameterGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsecuritygroups
     */
    dbSecurityGroups: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSnapshotIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsnapshotidentifier
     */
    dbSnapshotIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DeleteAutomatedBackups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deleteautomatedbackups
     */
    deleteAutomatedBackups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-deletionprotection
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Domain`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domain
     */
    domain: string | undefined;
    /**
     * `AWS::RDS::DBInstance.DomainIAMRoleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-domainiamrolename
     */
    domainIamRoleName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableCloudwatchLogsExports`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enablecloudwatchlogsexports
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::RDS::DBInstance.EnableIAMDatabaseAuthentication`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableiamdatabaseauthentication
     */
    enableIamDatabaseAuthentication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.EnablePerformanceInsights`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-enableperformanceinsights
     */
    enablePerformanceInsights: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engine
     */
    engine: string | undefined;
    /**
     * `AWS::RDS::DBInstance.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Iops`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-iops
     */
    iops: number | undefined;
    /**
     * `AWS::RDS::DBInstance.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.LicenseModel`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-licensemodel
     */
    licenseModel: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUsername`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masterusername
     */
    masterUsername: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MasterUserPassword`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-masteruserpassword
     */
    masterUserPassword: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MaxAllocatedStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-maxallocatedstorage
     */
    maxAllocatedStorage: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringInterval`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringinterval
     */
    monitoringInterval: number | undefined;
    /**
     * `AWS::RDS::DBInstance.MonitoringRoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-monitoringrolearn
     */
    monitoringRoleArn: string | undefined;
    /**
     * `AWS::RDS::DBInstance.MultiAZ`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-multiaz
     */
    multiAz: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.OptionGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-optiongroupname
     */
    optionGroupName: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsKMSKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightskmskeyid
     */
    performanceInsightsKmsKeyId: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PerformanceInsightsRetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-performanceinsightsretentionperiod
     */
    performanceInsightsRetentionPeriod: number | undefined;
    /**
     * `AWS::RDS::DBInstance.Port`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port
     */
    port: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredBackupWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredbackupwindow
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.PreferredMaintenanceWindow`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::RDS::DBInstance.ProcessorFeatures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-processorfeatures
     */
    processorFeatures: Array<CfnDBInstance.ProcessorFeatureProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.PromotionTier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-promotiontier
     */
    promotionTier: number | undefined;
    /**
     * `AWS::RDS::DBInstance.PubliclyAccessible`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-publiclyaccessible
     */
    publiclyAccessible: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceDBInstanceIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourcedbinstanceidentifier
     */
    sourceDbInstanceIdentifier: string | undefined;
    /**
     * `AWS::RDS::DBInstance.SourceRegion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-sourceregion
     */
    sourceRegion: string | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storageencrypted
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::RDS::DBInstance.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::RDS::DBInstance.Timezone`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-timezone
     */
    timezone: string | undefined;
    /**
     * `AWS::RDS::DBInstance.UseDefaultProcessorFeatures`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-usedefaultprocessorfeatures
     */
    useDefaultProcessorFeatures: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBInstance.VPCSecurityGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-vpcsecuritygroups
     */
    vpcSecurityGroups: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export declare namespace CfnDBInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html
     */
    interface DBInstanceRoleProperty {
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.FeatureName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-featurename
         */
        readonly featureName: string;
        /**
         * `CfnDBInstance.DBInstanceRoleProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-dbinstancerole.html#cfn-rds-dbinstance-dbinstancerole-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBInstance
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
export declare namespace CfnDBInstance {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html
     */
    interface ProcessorFeatureProperty {
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-name
         */
        readonly name?: string;
        /**
         * `CfnDBInstance.ProcessorFeatureProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbinstance-processorfeature.html#cfn-rds-dbinstance-processorfeature-value
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBParameterGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 */
export interface CfnDBParameterGroupProps {
    /**
     * `AWS::RDS::DBParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     */
    readonly description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     */
    readonly family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBParameterGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 */
export declare class CfnDBParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBParameterGroup;
    /**
     * `AWS::RDS::DBParameterGroup.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-description
     */
    description: string;
    /**
     * `AWS::RDS::DBParameterGroup.Family`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-family
     */
    family: string;
    /**
     * `AWS::RDS::DBParameterGroup.Parameters`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-parameters
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBParameterGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html#cfn-rds-dbparametergroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBParameterGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBProxy`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
export interface CfnDBProxyProps {
    /**
     * `AWS::RDS::DBProxy.Auth`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth
     */
    readonly auth: Array<CfnDBProxy.AuthFormatProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname
     */
    readonly dbProxyName: string;
    /**
     * `AWS::RDS::DBProxy.EngineFamily`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily
     */
    readonly engineFamily: string;
    /**
     * `AWS::RDS::DBProxy.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::RDS::DBProxy.VpcSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids
     */
    readonly vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxy.DebugLogging`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging
     */
    readonly debugLogging?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.IdleClientTimeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout
     */
    readonly idleClientTimeout?: number;
    /**
     * `AWS::RDS::DBProxy.RequireTLS`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls
     */
    readonly requireTls?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags
     */
    readonly tags?: CfnDBProxy.TagFormatProperty[];
    /**
     * `AWS::RDS::DBProxy.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
export declare class CfnDBProxy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBProxy;
    /**
     * @external
     * @cloudformationAttribute DBProxyArn
     */
    readonly attrDbProxyArn: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::RDS::DBProxy.Auth`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth
     */
    auth: Array<CfnDBProxy.AuthFormatProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxy.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname
     */
    dbProxyName: string;
    /**
     * `AWS::RDS::DBProxy.EngineFamily`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily
     */
    engineFamily: string;
    /**
     * `AWS::RDS::DBProxy.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn
     */
    roleArn: string;
    /**
     * `AWS::RDS::DBProxy.VpcSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids
     */
    vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxy.DebugLogging`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging
     */
    debugLogging: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxy.IdleClientTimeout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout
     */
    idleClientTimeout: number | undefined;
    /**
     * `AWS::RDS::DBProxy.RequireTLS`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls
     */
    requireTls: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxy.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags
     */
    tags: CfnDBProxy.TagFormatProperty[] | undefined;
    /**
     * `AWS::RDS::DBProxy.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBProxy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBProxyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
export declare namespace CfnDBProxy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html
     */
    interface AuthFormatProperty {
        /**
         * `CfnDBProxy.AuthFormatProperty.AuthScheme`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-authscheme
         */
        readonly authScheme?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-description
         */
        readonly description?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.IAMAuth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-iamauth
         */
        readonly iamAuth?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-secretarn
         */
        readonly secretArn?: string;
        /**
         * `CfnDBProxy.AuthFormatProperty.UserName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-authformat.html#cfn-rds-dbproxy-authformat-username
         */
        readonly userName?: string;
    }
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxy
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
export declare namespace CfnDBProxy {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html
     */
    interface TagFormatProperty {
        /**
         * `CfnDBProxy.TagFormatProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html#cfn-rds-dbproxy-tagformat-key
         */
        readonly key?: string;
        /**
         * `CfnDBProxy.TagFormatProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxy-tagformat.html#cfn-rds-dbproxy-tagformat-value
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBProxyEndpoint`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
export interface CfnDBProxyEndpointProps {
    /**
     * `AWS::RDS::DBProxyEndpoint.DBProxyEndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyendpointname
     */
    readonly dbProxyEndpointName: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyname
     */
    readonly dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.VpcSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsubnetids
     */
    readonly vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxyEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-tags
     */
    readonly tags?: CfnDBProxyEndpoint.TagFormatProperty[];
    /**
     * `AWS::RDS::DBProxyEndpoint.TargetRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-targetrole
     */
    readonly targetRole?: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsecuritygroupids
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBProxyEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxyEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
export declare class CfnDBProxyEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyEndpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBProxyEndpoint;
    /**
     * @external
     * @cloudformationAttribute DBProxyEndpointArn
     */
    readonly attrDbProxyEndpointArn: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute IsDefault
     */
    readonly attrIsDefault: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.DBProxyEndpointName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyendpointname
     */
    dbProxyEndpointName: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-dbproxyname
     */
    dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyEndpoint.VpcSubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsubnetids
     */
    vpcSubnetIds: string[];
    /**
     * `AWS::RDS::DBProxyEndpoint.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-tags
     */
    tags: CfnDBProxyEndpoint.TagFormatProperty[] | undefined;
    /**
     * `AWS::RDS::DBProxyEndpoint.TargetRole`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-targetrole
     */
    targetRole: string | undefined;
    /**
     * `AWS::RDS::DBProxyEndpoint.VpcSecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html#cfn-rds-dbproxyendpoint-vpcsecuritygroupids
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBProxyEndpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBProxyEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBProxyEndpoint`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxyEndpoint
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
export declare namespace CfnDBProxyEndpoint {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxyendpoint-tagformat.html
     */
    interface TagFormatProperty {
        /**
         * `CfnDBProxyEndpoint.TagFormatProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxyendpoint-tagformat.html#cfn-rds-dbproxyendpoint-tagformat-key
         */
        readonly key?: string;
        /**
         * `CfnDBProxyEndpoint.TagFormatProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxyendpoint-tagformat.html#cfn-rds-dbproxyendpoint-tagformat-value
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBProxyTargetGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
export interface CfnDBProxyTargetGroupProps {
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname
     */
    readonly dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.TargetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname
     */
    readonly targetGroupName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo
     */
    readonly connectionPoolConfigurationInfo?: CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty | cdk.IResolvable;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBClusterIdentifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers
     */
    readonly dbClusterIdentifiers?: string[];
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBInstanceIdentifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers
     */
    readonly dbInstanceIdentifiers?: string[];
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
export declare class CfnDBProxyTargetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyTargetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBProxyTargetGroup;
    /**
     * @external
     * @cloudformationAttribute TargetGroupArn
     */
    readonly attrTargetGroupArn: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBProxyName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbproxyname
     */
    dbProxyName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.TargetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-targetgroupname
     */
    targetGroupName: string;
    /**
     * `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfo`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfo
     */
    connectionPoolConfigurationInfo: CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBClusterIdentifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbclusteridentifiers
     */
    dbClusterIdentifiers: string[] | undefined;
    /**
     * `AWS::RDS::DBProxyTargetGroup.DBInstanceIdentifiers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html#cfn-rds-dbproxytargetgroup-dbinstanceidentifiers
     */
    dbInstanceIdentifiers: string[] | undefined;
    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBProxyTargetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
export declare namespace CfnDBProxyTargetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html
     */
    interface ConnectionPoolConfigurationInfoFormatProperty {
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.ConnectionBorrowTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-connectionborrowtimeout
         */
        readonly connectionBorrowTimeout?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.InitQuery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-initquery
         */
        readonly initQuery?: string;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.MaxConnectionsPercent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxconnectionspercent
         */
        readonly maxConnectionsPercent?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.MaxIdleConnectionsPercent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-maxidleconnectionspercent
         */
        readonly maxIdleConnectionsPercent?: number;
        /**
         * `CfnDBProxyTargetGroup.ConnectionPoolConfigurationInfoFormatProperty.SessionPinningFilters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat.html#cfn-rds-dbproxytargetgroup-connectionpoolconfigurationinfoformat-sessionpinningfilters
         */
        readonly sessionPinningFilters?: string[];
    }
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
export interface CfnDBSecurityGroupProps {
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     */
    readonly dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     */
    readonly groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     */
    readonly ec2VpcId?: string;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
export declare class CfnDBSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSecurityGroup;
    /**
     * `AWS::RDS::DBSecurityGroup.DBSecurityGroupIngress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-dbsecuritygroupingress
     */
    dbSecurityGroupIngress: Array<CfnDBSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::DBSecurityGroup.GroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-groupdescription
     */
    groupDescription: string;
    /**
     * `AWS::RDS::DBSecurityGroup.EC2VpcId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-ec2vpcid
     */
    ec2VpcId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html#cfn-rds-dbsecuritygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
export declare namespace CfnDBSecurityGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html
     */
    interface IngressProperty {
        /**
         * `CfnDBSecurityGroup.IngressProperty.CIDRIP`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-cidrip
         */
        readonly cidrip?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupid
         */
        readonly ec2SecurityGroupId?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupname
         */
        readonly ec2SecurityGroupName?: string;
        /**
         * `CfnDBSecurityGroup.IngressProperty.EC2SecurityGroupOwnerId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group-rule.html#cfn-rds-securitygroup-ec2securitygroupownerid
         */
        readonly ec2SecurityGroupOwnerId?: string;
    }
}
/**
 * Properties for defining a `AWS::RDS::DBSecurityGroupIngress`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
export interface CfnDBSecurityGroupIngressProps {
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     */
    readonly dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     */
    readonly cidrip?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     */
    readonly ec2SecurityGroupId?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     */
    readonly ec2SecurityGroupName?: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     */
    readonly ec2SecurityGroupOwnerId?: string;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
export declare class CfnDBSecurityGroupIngress extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSecurityGroupIngress;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.DBSecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-dbsecuritygroupname
     */
    dbSecurityGroupName: string;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.CIDRIP`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-cidrip
     */
    cidrip: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupid
     */
    ec2SecurityGroupId: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupname
     */
    ec2SecurityGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSecurityGroupIngress.EC2SecurityGroupOwnerId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html#cfn-rds-securitygroup-ingress-ec2securitygroupownerid
     */
    ec2SecurityGroupOwnerId: string | undefined;
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSecurityGroupIngressProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::DBSubnetGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 */
export interface CfnDBSubnetGroupProps {
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     */
    readonly dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 */
export declare class CfnDBSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSubnetGroup;
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupdescription
     */
    dbSubnetGroupDescription: string;
    /**
     * `AWS::RDS::DBSubnetGroup.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::RDS::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-dbsubnetgroupname
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::RDS::DBSubnetGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html#cfn-rds-dbsubnetgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSubnetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::EventSubscription`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
export interface CfnEventSubscriptionProps {
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     */
    readonly snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     */
    readonly eventCategories?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     */
    readonly sourceIds?: string[];
    /**
     * `AWS::RDS::EventSubscription.SourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     */
    readonly sourceType?: string;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`.
 *
 * @external
 * @cloudformationResource AWS::RDS::EventSubscription
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
export declare class CfnEventSubscription extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventSubscription;
    /**
     * `AWS::RDS::EventSubscription.SnsTopicArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-snstopicarn
     */
    snsTopicArn: string;
    /**
     * `AWS::RDS::EventSubscription.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::EventSubscription.EventCategories`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-eventcategories
     */
    eventCategories: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourceids
     */
    sourceIds: string[] | undefined;
    /**
     * `AWS::RDS::EventSubscription.SourceType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html#cfn-rds-eventsubscription-sourcetype
     */
    sourceType: string | undefined;
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSubscriptionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::GlobalCluster`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 */
export interface CfnGlobalClusterProps {
    /**
     * `AWS::RDS::GlobalCluster.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::RDS::GlobalCluster.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine
     */
    readonly engine?: string;
    /**
     * `AWS::RDS::GlobalCluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::RDS::GlobalCluster.GlobalClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier
     */
    readonly globalClusterIdentifier?: string;
    /**
     * `AWS::RDS::GlobalCluster.SourceDBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier
     */
    readonly sourceDbClusterIdentifier?: string;
    /**
     * `AWS::RDS::GlobalCluster.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::RDS::GlobalCluster`.
 *
 * @external
 * @cloudformationResource AWS::RDS::GlobalCluster
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 */
export declare class CfnGlobalCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::GlobalCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGlobalCluster;
    /**
     * `AWS::RDS::GlobalCluster.DeletionProtection`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-deletionprotection
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::RDS::GlobalCluster.Engine`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engine
     */
    engine: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.EngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.GlobalClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-globalclusteridentifier
     */
    globalClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.SourceDBClusterIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-sourcedbclusteridentifier
     */
    sourceDbClusterIdentifier: string | undefined;
    /**
     * `AWS::RDS::GlobalCluster.StorageEncrypted`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html#cfn-rds-globalcluster-storageencrypted
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGlobalClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RDS::OptionGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export interface CfnOptionGroupProps {
    /**
     * `AWS::RDS::OptionGroup.EngineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     */
    readonly engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     */
    readonly majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     */
    readonly optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     */
    readonly optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export declare class CfnOptionGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOptionGroup;
    /**
     * `AWS::RDS::OptionGroup.EngineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-enginename
     */
    engineName: string;
    /**
     * `AWS::RDS::OptionGroup.MajorEngineVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-majorengineversion
     */
    majorEngineVersion: string;
    /**
     * `AWS::RDS::OptionGroup.OptionConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optionconfigurations
     */
    optionConfigurations: Array<CfnOptionGroup.OptionConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RDS::OptionGroup.OptionGroupDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-optiongroupdescription
     */
    optionGroupDescription: string;
    /**
     * `AWS::RDS::OptionGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html#cfn-rds-optiongroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOptionGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export declare namespace CfnOptionGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html
     */
    interface OptionConfigurationProperty {
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.DBSecurityGroupMemberships`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-dbsecuritygroupmemberships
         */
        readonly dbSecurityGroupMemberships?: string[];
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionname
         */
        readonly optionName: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionSettings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-optionsettings
         */
        readonly optionSettings?: Array<CfnOptionGroup.OptionSettingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.OptionVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfiguration-optionversion
         */
        readonly optionVersion?: string;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-port
         */
        readonly port?: number;
        /**
         * `CfnOptionGroup.OptionConfigurationProperty.VpcSecurityGroupMemberships`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations.html#cfn-rds-optiongroup-optionconfigurations-vpcsecuritygroupmemberships
         */
        readonly vpcSecurityGroupMemberships?: string[];
    }
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`.
 *
 * @external
 * @cloudformationResource AWS::RDS::OptionGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
export declare namespace CfnOptionGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html
     */
    interface OptionSettingProperty {
        /**
         * `CfnOptionGroup.OptionSettingProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-name
         */
        readonly name?: string;
        /**
         * `CfnOptionGroup.OptionSettingProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-optiongroup-optionconfigurations-optionsettings.html#cfn-rds-optiongroup-optionconfigurations-optionsettings-value
         */
        readonly value?: string;
    }
}
