__all__ = ('BankCardPaymentPoint',)

from expressmoney.api import *

SERVICE = 'payments'


class BankCardPaymentCreateContract(Contract):
    amount = serializers.DecimalField(max_digits=16, decimal_places=0, min_value=1)
    withdraw = serializers.BooleanField()
    bank_card = serializers.IntegerField(min_value=1)
    order_id = serializers.IntegerField()
    order_type = serializers.CharField(max_length=128)


class PaymentInvoiceCreateContract(Contract):
    amount = serializers.DecimalField(max_digits=16, decimal_places=2)
    user_id = serializers.IntegerField(min_value=1)
    loan_type = serializers.CharField(max_length=16)
    description = serializers.CharField(max_length=512)


class PaymentInvoiceResponseContract(Contract):
    url = serializers.CharField(max_length=512)
    transaction_number = serializers.IntegerField(min_value=1)
    payment_invoice_id = serializers.IntegerField(min_value=1)


class BankCardPaymentResponseContract(Contract):
    id = serializers.IntegerField(min_value=1)
    created = serializers.DateTimeField()


class BankCardPaymentReadContract(BankCardPaymentCreateContract):
    id = serializers.IntegerField(min_value=1)
    created = serializers.DateTimeField()


class BankCardPaymentID(ID):
    _service = SERVICE
    _app = 'payments'
    _view_set = 'bank_card_payment'


class PaymentInvoiceID(ID):
    _service = SERVICE
    _app = 'payments'
    _view_set = 'payment_invoice'


class BankCardPaymentPoint(ListPointMixin, ResponseMixin, CreatePointMixin, ContractPoint):
    _point_id = BankCardPaymentID()
    _create_contract = BankCardPaymentCreateContract
    _response_contract = BankCardPaymentResponseContract
    _read_contract = BankCardPaymentReadContract


class PaymentInvoicePoint(CreatePointMixin, ResponseMixin, ContractPoint):
    _point_id = PaymentInvoiceID()
    _create_contract = PaymentInvoiceCreateContract
    _response_contract = PaymentInvoiceResponseContract
