/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./js/components/AdminLink.tsx":
/*!*************************************!*\
  !*** ./js/components/AdminLink.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
var _excluded = ["page", "path", "alt", "children"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }






function AdminLink(_ref) {
  var page = _ref.page,
      path = _ref.path,
      alt = _ref.alt,
      children = _ref.children,
      otherProps = _objectWithoutProperties(_ref, _excluded);

  var current = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)();
  var recordMatches = path === current.path && alt === current.alt;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_3__.NavLink, _extends({
    to: (0,_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_2__.adminPath)(page, path, alt),
    activeClassName: "active",
    isActive: function isActive(match) {
      return recordMatches && match != null;
    }
  }, otherProps), children);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(AdminLink));

/***/ }),

/***/ "./js/components/AdminLinkWithHotkey.tsx":
/*!***********************************************!*\
  !*** ./js/components/AdminLinkWithHotkey.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AdminLinkWithHotkey)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./js/utils.ts");
/* harmony import */ var _AdminLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AdminLink */ "./js/components/AdminLink.tsx");
var _excluded = ["children", "shortcut"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }




/**
 * React hook to add a global keyboard shortcut for the given
 * key for the lifetime of the component.
 */

function useKeyboardShortcut(key, action) {
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handler = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.keyboardShortcutHandler)(key, action);
    window.addEventListener("keydown", handler);
    return function () {
      return window.removeEventListener("keydown", handler);
    };
  }, [key, action]);
}
/**
 * Add a global keyboard shortcut for the given key and simulate
 * a click on the ref'ed element.
 */


function useKeyboardShortcutRef(key) {
  var el = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var handler = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    var _el$current;

    (_el$current = el.current) === null || _el$current === void 0 ? void 0 : _el$current.click();
  }, []);
  useKeyboardShortcut(key, handler);
  return el;
}

function AdminLinkWithHotkey(_ref) {
  var children = _ref.children,
      shortcut = _ref.shortcut,
      linkProps = _objectWithoutProperties(_ref, _excluded);

  var el = useKeyboardShortcutRef(shortcut);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AdminLink__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({}, linkProps, {
    title: (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getKey)(shortcut),
    ref: el
  }), children);
}

/***/ }),

/***/ "./js/components/DialogSlot.tsx":
/*!**************************************!*\
  !*** ./js/components/DialogSlot.tsx ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DialogSlot)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _dialogs_find_files_FindFiles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dialogs/find-files/FindFiles */ "./js/dialogs/find-files/FindFiles.tsx");
/* harmony import */ var _dialogs_Publish__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dialogs/Publish */ "./js/dialogs/Publish.tsx");
/* harmony import */ var _dialogs_Refresh__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dialogs/Refresh */ "./js/dialogs/Refresh.tsx");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../events */ "./js/events.ts");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






function DialogSlot() {
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      dialog = _useState2[0],
      setDialog = _useState2[1];

  var dismiss = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    return setDialog(function (c) {
      return c !== null && c !== void 0 && c.preventNavigation ? c : null;
    });
  }, []);
  var prevent = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (preventNavigation) {
    return setDialog(function (d) {
      return d ? _objectSpread(_objectSpread({}, d), {}, {
        preventNavigation: preventNavigation
      }) : null;
    });
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handler = function handler(_ref) {
      var detail = _ref.detail;
      // Only change dialog if there is no dialog yet.
      setDialog(function (current) {
        return current !== null && current !== void 0 ? current : detail;
      });
    };

    (0,_events__WEBPACK_IMPORTED_MODULE_4__.subscribe)("lektor-dialog", handler);
    return function () {
      return (0,_events__WEBPACK_IMPORTED_MODULE_4__.unsubscribe)("lektor-dialog", handler);
    };
  }, []);

  if (!dialog) {
    return null;
  }

  if (dialog.type === "find-files") {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dialogs_find_files_FindFiles__WEBPACK_IMPORTED_MODULE_1__["default"], {
      dismiss: dismiss
    });
  } else if (dialog.type === "refresh") {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dialogs_Refresh__WEBPACK_IMPORTED_MODULE_3__["default"], {
      dismiss: dismiss,
      preventNavigation: prevent
    });
  } else if (dialog.type === "publish") {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_dialogs_Publish__WEBPACK_IMPORTED_MODULE_2__["default"], {
      dismiss: dismiss,
      preventNavigation: prevent
    });
  }

  var exhaustiveCheck = dialog.type;
  throw new Error(exhaustiveCheck);
}

/***/ }),

/***/ "./js/components/ErrorDialog.tsx":
/*!***************************************!*\
  !*** ./js/components/ErrorDialog.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorDialog)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _SlideDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SlideDialog */ "./js/components/SlideDialog.tsx");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../events */ "./js/events.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }





/**
 * Listen to events and show an error dialog (potentially on top of an open
 * dialog).
 */

function ErrorDialog() {
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      error = _useState2[0],
      setError = _useState2[1];

  var dismiss = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    return setError(null);
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handler = function handler(_ref) {
      var detail = _ref.detail;
      return setError(detail);
    };

    (0,_events__WEBPACK_IMPORTED_MODULE_3__.subscribe)("lektor-error", handler);
    return function () {
      return (0,_events__WEBPACK_IMPORTED_MODULE_3__.unsubscribe)("lektor-error", handler);
    };
  }, []);

  if (!error) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SlideDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dismiss: dismiss,
    hasCloseButton: false,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_OCURRED"), ": ", (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_" + error.code)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    onClick: dismiss
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("CLOSE"))));
}

/***/ }),

/***/ "./js/components/ServerStatus.tsx":
/*!****************************************!*\
  !*** ./js/components/ServerStatus.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ServerStatus)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




function ServerStatus() {
  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({
    serverIsUp: true,
    projectId: null
  }),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var onInterval = function onInterval() {
      (0,_fetch__WEBPACK_IMPORTED_MODULE_1__.get)("/ping", null).then(function (_ref) {
        var project_id = _ref.project_id;
        setState(function (_ref2) {
          var projectId = _ref2.projectId;
          return projectId === null ? {
            projectId: project_id,
            serverIsUp: true
          } : {
            projectId: projectId,
            serverIsUp: projectId === project_id
          };
        });
      }, function () {
        setState(function (s) {
          return _objectSpread(_objectSpread({}, s), {}, {
            serverIsUp: false
          });
        });
      });
    };

    var id = window.setInterval(onInterval, 2000);
    return function () {
      return window.clearInterval(id);
    };
  }, []);

  if (state.serverIsUp) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "interface-protector server-down-panel"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "server-down-dialog"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_SERVER_UNAVAILABLE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_SERVER_UNAVAILABLE_MESSAGE"))));
}

/***/ }),

/***/ "./js/components/SlideDialog.tsx":
/*!***************************************!*\
  !*** ./js/components/SlideDialog.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SlideDialog)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");


function SlideDialog(_ref) {
  var title = _ref.title,
      hasCloseButton = _ref.hasCloseButton,
      dismiss = _ref.dismiss,
      children = _ref.children;
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handler = function handler(ev) {
      if (ev.key === "Escape") {
        ev.preventDefault();
        dismiss();
      }
    };

    window.addEventListener("keydown", handler);
    return function () {
      return window.removeEventListener("keydown", handler);
    };
  }, [dismiss]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.scrollTo(0, 0);
  }, []);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "dialog-slot"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "container"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "sliding-panel col-md-6 offset-md-3"
  }, hasCloseButton && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", {
    href: "#",
    className: "close-btn",
    onClick: function onClick(ev) {
      ev.preventDefault();
      dismiss();
    }
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("CLOSE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, title), children)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "interface-protector"
  }));
}

/***/ }),

/***/ "./js/components/ToggleGroup.tsx":
/*!***************************************!*\
  !*** ./js/components/ToggleGroup.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ToggleGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


function ToggleGroup(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? "" : _ref$className,
      groupTitle = _ref.groupTitle,
      children = _ref.children;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var toggle = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    event.preventDefault();
    setOpen(function (v) {
      return !v;
    });
  }, []);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: open ? "".concat(className, " toggle-group") : "".concat(className, " toggle-group closed")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h4", {
    className: "toggle-group-header",
    onClick: toggle
  }, groupTitle), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "toggle-group-content"
  }, children));
}

/***/ }),

/***/ "./js/components/use-go-to-admin-page.ts":
/*!***********************************************!*\
  !*** ./js/components/use-go-to-admin-page.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "adminPath": () => (/* binding */ adminPath),
/* harmony export */   "useGoToAdminPage": () => (/* binding */ useGoToAdminPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/esm/react-router.js");



/**
 * Compute an admin path.
 * @param page - e.g. edit or preview
 * @param path - fs path to the record
 * @param alt - the alternative to use.
 * @returns
 */
function adminPath(page, path, alt) {
  var params = new URLSearchParams({
    path: path
  });

  if (alt !== "_primary") {
    params.set("alt", alt);
  }

  return "".concat($LEKTOR_CONFIG.admin_root, "/").concat(page, "?").concat(params);
}
/**
 * Use a function to change the admin page.
 * @returns A function to navigate to an admin page for a given view
 *          and page fs path and alt.
 */

function useGoToAdminPage() {
  var history = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_1__.useHistory)();
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (name, path, alt) {
    history.push(adminPath(name, path, alt));
  }, [history]);
}

/***/ }),

/***/ "./js/context/page-context.ts":
/*!************************************!*\
  !*** ./js/context/page-context.ts ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PAGE_NAMES": () => (/* binding */ PAGE_NAMES),
/* harmony export */   "isPageName": () => (/* binding */ isPageName),
/* harmony export */   "PageContext": () => (/* binding */ PageContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

var PAGE_NAMES = ["edit", "delete", "preview", "add-child", "upload"];
function isPageName(p) {
  return PAGE_NAMES.includes(p);
}
/** The currently rendered page of the Lektor admin interface. */

var PageContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)("edit");

/***/ }),

/***/ "./js/context/record-context.ts":
/*!**************************************!*\
  !*** ./js/context/record-context.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RecordContext": () => (/* binding */ RecordContext),
/* harmony export */   "useRecord": () => (/* binding */ useRecord),
/* harmony export */   "useRecordAlt": () => (/* binding */ useRecordAlt),
/* harmony export */   "useRecordPath": () => (/* binding */ useRecordPath)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");

/** Path to a Lektor record. */

var RecordContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({
  path: "/",
  alt: "_primary"
});
/** The current record. */

function useRecord() {
  return (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(RecordContext);
}
/** The alternative of the currently active record. */

function useRecordAlt() {
  var record = useRecord();
  return record.alt;
}
/** The path of the currently active record. */

function useRecordPath() {
  var record = useRecord();
  return record.path;
}

/***/ }),

/***/ "./js/dialogs/Publish.tsx":
/*!********************************!*\
  !*** ./js/dialogs/Publish.tsx ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _components_SlideDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/SlideDialog */ "./js/components/SlideDialog.tsx");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }







/**
 * Render a <select for the available target servers.
 */
function TargetServers(_ref) {
  var activeTarget = _ref.activeTarget,
      servers = _ref.servers,
      setActiveTarget = _ref.setActiveTarget;

  function onChange(event) {
    setActiveTarget(event.target.value);
  }

  var serverOptions = servers.map(function (server) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("option", {
      value: server.id,
      key: server.id
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_fallback)(server.name_i18n, server.name) + " (" + server.short_target + ")");
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH_SERVER")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "input-group"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("select", {
    value: activeTarget,
    onChange: onChange,
    className: "form-control"
  }, serverOptions))));
}

function BuildLog(_ref2) {
  var log = _ref2.log;
  var buildLog = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var node = buildLog.current;

    if (node) {
      node.scrollTop = node.scrollHeight;
    }
  }, [log]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", {
    ref: buildLog,
    className: "build-log"
  }, log.join("\n"));
}

function Publish(_ref3) {
  var dismiss = _ref3.dismiss,
      preventNavigation = _ref3.preventNavigation;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]),
      _useState2 = _slicedToArray(_useState, 2),
      servers = _useState2[0],
      setServers = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
      _useState4 = _slicedToArray(_useState3, 2),
      activeTarget = _useState4[0],
      setActiveTarget = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]),
      _useState6 = _slicedToArray(_useState5, 2),
      log = _useState6[0],
      setLog = _useState6[1];

  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("IDLE"),
      _useState8 = _slicedToArray(_useState7, 2),
      state = _useState8[0],
      setState = _useState8[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/servers", null).then(function (_ref4) {
      var servers = _ref4.servers;
      setServers(servers);
      setActiveTarget(servers.length ? servers[0].id : "");
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
  }, []);
  var onPublish = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    setLog([]);
    setState("BUILDING");
    preventNavigation(true);
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.post)("/build", null).then(function () {
      setState("PUBLISH");
      var eventSource = new EventSource((0,_fetch__WEBPACK_IMPORTED_MODULE_2__.apiUrl)("/publish", {
        server: activeTarget
      }));
      eventSource.addEventListener("message", function (event) {
        var data = JSON.parse(event.data);

        if (data === null) {
          setState("DONE");
          preventNavigation(false);
          eventSource.close();
        } else {
          setLog(function (log) {
            return log.concat(data.msg);
          });
        }
      });
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
  }, [activeTarget, preventNavigation]);
  var isSafeToPublish = state === "IDLE" || state === "DONE";
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_SlideDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dismiss: dismiss,
    hasCloseButton: false,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH_NOTE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(TargetServers, {
    activeTarget: activeTarget,
    servers: servers,
    setActiveTarget: setActiveTarget
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    disabled: !isSafeToPublish,
    onClick: onPublish
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH")), " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    disabled: !isSafeToPublish,
    onClick: dismiss
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)(state === "DONE" ? "CLOSE" : "CANCEL"))), state !== "IDLE" ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, state !== "DONE" ? (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("CURRENTLY_PUBLISHING") : (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH_DONE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("pre", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("STATE") + ": " + (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PUBLISH_STATE_".concat(state))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(BuildLog, {
    log: log
  })) : null);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Publish);

/***/ }),

/***/ "./js/dialogs/Refresh.tsx":
/*!********************************!*\
  !*** ./js/dialogs/Refresh.tsx ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Refresh)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _components_SlideDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/SlideDialog */ "./js/components/SlideDialog.tsx");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






function Refresh(_ref) {
  var dismiss = _ref.dismiss,
      preventNavigation = _ref.preventNavigation;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("IDLE"),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var isSafeToNavigate = state === "IDLE" || state === "DONE";
  var refresh = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    setState("CLEANING");
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.post)("/clean", null).then(function () {
      setState("DONE");
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
  }, []);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    return preventNavigation(!isSafeToNavigate);
  }, [preventNavigation, isSafeToNavigate]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_SlideDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    dismiss: dismiss,
    hasCloseButton: false,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("REFRESH_BUILD")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("REFRESH_BUILD_NOTE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    disabled: !isSafeToNavigate,
    onClick: refresh
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("REFRESH_BUILD")), " ", /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    disabled: !isSafeToNavigate,
    onClick: dismiss
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)(state === "DONE" ? "CLOSE" : "CANCEL"))), state !== "IDLE" && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, state !== "DONE" ? (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("CURRENTLY_REFRESHING_BUILD") : (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("REFRESHING_BUILD_DONE"))));
}

/***/ }),

/***/ "./js/dialogs/find-files/FindFiles.tsx":
/*!*********************************************!*\
  !*** ./js/dialogs/find-files/FindFiles.tsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _components_SlideDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/SlideDialog */ "./js/components/SlideDialog.tsx");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _ResultRow__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ResultRow */ "./js/dialogs/find-files/ResultRow.tsx");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../context/page-context */ "./js/context/page-context.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }











function FindFiles(_ref) {
  var dismiss = _ref.dismiss;
  var alt = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecordAlt)();
  var page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_context_page_context__WEBPACK_IMPORTED_MODULE_8__.PageContext);

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
      _useState2 = _slicedToArray(_useState, 2),
      query = _useState2[0],
      setQuery = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]),
      _useState4 = _slicedToArray(_useState3, 2),
      results = _useState4[0],
      setResults = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(-1),
      _useState6 = _slicedToArray(_useState5, 2),
      selected = _useState6[0],
      setSelected = _useState6[1];

  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_7__.useGoToAdminPage)();
  var target = page === "preview" ? "preview" : "edit";
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    if (!query) {
      setResults([]);
      setSelected(-1);
      return;
    }

    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.post)("/find", {
      q: query,
      alt: alt,
      lang: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.getCurrentLanguge)()
    }).then(function (_ref2) {
      var results = _ref2.results;

      if (!ignore) {
        setResults(results);
        setSelected(function (selected) {
          return Math.min(selected, results.length - 1);
        });
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [alt, query]);
  var onInputKey = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    if (event.key === "ArrowDown") {
      event.preventDefault();
      setSelected(function (selected) {
        return (selected + 1) % results.length;
      });
    } else if (event.key === "ArrowUp") {
      event.preventDefault();
      setSelected(function (selected) {
        return (selected - 1 + results.length) % results.length;
      });
    } else if (event.key === "Enter") {
      var item = results[selected];

      if (item) {
        dismiss();
        goToAdminPage(target, item.path, alt);
      }
    }
  }, [alt, dismiss, goToAdminPage, results, selected, target]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_SlideDialog__WEBPACK_IMPORTED_MODULE_2__["default"], {
    dismiss: dismiss,
    hasCloseButton: true,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("FIND_FILES")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    type: "text",
    autoFocus: true,
    className: "form-control",
    value: query,
    onChange: function onChange(ev) {
      return setQuery(ev.target.value);
    },
    onKeyDown: onInputKey,
    placeholder: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("FIND_FILES_PLACEHOLDER")
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "search-results"
  }, results.map(function (result, idx) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ResultRow__WEBPACK_IMPORTED_MODULE_6__["default"], {
      key: result.path,
      result: result,
      isActive: idx === selected,
      dismiss: dismiss,
      alt: alt,
      target: target
    });
  })));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FindFiles);

/***/ }),

/***/ "./js/dialogs/find-files/ResultRow.tsx":
/*!*********************************************!*\
  !*** ./js/dialogs/find-files/ResultRow.tsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ResultRow)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../components/AdminLink */ "./js/components/AdminLink.tsx");



/**
 * A page in the result list in the find files dialog.
 */
function ResultRow(_ref) {
  var result = _ref.result,
      isActive = _ref.isActive,
      dismiss = _ref.dismiss,
      alt = _ref.alt,
      target = _ref.target;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: isActive ? "active" : ""
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
    page: target,
    path: result.path,
    alt: alt,
    onClick: dismiss
  }, result.parents.map(function (item) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
      key: item.title
    }, item.title);
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("strong", null, result.title)));
}

/***/ }),

/***/ "./js/error-dialog.ts":
/*!****************************!*\
  !*** ./js/error-dialog.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "showErrorDialog": () => (/* binding */ showErrorDialog)
/* harmony export */ });
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./events */ "./js/events.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fetch */ "./js/fetch.ts");


function showErrorDialog(error) {
  if (error instanceof _fetch__WEBPACK_IMPORTED_MODULE_1__.FetchError) {
    (0,_events__WEBPACK_IMPORTED_MODULE_0__.dispatch)("lektor-error", error);
  } else {
    console.error("unknown error:", error);
  }
}

/***/ }),

/***/ "./js/events.ts":
/*!**********************!*\
  !*** ./js/events.ts ***!
  \**********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dispatch": () => (/* binding */ dispatch),
/* harmony export */   "subscribe": () => (/* binding */ subscribe),
/* harmony export */   "unsubscribe": () => (/* binding */ unsubscribe)
/* harmony export */ });
/** Dispatch one of the custom events. */
function dispatch(type, detail) {
  document.dispatchEvent(new CustomEvent(type, {
    detail: detail
  }));
}
/** Subscribe to one of Lektor's custom events. */

function subscribe(type, handler) {
  document.addEventListener(type, handler);
}
/** Subscribe from one of Lektor's custom events. */

function unsubscribe(type, handler) {
  document.removeEventListener(type, handler);
}

/***/ }),

/***/ "./js/fetch.ts":
/*!*********************!*\
  !*** ./js/fetch.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FetchError": () => (/* binding */ FetchError),
/* harmony export */   "apiUrl": () => (/* binding */ apiUrl),
/* harmony export */   "get": () => (/* binding */ get),
/* harmony export */   "post": () => (/* binding */ post),
/* harmony export */   "put": () => (/* binding */ put)
/* harmony export */ });
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }

function _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _isNativeFunction(fn) { return Function.toString.call(fn).indexOf("[native code]") !== -1; }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var FetchError = /*#__PURE__*/function (_Error) {
  _inherits(FetchError, _Error);

  var _super = _createSuper(FetchError);

  function FetchError(code) {
    var _this;

    _classCallCheck(this, FetchError);

    _this = _super.call(this);
    _this.code = code;
    return _this;
  }

  return _createClass(FetchError);
}( /*#__PURE__*/_wrapNativeSuper(Error));
/**
 * Handle a JSON response - throw on HTTP error.
 */

function handleJSON(response) {
  if (!response.ok) {
    throw new FetchError("REQUEST_FAILED");
  }

  return response.json();
}

var credentials = "same-origin";
var headers = {
  "Content-Type": "application/json"
};
/**
 * Helper to execute one of the fetch requests to the Lektor admin API.
 */

function fetchJSON(input, method, json) {
  var init = json === undefined ? {
    credentials: credentials,
    method: method
  } : {
    credentials: credentials,
    method: method,
    headers: headers,
    body: JSON.stringify(json)
  };
  return fetch(input, init).then(handleJSON);
}
/** Required URL parameters for GET API endpoints. */


/**
 * URL to one of Lektor's API endpoints with query string.
 * @param endpoint - the API endpoint
 * @param params - possible URL parameters to include in the query string
 * @returns the absolute API URL with query string.
 */
function apiUrl(endpoint, params) {
  var url = "".concat($LEKTOR_CONFIG.admin_root, "/api").concat(endpoint);

  if (params) {
    var urlParams = new URLSearchParams();
    Object.entries(params).forEach(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          key = _ref2[0],
          value = _ref2[1];

      urlParams.set(key, value);
    });
    return "".concat(url, "?").concat(urlParams.toString());
  }

  return url;
}
/**
 * Load data from the JSON API.
 * @param endpoint - The API endpoint to get.
 * @param params - URL params to set.
 * @param json - Possible JSON body of the request.
 */

function get(endpoint, params) {
  var url = apiUrl(endpoint, params);
  return fetchJSON(url, "GET");
}
/**
 * Execute a POST api request.
 * @param endpoint - The API endpoint to POST to.
 * @param params - URL params to set.
 * @param json - Possible JSON body of the request.
 */

function post(endpoint, params, json) {
  var url = apiUrl(endpoint, params);
  return fetchJSON(url, "POST", json);
}
/**
 * Execute a PUT api request.
 * @param endpoint - The API endpoint to PUT to.
 * @param json - Possible JSON body of the request.
 */

function put(endpoint, json) {
  var url = apiUrl(endpoint);
  return fetchJSON(url, "PUT", json);
}

/***/ }),

/***/ "./js/header/BreadCrumbs.tsx":
/*!***********************************!*\
  !*** ./js/header/BreadCrumbs.tsx ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/AdminLink */ "./js/components/AdminLink.tsx");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../context/page-context */ "./js/context/page-context.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }









function Crumb(_ref) {
  var alt = _ref.alt,
      item = _ref.item,
      targetPage = _ref.targetPage;
  var path = item.path,
      exists = item.exists;
  var label = exists ? (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_fallback)(item.label_i18n, item.label) : item.id;
  var className = exists ? "breadcrumb-item" : "breadcrumb-item missing-record-crumb";
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: className
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_5__["default"], {
    page: targetPage,
    path: path,
    alt: alt
  }, label));
}

function AddNewPage(_ref2) {
  var alt = _ref2.alt,
      item = _ref2.item;
  return item.can_have_children ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: "new-record-crumb"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_5__["default"], {
    page: "add-child",
    path: item.path,
    alt: alt
  }, "+")) : null;
}

function BreadCrumbs() {
  var page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_context_page_context__WEBPACK_IMPORTED_MODULE_6__.PageContext);

  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      segments = _useState2[0],
      setSegments = _useState2[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/pathinfo", {
      path: path
    }).then(function (resp) {
      if (!ignore) {
        setSegments(resp.segments);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path]);

  if (!segments) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
      className: "breadcrumb"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_5__["default"], {
      page: "edit",
      path: "/",
      alt: "_primary"
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("BACK_TO_OVERVIEW"))));
  }

  var target = page === "preview" ? "preview" : "edit";
  var lastItem = segments[segments.length - 1];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "breadcrumb"
  }, segments.map(function (item) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Crumb, {
      key: item.path,
      item: item,
      alt: alt,
      targetPage: target
    });
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(AddNewPage, {
    item: lastItem,
    alt: alt
  }));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BreadCrumbs);

/***/ }),

/***/ "./js/header/GlobalActions.tsx":
/*!*************************************!*\
  !*** ./js/header/GlobalActions.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ GlobalActions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils */ "./js/utils.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../events */ "./js/events.ts");








var findFiles = function findFiles() {
  return (0,_events__WEBPACK_IMPORTED_MODULE_6__.dispatch)("lektor-dialog", {
    type: "find-files"
  });
};

var refresh = function refresh() {
  return (0,_events__WEBPACK_IMPORTED_MODULE_6__.dispatch)("lektor-dialog", {
    type: "refresh"
  });
};

var publish = function publish() {
  return (0,_events__WEBPACK_IMPORTED_MODULE_6__.dispatch)("lektor-dialog", {
    type: "publish"
  });
};

var onKeyPress = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.keyboardShortcutHandler)({
  key: "Control+g",
  mac: "Meta+g",
  preventDefault: true
}, findFiles);
function GlobalActions() {
  var record = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("keydown", onKeyPress);
    return function () {
      return window.removeEventListener("keydown", onKeyPress);
    };
  }, []);
  var returnToWebsite = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.get)("/previewinfo", record).then(function (_ref) {
      var url = _ref.url;
      window.location.href = url === null ? (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getCanonicalUrl)("/") : (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getCanonicalUrl)(url);
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
  }, [record]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "btn-group"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: findFiles,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("FIND_FILES")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-search fa-fw"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: publish,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("PUBLISH")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-cloud-upload fa-fw"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: refresh,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("REFRESH_BUILD")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-refresh fa-fw"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: returnToWebsite,
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_4__.trans)("RETURN_TO_WEBSITE")
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-eye fa-fw"
  })));
}

/***/ }),

/***/ "./js/header/Header.tsx":
/*!******************************!*\
  !*** ./js/header/Header.tsx ***!
  \******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Header)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _BreadCrumbs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BreadCrumbs */ "./js/header/BreadCrumbs.tsx");
/* harmony import */ var _GlobalActions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./GlobalActions */ "./js/header/GlobalActions.tsx");



function Header(_ref) {
  var sidebarIsActive = _ref.sidebarIsActive,
      toggleSidebar = _ref.toggleSidebar;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("header", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "container"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: sidebarIsActive ? "fa fa-bars navbar-toggle active" : "fa fa-bars navbar-toggle",
    onClick: toggleSidebar,
    "aria-label": "Toggle navigation"
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "d-flex justify-content-between"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadCrumbs__WEBPACK_IMPORTED_MODULE_1__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_GlobalActions__WEBPACK_IMPORTED_MODULE_2__["default"], null)))));
}

/***/ }),

/***/ "./js/i18n.tsx":
/*!*********************!*\
  !*** ./js/i18n.tsx ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "translations": () => (/* binding */ translations),
/* harmony export */   "setCurrentLanguage": () => (/* binding */ setCurrentLanguage),
/* harmony export */   "getCurrentLanguge": () => (/* binding */ getCurrentLanguge),
/* harmony export */   "trans": () => (/* binding */ trans),
/* harmony export */   "trans_obj": () => (/* binding */ trans_obj),
/* harmony export */   "trans_fallback": () => (/* binding */ trans_fallback),
/* harmony export */   "trans_format": () => (/* binding */ trans_format)
/* harmony export */ });
/* harmony import */ var _lektor_translations_ca_json__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../lektor/translations/ca.json */ "../lektor/translations/ca.json");
/* harmony import */ var _lektor_translations_de_json__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../lektor/translations/de.json */ "../lektor/translations/de.json");
/* harmony import */ var _lektor_translations_en_json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../lektor/translations/en.json */ "../lektor/translations/en.json");
/* harmony import */ var _lektor_translations_es_json__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../lektor/translations/es.json */ "../lektor/translations/es.json");
/* harmony import */ var _lektor_translations_fr_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../lektor/translations/fr.json */ "../lektor/translations/fr.json");
/* harmony import */ var _lektor_translations_it_json__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../lektor/translations/it.json */ "../lektor/translations/it.json");
/* harmony import */ var _lektor_translations_ja_json__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../lektor/translations/ja.json */ "../lektor/translations/ja.json");
/* harmony import */ var _lektor_translations_ko_json__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../lektor/translations/ko.json */ "../lektor/translations/ko.json");
/* harmony import */ var _lektor_translations_nl_json__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../lektor/translations/nl.json */ "../lektor/translations/nl.json");
/* harmony import */ var _lektor_translations_pl_json__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../lektor/translations/pl.json */ "../lektor/translations/pl.json");
/* harmony import */ var _lektor_translations_pt_json__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../lektor/translations/pt.json */ "../lektor/translations/pt.json");
/* harmony import */ var _lektor_translations_ru_json__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../lektor/translations/ru.json */ "../lektor/translations/ru.json");
/* harmony import */ var _lektor_translations_zh_json__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../lektor/translations/zh.json */ "../lektor/translations/zh.json");
var _translations$current;














var translations = {
  ca: _lektor_translations_ca_json__WEBPACK_IMPORTED_MODULE_0__,
  de: _lektor_translations_de_json__WEBPACK_IMPORTED_MODULE_1__,
  en: _lektor_translations_en_json__WEBPACK_IMPORTED_MODULE_2__,
  es: _lektor_translations_es_json__WEBPACK_IMPORTED_MODULE_3__,
  fr: _lektor_translations_fr_json__WEBPACK_IMPORTED_MODULE_4__,
  it: _lektor_translations_it_json__WEBPACK_IMPORTED_MODULE_5__,
  ja: _lektor_translations_ja_json__WEBPACK_IMPORTED_MODULE_6__,
  ko: _lektor_translations_ko_json__WEBPACK_IMPORTED_MODULE_7__,
  nl: _lektor_translations_nl_json__WEBPACK_IMPORTED_MODULE_8__,
  pl: _lektor_translations_pl_json__WEBPACK_IMPORTED_MODULE_9__,
  pt: _lektor_translations_pt_json__WEBPACK_IMPORTED_MODULE_10__,
  ru: _lektor_translations_ru_json__WEBPACK_IMPORTED_MODULE_11__,
  zh: _lektor_translations_zh_json__WEBPACK_IMPORTED_MODULE_12__
};
var currentLanguage = "en";
var currentTranslations = (_translations$current = translations[currentLanguage]) !== null && _translations$current !== void 0 ? _translations$current : {};
function setCurrentLanguage(lang) {
  currentLanguage = lang;
  currentTranslations = translations[currentLanguage];
}
function getCurrentLanguge() {
  return currentLanguage;
}

/**
 * Get translation for a key.
 * @param key - The translation key.
 */
function trans(key) {
  var _currentTranslations$;

  return (_currentTranslations$ = currentTranslations[key]) !== null && _currentTranslations$ !== void 0 ? _currentTranslations$ : key;
}
/**
 * Get translation from an object of translations
 * @param translation_object - The object containing translations.
 */

function trans_obj(translation_object) {
  var _ref, _translation_object$c;

  return (_ref = (_translation_object$c = translation_object[currentLanguage]) !== null && _translation_object$c !== void 0 ? _translation_object$c : translation_object.en) !== null && _ref !== void 0 ? _ref : "";
}
/**
 * Get translation for a key with a fallback.
 * @param translation_object - The translation key
 * @param fallback - A fallback to use if the translation is missing.
 */

function trans_fallback(translation_object, fallback) {
  if (!translation_object) {
    return fallback;
  }

  return trans_obj(translation_object) || fallback;
}
/**
 * Get translation for a key with a `%s` replacement.
 * @param key - The translation key
 * @param replacement - replacement for `%s`.
 */

function trans_format(key, replacement) {
  var translation = trans(key);
  return translation.replace("%s", replacement);
}

/***/ }),

/***/ "./js/main.tsx":
/*!*********************!*\
  !*** ./js/main.tsx ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-dom */ "./node_modules/react-dom/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/esm/react-router.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router-dom/esm/react-router-dom.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./i18n */ "./js/i18n.tsx");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _views_App__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./views/App */ "./js/views/App.tsx");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
/* harmony import */ var font_awesome_css_font_awesome_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! font-awesome/css/font-awesome.css */ "./node_modules/font-awesome/css/font-awesome.css");
/* harmony import */ var _scss_main_scss__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../scss/main.scss */ "./scss/main.scss");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./context/page-context */ "./js/context/page-context.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils */ "./js/utils.ts");












function Page(_ref) {
  var page = _ref.page;

  var _useLocation = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_10__.useLocation)(),
      search = _useLocation.search;

  var record = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    var _params$get, _params$get2;

    var params = new URLSearchParams(search);
    return {
      path: "/".concat((0,_utils__WEBPACK_IMPORTED_MODULE_9__.trimSlashes)((_params$get = params.get("path")) !== null && _params$get !== void 0 ? _params$get : "/")),
      alt: (_params$get2 = params.get("alt")) !== null && _params$get2 !== void 0 ? _params$get2 : "_primary"
    };
  }, [search]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_context_page_context__WEBPACK_IMPORTED_MODULE_8__.PageContext.Provider, {
    value: page
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_context_record_context__WEBPACK_IMPORTED_MODULE_3__.RecordContext.Provider, {
    value: record
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_views_App__WEBPACK_IMPORTED_MODULE_4__["default"], null)));
}

function Main() {
  var _useRouteMatch;

  var root = $LEKTOR_CONFIG.admin_root;
  var page = (_useRouteMatch = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_10__.useRouteMatch)("".concat(root, "/:page"))) === null || _useRouteMatch === void 0 ? void 0 : _useRouteMatch.params.page;

  if (!(0,_context_page_context__WEBPACK_IMPORTED_MODULE_8__.isPageName)(page)) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_10__.Redirect, {
      to: (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_5__.adminPath)("edit", "/", "_primary")
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Page, {
    page: page
  });
}

var dash = document.getElementById("dash");

if (dash) {
  (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.setCurrentLanguage)($LEKTOR_CONFIG.lang);
  react_dom__WEBPACK_IMPORTED_MODULE_1__.render( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_11__.BrowserRouter, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Main, null)), dash);
}

/***/ }),

/***/ "./js/sidebar/Alternatives.tsx":
/*!*************************************!*\
  !*** ./js/sidebar/Alternatives.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/AdminLink */ "./js/components/AdminLink.tsx");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context/page-context */ "./js/context/page-context.ts");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");






function Alternatives(_ref) {
  var alts = _ref.alts;
  var page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_context_page_context__WEBPACK_IMPORTED_MODULE_3__.PageContext);
  var path = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_4__.useRecordPath)();

  if (alts.length < 2) {
    return null;
  }

  var items = alts.map(function (item) {
    var title = (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(item.name_i18n);

    if (item.is_primary) {
      title += " (".concat((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("PRIMARY_ALT"), ")");
    } else if (item.primary_overlay) {
      title += " (".concat((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("PRIMARY_OVERLAY"), ")");
    }

    var className = item.exists ? "alt" : "alt alt-missing";
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: item.alt,
      className: className
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_2__["default"], {
      page: page,
      path: path,
      alt: item.alt
    }, title));
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ALTS")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "nav"
  }, items));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(Alternatives));

/***/ }),

/***/ "./js/sidebar/AttachmentActions.tsx":
/*!******************************************!*\
  !*** ./js/sidebar/AttachmentActions.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/AdminLink */ "./js/components/AdminLink.tsx");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");





function AttachmentActions(_ref) {
  var recordInfo = _ref.recordInfo;
  var alt = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_2__.useRecordAlt)();
  var attachments = recordInfo.attachments;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("ATTACHMENTS")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "nav"
  }, attachments.length > 0 ? attachments.map(function (atch) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: atch.id
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_1__["default"], {
      page: "edit",
      path: atch.path,
      alt: alt
    }, atch.id, " (", atch.type, ")"));
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "_missing"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("em", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("NO_ATTACHMENTS")))));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(AttachmentActions));

/***/ }),

/***/ "./js/sidebar/ChildActions.tsx":
/*!*************************************!*\
  !*** ./js/sidebar/ChildActions.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChildActions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _ChildPagination__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ChildPagination */ "./js/sidebar/ChildPagination.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "./js/sidebar/constants.ts");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/AdminLink */ "./js/components/AdminLink.tsx");






function ChildActions(_ref) {
  var targetPage = _ref.targetPage,
      allChildren = _ref.allChildren,
      page = _ref.page,
      setPage = _ref.setPage;
  var alt = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_2__.useRecordAlt)();
  var shownChildren = allChildren.slice((page - 1) * _constants__WEBPACK_IMPORTED_MODULE_4__.CHILDREN_PER_PAGE, page * _constants__WEBPACK_IMPORTED_MODULE_4__.CHILDREN_PER_PAGE);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("CHILD_PAGES")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "nav"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChildPagination__WEBPACK_IMPORTED_MODULE_3__["default"], {
    numberOfChildren: allChildren.length,
    page: page,
    setPage: setPage
  }), shownChildren.length > 0 ? shownChildren.map(function (child) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: child.id
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_5__["default"], {
      page: targetPage,
      path: child.path,
      alt: alt
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(child.label_i18n)));
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "_missing"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("em", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("NO_CHILD_PAGES")))));
}

/***/ }),

/***/ "./js/sidebar/ChildPagination.tsx":
/*!****************************************!*\
  !*** ./js/sidebar/ChildPagination.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChildPagination)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./js/sidebar/constants.ts");


/** Pagination buttons for the list of children in the sidebar. */

function ChildPagination(_ref) {
  var page = _ref.page,
      numberOfChildren = _ref.numberOfChildren,
      setPage = _ref.setPage;
  var pages = Math.ceil(numberOfChildren / _constants__WEBPACK_IMPORTED_MODULE_1__.CHILDREN_PER_PAGE);

  if (pages <= 1) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    className: "pagination"
  }, page > 1 ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", {
    href: "#",
    onClick: function onClick(ev) {
      ev.preventDefault();
      setPage(page - 1);
    }
  }, "\xAB") : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("em", null, "\xAB"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "page"
  }, page + " / " + pages), page < pages ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", {
    href: "#",
    onClick: function onClick(ev) {
      ev.preventDefault();
      setPage(page + 1);
    }
  }, "\xBB") : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("em", null, "\xBB"));
}

/***/ }),

/***/ "./js/sidebar/PageActions.tsx":
/*!************************************!*\
  !*** ./js/sidebar/PageActions.tsx ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils */ "./js/utils.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _components_AdminLinkWithHotkey__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/AdminLinkWithHotkey */ "./js/components/AdminLinkWithHotkey.tsx");
/* harmony import */ var _components_AdminLink__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/AdminLink */ "./js/components/AdminLink.tsx");









var getBrowseButtonTitle = function getBrowseButtonTitle() {
  var platform = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.getPlatform)();

  if (platform === "mac") {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("BROWSE_FS_MAC");
  } else if (platform === "windows") {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("BROWSE_FS_WINDOWS");
  } else {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("BROWSE_FS");
  }
};

function BrowseFSLink() {
  var record = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)();
  var fsOpen = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (ev) {
    ev.preventDefault();
    (0,_fetch__WEBPACK_IMPORTED_MODULE_4__.post)("/browsefs", record).then(function (_ref) {
      var okay = _ref.okay;

      if (!okay) {
        alert((0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_CANNOT_BROWSE_FS"));
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
  }, [record]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("a", {
    href: "#",
    onClick: fsOpen
  }, getBrowseButtonTitle());
}

var editKey = {
  key: "Control+e",
  mac: "Meta+e",
  preventDefault: true
};

function PageActions(_ref2) {
  var recordInfo = _ref2.recordInfo;

  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, recordInfo.is_attachment ? (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ATTACHMENT_ACTIONS") : (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("PAGE_ACTIONS")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", {
    className: "nav"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "edit"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLinkWithHotkey__WEBPACK_IMPORTED_MODULE_6__["default"], {
    page: "edit",
    path: path,
    alt: alt,
    shortcut: editKey
  }, recordInfo.is_attachment ? (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("EDIT_METADATA") : (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("EDIT"))), recordInfo.can_be_deleted && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "delete"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_7__["default"], {
    page: "delete",
    path: path,
    alt: alt
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("DELETE"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "preview"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_7__["default"], {
    page: "preview",
    path: path,
    alt: alt
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("PREVIEW"))), recordInfo.exists && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "fs-open"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(BrowseFSLink, null)), recordInfo.can_have_children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "add-child"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_7__["default"], {
    page: "add-child",
    path: path,
    alt: alt
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ADD_CHILD_PAGE"))), recordInfo.can_have_attachments && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
    key: "add-attachment"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AdminLink__WEBPACK_IMPORTED_MODULE_7__["default"], {
    page: "upload",
    path: path,
    alt: alt
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ADD_ATTACHMENT")))));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(PageActions));

/***/ }),

/***/ "./js/sidebar/Sidebar.tsx":
/*!********************************!*\
  !*** ./js/sidebar/Sidebar.tsx ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ChildPosCache": () => (/* binding */ ChildPosCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _PageActions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./PageActions */ "./js/sidebar/PageActions.tsx");
/* harmony import */ var _Alternatives__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Alternatives */ "./js/sidebar/Alternatives.tsx");
/* harmony import */ var _AttachmentActions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AttachmentActions */ "./js/sidebar/AttachmentActions.tsx");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./constants */ "./js/sidebar/constants.ts");
/* harmony import */ var _ChildActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ChildActions */ "./js/sidebar/ChildActions.tsx");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../events */ "./js/events.ts");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../context/page-context */ "./js/context/page-context.ts");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }













/**
 * Keep a cache of the page number in the list of subpages that we are currently
 * on. Only keeps this page number in memory for the last five records.
 */

var ChildPosCache = /*#__PURE__*/function () {
  function ChildPosCache() {
    _classCallCheck(this, ChildPosCache);

    this.memo = [];
  }
  /** Remember the page for a record. */


  _createClass(ChildPosCache, [{
    key: "rememberPosition",
    value: function rememberPosition(record, page) {
      // remove current value
      this.memo = this.memo.filter(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
            r = _ref2[0];

        return r !== record;
      });
      this.memo.unshift([record, page]);

      if (this.memo.length > 5) {
        this.memo.length = 5;
      }
    }
  }, {
    key: "getPosition",
    value: function getPosition(record, childCount) {
      var _this$memo$find;

      var page = (_this$memo$find = this.memo.find(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 1),
            r = _ref4[0];

        return r === record;
      })) === null || _this$memo$find === void 0 ? void 0 : _this$memo$find[1];
      return page ? Math.min(page, Math.ceil(childCount / _constants__WEBPACK_IMPORTED_MODULE_7__.CHILDREN_PER_PAGE)) : 1;
    }
  }]);

  return ChildPosCache;
}();

var compareAlternatives = function compareAlternatives(a, b) {
  var nameA = (a.is_primary ? "A" : "B") + (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans_obj)(a.name_i18n);
  var nameB = (b.is_primary ? "A" : "B") + (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans_obj)(b.name_i18n);
  return nameA === nameB ? 0 : nameA < nameB ? -1 : 1;
};

function Sidebar() {
  var page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_context_page_context__WEBPACK_IMPORTED_MODULE_10__.PageContext);
  var path = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_11__.useRecordPath)();

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      recordInfo = _useState2[0],
      setRecordInfo = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(1),
      _useState4 = _slicedToArray(_useState3, 2),
      childrenPage = _useState4[0],
      setChildrenPage = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(function () {
    return new ChildPosCache();
  }),
      _useState6 = _slicedToArray(_useState5, 1),
      childPosCache = _useState6[0];

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(function (x) {
    return x + 1;
  }, 0),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      updateForced = _useReducer2[0],
      forceUpdate = _useReducer2[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var handler = function handler(_ref5) {
      var detail = _ref5.detail;

      if (detail === path) {
        forceUpdate();
      }
    };

    (0,_events__WEBPACK_IMPORTED_MODULE_9__.subscribe)("lektor-attachments-changed", handler);
    return function () {
      return (0,_events__WEBPACK_IMPORTED_MODULE_9__.unsubscribe)("lektor-attachments-changed", handler);
    };
  }, [path]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_1__.get)("/recordinfo", {
      path: path
    }).then(function (resp) {
      if (!ignore) {
        setRecordInfo(_objectSpread(_objectSpread({}, resp), {}, {
          alts: resp.alts.sort(compareAlternatives)
        }));
        setChildrenPage(childPosCache.getPosition(path, resp.children.length));
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_3__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path, childPosCache, updateForced]);

  if (!recordInfo) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_PageActions__WEBPACK_IMPORTED_MODULE_4__["default"], {
    recordInfo: recordInfo
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Alternatives__WEBPACK_IMPORTED_MODULE_5__["default"], {
    alts: recordInfo.alts
  }), recordInfo.can_have_children && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ChildActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
    targetPage: page === "preview" ? "preview" : "edit",
    allChildren: recordInfo.children,
    page: childrenPage,
    setPage: function setPage(page) {
      childPosCache.rememberPosition(path, page);
      setChildrenPage(page);
    }
  }), recordInfo.can_have_attachments && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AttachmentActions__WEBPACK_IMPORTED_MODULE_6__["default"], {
    recordInfo: recordInfo
  }));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Sidebar);

/***/ }),

/***/ "./js/sidebar/constants.ts":
/*!*********************************!*\
  !*** ./js/sidebar/constants.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CHILDREN_PER_PAGE": () => (/* binding */ CHILDREN_PER_PAGE)
/* harmony export */ });
/** The number of children to show in the sidebar. */
var CHILDREN_PER_PAGE = 15;

/***/ }),

/***/ "./js/slugify.ts":
/*!***********************!*\
  !*** ./js/slugify.ts ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "slugify": () => (/* binding */ slugify)
/* harmony export */ });
// https://code.djangoproject.com/browser/django/trunk/django/contrib/admin/media/js/urlify.js
var charmap = {
  // latin
  À: "A",
  Á: "A",
  Â: "A",
  Ã: "A",
  Ä: "Ae",
  Å: "A",
  Æ: "AE",
  Ç: "C",
  È: "E",
  É: "E",
  Ê: "E",
  Ë: "E",
  Ì: "I",
  Í: "I",
  Î: "I",
  Ï: "I",
  Ð: "D",
  Ñ: "N",
  Ò: "O",
  Ó: "O",
  Ô: "O",
  Õ: "O",
  Ö: "Oe",
  Ő: "O",
  Ø: "O",
  Ù: "U",
  Ú: "U",
  Û: "U",
  Ü: "Ue",
  Ű: "U",
  Ý: "Y",
  Þ: "TH",
  ß: "ss",
  à: "a",
  á: "a",
  â: "a",
  ã: "a",
  ä: "ae",
  å: "a",
  æ: "ae",
  ç: "c",
  è: "e",
  é: "e",
  ê: "e",
  ë: "e",
  ì: "i",
  í: "i",
  î: "i",
  ï: "i",
  ð: "d",
  ñ: "n",
  ò: "o",
  ó: "o",
  ô: "o",
  õ: "o",
  ö: "oe",
  ő: "o",
  ø: "o",
  ù: "u",
  ú: "u",
  û: "u",
  ü: "ue",
  ű: "u",
  ý: "y",
  þ: "th",
  ÿ: "y",
  ẞ: "SS",
  // greek
  α: "a",
  β: "b",
  γ: "g",
  δ: "d",
  ε: "e",
  ζ: "z",
  η: "h",
  θ: "8",
  ι: "i",
  κ: "k",
  λ: "l",
  μ: "m",
  ν: "n",
  ξ: "3",
  ο: "o",
  π: "p",
  ρ: "r",
  σ: "s",
  τ: "t",
  υ: "y",
  φ: "f",
  χ: "x",
  ψ: "ps",
  ω: "w",
  ά: "a",
  έ: "e",
  ί: "i",
  ό: "o",
  ύ: "y",
  ή: "h",
  ώ: "w",
  ς: "s",
  ϊ: "i",
  ΰ: "y",
  ϋ: "y",
  ΐ: "i",
  Α: "A",
  Β: "B",
  Γ: "G",
  Δ: "D",
  Ε: "E",
  Ζ: "Z",
  Η: "H",
  Θ: "8",
  Ι: "I",
  Κ: "K",
  Λ: "L",
  Μ: "M",
  Ν: "N",
  Ξ: "3",
  Ο: "O",
  Π: "P",
  Ρ: "R",
  Σ: "S",
  Τ: "T",
  Υ: "Y",
  Φ: "F",
  Χ: "X",
  Ψ: "PS",
  Ω: "W",
  Ά: "A",
  Έ: "E",
  Ί: "I",
  Ό: "O",
  Ύ: "Y",
  Ή: "H",
  Ώ: "W",
  Ϊ: "I",
  Ϋ: "Y",
  // turkish
  ş: "s",
  Ş: "S",
  ı: "i",
  İ: "I",
  ğ: "g",
  Ğ: "G",
  // russian
  а: "a",
  б: "b",
  в: "v",
  г: "g",
  д: "d",
  е: "e",
  ё: "yo",
  ж: "zh",
  з: "z",
  и: "i",
  й: "j",
  к: "k",
  л: "l",
  м: "m",
  н: "n",
  о: "o",
  п: "p",
  р: "r",
  с: "s",
  т: "t",
  у: "u",
  ф: "f",
  х: "h",
  ц: "c",
  ч: "ch",
  ш: "sh",
  щ: "sh",
  ъ: "u",
  ы: "y",
  ь: "",
  э: "e",
  ю: "yu",
  я: "ya",
  А: "A",
  Б: "B",
  В: "V",
  Г: "G",
  Д: "D",
  Е: "E",
  Ё: "Yo",
  Ж: "Zh",
  З: "Z",
  И: "I",
  Й: "J",
  К: "K",
  Л: "L",
  М: "M",
  Н: "N",
  О: "O",
  П: "P",
  Р: "R",
  С: "S",
  Т: "T",
  У: "U",
  Ф: "F",
  Х: "H",
  Ц: "C",
  Ч: "Ch",
  Ш: "Sh",
  Щ: "Sh",
  Ъ: "U",
  Ы: "Y",
  Ь: "",
  Э: "E",
  Ю: "Yu",
  Я: "Ya",
  // ukranian
  Є: "Ye",
  І: "I",
  Ї: "Yi",
  Ґ: "G",
  є: "ye",
  і: "i",
  ї: "yi",
  ґ: "g",
  // czech
  č: "c",
  ď: "d",
  ě: "e",
  ň: "n",
  ř: "r",
  š: "s",
  ť: "t",
  ů: "u",
  ž: "z",
  Č: "C",
  Ď: "D",
  Ě: "E",
  Ň: "N",
  Ř: "R",
  Š: "S",
  Ť: "T",
  Ů: "U",
  Ž: "Z",
  // polish
  ą: "a",
  ć: "c",
  ę: "e",
  ł: "l",
  ń: "n",
  ś: "s",
  ź: "z",
  ż: "z",
  Ą: "A",
  Ć: "C",
  Ę: "E",
  Ł: "L",
  Ń: "N",
  Ś: "S",
  Ź: "Z",
  Ż: "Z",
  // latvian
  ā: "a",
  ē: "e",
  ģ: "g",
  ī: "i",
  ķ: "k",
  ļ: "l",
  ņ: "n",
  ū: "u",
  Ā: "A",
  Ē: "E",
  Ģ: "G",
  Ī: "I",
  Ķ: "K",
  Ļ: "L",
  Ņ: "N",
  Ū: "U",
  // lithuanian
  ė: "e",
  į: "i",
  ų: "u",
  Ė: "E",
  Į: "I",
  Ų: "U",
  // romanian
  ț: "t",
  Ț: "T",
  ţ: "t",
  Ţ: "T",
  ș: "s",
  Ș: "S",
  ă: "a",
  Ă: "A",
  // currency
  "€": "euro",
  "₢": "cruzeiro",
  "₣": "french franc",
  "£": "pound",
  "₤": "lira",
  "₥": "mill",
  "₦": "naira",
  "₧": "peseta",
  "₨": "rupee",
  "₩": "won",
  "₪": "new shequel",
  "₫": "dong",
  "₭": "kip",
  "₮": "tugrik",
  "₯": "drachma",
  "₰": "penny",
  "₱": "peso",
  "₲": "guarani",
  "₳": "austral",
  "₴": "hryvnia",
  "₵": "cedi",
  "¢": "cent",
  "¥": "yen",
  元: "yuan",
  円: "yen",
  "﷼": "rial",
  "₠": "ecu",
  "¤": "currency",
  "฿": "baht",
  $: "dollar",
  "₹": "indian rupee",
  // symbols
  "©": "(c)",
  œ: "oe",
  Œ: "OE",
  "∑": "sum",
  "®": "(r)",
  "†": "+",
  "“": '"',
  "”": '"',
  "‘": "'",
  "’": "'",
  "∂": "d",
  ƒ: "f",
  "™": "tm",
  "℠": "sm",
  "…": "...",
  "˚": "o",
  º: "o",
  ª: "a",
  "•": "*",
  "∆": "delta",
  "∞": "infinity",
  "♥": "love",
  "&": "and",
  "|": "or",
  "<": "less",
  ">": "greater",
  "=": "equals"
};
var multicharmap = {
  "<3": "love",
  "&&": "and",
  "||": "or",
  "w/": "with"
};
var pretty = {
  replacement: "-",
  remove: /[.]/g,
  charmap: charmap,
  multicharmap: multicharmap
};
function slugify(rawString) {
  var string = rawString.toString();
  var opts = pretty;
  var lengths = [];
  Object.keys(opts.multicharmap).forEach(function (key) {
    var len = key.length;

    if (!lengths.includes(len)) {
      lengths.push(len);
    }
  });
  var result = "";

  var _loop = function _loop(_char, _i, l) {
    _char = string[_i];

    if (!lengths.some(function (len) {
      var str = string.substr(_i, len);

      if (opts.multicharmap[str]) {
        _i += len - 1;
        _char = opts.multicharmap[str];
        _char2 = _char;
        i = _i;
        return true;
      } else {
        _char2 = _char;
        i = _i;
        return false;
      }
    })) {
      if (opts.charmap[_char]) {
        _char = opts.charmap[_char];
      }
    }

    _char = _char.replace(/[^\w\s\-._~]/g, ""); // allowed

    if (opts.remove) {
      // add flavour:
      _char = _char.replace(opts.remove, "");
    }

    result += _char;
    _char2 = _char;
    i = _i;
  };

  for (var _char2, i = 0, l = string.length; i < l; i++) {
    _loop(_char2, i, l);
  } // trim leading/trailing spaces:


  result = result.replace(/^\s+|\s+$/g, ""); // convert spaces:

  result = result.replace(/[-\s]+/g, opts.replacement); // remove trailing separator:

  return result.replace(opts.replacement + "$", "");
}

/***/ }),

/***/ "./js/userLabel.tsx":
/*!**************************!*\
  !*** ./js/userLabel.tsx ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "formatUserLabel": () => (/* binding */ formatUserLabel)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./i18n */ "./js/i18n.tsx");


/**
 * Formats a user label appropriately
 */

function formatUserLabel(inputConfig) {
  var label = typeof inputConfig === "string" ? inputConfig : (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(inputConfig);

  if (!label) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null);
  }

  var iconData = label.match(/^\[\[\s*(.*?)\s*(;\s*(.*?))?\s*\]\]$/);

  if (iconData) {
    var className = "fa fa-" + iconData[1];

    if ((iconData[3] || "").match(/90|180|270/)) {
      className += " fa-rotate-" + iconData[3];
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
      className: className
    });
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", null, label);
}

/***/ }),

/***/ "./js/utils.ts":
/*!*********************!*\
  !*** ./js/utils.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isValidUrl": () => (/* binding */ isValidUrl),
/* harmony export */   "trimLeadingSlashes": () => (/* binding */ trimLeadingSlashes),
/* harmony export */   "trimTrailingSlashes": () => (/* binding */ trimTrailingSlashes),
/* harmony export */   "trimSlashes": () => (/* binding */ trimSlashes),
/* harmony export */   "trimColons": () => (/* binding */ trimColons),
/* harmony export */   "getCanonicalUrl": () => (/* binding */ getCanonicalUrl),
/* harmony export */   "getPlatform": () => (/* binding */ getPlatform),
/* harmony export */   "getKey": () => (/* binding */ getKey),
/* harmony export */   "keyboardShortcutHandler": () => (/* binding */ keyboardShortcutHandler),
/* harmony export */   "getParentPath": () => (/* binding */ getParentPath)
/* harmony export */ });
function isValidUrl(url) {
  return !!url.match(/^([a-z0-9+.-]+):(\/\/)?[^/]\S+$/);
}
/**
 * Trim leading slashes from a string.
 */

function trimLeadingSlashes(string) {
  var match = /^\/*(.*?)$/.exec(string);
  return match ? match[1] : "";
}
/**
 * Trim trailing slashes from a string.
 */

function trimTrailingSlashes(string) {
  var match = /^(.*?)\/*$/.exec(string);
  return match ? match[1] : "";
}
/**
 * Trim both leading and trailing slashes from a string.
 */

function trimSlashes(string) {
  var match = /^\/*(.*?)\/*$/.exec(string);
  return match ? match[1] : "";
}
/**
 * Trim both leading and trailing colons from a string.
 */

function trimColons(string) {
  var match = /^:*(.*?):*$/.exec(string);
  return match ? match[1] : "";
}
function getCanonicalUrl(localPath) {
  var base = trimTrailingSlashes($LEKTOR_CONFIG.site_root);
  return "".concat(base, "/").concat(trimLeadingSlashes(localPath));
}
function getPlatform() {
  if (navigator.appVersion.indexOf("Win") !== -1) {
    return "windows";
  } else if (navigator.appVersion.indexOf("Mac") !== -1) {
    return "mac";
  } else if (navigator.appVersion.indexOf("X11") !== -1 || navigator.appVersion.indexOf("Linux") !== -1) {
    return "linux";
  }

  return "other";
}
function getKey(shortcut) {
  return getPlatform() === "mac" && shortcut.mac ? shortcut.mac : shortcut.key;
}
function keyboardShortcutHandler(shortcut, action) {
  var key = getKey(shortcut);
  return function (ev) {
    var eventKey = ev.key;

    if (ev.altKey) {
      eventKey = "Alt+".concat(eventKey);
    }

    if (ev.ctrlKey) {
      eventKey = "Control+".concat(eventKey);
    }

    if (ev.metaKey) {
      eventKey = "Meta+".concat(eventKey);
    }

    if (eventKey === key) {
      if (shortcut.preventDefault) {
        ev.preventDefault();
      }

      action(ev);
    }
  };
}
function getParentPath(path) {
  var match = /^(\/.*)\/[^/]*$/.exec(path);
  return match ? match[1] : null;
}

/***/ }),

/***/ "./js/views/AddAttachmentPage.tsx":
/*!****************************************!*\
  !*** ./js/views/AddAttachmentPage.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../events */ "./js/events.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }








function AddAttachmentPage() {
  var path = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecordPath)();

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      newAttachmentInfo = _useState2[0],
      setNewAttachmentInfo = _useState2[1];

  var fileInput = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]),
      _useState4 = _slicedToArray(_useState3, 2),
      currentFiles = _useState4[0],
      setCurrentFiles = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
      _useState6 = _slicedToArray(_useState5, 2),
      isUploading = _useState6[0],
      setIsUploading = _useState6[1];

  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0),
      _useState8 = _slicedToArray(_useState7, 2),
      currentProgress = _useState8[0],
      setCurrentProgress = _useState8[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/newattachment", {
      path: path
    }).then(function (resp) {
      if (!ignore) {
        setNewAttachmentInfo(resp);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path]);
  var onFileSelected = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (_ref) {
    var target = _ref.target;

    if (isUploading || !target.files) {
      return;
    }

    var files = Array.prototype.slice.call(target.files, 0);
    setCurrentFiles(files);
    setIsUploading(true);
    var formData = new FormData();
    formData.append("path", path);
    files.forEach(function (file) {
      formData.append("file", file, file.name);
    });
    var xhr = new XMLHttpRequest();
    xhr.open("POST", (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.apiUrl)("/newattachment"));

    xhr.onprogress = function (event) {
      setCurrentProgress(Math.round(event.loaded * 100 / event.total));
    };

    xhr.onload = function () {
      setIsUploading(false);
      setCurrentProgress(100);
      (0,_events__WEBPACK_IMPORTED_MODULE_5__.dispatch)("lektor-attachments-changed", path);
    };

    xhr.send(formData);
  }, [path, isUploading]);

  if (!newAttachmentInfo) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_format)("ADD_ATTACHMENT_TO", newAttachmentInfo.label)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("ADD_ATTACHMENT_NOTE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", null, currentFiles.map(function (file) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: file.name
    }, file.name, " (", file.type, ")");
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("PROGRESS"), ": ", currentProgress, "%"), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    type: "file",
    ref: fileInput,
    multiple: true,
    style: {
      display: "none"
    },
    onChange: onFileSelected
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "actions"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    onClick: function onClick() {
      var _fileInput$current;

      return (_fileInput$current = fileInput.current) === null || _fileInput$current === void 0 ? void 0 : _fileInput$current.click();
    }
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("UPLOAD"))));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddAttachmentPage);

/***/ }),

/***/ "./js/views/App.tsx":
/*!**************************!*\
  !*** ./js/views/App.tsx ***!
  \**************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ App)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _header_Header__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../header/Header */ "./js/header/Header.tsx");
/* harmony import */ var _sidebar_Sidebar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../sidebar/Sidebar */ "./js/sidebar/Sidebar.tsx");
/* harmony import */ var _components_DialogSlot__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/DialogSlot */ "./js/components/DialogSlot.tsx");
/* harmony import */ var _components_ServerStatus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../components/ServerStatus */ "./js/components/ServerStatus.tsx");
/* harmony import */ var _components_ErrorDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/ErrorDialog */ "./js/components/ErrorDialog.tsx");
/* harmony import */ var _edit_EditPage__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./edit/EditPage */ "./js/views/edit/EditPage.tsx");
/* harmony import */ var _delete_DeletePage__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./delete/DeletePage */ "./js/views/delete/DeletePage.tsx");
/* harmony import */ var _PreviewPage__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./PreviewPage */ "./js/views/PreviewPage.tsx");
/* harmony import */ var _add_child_page_AddChildPage__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./add-child-page/AddChildPage */ "./js/views/add-child-page/AddChildPage.tsx");
/* harmony import */ var _AddAttachmentPage__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./AddAttachmentPage */ "./js/views/AddAttachmentPage.tsx");
/* harmony import */ var _context_page_context__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../context/page-context */ "./js/context/page-context.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }













var mainComponentForPage = {
  edit: _edit_EditPage__WEBPACK_IMPORTED_MODULE_6__["default"],
  "delete": _delete_DeletePage__WEBPACK_IMPORTED_MODULE_7__["default"],
  preview: _PreviewPage__WEBPACK_IMPORTED_MODULE_8__["default"],
  "add-child": _add_child_page_AddChildPage__WEBPACK_IMPORTED_MODULE_9__["default"],
  upload: _AddAttachmentPage__WEBPACK_IMPORTED_MODULE_10__["default"]
};
function App() {
  var page = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_context_page_context__WEBPACK_IMPORTED_MODULE_11__.PageContext);

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(function (v) {
    return !v;
  }, false),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      sidebarIsActive = _useReducer2[0],
      toggleSidebar = _useReducer2[1];

  var MainComponent = mainComponentForPage[page];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_header_Header__WEBPACK_IMPORTED_MODULE_1__["default"], {
    sidebarIsActive: sidebarIsActive,
    toggleSidebar: toggleSidebar
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_ErrorDialog__WEBPACK_IMPORTED_MODULE_5__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_DialogSlot__WEBPACK_IMPORTED_MODULE_3__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "container"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: sidebarIsActive ? "block-offcanvas row active" : "block-offcanvas row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("nav", {
    className: "sidebar col-md-2 col-sm-3"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_sidebar_Sidebar__WEBPACK_IMPORTED_MODULE_2__["default"], null)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "main col-md-10 col-sm-9"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(MainComponent, null)))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_ServerStatus__WEBPACK_IMPORTED_MODULE_4__["default"], null));
}

/***/ }),

/***/ "./js/views/PreviewPage.tsx":
/*!**********************************!*\
  !*** ./js/views/PreviewPage.tsx ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PreviewPage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils */ "./js/utils.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../fetch */ "./js/fetch.ts");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }








function getSiteRootUrl() {
  var site_root = "/".concat((0,_utils__WEBPACK_IMPORTED_MODULE_1__.trimLeadingSlashes)($LEKTOR_CONFIG.site_root));
  var absRootUrl = new URL(site_root, document.baseURI).href;
  return (0,_utils__WEBPACK_IMPORTED_MODULE_1__.trimTrailingSlashes)(absRootUrl);
}

function usePreviewUrl(siteRootUrl) {
  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_3__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)("about:blank"),
      _useState2 = _slicedToArray(_useState, 2),
      previewUrl = _useState2[0],
      setPreviewUrl = _useState2[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/previewinfo", {
      path: path,
      alt: alt
    }).then(function (_ref) {
      var url = _ref.url;

      if (!ignore) {
        setPreviewUrl(url ? siteRootUrl + url : "about:blank");
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path, alt, siteRootUrl]);
  return previewUrl;
}

function PreviewPage() {
  var siteRootUrl = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(getSiteRootUrl, []);
  var previewUrl = usePreviewUrl(siteRootUrl);
  var iframe = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_5__.useGoToAdminPage)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var _iframe$current, _iframe$current$conte;

    var location = (_iframe$current = iframe.current) === null || _iframe$current === void 0 ? void 0 : (_iframe$current$conte = _iframe$current.contentWindow) === null || _iframe$current$conte === void 0 ? void 0 : _iframe$current$conte.location;

    if (location && location.href !== previewUrl) {
      location.replace(previewUrl);
    }
  }, [previewUrl]);
  var onFrameNavigated = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    var _event$currentTarget$;

    var location = (_event$currentTarget$ = event.currentTarget.contentWindow) === null || _event$currentTarget$ === void 0 ? void 0 : _event$currentTarget$.location;

    if (location && location.href !== previewUrl) {
      if (location.href.startsWith("".concat(siteRootUrl, "/"))) {
        var url_path = location.href.substr(siteRootUrl.length);
        (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/matchurl", {
          url_path: url_path
        }).then(function (_ref2) {
          var exists = _ref2.exists,
              alt = _ref2.alt,
              path = _ref2.path;

          if (exists) {
            goToAdminPage("preview", path, alt);
          }
        }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
      }
    }
  }, [goToAdminPage, previewUrl, siteRootUrl]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("iframe", {
    className: "preview",
    ref: iframe,
    onLoad: onFrameNavigated
  });
}

/***/ }),

/***/ "./js/views/add-child-page/AddChildPage.tsx":
/*!**************************************************!*\
  !*** ./js/views/add-child-page/AddChildPage.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../fetch */ "./js/fetch.ts");
/* harmony import */ var _slugify__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../slugify */ "./js/slugify.ts");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _AvailableModels__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AvailableModels */ "./js/views/add-child-page/AvailableModels.tsx");
/* harmony import */ var _PrimaryFieldRow__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./PrimaryFieldRow */ "./js/views/add-child-page/PrimaryFieldRow.tsx");
/* harmony import */ var _Slug__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Slug */ "./js/views/add-child-page/Slug.tsx");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }











/** Show an alert with the given error message. */

var alertErr = function alertErr(text) {
  alert((0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_PREFIX") + text);
};

function AddChildPage() {
  var _newChildInfo$availab;

  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      newChildInfo = _useState2[0],
      setNewChildInfo = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
      _useState4 = _slicedToArray(_useState3, 2),
      selectedModel = _useState4[0],
      setSelectedModel = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
      _useState6 = _slicedToArray(_useState5, 2),
      id = _useState6[0],
      setId = _useState6[1];

  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(""),
      _useState8 = _slicedToArray(_useState7, 2),
      primary = _useState8[0],
      setPrimary = _useState8[1];

  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.get)("/newrecord", {
      path: path
    }).then(function (resp) {
      if (!ignore) {
        var _resp$implied_model;

        var defaultModel = resp.available_models.page ? "page" : Object.keys(resp.available_models).sort()[0];

        var _selectedModel = (_resp$implied_model = resp.implied_model) !== null && _resp$implied_model !== void 0 ? _resp$implied_model : defaultModel;

        setNewChildInfo(resp);
        setId("");
        setPrimary("");
        setSelectedModel(_selectedModel);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path]);
  var primaryField = newChildInfo === null || newChildInfo === void 0 ? void 0 : (_newChildInfo$availab = newChildInfo.available_models[selectedModel]) === null || _newChildInfo$availab === void 0 ? void 0 : _newChildInfo$availab.primary_field;
  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_9__.useGoToAdminPage)();
  var createRecord = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    var currentId = id || (0,_slugify__WEBPACK_IMPORTED_MODULE_4__.slugify)(primary).toLowerCase();

    if (!currentId) {
      alertErr((0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ERROR_NO_ID_PROVIDED"));
      return;
    }

    var data = {};

    if (!(newChildInfo !== null && newChildInfo !== void 0 && newChildInfo.implied_model)) {
      data._model = selectedModel;
    }

    if (primaryField) {
      data[primaryField.name] = primary;
    }

    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.post)("/newrecord", null, {
      id: currentId,
      path: path,
      data: data
    }).then(function (_ref) {
      var exists = _ref.exists,
          valid_id = _ref.valid_id,
          path = _ref.path;

      if (exists) {
        alertErr((0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans_format)("ERROR_PAGE_ID_DUPLICATE", currentId));
      } else if (!valid_id) {
        alertErr((0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans_format)("ERROR_INVALID_ID", currentId));
      } else {
        goToAdminPage("edit", path, alt);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
  }, [alt, goToAdminPage, newChildInfo, id, path, primary, primaryField, selectedModel]);

  if (!newChildInfo) {
    return null;
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans_format)("ADD_CHILD_PAGE_TO", newChildInfo.label)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("ADD_CHILD_PAGE_NOTE")), !newChildInfo.implied_model && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AvailableModels__WEBPACK_IMPORTED_MODULE_6__["default"], {
    newChildInfo: newChildInfo,
    selected: selectedModel,
    setSelected: setSelectedModel
  }), primaryField && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_PrimaryFieldRow__WEBPACK_IMPORTED_MODULE_7__["default"], {
    primary: primary,
    setPrimary: setPrimary,
    field: primaryField
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Slug__WEBPACK_IMPORTED_MODULE_8__["default"], {
    id: id,
    placeholder: (0,_slugify__WEBPACK_IMPORTED_MODULE_4__.slugify)(primary).toLowerCase(),
    setId: setId
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "actions"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    onClick: createRecord
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_2__.trans)("CREATE_CHILD_PAGE"))));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddChildPage);

/***/ }),

/***/ "./js/views/add-child-page/AvailableModels.tsx":
/*!*****************************************************!*\
  !*** ./js/views/add-child-page/AvailableModels.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AvailableModels)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");



/**
 * A field to select one of the available models for the new child page.
 */
function AvailableModels(_ref) {
  var newChildInfo = _ref.newChildInfo,
      selected = _ref.selected,
      setSelected = _ref.setSelected;
  var available = Object.values(newChildInfo.available_models).sort(function (a, b) {
    return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "row field-row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "col-md-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", {
    className: "field"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("MODEL")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("select", {
    value: selected,
    className: "form-control",
    onChange: function onChange(event) {
      return setSelected(event.target.value);
    }
  }, available.map(function (model) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("option", {
      value: model.id,
      key: model.id
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(model.name_i18n));
  }))))));
}

/***/ }),

/***/ "./js/views/add-child-page/PrimaryFieldRow.tsx":
/*!*****************************************************!*\
  !*** ./js/views/add-child-page/PrimaryFieldRow.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PrimaryField)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _userLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../userLabel */ "./js/userLabel.tsx");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../widgets */ "./js/widgets.tsx");




/**
 * The input to change the primary field value for the new child page.
 */
function PrimaryField(_ref) {
  var primary = _ref.primary,
      field = _ref.field,
      setPrimary = _ref.setPrimary;
  var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_2__.getWidgetComponentWithFallback)(field.type);
  var value = Widget.deserializeValue ? Widget.deserializeValue(primary, field.type) : primary;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "row field-row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "col-md-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", {
    className: "field"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", null, (0,_userLabel__WEBPACK_IMPORTED_MODULE_1__.formatUserLabel)(field.label_i18n)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Widget, {
    value: value,
    onChange: setPrimary,
    type: field.type,
    field: field
  })))));
}

/***/ }),

/***/ "./js/views/add-child-page/Slug.tsx":
/*!******************************************!*\
  !*** ./js/views/add-child-page/Slug.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Slug)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _userLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../userLabel */ "./js/userLabel.tsx");
/* harmony import */ var _widgets_SlugInputWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../widgets/SlugInputWidget */ "./js/widgets/SlugInputWidget.tsx");




/**
 * Slug for the new child page.
 */

function Slug(_ref) {
  var id = _ref.id,
      placeholder = _ref.placeholder,
      setId = _ref.setId;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "row field-row"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "col-md-12"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", {
    className: "field"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", null, (0,_userLabel__WEBPACK_IMPORTED_MODULE_2__.formatUserLabel)((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ID"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets_SlugInputWidget__WEBPACK_IMPORTED_MODULE_3__.SlugInputWidget, {
    value: id,
    placeholder: placeholder,
    onChange: setId,
    type: {
      widget: "slug",
      name: "slug",
      size: "normal"
    }
  })))));
}

/***/ }),

/***/ "./js/views/delete/DeletableAlternatives.tsx":
/*!***************************************************!*\
  !*** ./js/views/delete/DeletableAlternatives.tsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeletableAlternatives)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeletableAlternatives(_ref) {
  var recordInfo = _ref.recordInfo;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h4", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ALTS_TO_BE_DELETED")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", null, recordInfo.alts.filter(function (i) {
    return i.exists;
  }).map(function (item) {
    var title = (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(item.name_i18n);

    if (item.is_primary) {
      title += " (" + (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("PRIMARY_ALT") + ")";
    } else if (item.primary_overlay) {
      title += " (" + (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("PRIMARY_OVERLAY") + ")";
    }

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: item.alt
    }, title);
  })));
}

/***/ }),

/***/ "./js/views/delete/DeletableAttachments.tsx":
/*!**************************************************!*\
  !*** ./js/views/delete/DeletableAttachments.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeletableAttachments)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeletableAttachments(_ref) {
  var recordInfo = _ref.recordInfo;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h4", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ATTACHMENTS_TO_BE_DELETED")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", null, recordInfo.attachments.map(function (atch) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: atch.id
    }, atch.id, " (", atch.type, ")");
  })));
}

/***/ }),

/***/ "./js/views/delete/DeletableChildPages.tsx":
/*!*************************************************!*\
  !*** ./js/views/delete/DeletableChildPages.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeletableChildPages)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeletableChildPages(_ref) {
  var recordInfo = _ref.recordInfo;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h4", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("CHILD_PAGES_TO_BE_DELETED")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", null, recordInfo.children.map(function (child) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", {
      key: child.id
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(child.label_i18n));
  })));
}

/***/ }),

/***/ "./js/views/delete/DeleteAllAltsChoice.tsx":
/*!*************************************************!*\
  !*** ./js/views/delete/DeleteAllAltsChoice.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeleteAllAltsChoice)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeleteAllAltsChoice(_ref) {
  var deleteMasterRecord = _ref.deleteMasterRecord,
      setDeleteMasterRecord = _ref.setDeleteMasterRecord,
      isAttachment = _ref.isAttachment;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_PRIMARY_ALT_INFO")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("ul", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    type: "radio",
    checked: deleteMasterRecord,
    onChange: function onChange() {
      return setDeleteMasterRecord(true);
    }
  }), " ", (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)(isAttachment ? "DELETE_ALL_ATTACHMENT_ALTS" : "DELETE_ALL_PAGE_ALTS"))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("li", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    type: "radio",
    checked: !deleteMasterRecord,
    onChange: function onChange() {
      return setDeleteMasterRecord(false);
    }
  }), " ", (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)(isAttachment ? "DELETE_ONLY_PRIMARY_ATTACHMENT_ALT" : "DELETE_ONLY_PRIMARY_PAGE_ALT")))));
}

/***/ }),

/***/ "./js/views/delete/DeletePage.tsx":
/*!****************************************!*\
  !*** ./js/views/delete/DeletePage.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils */ "./js/utils.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../fetch */ "./js/fetch.ts");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _DeletableAttachments__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DeletableAttachments */ "./js/views/delete/DeletableAttachments.tsx");
/* harmony import */ var _DeletableChildPages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DeletableChildPages */ "./js/views/delete/DeletableChildPages.tsx");
/* harmony import */ var _DeletableAlternatives__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DeletableAlternatives */ "./js/views/delete/DeletableAlternatives.tsx");
/* harmony import */ var _DeletePageActions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./DeletePageActions */ "./js/views/delete/DeletePageActions.tsx");
/* harmony import */ var _DeleteAllAltsChoice__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./DeleteAllAltsChoice */ "./js/views/delete/DeleteAllAltsChoice.tsx");
/* harmony import */ var _DeletePageHeader__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./DeletePageHeader */ "./js/views/delete/DeletePageHeader.tsx");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../events */ "./js/events.ts");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }















function DeletePage() {
  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      recordInfo = _useState2[0],
      setRecordInfo = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true),
      _useState4 = _slicedToArray(_useState3, 2),
      deleteMasterRecord = _useState4[0],
      setDeleteMasterRecord = _useState4[1];

  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_12__.useGoToAdminPage)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.get)("/recordinfo", {
      path: path
    }).then(function (resp) {
      if (!ignore) {
        setRecordInfo(resp);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [path]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    setDeleteMasterRecord(alt === "_primary");
  }, [alt]);
  var deleteRecord = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    var parent = (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getParentPath)(path);
    var targetPath = parent === null ? "/" : parent;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_3__.post)("/deleterecord", {
      path: path,
      alt: alt,
      delete_master: deleteMasterRecord ? "1" : "0"
    }).then(function () {
      if (recordInfo !== null && recordInfo !== void 0 && recordInfo.is_attachment) {
        (0,_events__WEBPACK_IMPORTED_MODULE_11__.dispatch)("lektor-attachments-changed", parent !== null && parent !== void 0 ? parent : "");
      }

      goToAdminPage("edit", targetPath, alt);
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_4__.showErrorDialog);
  }, [alt, path, deleteMasterRecord, goToAdminPage, recordInfo]);
  var cancelDelete = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    goToAdminPage("edit", path, alt);
  }, [goToAdminPage, path, alt]);

  if (!recordInfo || !recordInfo.can_be_deleted) {
    return null;
  }

  var hasAlts = recordInfo.alts.filter(function (a) {
    return a.exists;
  }).length > 1;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeletePageHeader__WEBPACK_IMPORTED_MODULE_10__["default"], {
    recordInfo: recordInfo,
    currentAlt: alt
  }), hasAlts && alt === "_primary" && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeleteAllAltsChoice__WEBPACK_IMPORTED_MODULE_9__["default"], {
    deleteMasterRecord: deleteMasterRecord,
    setDeleteMasterRecord: setDeleteMasterRecord,
    isAttachment: recordInfo.is_attachment
  }), deleteMasterRecord && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, hasAlts && alt === "_primary" && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeletableAlternatives__WEBPACK_IMPORTED_MODULE_7__["default"], {
    recordInfo: recordInfo
  }), recordInfo.children.length > 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeletableChildPages__WEBPACK_IMPORTED_MODULE_6__["default"], {
    recordInfo: recordInfo
  }), recordInfo.attachments.length > 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeletableAttachments__WEBPACK_IMPORTED_MODULE_5__["default"], {
    recordInfo: recordInfo
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DeletePageActions__WEBPACK_IMPORTED_MODULE_8__["default"], {
    deleteRecord: deleteRecord,
    cancelDelete: cancelDelete
  }));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeletePage);

/***/ }),

/***/ "./js/views/delete/DeletePageActions.tsx":
/*!***********************************************!*\
  !*** ./js/views/delete/DeletePageActions.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeletePageActions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeletePageActions(_ref) {
  var deleteRecord = _ref.deleteRecord,
      cancelDelete = _ref.cancelDelete;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "actions"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-primary",
    onClick: deleteRecord
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("YES_DELETE")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: cancelDelete
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("NO_CANCEL")));
}

/***/ }),

/***/ "./js/views/delete/DeletePageHeader.tsx":
/*!**********************************************!*\
  !*** ./js/views/delete/DeletePageHeader.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeletePageHeader)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");


function DeletePageHeader(_ref) {
  var recordInfo = _ref.recordInfo,
      currentAlt = _ref.currentAlt;
  var isPrimary = currentAlt === "_primary";
  var altInfo = recordInfo.alts.find(function (a) {
    return a.alt === currentAlt;
  });
  var label = (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_fallback)(recordInfo.label_i18n, recordInfo.id);

  if (!isPrimary && altInfo) {
    label += " (".concat((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(altInfo.name_i18n), ")");
  }

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_format)("DELETE_RECORD", label)), recordInfo.is_attachment ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, isPrimary ? (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_ATTACHMENT_PROMPT") : (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_ATTACHMENT_ALT_PROMPT"), " ") : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, isPrimary ? (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_PAGE_PROMPT") : (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_PAGE_ALT_PROMPT"), " ", recordInfo.children.length > 0 && isPrimary ? (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DELETE_PAGE_CHILDREN_WARNING") : null));
}

/***/ }),

/***/ "./js/views/edit/EditPage.tsx":
/*!************************************!*\
  !*** ./js/views/edit/EditPage.tsx ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-router-dom */ "./node_modules/react-router/esm/react-router.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ "./js/utils.ts");
/* harmony import */ var _fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../fetch */ "./js/fetch.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../widgets */ "./js/widgets.tsx");
/* harmony import */ var _error_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../error-dialog */ "./js/error-dialog.ts");
/* harmony import */ var _EditPageActions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./EditPageActions */ "./js/views/edit/EditPageActions.tsx");
/* harmony import */ var _components_ToggleGroup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../components/ToggleGroup */ "./js/components/ToggleGroup.tsx");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../context/record-context */ "./js/context/record-context.ts");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }













function legalFields(recordDataModel, recordInfo) {
  function isLegalField(field) {
    switch (field.name) {
      case "_id":
      case "_path":
      case "_gid":
      case "_alt":
      case "_source_alt":
      case "_model":
      case "_attachment_for":
        return false;

      case "_attachment_type":
        return recordInfo.is_attachment;
    }

    return true;
  }

  return recordDataModel.fields.filter(isLegalField);
}

function getPlaceholderForField(recordInfo, Widget, field) {
  if (field["default"] !== null) {
    if (Widget.deserializeValue) {
      return Widget.deserializeValue(field["default"], field.type);
    }

    return field["default"];
  } else if (field.name === "_slug") {
    return recordInfo.slug_format;
  } else if (field.name === "_template") {
    return recordInfo.default_template;
  } else if (field.name === "_attachment_type") {
    return recordInfo.implied_attachment_type;
  }

  return null;
}

function getValueForField(recordData, Widget, field) {
  var value = recordData[field.name];

  if (value === undefined) {
    value = "";

    if (Widget.deserializeValue) {
      value = Widget.deserializeValue(value, field.type);
    }
  }

  return value;
}

function getValues(_ref) {
  var recordDataModel = _ref.recordDataModel,
      recordInfo = _ref.recordInfo,
      recordData = _ref.recordData;
  var rv = {};

  if (!recordDataModel || !recordInfo) {
    return rv;
  }

  legalFields(recordDataModel, recordInfo).forEach(function (field) {
    var value = recordData[field.name];

    if (value !== undefined) {
      var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_4__.getWidgetComponentWithFallback)(field.type);

      if (Widget.serializeValue) {
        value = Widget.serializeValue(value, field.type);
      }
    } else {
      value = null;
    }

    rv[field.name] = value;
  });
  return rv;
}

function EditPage() {
  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_9__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var form = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null); // The deserialised record data.

  var _useState = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({}),
      _useState2 = _slicedToArray(_useState, 2),
      recordData = _useState2[0],
      setRecordData = _useState2[1];

  var _useState3 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState4 = _slicedToArray(_useState3, 2),
      recordDataModel = _useState4[0],
      setRecordDataModel = _useState4[1];

  var _useState5 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null),
      _useState6 = _slicedToArray(_useState5, 2),
      recordInfo = _useState6[0],
      setRecordnfo = _useState6[1];

  var _useState7 = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false),
      _useState8 = _slicedToArray(_useState7, 2),
      hasPendingChanges = _useState8[0],
      setHasPendingChanges = _useState8[1];

  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_8__.useGoToAdminPage)();
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var ignore = false;
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.get)("/rawrecord", {
      path: path,
      alt: alt
    }).then(function (_ref2) {
      var datamodel = _ref2.datamodel,
          data = _ref2.data,
          record_info = _ref2.record_info;

      if (!ignore) {
        // transform response data into actual data
        var _recordData = {};
        legalFields(datamodel, record_info).forEach(function (field) {
          var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_4__.getWidgetComponentWithFallback)(field.type);
          var value = data[field.name];

          if (value !== undefined) {
            if (Widget.deserializeValue) {
              value = Widget.deserializeValue(value, field.type);
            }

            _recordData[field.name] = value;
          }
        });
        setRecordData(_recordData);
        setRecordDataModel(datamodel);
        setRecordnfo(record_info);
        setHasPendingChanges(false);
      }
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
    return function () {
      ignore = true;
    };
  }, [alt, path]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    var onKeyPress = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.keyboardShortcutHandler)({
      key: "Control+s",
      mac: "Meta+s",
      preventDefault: true
    }, function () {
      var _form$current;

      if ((_form$current = form.current) !== null && _form$current !== void 0 && _form$current.reportValidity()) {
        var _form$current$querySe;

        (_form$current$querySe = form.current.querySelector("button[type='submit']")) === null || _form$current$querySe === void 0 ? void 0 : _form$current$querySe.click();
      }
    });
    window.addEventListener("keydown", onKeyPress);
    return function () {
      return window.removeEventListener("keydown", onKeyPress);
    };
  }, []);
  var setFieldValue = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (fieldName, value) {
    setRecordData(function (r) {
      return _objectSpread(_objectSpread({}, r), {}, _defineProperty({}, fieldName, typeof value === "function" ? value(r[fieldName]) : value));
    });
    setHasPendingChanges(true);
  }, []);
  var saveChanges = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (ev) {
    ev.preventDefault();
    var data = getValues({
      recordDataModel: recordDataModel,
      recordInfo: recordInfo,
      recordData: recordData
    });
    (0,_fetch__WEBPACK_IMPORTED_MODULE_2__.put)("/rawrecord", {
      data: data,
      path: path,
      alt: alt
    }).then(function () {
      setHasPendingChanges(false);
      goToAdminPage("preview", path, alt);
    }, _error_dialog__WEBPACK_IMPORTED_MODULE_5__.showErrorDialog);
  }, [alt, goToAdminPage, path, recordData, recordDataModel, recordInfo]);
  var renderFormField = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (field) {
    var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_4__.getWidgetComponentWithFallback)(field.type);

    if (!recordInfo) {
      return null;
    } // If alts_enabled is set, only show allow editing on alts (if true)
    // or on the primary (if false)


    var disabled = !(field.alts_enabled === null || field.alts_enabled !== (recordInfo.alt === "_primary"));
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets__WEBPACK_IMPORTED_MODULE_4__.FieldBox, {
      key: field.name,
      value: getValueForField(recordData, Widget, field),
      placeholder: getPlaceholderForField(recordInfo, Widget, field),
      field: field,
      setFieldValue: setFieldValue,
      disabled: disabled
    });
  }, [recordData, recordInfo, setFieldValue]);

  if (!recordInfo || !recordDataModel) {
    // we have not loaded anything yet.
    return null;
  }

  var label = (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_fallback)(recordInfo.label_i18n, recordInfo.label);
  var title = recordInfo.is_attachment ? (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_format)("EDIT_ATTACHMENT_METADATA_OF", label) : (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans_format)("EDIT_PAGE_NAME", label);
  var fields = legalFields(recordDataModel, recordInfo);

  var _splitFields = (0,_widgets__WEBPACK_IMPORTED_MODULE_4__.splitFields)(fields),
      _splitFields2 = _slicedToArray(_splitFields, 2),
      normalFields = _splitFields2[0],
      systemFields = _splitFields2[1];

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, hasPendingChanges && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_10__.Prompt, {
    message: (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("UNLOAD_ACTIVE_TAB")
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h2", null, title), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", {
    ref: form,
    onSubmit: saveChanges
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets__WEBPACK_IMPORTED_MODULE_4__.FieldRows, {
    fields: normalFields,
    renderFunc: renderFormField
  }), systemFields.length > 0 && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_ToggleGroup__WEBPACK_IMPORTED_MODULE_7__["default"], {
    groupTitle: (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("SYSTEM_FIELDS"),
    className: "system-fields"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets__WEBPACK_IMPORTED_MODULE_4__.FieldRows, {
    fields: systemFields,
    renderFunc: renderFormField
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_EditPageActions__WEBPACK_IMPORTED_MODULE_6__.EditPageActions, {
    recordInfo: recordInfo,
    hasPendingChanges: hasPendingChanges
  })));
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditPage);

/***/ }),

/***/ "./js/views/edit/EditPageActions.tsx":
/*!*******************************************!*\
  !*** ./js/views/edit/EditPageActions.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EditPageActions": () => (/* binding */ EditPageActions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _context_record_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context/record-context */ "./js/context/record-context.ts");
/* harmony import */ var _components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../components/use-go-to-admin-page */ "./js/components/use-go-to-admin-page.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");




function EditPageActions(_ref) {
  var recordInfo = _ref.recordInfo,
      hasPendingChanges = _ref.hasPendingChanges;

  var _useRecord = (0,_context_record_context__WEBPACK_IMPORTED_MODULE_1__.useRecord)(),
      path = _useRecord.path,
      alt = _useRecord.alt;

  var goToAdminPage = (0,_components_use_go_to_admin_page__WEBPACK_IMPORTED_MODULE_2__.useGoToAdminPage)();
  var deleteRecord = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    goToAdminPage("delete", path, alt);
  }, [alt, goToAdminPage, path]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "actions"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "submit",
    disabled: !hasPendingChanges,
    className: "btn btn-primary"
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("SAVE_CHANGES")), recordInfo.can_be_deleted ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary border",
    onClick: deleteRecord
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("DELETE")) : null);
}

/***/ }),

/***/ "./js/widgets.tsx":
/*!************************!*\
  !*** ./js/widgets.tsx ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FieldBox": () => (/* binding */ FieldBox),
/* harmony export */   "getWidgetComponent": () => (/* binding */ getWidgetComponent),
/* harmony export */   "getWidgetComponentWithFallback": () => (/* binding */ getWidgetComponentWithFallback),
/* harmony export */   "getFieldColumns": () => (/* binding */ getFieldColumns),
/* harmony export */   "splitFields": () => (/* binding */ splitFields),
/* harmony export */   "FieldRows": () => (/* binding */ FieldRows)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _widgets_IntegerInputWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./widgets/IntegerInputWidget */ "./js/widgets/IntegerInputWidget.tsx");
/* harmony import */ var _widgets_MultiLineTextInputWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./widgets/MultiLineTextInputWidget */ "./js/widgets/MultiLineTextInputWidget.tsx");
/* harmony import */ var _widgets_BooleanInputWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./widgets/BooleanInputWidget */ "./js/widgets/BooleanInputWidget.tsx");
/* harmony import */ var _widgets_DateInputWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./widgets/DateInputWidget */ "./js/widgets/DateInputWidget.tsx");
/* harmony import */ var _widgets_FloatInputWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widgets/FloatInputWidget */ "./js/widgets/FloatInputWidget.tsx");
/* harmony import */ var _widgets_UrlInputWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./widgets/UrlInputWidget */ "./js/widgets/UrlInputWidget.tsx");
/* harmony import */ var _widgets_SlugInputWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./widgets/SlugInputWidget */ "./js/widgets/SlugInputWidget.tsx");
/* harmony import */ var _widgets_SingleLineTextInputWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./widgets/SingleLineTextInputWidget */ "./js/widgets/SingleLineTextInputWidget.tsx");
/* harmony import */ var _widgets_CheckboxesInputWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./widgets/CheckboxesInputWidget */ "./js/widgets/CheckboxesInputWidget.tsx");
/* harmony import */ var _widgets_SelectInputWidget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./widgets/SelectInputWidget */ "./js/widgets/SelectInputWidget.tsx");
/* harmony import */ var _widgets_flow_FlowWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./widgets/flow/FlowWidget */ "./js/widgets/flow/FlowWidget.tsx");
/* harmony import */ var _widgets_fakeWidgets__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./widgets/fakeWidgets */ "./js/widgets/fakeWidgets.tsx");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./i18n */ "./js/i18n.tsx");














var widgetComponents = {
  "singleline-text": _widgets_SingleLineTextInputWidget__WEBPACK_IMPORTED_MODULE_8__.SingleLineTextInputWidget,
  "multiline-text": _widgets_MultiLineTextInputWidget__WEBPACK_IMPORTED_MODULE_2__.MultiLineTextInputWidget,
  datepicker: _widgets_DateInputWidget__WEBPACK_IMPORTED_MODULE_4__.DateInputWidget,
  integer: _widgets_IntegerInputWidget__WEBPACK_IMPORTED_MODULE_1__.IntegerInputWidget,
  "float": _widgets_FloatInputWidget__WEBPACK_IMPORTED_MODULE_5__.FloatInputWidget,
  checkbox: _widgets_BooleanInputWidget__WEBPACK_IMPORTED_MODULE_3__.BooleanInputWidget,
  url: _widgets_UrlInputWidget__WEBPACK_IMPORTED_MODULE_6__.UrlInputWidget,
  slug: _widgets_SlugInputWidget__WEBPACK_IMPORTED_MODULE_7__.SlugInputWidget,
  flow: _widgets_flow_FlowWidget__WEBPACK_IMPORTED_MODULE_11__.FlowWidget,
  checkboxes: _widgets_CheckboxesInputWidget__WEBPACK_IMPORTED_MODULE_9__.CheckboxesInputWidget,
  select: _widgets_SelectInputWidget__WEBPACK_IMPORTED_MODULE_10__.SelectInputWidget,
  "f-line": _widgets_fakeWidgets__WEBPACK_IMPORTED_MODULE_12__.LineWidget,
  "f-spacing": _widgets_fakeWidgets__WEBPACK_IMPORTED_MODULE_12__.SpacingWidget,
  "f-info": _widgets_fakeWidgets__WEBPACK_IMPORTED_MODULE_12__.InfoWidget,
  "f-heading": _widgets_fakeWidgets__WEBPACK_IMPORTED_MODULE_12__.HeadingWidget
};
/**
 * A fallback widget to render for fields missing a component.
 */

function FallbackWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("em", null, "Widget \"".concat(props.type.widget, "\" not implemented"), " (used by type \"".concat(props.type.name, "\")")));
}
/**
 * An input widget wrapped in a <div> with description and label.
 */


var FieldBox = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.memo(function FieldBox(props) {
  var field = props.field,
      value = props.value,
      placeholder = props.placeholder,
      disabled = props.disabled,
      setFieldValue = props.setFieldValue;
  var onChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (value) {
    return setFieldValue(field.name, value);
  }, [field, setFieldValue]);
  var className = "col-md-".concat(getFieldColumns(field));
  var Widget = getWidgetComponentWithFallback(field.type);

  if (Widget.isFakeWidget) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
      className: className,
      key: field.name
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Widget, {
      key: field.name,
      field: field
    }));
  }

  var description = field.description_i18n ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "help-text"
  }, (0,_i18n__WEBPACK_IMPORTED_MODULE_13__.trans_obj)(field.description_i18n)) : null;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: className,
    key: field.name
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dl", {
    className: "field"
  }, !field.hide_label ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dt", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_13__.trans_obj)(field.label_i18n)) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("dd", null, description, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(Widget, {
    value: value,
    onChange: onChange,
    type: field.type,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : undefined,
    disabled: disabled
  }))));
});
function getWidgetComponent(type) {
  // @ts-expect-error This is hard to type and not typed yet.
  return widgetComponents[type.widget] || null;
}
function getWidgetComponentWithFallback(type) {
  // @ts-expect-error This is hard to type and not typed yet.
  return widgetComponents[type.widget] || FallbackWidget;
}
/**
 * Get the width of a field in columns.
 */

function getFieldColumns(field) {
  var widthSpec = (field.type.width || "1/1").split("/");
  var fraction = 12 * +widthSpec[0] / +widthSpec[1];
  return Number.isNaN(fraction) ? 12 : Math.min(12, Math.max(2, parseInt("".concat(fraction))));
}
/**
 * Process fields into rows.
 */

function processFields(fields) {
  var rows = [];
  var currentColumns = 0;
  var row = [];
  fields.forEach(function (field) {
    var columns = getFieldColumns(field);

    if (columns + currentColumns > 12) {
      rows.push(row);
      currentColumns = 0;
      row = [];
    }

    row.push(field);
    currentColumns += columns;
  });

  if (row.length > 0) {
    rows.push(row);
  }

  return rows;
}
/**
 * Split the fields into normal and system fields.
 */


function splitFields(fields) {
  var normalFields = [];
  var systemFields = [];
  fields.forEach(function (field) {
    if (field.name.substr(0, 1) === "_") {
      systemFields.push(field);
    } else {
      normalFields.push(field);
    }
  });
  return [normalFields, systemFields];
}
/**
 * Render field rows using a render function.
 */

function FieldRows(_ref) {
  var fields = _ref.fields,
      renderFunc = _ref.renderFunc;
  var rows = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(function () {
    return processFields(fields);
  }, [fields]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, rows.map(function (row, idx) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
      key: idx,
      className: "row field-row"
    }, row.map(renderFunc));
  }));
}

/***/ }),

/***/ "./js/widgets/BooleanInputWidget.tsx":
/*!*******************************************!*\
  !*** ./js/widgets/BooleanInputWidget.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BooleanInputWidget": () => (/* binding */ BooleanInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");



var isTrue = function isTrue(value) {
  return value === "true" || value === "yes" || value === "1";
};

function BooleanInputWidget(_ref) {
  var type = _ref.type,
      value = _ref.value,
      disabled = _ref.disabled,
      placeholder = _ref.placeholder,
      _onChange = _ref.onChange;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "form-check"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", {
    className: "form-check-label"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    type: "checkbox",
    className: "form-check-input",
    disabled: disabled,
    ref: function ref(checkbox) {
      if (checkbox) {
        if (!value && placeholder) {
          checkbox.indeterminate = true;
          checkbox.checked = isTrue(placeholder);
        } else {
          checkbox.indeterminate = false;
        }
      }
    },
    checked: isTrue(value),
    onChange: function onChange(ev) {
      _onChange(ev.target.checked ? "yes" : "no");
    }
  }), type.checkbox_label_i18n ? (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(type.checkbox_label_i18n) : null));
}

/***/ }),

/***/ "./js/widgets/CheckboxesInputWidget.tsx":
/*!**********************************************!*\
  !*** ./js/widgets/CheckboxesInputWidget.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckboxesInputWidget": () => (/* binding */ CheckboxesInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }




var checkboxIsActive = function checkboxIsActive(field, value) {
  return value !== null && value.includes(field);
};

var flipSetValue = function flipSetValue(set, value, isActive) {
  if (isActive) {
    return set.includes(value) ? set : [].concat(_toConsumableArray(set), [value]);
  } else {
    return set.filter(function (v) {
      return v !== value;
    });
  }
};

var deserialize = function deserialize(value) {
  if (!value) {
    return null;
  }

  var rv = value.split(",").map(function (x) {
    return x.trim();
  });

  if (rv.length === 1 && rv[0] === "") {
    rv = [];
  }

  return rv;
};

function CheckboxesInputWidget(_ref) {
  var _type$choices;

  var disabled = _ref.disabled,
      type = _ref.type,
      _onChange = _ref.onChange,
      value = _ref.value,
      placeholder = _ref.placeholder;
  var deserializedValue = deserialize(value);
  var deserializedPlaceholder = deserialize(placeholder);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "checkboxes-widget"
  }, (_type$choices = type.choices) === null || _type$choices === void 0 ? void 0 : _type$choices.map(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        key = _ref3[0],
        description = _ref3[1];

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
      className: "form-check",
      key: key
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", {
      className: "form-check-label"
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
      className: "form-check-input",
      type: "checkbox",
      disabled: disabled,
      checked: checkboxIsActive(key, deserializedValue !== null && deserializedValue !== void 0 ? deserializedValue : deserializedPlaceholder),
      onChange: function onChange(ev) {
        var newValue = flipSetValue(deserializedValue || [], key, ev.target.checked);

        _onChange(newValue.join(", "));
      }
    }), (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(description)));
  }));
}

/***/ }),

/***/ "./js/widgets/DateInputWidget.tsx":
/*!****************************************!*\
  !*** ./js/widgets/DateInputWidget.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isValidDate": () => (/* binding */ isValidDate),
/* harmony export */   "validateDate": () => (/* binding */ validateDate),
/* harmony export */   "postprocessDate": () => (/* binding */ postprocessDate),
/* harmony export */   "DateInputWidget": () => (/* binding */ DateInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _wrapRegExp() { _wrapRegExp = function _wrapRegExp(re, groups) { return new BabelRegExp(re, void 0, groups); }; var _super = RegExp.prototype, _groups = new WeakMap(); function BabelRegExp(re, flags, groups) { var _this = new RegExp(re, flags); return _groups.set(_this, groups || _groups.get(re)), _setPrototypeOf(_this, BabelRegExp.prototype); } function buildGroups(result, re) { var g = _groups.get(re); return Object.keys(g).reduce(function (groups, name) { return groups[name] = result[g[name]], groups; }, Object.create(null)); } return _inherits(BabelRegExp, RegExp), BabelRegExp.prototype.exec = function (str) { var result = _super.exec.call(this, str); return result && (result.groups = buildGroups(result, this)), result; }, BabelRegExp.prototype[Symbol.replace] = function (str, substitution) { if ("string" == typeof substitution) { var groups = _groups.get(this); return _super[Symbol.replace].call(this, str, substitution.replace(/\$<([^>]+)>/g, function (_, name) { return "$" + groups[name]; })); } if ("function" == typeof substitution) { var _this = this; return _super[Symbol.replace].call(this, str, function () { var args = arguments; return "object" != _typeof(args[args.length - 1]) && (args = [].slice.call(args)).push(buildGroups(args, _this)), substitution.apply(this, args); }); } return _super[Symbol.replace].call(this, str, substitution); }, _wrapRegExp.apply(this, arguments); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }





var parseInteger = function parseInteger(s) {
  return Number.parseInt(s, 10);
};

function isValidDate(year, month, day) {
  var date = new Date(year, month - 1, day);
  return date.getFullYear() === year && date.getMonth() === month - 1 && date.getDate() === day;
}

var DATE_RE = /*#__PURE__*/_wrapRegExp(/^\s*(\d{4})\x2D(\d{1,2})\x2D(\d{1,2})\s*$/, {
  year: 1,
  month: 2,
  day: 3
});

function validateDate(value) {
  var _value$match;

  if (!value) {
    return null;
  }

  var groups = (_value$match = value.match(DATE_RE)) === null || _value$match === void 0 ? void 0 : _value$match.groups;

  if (groups && isValidDate(parseInteger(groups.year), parseInteger(groups.month), parseInteger(groups.day))) {
    return null;
  }

  return (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ERROR_INVALID_DATE");
}

var REVERSE_DATE_RE = /*#__PURE__*/_wrapRegExp(/^(\d{1,2})\.(\d{1,2})\.(\d{4})\s*$/, {
  day: 1,
  month: 2,
  year: 3
});

var pad = function pad(n) {
  return n < 10 ? "0".concat(n) : "".concat(n);
};

function postprocessDate(value) {
  var _value$match2;

  value = value.trim();
  var groups = (_value$match2 = value.match(REVERSE_DATE_RE)) === null || _value$match2 === void 0 ? void 0 : _value$match2.groups;

  if (groups) {
    var day = parseInteger(groups.day);
    var month = parseInteger(groups.month);
    var year = parseInteger(groups.year);
    return "".concat(year, "-").concat(pad(month), "-").concat(pad(day));
  }

  return value;
}
var inputAddon = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
  className: "fa fa-calendar"
});
function DateInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    inputType: "date",
    inputAddon: inputAddon,
    postprocessValue: postprocessDate,
    validate: validateDate
  }, props));
}

/***/ }),

/***/ "./js/widgets/FloatInputWidget.tsx":
/*!*****************************************!*\
  !*** ./js/widgets/FloatInputWidget.tsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FloatInputWidget": () => (/* binding */ FloatInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function postprocessFloat(value) {
  return value.trim();
}

function validateFloat(value) {
  if (value && !value.match(/^[+,-]?\d+[.]\d+$/)) {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ERROR_INVALID_NUMBER");
  }

  return null;
}

function FloatInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    inputType: "text",
    inputAddon: "0.0",
    postprocessValue: postprocessFloat,
    validate: validateFloat
  }, props));
}

/***/ }),

/***/ "./js/widgets/InputWidgetBase.tsx":
/*!****************************************!*\
  !*** ./js/widgets/InputWidgetBase.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InputWidgetBase)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _userLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../userLabel */ "./js/userLabel.tsx");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./types */ "./js/widgets/types.ts");



function InputWidgetBase(_ref) {
  var type = _ref.type,
      value = _ref.value,
      onChange = _ref.onChange,
      postprocessValue = _ref.postprocessValue,
      inputAddon = _ref.inputAddon,
      inputType = _ref.inputType,
      validate = _ref.validate,
      disabled = _ref.disabled,
      placeholder = _ref.placeholder;
  var onChangeHandler = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    var value = event.target.value;

    if (postprocessValue) {
      value = postprocessValue(value);
    }

    onChange(value);
  }, [onChange, postprocessValue]);
  var failure = validate ? validate(value) : null;

  var setValidity = function setValidity(el) {
    el === null || el === void 0 ? void 0 : el.setCustomValidity(failure !== null && failure !== void 0 ? failure : "");
  };

  var configuredAddon = type.addon_label_i18n;
  var addon = configuredAddon ? (0,_userLabel__WEBPACK_IMPORTED_MODULE_1__.formatUserLabel)(configuredAddon) : inputAddon;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "input-group"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("input", {
    ref: setValidity,
    type: inputType,
    disabled: disabled,
    placeholder: placeholder,
    className: (0,_types__WEBPACK_IMPORTED_MODULE_2__.getInputClass)(type),
    onChange: onChangeHandler,
    value: value || ""
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", {
    className: "input-group-text"
  }, addon)), failure !== null && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "validation-block validation-block-error"
  }, failure));
}

/***/ }),

/***/ "./js/widgets/IntegerInputWidget.tsx":
/*!*******************************************!*\
  !*** ./js/widgets/IntegerInputWidget.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntegerInputWidget": () => (/* binding */ IntegerInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }





function postprocessInteger(value) {
  return value.trim();
}

function validateInteger(value) {
  if (value && !value.match(/^-?\d+$/)) {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ERROR_INVALID_NUMBER");
  }

  return null;
}

function IntegerInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    inputType: "text",
    inputAddon: "0",
    postprocessValue: postprocessInteger,
    validate: validateInteger
  }, props));
}

/***/ }),

/***/ "./js/widgets/MultiLineTextInputWidget.tsx":
/*!*************************************************!*\
  !*** ./js/widgets/MultiLineTextInputWidget.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MultiLineTextInputWidget": () => (/* binding */ MultiLineTextInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./types */ "./js/widgets/types.ts");


function MultiLineTextInputWidget(_ref) {
  var type = _ref.type,
      value = _ref.value,
      placeholder = _ref.placeholder,
      disabled = _ref.disabled,
      onChangeProp = _ref.onChange;
  var textarea = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
  var recalculateSize = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function () {
    var node = textarea.current;

    if (node) {
      node.style.height = "auto";
      node.style.height = node.scrollHeight + "px";
    }
  }, []);
  var onChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (event) {
    onChangeProp(event.target.value);
  }, [onChangeProp]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    recalculateSize();
  }, [recalculateSize, value]);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(function () {
    window.addEventListener("resize", recalculateSize);
    return function () {
      window.removeEventListener("resize", recalculateSize);
    };
  }, [recalculateSize]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("textarea", {
    ref: textarea,
    className: (0,_types__WEBPACK_IMPORTED_MODULE_1__.getInputClass)(type),
    onChange: onChange,
    value: value,
    disabled: disabled,
    placeholder: placeholder
  }));
}

/***/ }),

/***/ "./js/widgets/SelectInputWidget.tsx":
/*!******************************************!*\
  !*** ./js/widgets/SelectInputWidget.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectInputWidget": () => (/* binding */ SelectInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./types */ "./js/widgets/types.ts");



function SelectInputWidget(props) {
  var _type$choices;

  var type = props.type,
      value = props.value,
      placeholder = props.placeholder,
      _onChange = props.onChange,
      disabled = props.disabled;
  var choices = (_type$choices = type.choices) === null || _type$choices === void 0 ? void 0 : _type$choices.map(function (item) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("option", {
      key: item[0],
      value: item[0]
    }, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(item[1]));
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("select", {
    className: (0,_types__WEBPACK_IMPORTED_MODULE_2__.getInputClass)(type),
    value: value || placeholder || "",
    onChange: function onChange(e) {
      return _onChange(e.target.value);
    },
    disabled: disabled
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("option", {
    key: "",
    value: ""
  }, "----"), choices));
}

/***/ }),

/***/ "./js/widgets/SingleLineTextInputWidget.tsx":
/*!**************************************************!*\
  !*** ./js/widgets/SingleLineTextInputWidget.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SingleLineTextInputWidget": () => (/* binding */ SingleLineTextInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }



var inputAddon = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
  className: "fa fa-paragraph"
});
function SingleLineTextInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({
    inputType: "text",
    inputAddon: inputAddon
  }, props));
}

/***/ }),

/***/ "./js/widgets/SlugInputWidget.tsx":
/*!****************************************!*\
  !*** ./js/widgets/SlugInputWidget.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SlugInputWidget": () => (/* binding */ SlugInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }




function postprocessSlug(value) {
  return value.replace(/\s+/g, "-");
}

var inputAddon = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
  className: "fa fa-link"
});
function SlugInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({
    inputType: "text",
    inputAddon: inputAddon,
    postprocessValue: postprocessSlug
  }, props));
}

/***/ }),

/***/ "./js/widgets/UrlInputWidget.tsx":
/*!***************************************!*\
  !*** ./js/widgets/UrlInputWidget.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UrlInputWidget": () => (/* binding */ UrlInputWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./InputWidgetBase */ "./js/widgets/InputWidgetBase.tsx");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils */ "./js/utils.ts");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }






function validateUrl(value) {
  if (value && !(0,_utils__WEBPACK_IMPORTED_MODULE_2__.isValidUrl)(value)) {
    return (0,_i18n__WEBPACK_IMPORTED_MODULE_3__.trans)("ERROR_INVALID_URL");
  }

  return null;
}

var inputAddon = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
  className: "fa fa-external-link"
});
function UrlInputWidget(props) {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_InputWidgetBase__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({
    inputType: "text",
    inputAddon: inputAddon,
    validate: validateUrl
  }, props));
}

/***/ }),

/***/ "./js/widgets/fakeWidgets.tsx":
/*!************************************!*\
  !*** ./js/widgets/fakeWidgets.tsx ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LineWidget": () => (/* binding */ LineWidget),
/* harmony export */   "SpacingWidget": () => (/* binding */ SpacingWidget),
/* harmony export */   "InfoWidget": () => (/* binding */ InfoWidget),
/* harmony export */   "HeadingWidget": () => (/* binding */ HeadingWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../i18n */ "./js/i18n.tsx");


function LineWidget() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("hr", null);
}
LineWidget.isFakeWidget = true;
function SpacingWidget() {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "spacing-widget"
  });
}
SpacingWidget.isFakeWidget = true;
function InfoWidget(props) {
  var label = (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(props.field.label_i18n);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "info-widget"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("p", null, label ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("strong", null, label + ": ") : null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(props.field.description_i18n)));
}
InfoWidget.isFakeWidget = true;
function HeadingWidget(props) {
  var _props$field$type$hea;

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h3", null, (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)((_props$field$type$hea = props.field.type.heading_i18n) !== null && _props$field$type$hea !== void 0 ? _props$field$type$hea : {}));
}
HeadingWidget.isFakeWidget = true;

/***/ }),

/***/ "./js/widgets/flow/AddFlowBlockButtons.tsx":
/*!*************************************************!*\
  !*** ./js/widgets/flow/AddFlowBlockButtons.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddFlowBlockButtons)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _userLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../userLabel */ "./js/userLabel.tsx");



function AddFlowBlockButtons(_ref) {
  var flowblock_order = _ref.flowblock_order,
      flowblocks = _ref.flowblocks,
      addBlock = _ref.addBlock;
  var models = flowblock_order.map(function (key) {
    return flowblocks[key];
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "add-flow-block"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("label", null, "".concat((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("ADD_FLOWBLOCK"), ": ")), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "btn-group"
  }, models.map(function (model) {
    var label = model.button_label ? (0,_userLabel__WEBPACK_IMPORTED_MODULE_2__.formatUserLabel)(model.button_label) : (0,_userLabel__WEBPACK_IMPORTED_MODULE_2__.formatUserLabel)(model.name_i18n);
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
      type: "button",
      className: "btn btn-secondary border",
      onClick: function onClick() {
        return addBlock(model);
      },
      title: (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans_obj)(model.name_i18n),
      key: model.id
    }, label);
  })));
}

/***/ }),

/***/ "./js/widgets/flow/FlowBlock.tsx":
/*!***************************************!*\
  !*** ./js/widgets/flow/FlowBlock.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _userLabel__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../userLabel */ "./js/userLabel.tsx");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../widgets */ "./js/widgets.tsx");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






/**
 * Render a single flow block in the flow widget. The function to render
 * the child input widgets is passed down.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (/*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.memo)(function FlowBlock(_ref) {
  var block = _ref.block,
      moveBlock = _ref.moveBlock,
      renderFormField = _ref.renderFormField,
      removeBlock = _ref.removeBlock,
      idx = _ref.idx,
      length = _ref.length;

  var _useReducer = (0,react__WEBPACK_IMPORTED_MODULE_0__.useReducer)(function (s) {
    return !s;
  }, false),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      collapsed = _useReducer2[0],
      toggle = _useReducer2[1];

  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "flow-block"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "d-flex justify-content-between"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("h4", {
    className: "block-name"
  }, (0,_userLabel__WEBPACK_IMPORTED_MODULE_2__.formatUserLabel)(block.model.name_i18n)), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "btn-group action-bar"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary btn-sm border",
    title: collapsed ? (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("EXPAND") : (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("COLLAPSE"),
    onClick: toggle
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: collapsed ? "fa fa-expand" : "fa fa-compress"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary btn-sm border",
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("UP"),
    disabled: idx === 0,
    onClick: function onClick() {
      return moveBlock(idx, -1);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-fw fa-chevron-up"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary btn-sm border",
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("DOWN"),
    disabled: idx === length - 1,
    onClick: function onClick() {
      return moveBlock(idx, 1);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-fw fa-chevron-down"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("button", {
    type: "button",
    className: "btn btn-secondary btn-sm border",
    title: (0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("REMOVE"),
    onClick: function onClick() {
      return removeBlock(idx);
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("i", {
    className: "fa fa-fw fa-times"
  })))), collapsed ? null : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets__WEBPACK_IMPORTED_MODULE_3__.FieldRows, {
    fields: block.model.fields,
    renderFunc: renderFormField.bind(undefined, block)
  }));
}));

/***/ }),

/***/ "./js/widgets/flow/FlowWidget.tsx":
/*!****************************************!*\
  !*** ./js/widgets/flow/FlowWidget.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "parseFlowFormat": () => (/* binding */ parseFlowFormat),
/* harmony export */   "serializeFlowFormat": () => (/* binding */ serializeFlowFormat),
/* harmony export */   "FlowWidget": () => (/* binding */ FlowWidget)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../i18n */ "./js/i18n.tsx");
/* harmony import */ var _metaformat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./metaformat */ "./js/widgets/flow/metaformat.tsx");
/* harmony import */ var _widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../widgets */ "./js/widgets.tsx");
/* harmony import */ var _FlowBlock__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FlowBlock */ "./js/widgets/flow/FlowBlock.tsx");
/* harmony import */ var _AddFlowBlockButtons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AddFlowBlockButtons */ "./js/widgets/flow/AddFlowBlockButtons.tsx");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }








/**
 * Parse the row string from a Lektor file for the flow format
 * to its separate flow blocks. Each flow block can then be
 * deserialised with deserializeFlowBlock.
 */
function parseFlowFormat() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "";
  var blocks = [];
  var lines = value.split(/\r?\n/);
  var blockName = null;
  var blockLines = [];

  var flush = function flush() {
    if (blockName !== null) {
      blocks.push([blockName, blockLines]);
      blockLines = [];
    }
  };

  var _iterator = _createForOfIteratorHelper(lines),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var line = _step.value;

      // leading whitespace is ignored.
      if (blockName === null && line.match(/^\s*$/)) {
        continue;
      }

      var blockStart = line.match(/^####\s*([^#]*?)\s*####\s*$/);

      if (!blockStart) {
        if (blockName === null) {
          // bad format :(
          return [];
        }
      } else {
        flush();
        blockName = blockStart[1];
        continue;
      }

      blockLines.push(line.replace(/^#####(.*?)#####$/, "####$1####"));
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  flush();
  return blocks;
}
/** Serialise an array of single blocks to a string. */

function serializeFlowFormat(blocks) {
  var serialisedBlocks = [];
  blocks.forEach(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        blockName = _ref2[0],
        lines = _ref2[1];

    serialisedBlocks.push("#### ".concat(blockName, " ####\n"));
    lines.forEach(function (line) {
      serialisedBlocks.push(line.replace(/^(####(.*)####)(\r?\n)?$/, "#$1#$3"));
    });
  });
  var rv = serialisedBlocks.join("");
  /* we need to chop of the last newline if it exists because this would
     otherwise add a newline to the last block.  This is just a side effect
     of how we serialize the meta format internally */

  return rv[rv.length - 1] === "\n" ? rv.substr(0, rv.length - 1) : rv;
}

function deserializeFlowBlock(model, lines, localId) {
  var data = {};
  var rawData = {};
  (0,_metaformat__WEBPACK_IMPORTED_MODULE_2__.tokenize)(lines).forEach(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        key = _ref4[0],
        lines = _ref4[1];

    rawData[key] = lines.join("");
  });
  model.fields.forEach(function (field) {
    var value = rawData[field.name] || "";
    var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_3__.getWidgetComponent)(field.type);

    if (!value && field["default"]) {
      value = field["default"];
    }

    if (Widget && Widget.deserializeValue) {
      value = Widget.deserializeValue(value, field.type);
    }

    data[field.name] = value;
  });
  return {
    localId: localId,
    model: model,
    data: data
  };
}

function serializeFlowBlock(flockBlockModel, data) {
  var rv = [];
  flockBlockModel.fields.forEach(function (field) {
    var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_3__.getWidgetComponent)(field.type);

    if (Widget === null) {
      return;
    }

    var value = data[field.name];

    if (value === undefined || value === null) {
      return;
    }

    if (Widget.serializeValue) {
      value = Widget.serializeValue(value, field.type);
    }

    rv.push([field.name, value]);
  });
  return (0,_metaformat__WEBPACK_IMPORTED_MODULE_2__.serialize)(rv);
}

function FlowWidget(props) {
  var value = props.value,
      onChange = props.onChange;
  var moveBlock = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (idx, offset) {
    onChange(function (prevValue) {
      var newIndex = idx + offset;

      if (newIndex < 0 || newIndex >= prevValue.length) {
        return prevValue;
      }

      var newValue = _toConsumableArray(prevValue);

      newValue[newIndex] = prevValue[idx];
      newValue[idx] = prevValue[newIndex];
      return newValue;
    });
  }, [onChange]);
  var removeBlock = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (idx) {
    if (confirm((0,_i18n__WEBPACK_IMPORTED_MODULE_1__.trans)("REMOVE_FLOWBLOCK_PROMPT"))) {
      onChange(function (v) {
        return v.filter(function (item, i) {
          return i !== idx;
        });
      });
    }
  }, [onChange]);
  var addNewBlock = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (flowBlockModel) {
    onChange(function (prevValue) {
      var _prevValue;

      // find the first available id for this new block - use findMax + 1
      (_prevValue = prevValue) !== null && _prevValue !== void 0 ? _prevValue : prevValue = [];
      var newBlockId = Math.max.apply(Math, [0].concat(_toConsumableArray(prevValue.map(function (_ref5) {
        var localId = _ref5.localId;
        return localId;
      })))) + 1; // this is a rather ugly way to do this, but hey, it works.

      var newBlock = deserializeFlowBlock(flowBlockModel, [], newBlockId);
      return [].concat(_toConsumableArray(prevValue), [newBlock]);
    });
  }, [onChange]);
  var renderFormField = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(function (block, field) {
    var fieldValue = block.data[field.name];
    var placeholder = field["default"];
    var Widget = (0,_widgets__WEBPACK_IMPORTED_MODULE_3__.getWidgetComponentWithFallback)(field.type);

    if (Widget.deserializeValue && placeholder != null) {
      placeholder = Widget.deserializeValue(placeholder, field.type);
    }

    var setFieldValue = function setFieldValue(fieldName, v) {
      onChange(function (prevValue) {
        var newValue = _toConsumableArray(prevValue);

        var idx = newValue.indexOf(block);

        var data = _objectSpread(_objectSpread({}, block.data), {}, _defineProperty({}, fieldName, typeof v === "function" ? v(block.data[fieldName]) : v));

        newValue[idx] = _objectSpread(_objectSpread({}, block), {}, {
          data: data
        });
        return newValue;
      });
    };

    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_widgets__WEBPACK_IMPORTED_MODULE_3__.FieldBox, {
      key: field.name,
      value: fieldValue,
      placeholder: placeholder,
      field: field,
      setFieldValue: setFieldValue
    });
  }, [onChange]);
  var _props$type = props.type,
      flowblock_order = _props$type.flowblock_order,
      flowblocks = _props$type.flowblocks;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", {
    className: "flow-widget"
  }, value.map(function (block, idx) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FlowBlock__WEBPACK_IMPORTED_MODULE_4__["default"], {
      key: block.localId,
      block: block,
      moveBlock: moveBlock,
      renderFormField: renderFormField,
      removeBlock: removeBlock,
      length: value.length,
      idx: idx
    });
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AddFlowBlockButtons__WEBPACK_IMPORTED_MODULE_5__["default"], {
    flowblock_order: flowblock_order,
    flowblocks: flowblocks,
    addBlock: addNewBlock
  }));
}

FlowWidget.deserializeValue = function (value, _ref6) {
  var flowblocks = _ref6.flowblocks;
  var blockId = 0;
  var blocks = [];
  parseFlowFormat(value).forEach(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 2),
        id = _ref8[0],
        lines = _ref8[1];

    var flowBlock = flowblocks[id];

    if (flowBlock !== undefined) {
      blocks.push(deserializeFlowBlock(flowBlock, lines, ++blockId));
    }
  });
  return blocks;
};

FlowWidget.serializeValue = function (value) {
  return serializeFlowFormat(value.map(function (_ref9) {
    var flowBlockModel = _ref9.model,
        data = _ref9.data;
    return [flowBlockModel.id, serializeFlowBlock(flowBlockModel, data)];
  }));
};

/***/ }),

/***/ "./js/widgets/flow/metaformat.tsx":
/*!****************************************!*\
  !*** ./js/widgets/flow/metaformat.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "lineIsDashes": () => (/* binding */ lineIsDashes),
/* harmony export */   "processBuf": () => (/* binding */ processBuf),
/* harmony export */   "tokenize": () => (/* binding */ tokenize),
/* harmony export */   "serialize": () => (/* binding */ serialize)
/* harmony export */ });
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/** Check whether the (trimmed) line is at least 3 chars wide and only dashes. */
function lineIsDashes(rawLine) {
  var line = rawLine.trim();
  return line.length >= 3 && line.match(/[^-]/) === null;
}
function processBuf(buf) {
  if (buf.length === 0) {
    return buf;
  }

  var lines = buf.map(function (line) {
    return lineIsDashes(line) ? line.substr(1) : line;
  });
  var lastLine = lines[lines.length - 1];

  if (lastLine[lastLine.length - 1] === "\n") {
    // trim newline at the end of the last line.
    lines[lines.length - 1] = lastLine.substr(0, lastLine.length - 1);
  }

  return lines;
}

function trimTabsAndSpaces(str) {
  var match = str.match(/^[\t ]*(.*?)[\t ]*$/m);
  return match ? match[1] : "";
}

function tokenize(lines) {
  var key = null;
  var buf = [];
  var wantNewline = false;
  var rv = [];

  function flushItem() {
    if (key !== null) {
      rv.push([key, processBuf(buf)]);
      key = null;
      buf = [];
    }
  }

  for (var i = 0; i < lines.length; i++) {
    var match = lines[i].match(/^(.*?)(\r?\n)*$/m);
    var line = match ? "".concat(match[1], "\n") : "\n";

    if (line.trimRight() === "---") {
      wantNewline = false;
      flushItem();
    } else if (key !== null) {
      if (wantNewline) {
        wantNewline = false;

        if (line.match(/^\s*$/)) {
          continue;
        }
      }

      buf.push(line);
    } else {
      var bits = line.split(":");

      if (bits.length >= 2) {
        var _bits = _toArray(bits),
            rawKey = _bits[0],
            rest = _bits.slice(1);

        key = rawKey.trim();
        var firstBit = trimTabsAndSpaces(rest.join(":"));

        if (!firstBit.match(/^\s*$/)) {
          buf = [firstBit];
        } else {
          buf = [];
          wantNewline = true;
        }
      }
    }
  }

  flushItem();
  return rv;
}
function serialize(blocks) {
  var rv = [];
  blocks.forEach(function (item, idx) {
    var _item = _slicedToArray(item, 2),
        key = _item[0],
        value = _item[1];

    if (idx > 0) {
      rv.push("---\n");
    }

    if (value.match(/([\r\n]|(^[\t ])|([\t ]$))/m)) {
      rv.push(key + ":\n");
      rv.push("\n");
      var lines = value.split(/\n/);

      if (lines[lines.length - 1] === "") {
        lines.pop();
      }

      lines.forEach(function (line) {
        rv.push(lineIsDashes(line) ? "-".concat(line, "\n") : "".concat(line, "\n"));
      });
    } else {
      rv.push(key + ": " + value + "\n");
    }
  });
  return rv;
}

/***/ }),

/***/ "./js/widgets/types.ts":
/*!*****************************!*\
  !*** ./js/widgets/types.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getInputClass": () => (/* binding */ getInputClass)
/* harmony export */ });
function getInputClass(type) {
  if (type.size === "small") {
    return "form-control input-sm";
  } else if (type.size === "large") {
    return "form-control input-lg";
  }

  return "form-control";
}

/***/ }),

/***/ "./scss/main.scss":
/*!************************!*\
  !*** ./scss/main.scss ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ "../lektor/translations/ca.json":
/*!**************************************!*\
  !*** ../lektor/translations/ca.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Tornar al Lloc Web","UNLOAD_ACTIVE_TAB":"Hi ha informació sense desar, està segur que vol abandonar aquesta pàgina?","EDIT_METADATA":"Editar Metadades","EDIT":"Editar","DELETE":"Esborrar","PREVIEW":"Previsualitzar","ALTS":"Alternatives","PRIMARY_ALT":"Primària","PRIMARY_OVERLAY":"Overlaid","ADD_CHILD_PAGE":"Afegir Pàgina","ADD_ATTACHMENT":"Afegir Adjunt","ATTACHMENT_ACTIONS":"Accions sobre els Adjunts","PAGE_ACTIONS":"Accions sobre la Pàgina","NO_CHILD_PAGES":"Sense Subpàgines","CHILD_PAGES":"Subpàgines","NO_ATTACHMENTS":"Sense Adjunts","ATTACHMENTS":"Adjunts","ADD_ATTACHMENT_TO":"Afegir Adjunt a “%s”","ADD_ATTACHMENT_NOTE":"Pot pujar un nou adjunt aquí.","UPLOAD":"Pujar","PROGRESS":"Avenç","ERROR_PREFIX":"Error: ","ERROR_NO_ID_PROVIDED":"No s\'ha proporcionat un ID.","ERROR_PAGE_ID_DUPLICATE":"Ja existeix una pàgina amb aquest ID (%s).","ERROR_INVALID_ID":"ID invàlid","ERROR_INVALID_DATE":"Data invàlida","ERROR_INVALID_NUMBER":"Número no vàlid","ERROR_INVALID_URL":"URL no vàlida","ERROR":"Error","ERROR_OCURRED":"Ha ocorregut un Error","ERROR_REQUEST_FAILED":"No s\'ha pogut enviar la tasca al servidor.  Potser el servidor està apagat o és inaccessible","ERROR_SERVER_UNAVAILABLE":"Servidor No Disponible","ERROR_SERVER_UNAVAILABLE_MESSAGE":"El servidor no respon.  Ha estat apagat o hi ha hagut un error crític que ha fet que estigui inoperatiu i hagi de ser reiniciat.","MODEL":"Model","ADD_CHILD_PAGE_TO":"Afegir Subpàgina a “%s”","ADD_CHILD_PAGE_NOTE":"Pot afegir una nova subpàgina aquí. Tingui en compte que el model o el ID no podrà ser canviat fàcilment més endavant.","CREATE_CHILD_PAGE":"Afegir pàgina filla","DELETE_ATTACHMENT_PROMPT":"Realment vol esborrar aquest adjunt?","DELETE_ATTACHMENT_ALT_PROMPT":"Realment vol esborrar les metadades d\'aquest adjunt alternatiu?","DELETE_PAGE_PROMPT":"Vol realment esborrar aquesta pàgina?","DELETE_PAGE_ALT_PROMPT":"Realment desitja esborrar aquesta alternativa?","DELETE_PAGE_CHILDREN_WARNING":"També s\'esborraran les subpàgines que pengin d\'aquesta pàgina.","DELETE_RECORD":"Esborrar “%s”","DELETE_ALL_PAGE_ALTS":"Esborrar també totes les alternatives i fitxers adjunts.","DELETE_ALL_ATTACHMENT_ALTS":"Esborrar totes les alternatives de l\'annex i el fitxer adjunt.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Esborrar només el registre principal.  Els adjunts, les alternatives i les subpàgines no seran esborrades.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Esborrar només les metadades del registre principal.","DELETE_PRIMARY_ALT_INFO":"Com aquest registre és una alternativa principal, pot ser esborrat per separat o conjuntament a la resta de continguts.","CHILD_PAGES_TO_BE_DELETED":"Subpàgines que seran esborrares:","ALTS_TO_BE_DELETED":"Alternatives que seran eliminades:","ATTACHMENTS_TO_BE_DELETED":"Adjunts que seran eliminats:","YES_DELETE":"Sí, esborrar","NO_CANCEL":"No, cancel·lar","SYSTEM_FIELDS":"Camps del Sistema","EDIT_ATTACHMENT_METADATA_OF":"Editar les Metadades de l\'Adjunt “%s”","EDIT_PAGE_NAME":"Editar “%s”","SAVE_CHANGES":"Desar els canvis","BROWSE_FS":"Veure al Sistema de fitxers","BROWSE_FS_MAC":"Mostrar al Finder","BROWSE_FS_WINDOWS":"Mostrar a l\'Explorador","ERROR_CANNOT_BROWSE_FS":"Error: el fitxer no existeix encara.","REMOVE_FLOWBLOCK_PROMPT":"¿Realment vol esborrar aquest block?","ADD_FLOWBLOCK":"Afegir Block","INVALID_INPUT":"Entrada invàlida","UP":"Amunt","DOWN":"Abaix","REMOVE":"Esborrar","ID":"ID","CLOSE":"Tancar","CANCEL":"Cancel·lar","BACK_TO_OVERVIEW":"Tornar a la Revisió","PUBLISH":"Publicar","PUBLISH_NOTE":"Des d\'aquí pot publicar la versió actual del lloc web.","PUBLISH_SERVER":"Servidor Destinació","CURRENTLY_PUBLISHING":"Publicannt ...","STATE":"Estat","PUBLISH_DONE":"Publicat","PUBLISH_STATE_BUILDING":"Els canvis s\'estan generant ...","PUBLISH_STATE_PUBLISH":"Els canvis s\'estan publicant ...","PUBLISH_STATE_DONE":"Publicació finalitzada.","FIND_FILES":"Buscar Fitxers","FIND_FILES_PLACEHOLDER":"Introdueixi el nom de la pàgina ...","ATTACHMENT_TYPE":"Tipus d\'adjunt","URL_SLUG":"URL personalitzada","TEMPLATE":"Plantilla","HIDE_PAGE":"Amagar pàgina","HIDE_PAGE_EXPLANATION":"Hauria d\'estar oculta aquesta pàgina?","PAGE_IS_DISCOVERABLE":"La Pàgina és detectable","PAGE_IS_DISCOVERABLE_EXPLANATION":"Si s\'habilita, la pàgina pot ser detectada, en cas contrari la URL del contingut ha de ser coneguda.","REFRESH_BUILD":"Regenerar Lloc Web","REFRESH_BUILD_NOTE":"Això esborra tots els resultats generats i llença una nova generació des de zero.  Això és útil en algunes situacions on els errors de sincronització o a les plantilles han causat un resultat corrupte.","CURRENTLY_REFRESHING_BUILD":"Regenerant ...","REFRESHING_BUILD_DONE":"Actualització finalitzada!","FAILED_TO_LAUNCH_LEKTOR":"Ha fallat l\'execució de Lektor.","PROJECT":"Projecte","CLOSE_PROJECT":"Tancar Projecte","OPEN_PROJECT":"Obrir Projecte","BROWSE_WEBSITE":"Anar al Lloc Web","VIEW_ADMIN_PANEL":"Anar al Panell d\'Administració","QUIT":"Sortir","FAILED_TO_LOAD_PROJECT":"Ha fallat la càrrega del projecte :(","LOADING_PROJECT":"Carregant projecte ...","INITIALIZING_LEKTOR":"Inicialitzant Lektor ...","QUIT_LEKTOR":"Sortir de Lektor","FILE":"Arxiu","UNDO":"Desfer","REDO":"Tornar a fer","CUT":"Tallar","COPY":"Copiar","PASTE":"Enganxar","SELECT_ALL":"Seleccionar-ho Tot","HELP":"Ajuda","VISIT_WEBSITE":"Visitar Web","INSTALL_SHELL_COMMAND":"Instalar Eina","INSTALL_SHELL_COMMAND_QUESTION":"Vol instal·lar la eina \'lektor\'? Es requereixen permisos d\'administració.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Ha fallat la instal·lació de l\'eina.","INSTALL_SHELL_COMMAND_SUCCESS":"L\'eina ha estat instal·lada amb èxit.","OPERATION_SUCCESS":"Amb èxit","YES":"Sí","NO":"No","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Error al intentar obrir el fitxer de contingut","OPEN_OTHER_PROJECT":"Obrir un altre Projecte","OPEN_OTHER_PROJECT_QUESTION":"Obrir aquest fitxer implica obrir un altre projecte (%s). El projecte actual serà tancat. Vol continuar?"}');

/***/ }),

/***/ "../lektor/translations/de.json":
/*!**************************************!*\
  !*** ../lektor/translations/de.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Zur Webseite","UNLOAD_ACTIVE_TAB":"Du hast ungespeicherte Änderungen, willst du die Seite wirklich verlassen?","EDIT_METADATA":"Metadaten bearbeiten","EDIT":"Bearbeiten","DELETE":"Löschen","PREVIEW":"Vorschau","ALTS":"Alternativen","PRIMARY_ALT":"Primär","PRIMARY_OVERLAY":"Überlagert","ADD_CHILD_PAGE":"Seite hinzufügen","ADD_ATTACHMENT":"Anhang hinzufügen","ATTACHMENT_ACTIONS":"Anhang-Aktionen","PAGE_ACTIONS":"Seiten-Aktionen","NO_CHILD_PAGES":"Keine Unterseiten","CHILD_PAGES":"Unterseiten","NO_ATTACHMENTS":"Keine Anhänge","ATTACHMENTS":"Anhänge","ADD_ATTACHMENT_TO":"Anhang zu “%s” hinzufügen","ADD_ATTACHMENT_NOTE":"Hier kannst du neue Anhänge hochladen.","UPLOAD":"Hochladen","PROGRESS":"Fortschritt","ERROR_PREFIX":"Fehler: ","ERROR_NO_ID_PROVIDED":"Es wurde keine ID eingegeben.","ERROR_PAGE_ID_DUPLICATE":"Eine Seite mit dieser ID (%s) existiert bereits.","ERROR_INVALID_ID":"Ungültige ID","ERROR_INVALID_DATE":"Ungültiges Datum","ERROR_INVALID_NUMBER":"Ungültige Zahl","ERROR_INVALID_URL":"Ungültige URL","ERROR":"Fehler","ERROR_OCURRED":"Ein Fehler ist aufgetreten","ERROR_REQUEST_FAILED":"Ein Befehl konnte nicht an den Server gesendet werden. Eventuell reagiert der Server nicht oder wurde gestoppt.","ERROR_SERVER_UNAVAILABLE":"Server unerreichbar","ERROR_SERVER_UNAVAILABLE_MESSAGE":"Der Server reagiert nicht. Entweder er wurde gestoppt oder ein kritischer Fehler ist aufgetreten und er muss neu gestartet werden.","MODEL":"Modell","ADD_CHILD_PAGE_TO":"Unterseite zu “%s” hinzufügen","ADD_CHILD_PAGE_NOTE":"Du kannst hier eine neue Unterseite hinzufügen.  Beachte, dass die ID und das Modell später nicht mehr verändert werden kann.","CREATE_CHILD_PAGE":"Unterseite hinzufügen","DELETE_ATTACHMENT_PROMPT":"Willst du den Anhang wirklich löschen?","DELETE_ATTACHMENT_ALT_PROMPT":"Willst du die Metadaten dieser Anhang-Alternative wirklich löschen?","DELETE_PAGE_PROMPT":"Willst du diese Seite wirklich löschen?","DELETE_PAGE_ALT_PROMPT":"Willst du diese Alternative wirklich löschen?","DELETE_PAGE_CHILDREN_WARNING":"Dies wird auch die Unterseiten der Seite löschen.","DELETE_RECORD":"“%s” Löschen","DELETE_ALL_PAGE_ALTS":"Alle Alternativen und angehängten Dateien mitlöschen.","DELETE_ALL_ATTACHMENT_ALTS":"Alle Alternativen und die angehängte Datei löschen.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Nur den Primäreintrag löschen. Anhänge, andere Alternativen und Unterseiten werden nicht gelöscht.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Nur die Metadaten des Primäreintrages löschen.","DELETE_PRIMARY_ALT_INFO":"Da dieser Eintrag eine Primäralternative ist, kann diese auch separat gelöscht werden oder zusammen mit allen anderen Inhalten.","CHILD_PAGES_TO_BE_DELETED":"Unterseiten, die gelöscht werden:","ALTS_TO_BE_DELETED":"Alternativen, die gelöscht werden:","ATTACHMENTS_TO_BE_DELETED":"Anhänge, die gelöscht werden:","YES_DELETE":"Ja, löschen","NO_CANCEL":"Nein, abbrechen","SYSTEM_FIELDS":"Systemfelder","EDIT_ATTACHMENT_METADATA_OF":"Bearbeite Metadaten von Anhang “%s”","EDIT_PAGE_NAME":"Bearbeite “%s”","SAVE_CHANGES":"Änderungen speichern","BROWSE_FS":"Im Dateisystem öffnen","BROWSE_FS_MAC":"In Finder anzeigen","BROWSE_FS_WINDOWS":"Im Explorer öffnen","ERROR_CANNOT_BROWSE_FS":"Fehler: Datei existiert noch nicht","REMOVE_FLOWBLOCK_PROMPT":"Willst du diesen Block wirklich entfernen?","ADD_FLOWBLOCK":"Block hinzufügen","INVALID_INPUT":"Ungültige Eingabe","UP":"Nach oben","DOWN":"Nach unten","REMOVE":"Entfernen","ID":"ID","CLOSE":"Schließen","CANCEL":"Abbrechen","BACK_TO_OVERVIEW":"Übersicht","PUBLISH":"Veröffentlichen","PUBLISH_NOTE":"Von hier aus kann der aktuelle Stand der Webseite publiziert werden.","PUBLISH_SERVER":"Ziel-Server","CURRENTLY_PUBLISHING":"Veröffentlichung …","STATE":"Status","PUBLISH_DONE":"Veröffentlicht","PUBLISH_STATE_BUILDING":"Änderungen werden gebaut ...","PUBLISH_STATE_PUBLISH":"Änderungen werden publiziert ...","PUBLISH_STATE_DONE":"Veröffentlichung fertiggestellt.","FIND_FILES":"Seiten Finden","FIND_FILES_PLACEHOLDER":"Seitenname eingeben ...","ATTACHMENT_TYPE":"Attachment type","URL_SLUG":"URL-Slug","TEMPLATE":"Vorlage","HIDE_PAGE":"Seite verstecken","HIDE_PAGE_EXPLANATION":"Soll diese Seite versteckt werden?","PAGE_IS_DISCOVERABLE":"Seite ist erkundbar","PAGE_IS_DISCOVERABLE_EXPLANATION":"Wenn dies aktiviert ist, wird Seite von Vorlagen verlinkt. Ansonsten muss die URL bekannt sein.","REFRESH_BUILD":"Änderungen regenerieren","REFRESH_BUILD_NOTE":"In machen Situationen kann es nützlich sein, alle Änderungen zu regenerieren.  Zum Beispiel können Synchronisationsfehler und kaputte Vorlagen manchmal dazu führen, dass Seiten fehlerhaft gebaut wurden.  Dies bringt Lektor dazu, alle Seiten neu zu bauen.","CURRENTLY_REFRESHING_BUILD":"Änderungen werden regeneriert ...","REFRESHING_BUILD_DONE":"Änderungen wurden regeneriert!","FAILED_TO_LAUNCH_LEKTOR":"Lektor konnte nicht gestartet werden.","PROJECT":"Projekt","CLOSE_PROJECT":"Projekt schließen","OPEN_PROJECT":"Projekt öffnen","BROWSE_WEBSITE":"Webseite anzeigen","VIEW_ADMIN_PANEL":"Admin-Panel öffnen","QUIT":"Beenden","FAILED_TO_LOAD_PROJECT":"Projekt konnte nicht geladen werden :(","LOADING_PROJECT":"Projekt wird geöffnet ...","INITIALIZING_LEKTOR":"Initialisiere Lektor ...","QUIT_LEKTOR":"Lektor beenden","FILE":"Datei","UNDO":"Rückgängig","REDO":"Wiederholen","CUT":"Ausschneiden","COPY":"Kopieren","PASTE":"Einfügen","SELECT_ALL":"Alles Markieren","HELP":"Hilfe","VISIT_WEBSITE":"Webseite öffnen","INSTALL_SHELL_COMMAND":"Shell-Befehl installieren","INSTALL_SHELL_COMMAND_QUESTION":"Möchtest du den \'lektor\' Shell-Befehl installieren? Dies erfordert Admin-Rechte.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Konnte Shell-Befehl nicht installieren.","INSTALL_SHELL_COMMAND_SUCCESS":"Shell-Befehl wurde erfolgreich installiert.","OPERATION_SUCCESS":"Operation erfolgreich","YES":"Ja","NO":"Nein","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Konnte Datei nicht öffnen","OPEN_OTHER_PROJECT":"Anderes Projekt öffnen","OPEN_OTHER_PROJECT_QUESTION":"Um diese Datei zu öffnen, muss ein anderes Projekt (%s) geöffnet werden. Das aktuelle Projekt wird dadurch geschlossen. Fortfahren?"}');

/***/ }),

/***/ "../lektor/translations/en.json":
/*!**************************************!*\
  !*** ../lektor/translations/en.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Return to Website","UNLOAD_ACTIVE_TAB":"You have unsaved information, are you sure you want to leave this page?","EDIT_METADATA":"Edit Metadata","EDIT":"Edit","DELETE":"Delete","PREVIEW":"Preview","ALTS":"Alternatives","PRIMARY_ALT":"Primary","PRIMARY_OVERLAY":"Overlaid","ADD_CHILD_PAGE":"Add Page","ADD_ATTACHMENT":"Add Attachment","ATTACHMENT_ACTIONS":"Attachment Actions","PAGE_ACTIONS":"Page Actions","NO_CHILD_PAGES":"No Subpages","CHILD_PAGES":"Subpages","NO_ATTACHMENTS":"No attachments","ATTACHMENTS":"Attachments","ADD_ATTACHMENT_TO":"Add Attachment to “%s”","ADD_ATTACHMENT_NOTE":"You can upload a new attachment here.","UPLOAD":"Upload","PROGRESS":"Progress","ERROR_PREFIX":"Error: ","ERROR_NO_ID_PROVIDED":"No ID provided.","ERROR_PAGE_ID_DUPLICATE":"A page with this ID (%s) exists already.","ERROR_INVALID_ID":"Invalid ID","ERROR_INVALID_DATE":"Invalid date","ERROR_INVALID_NUMBER":"Not a valid number","ERROR_INVALID_URL":"Not a valid URL","ERROR":"Error","ERROR_OCURRED":"An Error ocurred","ERROR_REQUEST_FAILED":"Could not send command to server.  Maybe the server was stopped or is unresponsive?","ERROR_SERVER_UNAVAILABLE":"Server Unavailable","ERROR_SERVER_UNAVAILABLE_MESSAGE":"The server is not responding.  Either it was stopped or a critical error made it not operable and it needs to be restarted.","MODEL":"Model","ADD_CHILD_PAGE_TO":"Add Subpage to “%s”","ADD_CHILD_PAGE_NOTE":"You can add a new subpage to the page here.  Note that the model or ID cannot be easily changed afterwards.","CREATE_CHILD_PAGE":"Add Child Page","DELETE_ATTACHMENT_PROMPT":"Do you really want to delete this attachment?","DELETE_ATTACHMENT_ALT_PROMPT":"Do you really want to delete the metadata of this attachment alternative?","DELETE_PAGE_PROMPT":"Do you really want to delete this page?","DELETE_PAGE_ALT_PROMPT":"Do you really want to delete this alternative?","DELETE_PAGE_CHILDREN_WARNING":"This will also delete the child subpages of this page.","DELETE_RECORD":"Delete “%s”","DELETE_ALL_PAGE_ALTS":"Also delete all alternatives and attached files.","DELETE_ALL_ATTACHMENT_ALTS":"Delete all alternatives and the attached file.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Delete only the primary record.  Attachments, alternatives and subpages will not be deleted.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Only delete the Metadata of the primary record.","DELETE_PRIMARY_ALT_INFO":"Because this record is a primary alternative it can be deleted separately or together with all other contents.","CHILD_PAGES_TO_BE_DELETED":"Subpages that will be deleted:","ALTS_TO_BE_DELETED":"Alternatives that will be deleted:","ATTACHMENTS_TO_BE_DELETED":"Attachments that will be deleted:","YES_DELETE":"Yes, delete","NO_CANCEL":"No, cancel","SYSTEM_FIELDS":"System Fields","EDIT_ATTACHMENT_METADATA_OF":"Edit Metadata of Attachment “%s”","EDIT_PAGE_NAME":"Edit “%s”","SAVE_CHANGES":"Save Changes","BROWSE_FS":"Browse in Filesystem","BROWSE_FS_MAC":"Reveal in Finder","BROWSE_FS_WINDOWS":"Open in Explorer","ERROR_CANNOT_BROWSE_FS":"Error: File does not exist yet.","REMOVE_FLOWBLOCK_PROMPT":"Do you really want to remove this block?","ADD_FLOWBLOCK":"Add Block","INVALID_INPUT":"Invalid Input","UP":"Up","DOWN":"Down","REMOVE":"Remove","ID":"ID","CLOSE":"Close","CANCEL":"Cancel","BACK_TO_OVERVIEW":"Back to Overview","PUBLISH":"Publish","PUBLISH_NOTE":"From here you can publish the current version of the website.","PUBLISH_SERVER":"Target Server","CURRENTLY_PUBLISHING":"Publishing …","STATE":"Status","PUBLISH_DONE":"Published","PUBLISH_STATE_BUILDING":"Changes are being built ...","PUBLISH_STATE_PUBLISH":"Changes are being published ...","PUBLISH_STATE_DONE":"Publishing done.","FIND_FILES":"Find Files","FIND_FILES_PLACEHOLDER":"Enter page name ...","ATTACHMENT_TYPE":"Attachment type","URL_SLUG":"URL slug","TEMPLATE":"Template","HIDE_PAGE":"Hide page","HIDE_PAGE_EXPLANATION":"Should this page be hidden?","PAGE_IS_DISCOVERABLE":"Page is discoverable","PAGE_IS_DISCOVERABLE_EXPLANATION":"If this is enabled the page can be discovered, otherwise the URL has to be known.","REFRESH_BUILD":"Refresh Build","REFRESH_BUILD_NOTE":"This deletes all cached build results which triggers a rebuilt from scratch.  This is useful in certain situations where sync errors or mistakes in templates caused corrupted output.","CURRENTLY_REFRESHING_BUILD":"Currently refreshing build ...","REFRESHING_BUILD_DONE":"Done refreshing build!","FAILED_TO_LAUNCH_LEKTOR":"Failed to launch Lektor.","PROJECT":"Project","CLOSE_PROJECT":"Close Project","OPEN_PROJECT":"Open Project","BROWSE_WEBSITE":"Browse Website","VIEW_ADMIN_PANEL":"View Admin Panel","QUIT":"Quit","FAILED_TO_LOAD_PROJECT":"Failed to load the project :(","LOADING_PROJECT":"Loading project ...","INITIALIZING_LEKTOR":"Initializing Lektor ...","QUIT_LEKTOR":"Quit Lektor","FILE":"File","UNDO":"Undo","REDO":"Redo","CUT":"Cut","COPY":"Copy","PASTE":"Paste","SELECT_ALL":"Select All","HELP":"Help","VISIT_WEBSITE":"Visit Website","INSTALL_SHELL_COMMAND":"Install Shell Command","INSTALL_SHELL_COMMAND_QUESTION":"Do you want to install the \'lektor\' shell command? This requires admin rights.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Failed to install shell commands.","INSTALL_SHELL_COMMAND_SUCCESS":"Shell command was successfully installed.","OPERATION_SUCCESS":"Success","YES":"Yes","NO":"No","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Failed to open content file","OPEN_OTHER_PROJECT":"Open other Project","OPEN_OTHER_PROJECT_QUESTION":"Opening this file requires opening another project (%s). The current project will be closed. Do you want to continue?","COLLAPSE":"Collapse","EXPAND":"Expand"}');

/***/ }),

/***/ "../lektor/translations/es.json":
/*!**************************************!*\
  !*** ../lektor/translations/es.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Volver al Sitio Web","UNLOAD_ACTIVE_TAB":"Tiene información sin guardar, está seguro de que quiere abandonar esta página?","EDIT_METADATA":"Editar Metadatos","EDIT":"Editar","DELETE":"Borrar","PREVIEW":"Previsualizar","ALTS":"Alternativas","PRIMARY_ALT":"Primaria","PRIMARY_OVERLAY":"Overlaid","ADD_CHILD_PAGE":"Añadir Página","ADD_ATTACHMENT":"Añadir Adjunto","ATTACHMENT_ACTIONS":"Acciones de Adjunto","PAGE_ACTIONS":"Acciones de Página","NO_CHILD_PAGES":"Sin Subpáginas","CHILD_PAGES":"Subpáginas","NO_ATTACHMENTS":"Sin Adjuntos","ATTACHMENTS":"Adjuntos","ADD_ATTACHMENT_TO":"Añadir Adjunto a “%s”","ADD_ATTACHMENT_NOTE":"Puede cargar un nuevo adjunto aquí.","UPLOAD":"Cargar","PROGRESS":"Avance","ERROR_PREFIX":"Error: ","ERROR_NO_ID_PROVIDED":"No se proporcionó un ID.","ERROR_PAGE_ID_DUPLICATE":"Ya existe una página con este ID (%s).","ERROR_INVALID_ID":"ID inválido","ERROR_INVALID_DATE":"Fecha inválida","ERROR_INVALID_NUMBER":"Número no válido","ERROR_INVALID_URL":"URL no válida","ERROR":"Error","ERROR_OCURRED":"Ocurrió un Error","ERROR_REQUEST_FAILED":"No se pudo enviar el comando al servidor.  ¿Es posible que el servidor esté apagado o no responda?","ERROR_SERVER_UNAVAILABLE":"Servidor No Disponible","ERROR_SERVER_UNAVAILABLE_MESSAGE":"El servidor no responde.  Fue apagado o hubo un error crítico que lo hace inoperativo y necesita ser reiniciado.","MODEL":"Modelo","ADD_CHILD_PAGE_TO":"Añada Subpágina a “%s”","ADD_CHILD_PAGE_NOTE":"Puede añadir una nueva subpágina aquí.  Tenga en cuenta que el modelo o el ID no puede ser cambiado fácilmente más tarde.","CREATE_CHILD_PAGE":"Añada Página Hijo","DELETE_ATTACHMENT_PROMPT":"¿Quiere realmente borrar este anexo?","DELETE_ATTACHMENT_ALT_PROMPT":"¿Quiere realmente borrar los metadatos de esta alternativa de anexo?","DELETE_PAGE_PROMPT":"¿Quiere realmente borrar esta página?","DELETE_PAGE_ALT_PROMPT":"¿Quiere realmente borrar esta alternativa?","DELETE_PAGE_CHILDREN_WARNING":"Esto también borrará las subpáginas hijo de esta página.","DELETE_RECORD":"Borrar “%s”","DELETE_ALL_PAGE_ALTS":"Borrar también todas las alternativas y ficheros adjuntos.","DELETE_ALL_ATTACHMENT_ALTS":"Borrar todas las alternativas y el fichero adjunto.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Borra sólo el registro principal.  Los adjuntos, las alternativas y las subpáginas no serán borradas.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Borra sólo los metadatos del registro principal.","DELETE_PRIMARY_ALT_INFO":"Como este registro es una alternativa principal, puede ser borrado por separado o junto al resto de contenidos.","CHILD_PAGES_TO_BE_DELETED":"Subpáginas que serán borradas:","ALTS_TO_BE_DELETED":"Alternativas que serán borradas:","ATTACHMENTS_TO_BE_DELETED":"Adjuntos que serán borrados:","YES_DELETE":"Sí, borrar","NO_CANCEL":"No, cancelar","SYSTEM_FIELDS":"Campos de Sistema","EDIT_ATTACHMENT_METADATA_OF":"Editar los Metadatos del Adjunto “%s”","EDIT_PAGE_NAME":"Editar “%s”","SAVE_CHANGES":"Guardar los cambios","BROWSE_FS":"Navegar en el Sistema de ficheros","BROWSE_FS_MAC":"Mostrar en el Finder","BROWSE_FS_WINDOWS":"Abrir en el Explorador","ERROR_CANNOT_BROWSE_FS":"Error: el fichero no existe todavía.","REMOVE_FLOWBLOCK_PROMPT":"¿Quiere realmente borrar este bloque?","ADD_FLOWBLOCK":"Añadir Bloque","INVALID_INPUT":"Entrada inválida","UP":"Arriba","DOWN":"Abajo","REMOVE":"Eliminar","ID":"ID","CLOSE":"Cerrar","CANCEL":"Cancelar","BACK_TO_OVERVIEW":"Vuelve a Revisión","PUBLISH":"Publicar","PUBLISH_NOTE":"Desde aquí puede publicar la versión actual del sitio web.","PUBLISH_SERVER":"Servidor Destino","CURRENTLY_PUBLISHING":"Publicando …","STATE":"Estado","PUBLISH_DONE":"Publicado","PUBLISH_STATE_BUILDING":"Los cambios se están generando ...","PUBLISH_STATE_PUBLISH":"Los cambios están siendo publicados ...","PUBLISH_STATE_DONE":"Publicación finalizada.","FIND_FILES":"Encontrar Ficheros","FIND_FILES_PLACEHOLDER":"Introduzca el nombre de la página ...","ATTACHMENT_TYPE":"Tipo de adjunto","URL_SLUG":"URL personalizada","TEMPLATE":"Plantilla","HIDE_PAGE":"Ocultar página","HIDE_PAGE_EXPLANATION":"¿Debería estar oculta esta página?","PAGE_IS_DISCOVERABLE":"La Página es detectable","PAGE_IS_DISCOVERABLE_EXPLANATION":"Si esto está habilitado la página puede ser detectada, en caso contrario la URL ha de ser conocida.","REFRESH_BUILD":"Refrescar la Generación","REFRESH_BUILD_NOTE":"Esto borra todos los resultados generados y lanza una nueva generación desde cero. Esto es útil en ciertas situaciones donde errores de sincronización o en las plantillas causaron un resultado corrupto.","CURRENTLY_REFRESHING_BUILD":"Regenerando ...","REFRESHING_BUILD_DONE":"¡Acabó la regeneración!","FAILED_TO_LAUNCH_LEKTOR":"Falló la ejecución de Lektor.","PROJECT":"Proyecto","CLOSE_PROJECT":"Cerrar Proyecto","OPEN_PROJECT":"Abrir Proyecto","BROWSE_WEBSITE":"Navegar Sitio Web","VIEW_ADMIN_PANEL":"Ver Panel de Administración","QUIT":"Salir","FAILED_TO_LOAD_PROJECT":"Falló la carga del proyecto :(","LOADING_PROJECT":"Cargando proyecto ...","INITIALIZING_LEKTOR":"Inicializando Lektor ...","QUIT_LEKTOR":"Salir de Lektor","FILE":"Archivo","UNDO":"Deshacer","REDO":"Rehacer","CUT":"Cortar","COPY":"Copiar","PASTE":"Pegar","SELECT_ALL":"Seleccionar Todo","HELP":"Ayuda","VISIT_WEBSITE":"Visitar Web","INSTALL_SHELL_COMMAND":"Instalar Comando","INSTALL_SHELL_COMMAND_QUESTION":"¿Quiere instalar el comando \'lektor\'? Son necesarios privilegios de administrador.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Falló la instalación de los comandos.","INSTALL_SHELL_COMMAND_SUCCESS":"El comando se instaló con éxito.","OPERATION_SUCCESS":"Con éxito","YES":"Sí","NO":"No","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Falló al abrir el fichero de contenido","OPEN_OTHER_PROJECT":"Abrir otro Proyecto","OPEN_OTHER_PROJECT_QUESTION":"Abrir este fichero requiere abrir otro proyecto (%s). El proyecto actual será cerrado. ¿Quiere continuar?"}');

/***/ }),

/***/ "../lektor/translations/fr.json":
/*!**************************************!*\
  !*** ../lektor/translations/fr.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Retour au site Web","UNLOAD_ACTIVE_TAB":"Des informations ne sont pas enregistrées, voulez-vous vraiment quitter cette page ?","EDIT_METADATA":"Modifier les métadonnées","EDIT":"Modifier","DELETE":"Supprimer","PREVIEW":"Aperçu","ALTS":"Alternatives","PRIMARY_ALT":"Primaire","PRIMARY_OVERLAY":"Superposée","ADD_CHILD_PAGE":"Ajouter une page","ADD_ATTACHMENT":"Joindre un fichier","ATTACHMENT_ACTIONS":"Actions sur les fichiers joints","PAGE_ACTIONS":"Action sur les pages","NO_CHILD_PAGES":"Aucune sous-page","CHILD_PAGES":"Sous-pages","NO_ATTACHMENTS":"Aucun fichier joint","ATTACHMENTS":"Fichiers joints","ADD_ATTACHMENT_TO":"Joindre un fichier à « %s »","ADD_ATTACHMENT_NOTE":"Vous pouvez téléverser un nouveau fichier joint ici.","UPLOAD":"Téléverser","PROGRESS":"Progression","ERROR_PREFIX":"Erreur : ","ERROR_NO_ID_PROVIDED":"Erreur : aucun ID fourni.","ERROR_PAGE_ID_DUPLICATE":"Une page avec cet ID (%s) existe déjà.","ERROR_INVALID_ID":"ID non valide","ERROR_INVALID_DATE":"Date non valide","ERROR_INVALID_NUMBER":"Nombre non valide","ERROR_INVALID_URL":"URL non valide","ERROR":"Erreur","ERROR_OCURRED":"Une erreur a été rencontrée","ERROR_REQUEST_FAILED":"La commande n\'a pas pu être envoyée au serveur. Le serveur a peut-être été arrêté ou ne répond plus ?","ERROR_SERVER_UNAVAILABLE":"Serveur indisponible","ERROR_SERVER_UNAVAILABLE_MESSAGE":"Le serveur ne répond pas. Il a dû être arrêté ou une erreur critique l\'a rendu inopérant et il doit être redémarré.","MODEL":"Modèle","ADD_CHILD_PAGE_TO":"Ajouter une sous-page à « %s »","ADD_CHILD_PAGE_NOTE":"Vous pouvez ajouter une nouvelle sous-page à la page ici. Veuillez noter que le modèle ou l\'ID ne peut pas être changé facilement ultérieurement.","CREATE_CHILD_PAGE":"Ajouter une sous-page","DELETE_ATTACHMENT_PROMPT":"Voulez-vous vraiment supprimer ce fichier joint ?","DELETE_ATTACHMENT_ALT_PROMPT":"Voulez-vous vraiment supprimer les métadonnées de ce fichier joint alternatif ?","DELETE_PAGE_PROMPT":"Voulez-vous vraiment supprimer cette page ?","DELETE_PAGE_ALT_PROMPT":"Voulez-vous vraiment supprimer cette version alternative ?","DELETE_PAGE_CHILDREN_WARNING":"Cela supprimera aussi les sous-pages de cette page.","DELETE_RECORD":"Supprimer « %s »","DELETE_ALL_PAGE_ALTS":"Supprimer aussi toutes les versions alternatives et les fichiers joints.","DELETE_ALL_ATTACHMENT_ALTS":"Supprimer toutes les versions alternatives et les fichiers joints.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Supprimer seulement le premier enregistrement. Les fichiers joints, versions alternatives et sous-pages ne seront pas supprimées.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Supprimer seulement les métadonnées de la pièce jointe primaire.","DELETE_PRIMARY_ALT_INFO":"Cet enregistrement étant l\'alternative primaire, il peut être supprimé séparément ou avec tous les autres contenus.","CHILD_PAGES_TO_BE_DELETED":"Les sous-pages qui seront supprimées :","ALTS_TO_BE_DELETED":"Les versions alternatives qui seront supprimées :","ATTACHMENTS_TO_BE_DELETED":"Les fichiers joints qui seront supprimés :","YES_DELETE":"Oui, supprimer","NO_CANCEL":"Non, annuler","SYSTEM_FIELDS":"Champs système","EDIT_ATTACHMENT_METADATA_OF":"Modifier les métadonnées du fichier joint « %s »","EDIT_PAGE_NAME":"Modifier « %s »","SAVE_CHANGES":"Enregistrer les changements","BROWSE_FS":"Parcourir le système de fichiers","BROWSE_FS_MAC":"Révéler dans le Finder","BROWSE_FS_WINDOWS":"Ouvrir dans l\'Explorateur","ERROR_CANNOT_BROWSE_FS":"Erreur : le fichier n\'existe pas encore.","REMOVE_FLOWBLOCK_PROMPT":"Voulez-vous vraiment supprimer ce bloc ?","ADD_FLOWBLOCK":"Ajouter un bloc","INVALID_INPUT":"Saisie non valide","UP":"Haut","DOWN":"Bas","REMOVE":"Enlever","ID":"ID","CLOSE":"Fermer","CANCEL":"Annuler","BACK_TO_OVERVIEW":"Retour à l\'aperçu","PUBLISH":"Publier","PUBLISH_NOTE":"À partir de maintenant, vous pouvez publier la version actuelle de votre site Web.","PUBLISH_SERVER":"Serveur cible","CURRENTLY_PUBLISHING":"Publication en cours…","STATE":"Statut","PUBLISH_DONE":"Publié","PUBLISH_STATE_BUILDING":"Les changements sont en cours de construction…","PUBLISH_STATE_PUBLISH":"Les changements  sont en cours de publication…","PUBLISH_STATE_DONE":"Publication effectuée.","FIND_FILES":"Trouver les fichiers","FIND_FILES_PLACEHOLDER":"Saisir le nom de la page…","ATTACHMENT_TYPE":"Type de fichier joint","URL_SLUG":"Motif d\'URL (slug)","TEMPLATE":"Modèle","HIDE_PAGE":"Masquer la page","HIDE_PAGE_EXPLANATION":"Est-ce que cette page devrait être masquée ?","PAGE_IS_DISCOVERABLE":"La page est « découvrable »","PAGE_IS_DISCOVERABLE_EXPLANATION":"Si activé, la page pourra être retrouvée car elle sera indexée, sinon l\'URL devra être connue pour y accéder.","REFRESH_BUILD":"Actualiser la construction","REFRESH_BUILD_NOTE":"Cela supprime tous les résultats de la construction et entraîne une reconstruction complète. C\'est utile dans certaines situations où le résultat est corrompu suite à des erreurs de synchronisation ou de modèles.","CURRENTLY_REFRESHING_BUILD":"Actualisation de la construction en cours…","REFRESHING_BUILD_DONE":"Actualisation de la construction terminée","FAILED_TO_LAUNCH_LEKTOR":"Impossible de lancer Lektor.","PROJECT":"Projet","CLOSE_PROJECT":"Fermer le projet","OPEN_PROJECT":"Ouvrir le projet","BROWSE_WEBSITE":"Ouvrir le site Web","VIEW_ADMIN_PANEL":"Voir le panneau administrateur","QUIT":"Quitter","FAILED_TO_LOAD_PROJECT":"Impossible de charger le projet :(","LOADING_PROJECT":"Chargement du projet…","INITIALIZING_LEKTOR":"Initialisation de Lektor…","QUIT_LEKTOR":"Quitter Lektor","FILE":"Fichier","UNDO":"Annuler","REDO":"Rétablir","CUT":"Couper","COPY":"Copier","PASTE":"Coller","SELECT_ALL":"Sélectionner tout","HELP":"Aide","VISIT_WEBSITE":"Visiter le site Web","INSTALL_SHELL_COMMAND":"Installer la commande shell","INSTALL_SHELL_COMMAND_QUESTION":"Voulez-vous installer la commande shell « lektor » ? Cela nécessite des droits administrateurs.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Impossible d\'installer les commandes shell.","INSTALL_SHELL_COMMAND_SUCCESS":"La commande shell  a été correctement installée.","OPERATION_SUCCESS":"Succès","YES":"Oui","NO":"Non","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Impossible d\'ouvir le contenu du fichier","OPEN_OTHER_PROJECT":"Ouvrir un autre projet","OPEN_OTHER_PROJECT_QUESTION":"Ouvrir ce fichier nécessite d\'ouvrir un autre projet (%s). Le projet actuel sera fermé. Voulez-vous vraiment continuer ?"}');

/***/ }),

/***/ "../lektor/translations/it.json":
/*!**************************************!*\
  !*** ../lektor/translations/it.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Torna al sito web","UNLOAD_ACTIVE_TAB":"Hai informazioni non salvate, sei sicuro di voler abbandonare questa pagina?","EDIT_METADATA":"Modifica metadati","EDIT":"Modifica","DELETE":"Cancella","PREVIEW":"Anteprima","ALTS":"Alternative","PRIMARY_ALT":"Primaria","PRIMARY_OVERLAY":"Sovrascritta","ADD_CHILD_PAGE":"Aggiungi pagina","ADD_ATTACHMENT":"Aggiungi allegato","ATTACHMENT_ACTIONS":"Azioni sull\'allegato","PAGE_ACTIONS":"Azioni sulla pagina","NO_CHILD_PAGES":"Nessuna sottopagina","CHILD_PAGES":"Sottopagine","NO_ATTACHMENTS":"Nessun alleagto","ATTACHMENTS":"Allegati","ADD_ATTACHMENT_TO":"Aggiungi allegato a “%s”","ADD_ATTACHMENT_NOTE":"Puoi caricare un allegato qui.","UPLOAD":"Carica","PROGRESS":"Avanzamento","ERROR_PREFIX":"Errore: ","ERROR_NO_ID_PROVIDED":"Nessun ID fornito.","ERROR_PAGE_ID_DUPLICATE":"Una pagina con questo ID (%s) esiste già.","ERROR_INVALID_ID":"ID non valido","ERROR_INVALID_DATE":"Data non valida","ERROR_INVALID_NUMBER":"Non è un numero valido","ERROR_INVALID_URL":"Non è un indirizzo valido","ERROR":"Errore","ERROR_OCURRED":"È capitato un errore","ERROR_REQUEST_FAILED":"Impossibile inviare comandi al server.  Magari il server è stato spento o è sovraccarico?","ERROR_SERVER_UNAVAILABLE":"Server non disponibile","ERROR_SERVER_UNAVAILABLE_MESSAGE":"Il server non risponde.  Può essere spento o un errore critico l\'ha reso non operativo ed è necessario riavviarlo.","MODEL":"Modello","ADD_CHILD_PAGE_TO":"Aggiungi sottopagina a “%s”","ADD_CHILD_PAGE_NOTE":"Puoi aggiungere una nuova sottopagina qui.  Tieni presente che il modello o l\'ID non potranno essere cambiati facilmente in futuro.","CREATE_CHILD_PAGE":"Aggiungi sottopagina","DELETE_ATTACHMENT_PROMPT":"Vuoi veramente cancellare questo allegato?","DELETE_ATTACHMENT_ALT_PROMPT":"Vuoi veramente cancellare i metadati di questa alternativa all\'allegato?","DELETE_PAGE_PROMPT":"Vuoi veramente cancellare questa pagina?","DELETE_PAGE_ALT_PROMPT":"Vuoi veramente cancellare questa alternativa?","DELETE_PAGE_CHILDREN_WARNING":"Questo cancellerà anche le sottopagine di questa pagina.","DELETE_RECORD":"Cancella “%s”","DELETE_ALL_PAGE_ALTS":"Cancella anche tutte le alternative ed i file allegati.","DELETE_ALL_ATTACHMENT_ALTS":"Cancella tutte le alternative ed il file allegato.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Cancella solo la pagina principale. Allegati, alternative e sottopagine nnon verranno cancellate.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Cancella solo i metadati dell\'allegato principale.","DELETE_PRIMARY_ALT_INFO":"Dato che questo oggetto è l\'alternativa primaria, può essere cancellato separatamente o insieme al resto del contenuto.","CHILD_PAGES_TO_BE_DELETED":"Sottopagine che verranno cancellate:","ALTS_TO_BE_DELETED":"Alternative che verranno cancellate:","ATTACHMENTS_TO_BE_DELETED":"Allegati che verranno cancellati:","YES_DELETE":"Si, cancella","NO_CANCEL":"No, annulla","SYSTEM_FIELDS":"Campi di sistema","EDIT_ATTACHMENT_METADATA_OF":"Modifica i metadati dell\'allegato “%s”","EDIT_PAGE_NAME":"Modifica “%s”","SAVE_CHANGES":"Salva modifiche","BROWSE_FS":"Apri nel filesystem","BROWSE_FS_MAC":"Apri in Finder","BROWSE_FS_WINDOWS":"Apri in Esplora risorse","ERROR_CANNOT_BROWSE_FS":"Errore: il file non esiste.","REMOVE_FLOWBLOCK_PROMPT":"Vuoi davvero cancellare questo blocco?","ADD_FLOWBLOCK":"Aggiungi blocco","INVALID_INPUT":"Input invalido","UP":"Su","DOWN":"Giù","REMOVE":"Rimuovi","ID":"ID","CLOSE":"Chiudi","CANCEL":"Annulla","BACK_TO_OVERVIEW":"Torna alla panoramica","PUBLISH":"Pubblica","PUBLISH_NOTE":"Da qui puoi pubblicare la versione corrente del sito web.","PUBLISH_SERVER":"Server di destinazione","CURRENTLY_PUBLISHING":"Pubblicazione in corso...","STATE":"Stato","PUBLISH_DONE":"Pubblicato","PUBLISH_STATE_BUILDING":"Costruendo le pagine modificate...","PUBLISH_STATE_PUBLISH":"Pubblicando le pagine modificate...","PUBLISH_STATE_DONE":"Pubblicazione completata.","FIND_FILES":"Trova i file","FIND_FILES_PLACEHOLDER":"Inserisci il nome della pagina...","ATTACHMENT_TYPE":"Tipo dell\'allegato","URL_SLUG":"Alias della pagina","TEMPLATE":"Template","HIDE_PAGE":"Nascondi pagina","HIDE_PAGE_EXPLANATION":"Questa pagina deve essere nascosta?","PAGE_IS_DISCOVERABLE":"La pagina può essere scoperta?","PAGE_IS_DISCOVERABLE_EXPLANATION":"Se è abilitato la pagina può essere scoperta, altrimenti l\'indirizzo deve essere noto.","REFRESH_BUILD":"Esegui build completa","REFRESH_BUILD_NOTE":"Questo cancella tutti i risultati precedenti, eseguendo una build completa.  Questo è utile in casi in cui errori di sincronizzazione o errori nei template rendono il risultato corrotto.","CURRENTLY_REFRESHING_BUILD":"Eseguendo build completa...","REFRESHING_BUILD_DONE":"Build completa eseguita!","FAILED_TO_LAUNCH_LEKTOR":"Impossibile eseguire Lektor.","PROJECT":"Progetto","CLOSE_PROJECT":"Chiudi progetto","OPEN_PROJECT":"Apri progetto","BROWSE_WEBSITE":"Naviga nel sito web","VIEW_ADMIN_PANEL":"Mostra pannello di amministrazione","QUIT":"Esci","FAILED_TO_LOAD_PROJECT":"Impossibile caricare il progetto :(","LOADING_PROJECT":"Caricamento del progetto...","INITIALIZING_LEKTOR":"Preparazione di Lektor...","QUIT_LEKTOR":"Esci da Lektor","FILE":"File","UNDO":"Annulla","REDO":"Ripeti","CUT":"Taglia","COPY":"Copia","PASTE":"Incolla","SELECT_ALL":"Seleziona tutto","HELP":"Aiuto","VISIT_WEBSITE":"Visita il sito web","INSTALL_SHELL_COMMAND":"Installa comando shell","INSTALL_SHELL_COMMAND_QUESTION":"Vuoi installare il comando shell \'lektor\'? Questo richiede privilegi di amministrazione.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Impossibile installare il comando shell.","INSTALL_SHELL_COMMAND_SUCCESS":"Il comando shell è stato installato con successo.","OPERATION_SUCCESS":"Successo","YES":"Si","NO":"No","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Impossibile aprire il file di contenuto","OPEN_OTHER_PROJECT":"Apri un altro progetto","OPEN_OTHER_PROJECT_QUESTION":"Aprire questo file richiede l\'apertura di un altro progetto (%s). Il progetto corrente verrà chiuso. Vuoi proseguire?"}');

/***/ }),

/***/ "../lektor/translations/ja.json":
/*!**************************************!*\
  !*** ../lektor/translations/ja.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Websiteに戻る","UNLOAD_ACTIVE_TAB":"保存していない編集があります、本当にページを離れますか?","EDIT_METADATA":"メタデータの編集","EDIT":"編集","DELETE":"削除","PREVIEW":"プレビュー","ALTS":"代替","PRIMARY_ALT":"プライマリー","PRIMARY_OVERLAY":"上書き","ADD_CHILD_PAGE":"ページの追加","ADD_ATTACHMENT":"アタッチメントの追加","ATTACHMENT_ACTIONS":"アタッチメントのアクション","PAGE_ACTIONS":"ページアクション","NO_CHILD_PAGES":"サブページはありません","CHILD_PAGES":"サブページ","NO_ATTACHMENTS":"アタッチメントはありません","ATTACHMENTS":"アタッチメント","ADD_ATTACHMENT_TO":"“%s”にアタッチメントを追加する","ADD_ATTACHMENT_NOTE":"ここに新しいアタッチメントをアップロードできます","UPLOAD":"アップロード","PROGRESS":"プログレス","ERROR_PREFIX":"エラー: ","ERROR_NO_ID_PROVIDED":"IDがありません","ERROR_PAGE_ID_DUPLICATE":"このID (%s) のページはすでに存在します","ERROR_INVALID_ID":"IDが不正です","ERROR_INVALID_DATE":"日付が不正です","ERROR_INVALID_NUMBER":"不正な番号です","ERROR_INVALID_URL":"URLが不正です","ERROR":"エラー","ERROR_OCURRED":"エラーが発生しました","ERROR_REQUEST_FAILED":"サーバーにコマンドが送れませんでした、サーバーが止まっているか応答がないのかもしれません","ERROR_SERVER_UNAVAILABLE":"サーバーアンアベイラブル","ERROR_SERVER_UNAVAILABLE_MESSAGE":"サーバーが応答しません、中断されたかクリティカルなエラーが発生したたためオペレーションが完了しなかったためリスタートが必要です。","MODEL":"モデル","ADD_CHILD_PAGE_TO":"“%s”にサブページを追加する","ADD_CHILD_PAGE_NOTE":"このページにサブページが作れます。注意: モデルまたはIDはその後簡単には変更できません。","CREATE_CHILD_PAGE":"チャイルドページを作る","DELETE_ATTACHMENT_PROMPT":"本当にこの添付を削除しますか？","DELETE_ATTACHMENT_ALT_PROMPT":"本当にこの添付代替のメタデータを削除しますか？","DELETE_PAGE_PROMPT":"このページを本当に削除しますか？","DELETE_PAGE_ALT_PROMPT":"この代替を本能に削除しますか?","DELETE_PAGE_CHILDREN_WARNING":"このページのサブページも削除されます","DELETE_RECORD":"“%s”を削除","DELETE_ALL_PAGE_ALTS":"すべての代替と添付も削除","DELETE_ALL_ATTACHMENT_ALTS":"すべての代替と添付を削除","DELETE_ONLY_PRIMARY_PAGE_ALT":"プライマリレコードのメタデータのみ削除。添付、代替、サブページは削除されません。","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"プライマリレコードのメタデータのみ削除","DELETE_PRIMARY_ALT_INFO":"このレコードはプライマリの代替のため、別に削除することも、他のすべてのコンポーネントともに削除することもできます。","CHILD_PAGES_TO_BE_DELETED":"サブページは削除されます:","ALTS_TO_BE_DELETED":"代替は削除されます:","ATTACHMENTS_TO_BE_DELETED":"添付は削除されます:","YES_DELETE":"はい、削除します","NO_CANCEL":"いいえ、キャンセルします","SYSTEM_FIELDS":"システムフィールド","EDIT_ATTACHMENT_METADATA_OF":"添付 “%s”のメタデータを編集","EDIT_PAGE_NAME":"“%s”を編集","SAVE_CHANGES":"編集を保存","BROWSE_FS":"ファイルシステムで閲覧する","BROWSE_FS_MAC":"ファインダーで開く","BROWSE_FS_WINDOWS":"エクスプローラで開く","ERROR_CANNOT_BROWSE_FS":"エラー: ファイルは存在しません","REMOVE_FLOWBLOCK_PROMPT":"このブロックを本当に削除しますか？","ADD_FLOWBLOCK":"ブロックを追加","INVALID_INPUT":"不正な入力","UP":"アップ","DOWN":"ダウン","REMOVE":"取り除く","ID":"ID","CLOSE":"閉じる","CANCEL":"キャンセル","BACK_TO_OVERVIEW":"オーバービューに戻る","PUBLISH":"公開","PUBLISH_NOTE":"ここから現行のウェブサイトを公開できます。","PUBLISH_SERVER":"ターゲットサーバー","CURRENTLY_PUBLISHING":"公開 …","STATE":"状態","PUBLISH_DONE":"公開中","PUBLISH_STATE_BUILDING":"変更がをビルドしています...","PUBLISH_STATE_PUBLISH":"変更が公開されました ...","PUBLISH_STATE_DONE":"公開完了","FIND_FILES":"ファイルを見つける","FIND_FILES_PLACEHOLDER":"ページ名を入力...","ATTACHMENT_TYPE":"添付タイプ","URL_SLUG":"URLストリング","TEMPLATE":"テンプレート","HIDE_PAGE":"ヘージを隠す","HIDE_PAGE_EXPLANATION":"このページを非表示にしますか?","PAGE_IS_DISCOVERABLE":"このページは外部から見ることが可能です","PAGE_IS_DISCOVERABLE_EXPLANATION":"有効にすることで、ページは発見可能になります、そうしない場合はアクセスするのにそのURLを知っている必要があります。","REFRESH_BUILD":"ビルドを更新","REFRESH_BUILD_NOTE":"これは、キャッシュ済みのビルド結果をすべて削除し、最初からの構築を開始します。同期のエラーやテンプレート内のミスにより出力が不正な場合に有効です。","CURRENTLY_REFRESHING_BUILD":"ビルドを更新中...","REFRESHING_BUILD_DONE":"ビルドを更新が完了しました!","FAILED_TO_LAUNCH_LEKTOR":"Lektorを開けるのに失敗しました","PROJECT":"プロジェクト","CLOSE_PROJECT":"プロジェクトを閉じる","OPEN_PROJECT":"プロジェクトを開ける","BROWSE_WEBSITE":"ブラウザで開く","VIEW_ADMIN_PANEL":"アドミンパネルを開く","QUIT":"終了","FAILED_TO_LOAD_PROJECT":"Failed to load the project :(","LOADING_PROJECT":"プロジェクトを読み込んでいます ...","INITIALIZING_LEKTOR":"Lektorを初期化しています ...","QUIT_LEKTOR":"Lektorを終了する","FILE":"ファイル","UNDO":"アンドゥー","REDO":"リドゥー","CUT":"カット","COPY":"コピー","PASTE":"ペースト","SELECT_ALL":"全てを選択","HELP":"ヘルプ","VISIT_WEBSITE":"Websiteを訪ねる","INSTALL_SHELL_COMMAND":"シェルコマンドをインストール","INSTALL_SHELL_COMMAND_QUESTION":"「lektor」のシェルコマンドをインストールしますか？。インストールするには管理権限が必要です。","FAILED_TO_INSTALL_SHELL_COMMANDS":"シェルコマンドのインストールに失敗しました。","INSTALL_SHELL_COMMAND_SUCCESS":"シェルコマンドのインストールに成功しました。","OPERATION_SUCCESS":"成功","YES":"はい","NO":"いいえ","OK":"了解","FAILED_TO_OPEN_CONTENT_FILE":"コンテンツファイルを開くのに失敗しました","OPEN_OTHER_PROJECT":"他のプロジェクトを開く","OPEN_OTHER_PROJECT_QUESTION":"このファイルを開くには、他のプロジェクト(%s)を開く必要があります。現在のプロジェクトは閉じられます、処理を継続しますか?"}');

/***/ }),

/***/ "../lektor/translations/ko.json":
/*!**************************************!*\
  !*** ../lektor/translations/ko.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"사이트로 되돌아가기","UNLOAD_ACTIVE_TAB":"저장되지 않은 정보가 있습니다. 페이지를 떠나시겠습니까?","EDIT_METADATA":"메타데이터 수정","EDIT":"수정","DELETE":"삭제","PREVIEW":"미리보기","ALTS":"다른 언어","PRIMARY_ALT":"기본","PRIMARY_OVERLAY":"겹친","ADD_CHILD_PAGE":"페이지 추가","ADD_ATTACHMENT":"첨부 파일 추가","ATTACHMENT_ACTIONS":"첨부 파일 작업","PAGE_ACTIONS":"페이지 작업","NO_CHILD_PAGES":"하위 페이지 없음","CHILD_PAGES":"하위 페이지","NO_ATTACHMENTS":"첨부 파일 없음","ATTACHMENTS":"첨부 파일","ADD_ATTACHMENT_TO":"“%s“에서 첨부 파일 추가","ADD_ATTACHMENT_NOTE":"여기서 새로운 첨부 파일을 업로드할 수 있습니다.","UPLOAD":"업로드","PROGRESS":"진행","ERROR_PREFIX":"에러: ","ERROR_NO_ID_PROVIDED":"제공된 ID가 없습니다.","ERROR_PAGE_ID_DUPLICATE":"이 ID (%s) 페이지는 이미 존재합니다.","ERROR_INVALID_ID":"잘못된 ID","ERROR_INVALID_DATE":"잘못된 날짜","ERROR_INVALID_NUMBER":"유효한 숫자 아님","ERROR_INVALID_URL":"유효한 URL 아님","ERROR":"에러","ERROR_OCURRED":"오류 발생","ERROR_REQUEST_FAILED":"서버에 명령을 보내지 못했습니다. 서버가 중지되었거나 응답하지 않을 수도 있네요?","ERROR_SERVER_UNAVAILABLE":"서버를 사용할 수 없음","ERROR_SERVER_UNAVAILABLE_MESSAGE":"서버가 응답하지 않습니다. 서버가 중지되었거나, 재시작을 필요로 하는 치명적인 오류가 발생했습니다.","MODEL":"모델","ADD_CHILD_PAGE_TO":"“%s”에 하위 페이지 추가","ADD_CHILD_PAGE_NOTE":"이 페이지에서 새로운 하위 페이지를 추가할 수 있습니다.  중요, 나중에 모델이나 ID를 변경하기 어렵습니다.","CREATE_CHILD_PAGE":"하위 페이지 추가","DELETE_ATTACHMENT_PROMPT":"정말로 첨부 파일을 삭제하실 건가요?","DELETE_ATTACHMENT_ALT_PROMPT":"정말로 첨부 파일의 다른 언어에 대한 메타데이터를 삭제하실 건가요?","DELETE_PAGE_PROMPT":"정말로 이 페이지를 삭제하실 건가요?","DELETE_PAGE_ALT_PROMPT":"정말로 이 다른 언어를 삭제하실 건가요?","DELETE_PAGE_CHILDREN_WARNING":"이 페이지의 하위 페이지 또한 삭제됩니다.","DELETE_RECORD":"“%s” 삭제","DELETE_ALL_PAGE_ALTS":"또한, 모든 다른 언어와 첨부 파일을 삭제합니다.","DELETE_ALL_ATTACHMENT_ALTS":"모든 다른 언어와 첨부 파일을 삭제합니다.","DELETE_ONLY_PRIMARY_PAGE_ALT":"오직 주 레코드만 삭제됩니다. 첨부 파일, 다른 언어, 하위 페이지는 삭제되지 않습니다.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"오직 주 레코드의 메타데이터만 삭제됩니다.","DELETE_PRIMARY_ALT_INFO":"이 레코드는 기본 언어이기 때문에 별도로 삭제하거나 다른 콘텐츠 전부와 같이 삭제할 수 있습니다.","CHILD_PAGES_TO_BE_DELETED":"하위 페이지를 삭제합니다:","ALTS_TO_BE_DELETED":"다른 언어를 삭제합니다:","ATTACHMENTS_TO_BE_DELETED":"첨부 파일을 삭제합니다:","YES_DELETE":"네, 삭제","NO_CANCEL":"아니요, 취소","SYSTEM_FIELDS":"시스템 필드","EDIT_ATTACHMENT_METADATA_OF":"첨부 파일 “%s”의 메타데이터 수정","EDIT_PAGE_NAME":"“%s” 수정","SAVE_CHANGES":"변경 저장","BROWSE_FS":"파일 시스템 검색","BROWSE_FS_MAC":"파인더에서 검색","BROWSE_FS_WINDOWS":"탐색기에서 열기","ERROR_CANNOT_BROWSE_FS":"오류: 파일이 존재하지 않습니다.","REMOVE_FLOWBLOCK_PROMPT":"이 블록을 제거하시겠습니까?","ADD_FLOWBLOCK":"블록 추가","INVALID_INPUT":"잘못된 입력","UP":"위로","DOWN":"아래로","REMOVE":"제거","ID":"ID","CLOSE":"닫기","CANCEL":"취소","BACK_TO_OVERVIEW":"개요로 되돌아가기","PUBLISH":"발행","PUBLISH_NOTE":"여기서 웹사이트 현재 버전을 발행할 수 있습니다.","PUBLISH_SERVER":"대상 서버","CURRENTLY_PUBLISHING":"발행 중 ...","STATE":"상태","PUBLISH_DONE":"발행됨","PUBLISH_STATE_BUILDING":"변경 사항 빌드 중 ...","PUBLISH_STATE_PUBLISH":"변경 사항 발행 중 ...","PUBLISH_STATE_DONE":"발행 완료.","FIND_FILES":"파일 찾기","FIND_FILES_PLACEHOLDER":"페이지 이름 입력 ...","ATTACHMENT_TYPE":"첨부 파일 형식","URL_SLUG":"URL slug","TEMPLATE":"템플릿","HIDE_PAGE":"페이지 숨기기","HIDE_PAGE_EXPLANATION":"이 페이지를 숨길까요?","PAGE_IS_DISCOVERABLE":"페이지 다시보이기","PAGE_IS_DISCOVERABLE_EXPLANATION":"이 설정이 활성화되어있으면 페이지를 확인할 수 있습니다. 그렇지 않으면 URL만 확인할 수 있습니다.","REFRESH_BUILD":"새로운 빌드","REFRESH_BUILD_NOTE":"이 트리거는 처음부터 다시 빌드합니다. 그러면서 이전 빌드하면서 캐시된 결과를 삭제합니다. 이 기능은 동기화 오류나 템플릿에서 잘못된 설정으로 출력물에 문제가 있을 때 유용합니다.","CURRENTLY_REFRESHING_BUILD":"지금 새롭게 빌드 중 ...","REFRESHING_BUILD_DONE":"새로운 빌드를 완료하였습니다!","FAILED_TO_LAUNCH_LEKTOR":"실행하지 못하였습니다.","PROJECT":"프로젝트","CLOSE_PROJECT":"프로젝트 닫기","OPEN_PROJECT":"프로젝트 열기","BROWSE_WEBSITE":"웹사이트 찾아보기","VIEW_ADMIN_PANEL":"관리자 판넬 보기","QUIT":"나가기","FAILED_TO_LOAD_PROJECT":"프로젝트를 불러오지 못하였습니다. :(","LOADING_PROJECT":"프로젝트 불러오는 중 ...","INITIALIZING_LEKTOR":"Lektor 초기화 중 ...","QUIT_LEKTOR":"Lektor 나가기","FILE":"파일","UNDO":"실행 취소","REDO":"다시 실행","CUT":"잘라내기","COPY":"복사","PASTE":"붙여넣기","SELECT_ALL":"전부 선택","HELP":"도움말","VISIT_WEBSITE":"웹사이트 방문","INSTALL_SHELL_COMMAND":"쉘 커멘드 설치","INSTALL_SHELL_COMMAND_QUESTION":"\'lektor\' 쉘 명령을 설치하시겠습니까? 관리자 권한이 필요합니다.","FAILED_TO_INSTALL_SHELL_COMMANDS":"쉘 명령을 설치하지 못하였습니다.","INSTALL_SHELL_COMMAND_SUCCESS":"쉘 명령이 성공적으로 설치되었습니다.","OPERATION_SUCCESS":"완료","YES":"예","NO":"아니오","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"현재 파일을 열지 못하였습니다.","OPEN_OTHER_PROJECT":"다른 프로젝트 열기","OPEN_OTHER_PROJECT_QUESTION":"열려는 파일은 다른 프로젝트 (%s)를 열어야합니다. 현재 프로젝트는 종료됩니다. 계속 하시겠습니까?"}');

/***/ }),

/***/ "../lektor/translations/nl.json":
/*!**************************************!*\
  !*** ../lektor/translations/nl.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Terug naar Website","UNLOAD_ACTIVE_TAB":"U hebt niet-opgeslagen data, weet je zeker dat je deze pagina wil verlaten?","EDIT_METADATA":"Bewerk Metadata","EDIT":"Bewerken","DELETE":"Verwijderen","PREVIEW":"Voorbeeld","ALTS":"Alternatieven","PRIMARY_ALT":"Primair","PRIMARY_OVERLAY":"Overlapt","ADD_CHILD_PAGE":"Pagina toevoegen","ADD_ATTACHMENT":"Bijlage toevoegen","ATTACHMENT_ACTIONS":"Bijlage Acties","PAGE_ACTIONS":"Pagina Acties","NO_CHILD_PAGES":"Geen Subpagina\'s","CHILD_PAGES":"Subpagina\'s","NO_ATTACHMENTS":"Geen bijlages","ATTACHMENTS":"Bijlages","ADD_ATTACHMENT_TO":"Voeg bijlage toe aan “%s”","ADD_ATTACHMENT_NOTE":"Je kan hier een nieuwe bijlage uploaden.","UPLOAD":"Upload","PROGRESS":"Vooruitgang","ERROR_PREFIX":"Fout: ","ERROR_NO_ID_PROVIDED":"Geen ID gegeven.","ERROR_PAGE_ID_DUPLICATE":"Een pagina met deze ID (%s) bestaat al.","ERROR_INVALID_ID":"Ongeldige ID","ERROR_INVALID_DATE":"Ongeldige datum","ERROR_INVALID_NUMBER":"Geen geldig getal","ERROR_INVALID_URL":"Geen geldige URL","ERROR":"Fout","ERROR_OCURRED":"Er is een fout opgetreden","ERROR_REQUEST_FAILED":"Kon het commando niet naar de server sturen. Misschien is de server gestopt of reageert deze niet?","ERROR_SERVER_UNAVAILABLE":"Server niet beschikbaar","ERROR_SERVER_UNAVAILABLE_MESSAGE":"De server reageert niet. Deze was gestopt of door een kritieke fout niet langer operationeel en moet worden herstart.","MODEL":"Model","ADD_CHILD_PAGE_TO":"Voeg Subpagina toe aan “%s”","ADD_CHILD_PAGE_NOTE":"U kan hier een nieuwe subpagina toevoegen. Merk op dat het model of de ID achteraf niet makkelijk gewijzigd kunnen worden.","CREATE_CHILD_PAGE":"Subpagina Toevoegen","DELETE_ATTACHMENT_PROMPT":"Weet je zeker dat je deze bijlage wilt verwijderen?","DELETE_ATTACHMENT_ALT_PROMPT":"Weet je zeker dat je de metadata van dit bijlage alternatief wilt verwijderen?","DELETE_PAGE_PROMPT":"Weet je zeker dat je deze pagina wilt verwijderen?","DELETE_PAGE_ALT_PROMPT":"Weet je zeker dat je dit alternatief wilt verwijderen?","DELETE_PAGE_CHILDREN_WARNING":"Dit zal ook de subpagina\'s van deze pagina verwijderen.","DELETE_RECORD":"Verwijder “%s”","DELETE_ALL_PAGE_ALTS":"Verwijder ook de alternatieven en bijlages.","DELETE_ALL_ATTACHMENT_ALTS":"Verwijder alle alternatieven en bijlages.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Verwijder enkel de primaire record. Bijlages, alternatieven en subpagina\'s zullen niet verwijderd worden.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Verwijder enkel de metadata van de primaire record.","DELETE_PRIMARY_ALT_INFO":"Omdat dit record een primair alternatief is, kan het apart verwijderd worden of samen met alle andere inhoud.","CHILD_PAGES_TO_BE_DELETED":"Subpagina\'s die verwijderd zullen worden:","ALTS_TO_BE_DELETED":"Alternatieven die verwijderd zullen worden:","ATTACHMENTS_TO_BE_DELETED":"Bijlages die verwijderd zullen worden:","YES_DELETE":"Ja, verwijder","NO_CANCEL":"Nee, annuleer","SYSTEM_FIELDS":"Systeem Velden","EDIT_ATTACHMENT_METADATA_OF":"Bewerk Metadata van Bijlage “%s”","EDIT_PAGE_NAME":"Bewerk “%s”","SAVE_CHANGES":"Wijzigingen opslaan","BROWSE_FS":"Blader in Bestandsysteem","BROWSE_FS_MAC":"Bekijk in Finder","BROWSE_FS_WINDOWS":"Open in Explorer","ERROR_CANNOT_BROWSE_FS":"Fout: Bestand bestaat nog niet.","REMOVE_FLOWBLOCK_PROMPT":"Weet je zeker dat je dit blok wilt verwijderen?","ADD_FLOWBLOCK":"Blok Toevoegen","INVALID_INPUT":"Ongeldige Invoer","UP":"Omhoog","DOWN":"Omlaag","REMOVE":"Verwijderen","ID":"ID","CLOSE":"Sluiten","CANCEL":"Annuleren","BACK_TO_OVERVIEW":"Terug naar Overzicht","PUBLISH":"Publiceren","PUBLISH_NOTE":"Van hieruit kan je de huidige versie van je website publiceren.","PUBLISH_SERVER":"Doelserver","CURRENTLY_PUBLISHING":"Publiceren …","STATE":"Status","PUBLISH_DONE":"Gepubliceerd","PUBLISH_STATE_BUILDING":"De wijzigingen worden gebouwd ...","PUBLISH_STATE_PUBLISH":"De wijzigingen worden gepuliceerd ...","PUBLISH_STATE_DONE":"Klaar met publiceren.","FIND_FILES":"Zoek bestanden","FIND_FILES_PLACEHOLDER":"Vul paginanaam in ...","ATTACHMENT_TYPE":"Type Bijlage","URL_SLUG":"URL slug","TEMPLATE":"Template","HIDE_PAGE":"Verberg pagina","HIDE_PAGE_EXPLANATION":"Moet deze pagina verborgen zijn?","PAGE_IS_DISCOVERABLE":"Deze pagina is vindbaar","PAGE_IS_DISCOVERABLE_EXPLANATION":"Als dit ingeschakeld is, is de pagina vindbaar. Anders moet de URL bekend zijn.","REFRESH_BUILD":"Ververs Build","REFRESH_BUILD_NOTE":"Dit verwijdert alle buildresultaten in de cache en veroorzaakt een volledige rebuild. Dit is nuttig in bepaalde situaties waar synchonisatiefouten of fouten in de templates de uitvoer corrupt hebben gemaakt.","CURRENTLY_REFRESHING_BUILD":"Bezig met verversen van de build ...","REFRESHING_BUILD_DONE":"Klaar met de build te verversen!","FAILED_TO_LAUNCH_LEKTOR":"Het starten van Lektor is mislukt.","PROJECT":"Project","CLOSE_PROJECT":"Sluit Project","OPEN_PROJECT":"Open Project","BROWSE_WEBSITE":"Bekijk Website","VIEW_ADMIN_PANEL":"Bekijk Admin Paneel","QUIT":"Afsluiten","FAILED_TO_LOAD_PROJECT":"Laden van het project is mislukt :(","LOADING_PROJECT":"Project laden ...","INITIALIZING_LEKTOR":"Lektor Initializeren ...","QUIT_LEKTOR":"Lektor Afsluiten","FILE":"Bestand","UNDO":"Ongedaan maken","REDO":"Opnieuw","CUT":"Knippen","COPY":"Kopiëren","PASTE":"Plakken","SELECT_ALL":"Selecteer alles","HELP":"Help","VISIT_WEBSITE":"Bezoek Website","INSTALL_SHELL_COMMAND":"Installeer Shell Commando","INSTALL_SHELL_COMMAND_QUESTION":"Weet je zeker dat je het \'lektor\' shell commando wil installeren? Dit vereist admin rechten.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Installeren van de shell commando\'s mislukt.","INSTALL_SHELL_COMMAND_SUCCESS":"Shell commando\'s zijn geïnstalleerd.","OPERATION_SUCCESS":"Success","YES":"Ja","NO":"Nee","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Kon het inhoudbestand niet openen","OPEN_OTHER_PROJECT":"Open ander Project","OPEN_OTHER_PROJECT_QUESTION":"Om deze file te openen moet een ander project geopend worden (%s). Het huidige project zal gesloten worden. Wil je verdergaan?"}');

/***/ }),

/***/ "../lektor/translations/pl.json":
/*!**************************************!*\
  !*** ../lektor/translations/pl.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Wróć do strony","UNLOAD_ACTIVE_TAB":"Masz niezapisane dane, czy na pewno chcesz opuścić tą stronę ?","EDIT_METADATA":"Edytuj dane","EDIT":"Edytuj","DELETE":"Usuń","PREVIEW":"Podgląd","ALTS":"Wersje językowe","PRIMARY_ALT":"Podstawowy język","PRIMARY_OVERLAY":"(Nałożony)","ADD_CHILD_PAGE":"Dodaj podstronę","ADD_ATTACHMENT":"Dodaj załącznik","ATTACHMENT_ACTIONS":"Operacje na załącznikach","PAGE_ACTIONS":"Operacje na stronach","NO_CHILD_PAGES":"Brak podstron","CHILD_PAGES":"Podstrony","NO_ATTACHMENTS":"Brak załączników","ATTACHMENTS":"Załączniki","ADD_ATTACHMENT_TO":"Dodaj załącznik do “%s”","ADD_ATTACHMENT_NOTE":"Możesz wgrać nowy załącznik tutaj.","UPLOAD":"Wgraj","PROGRESS":"Postęp","ERROR_PREFIX":"Błąd: ","ERROR_NO_ID_PROVIDED":"Nie podano ID.","ERROR_PAGE_ID_DUPLICATE":"Strona z ID: (%s) już istnieje.","ERROR_INVALID_ID":"Błędny ID","ERROR_INVALID_DATE":"Błędna data","ERROR_INVALID_NUMBER":"Błędny numer","ERROR_INVALID_URL":"Błędny adres URL","ERROR":"Błąd","ERROR_OCURRED":"Wystąpił błąd","ERROR_REQUEST_FAILED":"Nie można wysłać żądania do serwera. Może został zatrzymany, albo nie odpowiada?","ERROR_SERVER_UNAVAILABLE":"Serwer niedostępny","ERROR_SERVER_UNAVAILABLE_MESSAGE":"Serwer nie odpowiada. Został zatrzymany, albo wystąpił błąd krytyczny, który spowodował brak działania. Być może musi zostać zrestartowany.","MODEL":"Model","ADD_CHILD_PAGE_TO":"Dodaj podstronę do “%s”","ADD_CHILD_PAGE_NOTE":"Możesz dodać podstronę tutaj. Pamiętaj, że Model oraz ID nie mogą być zmienione później w prosty sposób.","CREATE_CHILD_PAGE":"Dodaj podstronę","DELETE_ATTACHMENT_PROMPT":"Czy na pewno chcesz usunąć ten załącznik?","DELETE_ATTACHMENT_ALT_PROMPT":"Czy na pewno chcesz usunąć dane załącznika dla tego języka?","DELETE_PAGE_PROMPT":"Czy na pewno chcesz usunąć tą stronę?","DELETE_PAGE_ALT_PROMPT":"Czy na pewno chcesz usunąć ten język?","DELETE_PAGE_CHILDREN_WARNING":"To spowoduje także usunięcie wszystkich podstron.","DELETE_RECORD":"Skasuj “%s”","DELETE_ALL_PAGE_ALTS":"Usuń również wszystkie wersje językowe oraz załączniki.","DELETE_ALL_ATTACHMENT_ALTS":"Usuń wszystkie wersje językowe oraz załączony plik.","DELETE_ONLY_PRIMARY_PAGE_ALT":"Usuń tylko podstawowy rekord.  Załączniki, wersje językowe oraz podstrony nie będę usunięte.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Usuń tylko dane podstawowego rekordu.","DELETE_PRIMARY_ALT_INFO":"Ponieważ ten rekord zawiera podstawową wersję językową może zostać usunięty osobno jak i razem z pozostałą zawartością.","CHILD_PAGES_TO_BE_DELETED":"Podstrony, które zostaną usunięte:","ALTS_TO_BE_DELETED":"Wersje językowe, które zostaną usunięte:","ATTACHMENTS_TO_BE_DELETED":"Załączniki, które zostaną usunięte:","YES_DELETE":"Tak, usuń","NO_CANCEL":"Nie, anuluj","SYSTEM_FIELDS":"Pola Systemowe","EDIT_ATTACHMENT_METADATA_OF":"Edytuj dane załącznika “%s”","EDIT_PAGE_NAME":"Edytuj “%s”","SAVE_CHANGES":"Zapisz zmiany","BROWSE_FS":"Otwórz w przeglądarce plików","BROWSE_FS_MAC":"Otwórz w Finderze","BROWSE_FS_WINDOWS":"Otwórz w eksploratorze plików","ERROR_CANNOT_BROWSE_FS":"Błąd: Plik jeszcze nie istnieje.","REMOVE_FLOWBLOCK_PROMPT":"Czy na pewno chcesz usunąć ten blok ?","ADD_FLOWBLOCK":"Dodaj blok","INVALID_INPUT":"Błędne dane wejściowe","UP":"W górę","DOWN":"W dół","REMOVE":"Usuń","ID":"ID","CLOSE":"Zamknij","CANCEL":"Anuluj","BACK_TO_OVERVIEW":"Powrót do przeglądu","PUBLISH":"Publikuj","PUBLISH_NOTE":"Stąd możesz opublikować aktualną wersję strony.","PUBLISH_SERVER":"Serwer Docelowy","CURRENTLY_PUBLISHING":"Publikowanie …","STATE":"Status","PUBLISH_DONE":"Opublikowany","PUBLISH_STATE_BUILDING":"Zmiany są wprowadzane ...","PUBLISH_STATE_PUBLISH":"Zmiany są publikowane ...","PUBLISH_STATE_DONE":"Publikowanie zakończone.","FIND_FILES":"Znadź Pliki","FIND_FILES_PLACEHOLDER":"Podaj nazwę strony ...","ATTACHMENT_TYPE":"Typ załącznika","URL_SLUG":"Przyjazny URL","TEMPLATE":"Szablon","HIDE_PAGE":"Ukryj stronę","HIDE_PAGE_EXPLANATION":"Czy ta strona powinna być ukryta?","PAGE_IS_DISCOVERABLE":"Strona jest \'widoczna\'","PAGE_IS_DISCOVERABLE_EXPLANATION":"Jeśli włączone, strona jest widoczna na liście stron oraz w listingu dla danego rekordu. W przeciwnym razie, adres URL musi być znany","REFRESH_BUILD":"Zbuduj odświeżoną wersję","REFRESH_BUILD_NOTE":"To spowoduje usunięcie pamięci podręcznej i stworzenie wersji końcowej od nowa. Ta opcja jest przydatna w sytuacjach, gdzie błędy albo pomyłki synchronizacji w szablonach spowodowały uszkodzenie danych wyjściowych.","CURRENTLY_REFRESHING_BUILD":"Aktualnie odświeżam pakiet wyjściowy ...","REFRESHING_BUILD_DONE":"Zakończono odświeżanie pakietu wyjściowego!","FAILED_TO_LAUNCH_LEKTOR":"Nie udało się uruchomić Lektor.","PROJECT":"Projekt","CLOSE_PROJECT":"Zamknij projekt","OPEN_PROJECT":"Otwórz projekt","BROWSE_WEBSITE":"Przeglądaj stronę","VIEW_ADMIN_PANEL":"Przejdź do panelu administracyjnego","QUIT":"Wyjdź","FAILED_TO_LOAD_PROJECT":"Nie udało się załadować projektu :(","LOADING_PROJECT":"Ładowanie projektu ...","INITIALIZING_LEKTOR":"Inicjalizacja Lektor ...","QUIT_LEKTOR":"Opuść Lektor","FILE":"Plik","UNDO":"Cofnij","REDO":"Ponów","CUT":"Wytnij","COPY":"Kopiuj","PASTE":"Wklej","SELECT_ALL":"Zaznacz wszystko","HELP":"Pomoc","VISIT_WEBSITE":"Odwiedź stronę","INSTALL_SHELL_COMMAND":"Zainstaluj komendę powłoki","INSTALL_SHELL_COMMAND_QUESTION":"Czy chcesz zainstalować komendę \'lektor\' w powłoce systemowej? Wygamane są uprawnienia administracyjne.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Nie udało się zainstalować komend w powłoce systemowej.","INSTALL_SHELL_COMMAND_SUCCESS":"Komenda została pomyślnie zainstalowana w powłoce systemowej.","OPERATION_SUCCESS":"Sukces","YES":"Tak","NO":"Nie","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Nie udało się otworzyć zawartości pliku","OPEN_OTHER_PROJECT":"Otwórz inny projekt","OPEN_OTHER_PROJECT_QUESTION":"Otwarcie tego pliku wymaga otwarcia kolejnego projektu (%s). Obecny projekt zostanie zamknięty. Czy chcesz kontynuować?"}');

/***/ }),

/***/ "../lektor/translations/pt.json":
/*!**************************************!*\
  !*** ../lektor/translations/pt.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Retornar ao Site","UNLOAD_ACTIVE_TAB":"Você tem modificações não salvas, tem certeza que deseja deixar a página?","EDIT_METADATA":"Editar Metadado","EDIT":"Editar","DELETE":"Deletar","PREVIEW":"Pré-visualizar","ALTS":"Alternativas","PRIMARY_ALT":"Primária","PRIMARY_OVERLAY":"Revestida","ADD_CHILD_PAGE":"Add Página","ADD_ATTACHMENT":"Add Anexo","ATTACHMENT_ACTIONS":"Ações de Anexos","PAGE_ACTIONS":"Ações de Páginas","NO_CHILD_PAGES":"Sem sub-páginas","CHILD_PAGES":"Sub-páginas","NO_ATTACHMENTS":"Sem anexos","ATTACHMENTS":"Anexos","ADD_ATTACHMENT_TO":"Add anexo para “%s”","ADD_ATTACHMENT_NOTE":"Você pode subir um novo anexo aqui.","UPLOAD":"Upload","PROGRESS":"Progresso","ERROR_PREFIX":"Erro: ","ERROR_NO_ID_PROVIDED":"Nenhuma ID fornecida.","ERROR_PAGE_ID_DUPLICATE":"Uma página com este ID (%s) já existe.","ERROR_INVALID_ID":"ID inválido","ERROR_INVALID_DATE":"Data inválida","ERROR_INVALID_NUMBER":"Não é um número válido","ERROR_INVALID_URL":"Não é uma URL válida","ERROR":"Erro","ERROR_OCURRED":"Ocorreu um Erro","ERROR_REQUEST_FAILED":"Não foi possível enviar o comando ao servidor.  Talvez o servidor foi parado ou não está respondendo","ERROR_SERVER_UNAVAILABLE":"Servidor Não Disponível","ERROR_SERVER_UNAVAILABLE_MESSAGE":"O servidor não está respondendo.  Ou foi parado ou um erro sério o fez parar e precisa ser reiniciado.","MODEL":"Modelo","ADD_CHILD_PAGE_TO":"Add Sub-página para “%s”","ADD_CHILD_PAGE_NOTE":"Você pode adicionar uma nova sub-página aqui.  Note que o modelo ou o ID não podem ser mudados facilmente depois.","CREATE_CHILD_PAGE":"Add Página Filha","DELETE_ATTACHMENT_PROMPT":"Você tem certeza que deseja deletar este anexo?","DELETE_ATTACHMENT_ALT_PROMPT":"Você tem certeza que deseja deletar o metadado deste anexo alternativo?","DELETE_PAGE_PROMPT":"Você tem certeza que deseja deletar esta página","DELETE_PAGE_ALT_PROMPT":"Você tem certeza que deseja deletar esta alternativa?","DELETE_PAGE_CHILDREN_WARNING":"Isto também deletará as sub-páginas filhas desta página.","DELETE_RECORD":"Deletar “%s”","DELETE_ALL_PAGE_ALTS":"Também delete todas alternativas e arquivos de anexo.","DELETE_ALL_ATTACHMENT_ALTS":"Delete todas alternativas e arquivo de anexo","DELETE_ONLY_PRIMARY_PAGE_ALT":"Delete somente o registro primário.  Anexos, alternativas e sub-páginas não serão deletadas.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Delete somente o Metadado do registro primário.","DELETE_PRIMARY_ALT_INFO":"Porque este registro é uma alternativa primária ele pode ser deletado separadamente ou junto com todos os outros conteúdos.","CHILD_PAGES_TO_BE_DELETED":"Sub-páginas que serão deletadas:","ALTS_TO_BE_DELETED":"Alternativas que serão deletadas:","ATTACHMENTS_TO_BE_DELETED":"Anexos que serão deletados:","YES_DELETE":"Sim, deletar","NO_CANCEL":"Não, cancelar","SYSTEM_FIELDS":"Campos do Sistema","EDIT_ATTACHMENT_METADATA_OF":"Editar Metadado do Anexo “%s”","EDIT_PAGE_NAME":"Editar “%s”","SAVE_CHANGES":"Salvar Alterações","BROWSE_FS":"Navegar no Sistema","BROWSE_FS_MAC":"Mostrar no Finder","BROWSE_FS_WINDOWS":"Abrir no Explorer","ERROR_CANNOT_BROWSE_FS":"Erro: Arquivo não existe ainda.","REMOVE_FLOWBLOCK_PROMPT":"Você realmente deseja remover este bloco?","ADD_FLOWBLOCK":"Add Bloco","INVALID_INPUT":"Entrada Inválida","UP":"Cima","DOWN":"Baixo","REMOVE":"Remover","ID":"ID","CLOSE":"Fechar","CANCEL":"Cancelar","BACK_TO_OVERVIEW":"Voltar para Overview","PUBLISH":"Publicar","PUBLISH_NOTE":"Daqui você pode publicar a versão atual do website.","PUBLISH_SERVER":"Servidor Alvo","CURRENTLY_PUBLISHING":"Publicando …","STATE":"Status","PUBLISH_DONE":"Publicado","PUBLISH_STATE_BUILDING":"Mudanças estão sendo construídas ...","PUBLISH_STATE_PUBLISH":"Mudanças estão sendo publicadas ...","PUBLISH_STATE_DONE":"Publicação feita.","FIND_FILES":"Procurar Arquivos","FIND_FILES_PLACEHOLDER":"Entrar com o nome da página ...","ATTACHMENT_TYPE":"Tipo de anexo","URL_SLUG":"URL slug","TEMPLATE":"Template","HIDE_PAGE":"Esconder página","HIDE_PAGE_EXPLANATION":"Isto deveria ser escondido?","PAGE_IS_DISCOVERABLE":"Página é descobrível","PAGE_IS_DISCOVERABLE_EXPLANATION":"Se isto estiver ativo a página pode ser descoberta, caso contrário será necessário saber a URL.","REFRESH_BUILD":"Atualizar Build","REFRESH_BUILD_NOTE":"Isto deleta todos os resultados de builds em cache ativando uma build do zero.  Isto é útil em situações onde erros de sincronização ou erros no template causam saídas corrompidas.","CURRENTLY_REFRESHING_BUILD":"No momento atualizando a build ...","REFRESHING_BUILD_DONE":"Atualização da build feita!","FAILED_TO_LAUNCH_LEKTOR":"Falha ao iniciar o Lektor.","PROJECT":"Projeto","CLOSE_PROJECT":"Fechar Projeto","OPEN_PROJECT":"Abrir Projeto","BROWSE_WEBSITE":"Navegar no Website","VIEW_ADMIN_PANEL":"Ver Admin Painel","QUIT":"Sair","FAILED_TO_LOAD_PROJECT":"Falha ao carregar o projeto :(","LOADING_PROJECT":"Carregando o projeto ...","INITIALIZING_LEKTOR":"Iniciando o Lektor ...","QUIT_LEKTOR":"Sair do Lektor","FILE":"Arquivo","UNDO":"Desfazer","REDO":"Refazer","CUT":"Cortar","COPY":"Copiar","PASTE":"Colar","SELECT_ALL":"Selecionar Todos","HELP":"Ajuda","VISIT_WEBSITE":"Visitar Website","INSTALL_SHELL_COMMAND":"Instalar Shell Command","INSTALL_SHELL_COMMAND_QUESTION":"Você deseja instalar \'lektor\' shell command? Isto requer permissões de administrador.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Falha ao instalar shell commands.","INSTALL_SHELL_COMMAND_SUCCESS":"Shell command foi instalado com sucesso.","OPERATION_SUCCESS":"Sucesso","YES":"Sim","NO":"Não","OK":"OK","FAILED_TO_OPEN_CONTENT_FILE":"Falha ao abrir o conteúdo do arquivo","OPEN_OTHER_PROJECT":"Abrir outro Projeto","OPEN_OTHER_PROJECT_QUESTION":"Abrir este arquivo requer abrir outro projeto (%s). O projeto atual será fechado. Deseja continuar?"}');

/***/ }),

/***/ "../lektor/translations/ru.json":
/*!**************************************!*\
  !*** ../lektor/translations/ru.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"Вернуться на вебсайт","UNLOAD_ACTIVE_TAB":"Ваши изменения не сохранены. Вы уверены, что хотите покинуть страницу?","EDIT_METADATA":"Редактировать метаданные","EDIT":"Редактировать","DELETE":"Удалить","PREVIEW":"Предпросмотр","ALTS":"Варианты","PRIMARY_ALT":"Основной","PRIMARY_OVERLAY":"Оверлей","ADD_CHILD_PAGE":"Добавить страницу","ADD_ATTACHMENT":"Приложить файл","ATTACHMENT_ACTIONS":"Действия с вложением","PAGE_ACTIONS":"Действия со страницей","NO_CHILD_PAGES":"Вложенные страницы отсутствуют","CHILD_PAGES":"Вложенные страницы","NO_ATTACHMENTS":"Вложенные файлы отсутствуют","ATTACHMENTS":"Вложенные файлы","ADD_ATTACHMENT_TO":"Приложить файл к странице “%s”","ADD_ATTACHMENT_NOTE":"Здесь вы можете загрузить новый файл.","UPLOAD":"Загрузить","PROGRESS":"Прогресс","ERROR_PREFIX":"Ошибка: ","ERROR_NO_ID_PROVIDED":"Ошибка: Отсутсует ID.","ERROR_PAGE_ID_DUPLICATE":"Страница с ID (%s) уже существует.","ERROR_INVALID_ID":"Некорректный ID","ERROR_INVALID_DATE":"Некорректная дата","ERROR_INVALID_NUMBER":"Некорректное число","ERROR_INVALID_URL":"Некорректный URL","ERROR":"Ошибка","ERROR_OCURRED":"Произошла ошибка","ERROR_REQUEST_FAILED":"Ошибка при отправке команды на сервер.  Возможно, сервер остановлен или не отвечает.","ERROR_SERVER_UNAVAILABLE":"Сервер недоступен","ERROR_SERVER_UNAVAILABLE_MESSAGE":"Сервер не отвечает. Возможно, сервер остановлен или произошла критическая ошибка. Перезапустите сервер.","MODEL":"Модель","ADD_CHILD_PAGE_TO":"Создать вложенную страницу для “%s”","ADD_CHILD_PAGE_NOTE":"Здесь вы можете создать новую вложенную страницу. Имейте в виду, что вы не сможете легко изменить модель и ID после создания страницы.","CREATE_CHILD_PAGE":"Создать вложенную страницу","DELETE_ATTACHMENT_PROMPT":"Вы действительно хотите удалить это вложение?","DELETE_ATTACHMENT_ALT_PROMPT":"Вы действительно хотите удалить этот вариант вложения?","DELETE_PAGE_PROMPT":"Вы действительно хотите удалить эту страницу?","DELETE_PAGE_ALT_PROMPT":"Вы действительно хотите удалить этот вариант страницы?","DELETE_PAGE_CHILDREN_WARNING":"Страница будет удалена вместе со всеми вложенными страницами.","DELETE_RECORD":"Удалить “%s”","DELETE_ALL_PAGE_ALTS":"Удалить все варианты страницы и вложенные файлы.","DELETE_ALL_ATTACHMENT_ALTS":"Удалить все варианты вложенного файла","DELETE_ONLY_PRIMARY_PAGE_ALT":"Удалить только основную версию.  Вложеннные страницы, файлы и другие варианты страницы не будут удалены.","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"Удалить только основную версию.","DELETE_PRIMARY_ALT_INFO":"Данная версия является основной и может быть удалена как отдельно, так и вместе со всем содержимым.","CHILD_PAGES_TO_BE_DELETED":"Вложенные страницы, которые будут удалены:","ALTS_TO_BE_DELETED":"Версии, которые будут удалены:","ATTACHMENTS_TO_BE_DELETED":"Вложенные файлы, которые будут удалены:","YES_DELETE":"Да, удалить","NO_CANCEL":"Отмена","SYSTEM_FIELDS":"Системные поля","EDIT_ATTACHMENT_METADATA_OF":"Редактировать метаданные вложения “%s”","EDIT_PAGE_NAME":"Редактировать “%s”","SAVE_CHANGES":"Сохранить изменения","BROWSE_FS":"Посмотреть в файловой системе","BROWSE_FS_MAC":"Открыть в Finder","BROWSE_FS_WINDOWS":"Открыть в Обозревателе","ERROR_CANNOT_BROWSE_FS":"Ошибка: Файл не существует.","REMOVE_FLOWBLOCK_PROMPT":"Вы действительно хотите удалить этот блок?","ADD_FLOWBLOCK":"Добавить блок","INVALID_INPUT":"Некорректный ввод","UP":"Вверх","DOWN":"Вниз","REMOVE":"Удалить","ID":"Идентификатор (ID)","CLOSE":"Закрыть","CANCEL":"Отмена","BACK_TO_OVERVIEW":"На стартовую страницу","PUBLISH":"Опубликовать","PUBLISH_NOTE":"Здесь вы можете опубликовать текущую версию вебсайта.","PUBLISH_SERVER":"Сервер","CURRENTLY_PUBLISHING":"Публикация …","STATE":"Статус","PUBLISH_DONE":"Публикация завершена","PUBLISH_STATE_BUILDING":"Сборка изменений ...","PUBLISH_STATE_PUBLISH":"Публикация изменений ...","PUBLISH_STATE_DONE":"Публикация завершена.","FIND_FILES":"Поиск файла","FIND_FILES_PLACEHOLDER":"Введите имя страницы ...","ATTACHMENT_TYPE":"Тип вложения","URL_SLUG":"Краткий заголовок для URL","TEMPLATE":"Шаблон","HIDE_PAGE":"Скрыть страницу","HIDE_PAGE_EXPLANATION":"Скрыть данную страницу?","REFRESH_BUILD":"Обновить сборку","REFRESH_BUILD_NOTE":"В некоторых ситуациях бывает полезно заново пересобрать страницы вебсайта: например, когда произошёл сбой синхронизации или ошибка в шаблоне привела к некорректному отображению вебсайта.","CURRENTLY_REFRESHING_BUILD":"Обновление сборки ...","REFRESHING_BUILD_DONE":"Сборка обновлена!","FAILED_TO_LAUNCH_LEKTOR":"Не удалось запустить Lektor.","PROJECT":"Проект","CLOSE_PROJECT":"Закрыть проект","OPEN_PROJECT":"Открыть проект","BROWSE_WEBSITE":"Открыть вебсайт","VIEW_ADMIN_PANEL":"Открыть админ-панель","QUIT":"Выйти","FAILED_TO_LOAD_PROJECT":"Не удалось загрузить проект :(","LOADING_PROJECT":"Загрузка проекта ...","INITIALIZING_LEKTOR":"Инициализация Lektor ...","QUIT_LEKTOR":"Выйти из Lektor","FILE":"Файл","UNDO":"Отменить","REDO":"Повторить","CUT":"Вырезать","COPY":"Копировать","PASTE":"Вставить","SELECT_ALL":"Выделить всё","HELP":"Помощь","VISIT_WEBSITE":"Открыть вебсайт","INSTALL_SHELL_COMMAND":"Установить команду для терминала","INSTALL_SHELL_COMMAND_QUESTION":"Вы хотите установить команду \'lektor\' для терминала? Для этого необходимы права администратора.","FAILED_TO_INSTALL_SHELL_COMMANDS":"Не удалось установить команду для терминала.","INSTALL_SHELL_COMMAND_SUCCESS":"Команда для терминала была успешно установлена.","OPERATION_SUCCESS":"Операция завершена успешно","YES":"Да","NO":"Нет","OK":"ОК"}');

/***/ }),

/***/ "../lektor/translations/zh.json":
/*!**************************************!*\
  !*** ../lektor/translations/zh.json ***!
  \**************************************/
/***/ ((module) => {

module.exports = JSON.parse('{"RETURN_TO_WEBSITE":"回到網頁","UNLOAD_ACTIVE_TAB":"你還有未儲存的資訊，確定要離開這個頁面？","EDIT_METADATA":"編輯元資料","EDIT":"編輯","DELETE":"刪除","PREVIEW":"預覽","ALTS":"副語","PRIMARY_ALT":"主語","PRIMARY_OVERLAY":"Overlaid","ADD_CHILD_PAGE":"新增頁面","ADD_ATTACHMENT":"新增附件","ATTACHMENT_ACTIONS":"附件行為","PAGE_ACTIONS":"頁面行為","NO_CHILD_PAGES":"沒有附件","CHILD_PAGES":"子頁面","NO_ATTACHMENTS":"沒有附件","ATTACHMENTS":"附件","ADD_ATTACHMENT_TO":"新增附件到「%s」","ADD_ATTACHMENT_NOTE":"你可以在這裡上傳新的附件。","UPLOAD":"上傳","PROGRESS":"進度","ERROR_PREFIX":"錯誤：","ERROR_NO_ID_PROVIDED":"錯誤：沒有提供ID。","ERROR_PAGE_ID_DUPLICATE":"已經有頁面的ID跟這個ID（%s）一樣了。","ERROR_INVALID_ID":"無效的ID","ERROR_INVALID_DATE":"無效的日期","ERROR_INVALID_NUMBER":"無效的數字","ERROR_INVALID_URL":"無效的URL","ERROR":"錯誤","ERROR_OCURRED":"發生錯誤","ERROR_REQUEST_FAILED":"無法傳送指令到伺服器，可能它被關了或沒回應？","ERROR_SERVER_UNAVAILABLE":"伺服器掛掉了","ERROR_SERVER_UNAVAILABLE_MESSAGE":"伺服器目前沒回應，它可能已被關閉或是遇到嚴重錯誤導致無法運作，伺服器需要重新啟動。","MODEL":"模型","ADD_CHILD_PAGE_TO":"新增子面頁到 「%s」","ADD_CHILD_PAGE_NOTE":"你可以在這裡加入新的子頁面，注意模型及ID之後無法輕易更改。","CREATE_CHILD_PAGE":"新增子頁面","DELETE_ATTACHMENT_PROMPT":"真的要刪除這個附件？","DELETE_ATTACHMENT_ALT_PROMPT":"你真的想刪除這個副語附件的元資料嗎？","DELETE_PAGE_PROMPT":"真的要刪除這個頁面？","DELETE_PAGE_ALT_PROMPT":"你真的想刪除這個分支嗎？","DELETE_PAGE_CHILDREN_WARNING":"這也會把這個頁面的子頁面刪除。","DELETE_RECORD":"刪除「%s」","DELETE_ALL_PAGE_ALTS":"順便刪除所有副語及附加檔案。","DELETE_ALL_ATTACHMENT_ALTS":"刪除所有副語及附加檔案。","DELETE_ONLY_PRIMARY_PAGE_ALT":"只刪除主語的紀錄，附件、副語、及子頁面不會被刪除。","DELETE_ONLY_PRIMARY_ATTACHMENT_ALT":"只刪除主語紀錄的元資料。","DELETE_PRIMARY_ALT_INFO":"主語可以被單獨刪除，或是連同副語一起刪除。","CHILD_PAGES_TO_BE_DELETED":"即將被刪除的子頁面：","ALTS_TO_BE_DELETED":"即將被刪除的副語：","ATTACHMENTS_TO_BE_DELETED":"即將被刪除的附件：","YES_DELETE":"對，就是要把它刪掉！","NO_CANCEL":"還是不要好了...","SYSTEM_FIELDS":"系統欄位","EDIT_ATTACHMENT_METADATA_OF":"編輯附件「%s」的元資料","EDIT_PAGE_NAME":"編輯「%s」","SAVE_CHANGES":"儲存變更","BROWSE_FS":"用文件系統開啟","BROWSE_FS_MAC":"用Finder開啟","BROWSE_FS_WINDOWS":"用檔案總管開啟","ERROR_CANNOT_BROWSE_FS":"錯誤：檔案還沒有存在。","REMOVE_FLOWBLOCK_PROMPT":"你真的要刪掉這個區塊？","ADD_FLOWBLOCK":"新增區塊","INVALID_INPUT":"無效的輸入","UP":"上","DOWN":"下","REMOVE":"移除","ID":"ID","CLOSE":"關閉","CANCEL":"取消","BACK_TO_OVERVIEW":"回到總覽","PUBLISH":"發佈","PUBLISH_NOTE":"你可以在這裡發佈網站目前的版本。","PUBLISH_SERVER":"目標伺服器","CURRENTLY_PUBLISHING":"發佈中...","STATE":"狀態","PUBLISH_DONE":"已發佈","PUBLISH_STATE_BUILDING":"正在建置變更...","PUBLISH_STATE_PUBLISH":"正在發佈變更...","PUBLISH_STATE_DONE":"發佈完成。","FIND_FILES":"搜尋檔案","FIND_FILES_PLACEHOLDER":"輸入頁面名稱...","ATTACHMENT_TYPE":"附件類型","URL_SLUG":"URL縮略名","TEMPLATE":"模板","HIDE_PAGE":"隱藏頁面","HIDE_PAGE_EXPLANATION":"要隱藏這個頁面嗎？","PAGE_IS_DISCOVERABLE":"網頁可以被發現","PAGE_IS_DISCOVERABLE_EXPLANATION":"若啟用則這個頁面可以被發現，否則必須知道URL才能連結到這裡。","REFRESH_BUILD":"重新整理建置","REFRESH_BUILD_NOTE":"這會刪掉所有緩存的建置結果並導致重新置建。這在特殊情況（如同步錯誤、模板出錯等）下會有用。","CURRENTLY_REFRESHING_BUILD":"刷新建置中...","REFRESHING_BUILD_DONE":"完成刷新建置！","FAILED_TO_LAUNCH_LEKTOR":"啟動Lektor失敗。","PROJECT":"專案","CLOSE_PROJECT":"關閉專案","OPEN_PROJECT":"開啟專案","BROWSE_WEBSITE":"瀏覽網站","VIEW_ADMIN_PANEL":"查看管理員面板","QUIT":"離開","FAILED_TO_LOAD_PROJECT":"讀取專案失敗 QAQ","LOADING_PROJECT":"讀取專案中...","INITIALIZING_LEKTOR":"初始化Lektor中...","QUIT_LEKTOR":"離開Lektor","FILE":"檔案","UNDO":"復原","REDO":"重做","CUT":"剪下","COPY":"複製","PASTE":"貼上","SELECT_ALL":"全選","HELP":"說明","VISIT_WEBSITE":"參觀網站","INSTALL_SHELL_COMMAND":"安裝命令列模式","INSTALL_SHELL_COMMAND_QUESTION":"你想安裝lektor命令列模式嗎？ 這需要管理員權限。","FAILED_TO_INSTALL_SHELL_COMMANDS":"安裝命令列模式失敗。","INSTALL_SHELL_COMMAND_SUCCESS":"命令列模式安裝成功","OPERATION_SUCCESS":"成功","YES":"是","NO":"否","OK":"好","FAILED_TO_OPEN_CONTENT_FILE":"開啟檔案失敗","OPEN_OTHER_PROJECT":"開啟其它專案","OPEN_OTHER_PROJECT_QUESTION":"開啟這份檔案需要連同開啟另一個專案（%s），目前的專案將會被關閉，確定要繼續？"}');

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/chunk loaded */
/******/ 	(() => {
/******/ 		var deferred = [];
/******/ 		__webpack_require__.O = (result, chunkIds, fn, priority) => {
/******/ 			if(chunkIds) {
/******/ 				priority = priority || 0;
/******/ 				for(var i = deferred.length; i > 0 && deferred[i - 1][2] > priority; i--) deferred[i] = deferred[i - 1];
/******/ 				deferred[i] = [chunkIds, fn, priority];
/******/ 				return;
/******/ 			}
/******/ 			var notFulfilled = Infinity;
/******/ 			for (var i = 0; i < deferred.length; i++) {
/******/ 				var [chunkIds, fn, priority] = deferred[i];
/******/ 				var fulfilled = true;
/******/ 				for (var j = 0; j < chunkIds.length; j++) {
/******/ 					if ((priority & 1 === 0 || notFulfilled >= priority) && Object.keys(__webpack_require__.O).every((key) => (__webpack_require__.O[key](chunkIds[j])))) {
/******/ 						chunkIds.splice(j--, 1);
/******/ 					} else {
/******/ 						fulfilled = false;
/******/ 						if(priority < notFulfilled) notFulfilled = priority;
/******/ 					}
/******/ 				}
/******/ 				if(fulfilled) {
/******/ 					deferred.splice(i--, 1)
/******/ 					var r = fn();
/******/ 					if (r !== undefined) result = r;
/******/ 				}
/******/ 			}
/******/ 			return result;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/global */
/******/ 	(() => {
/******/ 		__webpack_require__.g = (function() {
/******/ 			if (typeof globalThis === 'object') return globalThis;
/******/ 			try {
/******/ 				return this || new Function('return this')();
/******/ 			} catch (e) {
/******/ 				if (typeof window === 'object') return window;
/******/ 			}
/******/ 		})();
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			"app": 0
/******/ 		};
/******/ 		
/******/ 		// no chunk on demand loading
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		__webpack_require__.O.j = (chunkId) => (installedChunks[chunkId] === 0);
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 			return __webpack_require__.O(result);
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunklektor"] = self["webpackChunklektor"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module depends on other loaded chunks and execution need to be delayed
/******/ 	var __webpack_exports__ = __webpack_require__.O(undefined, ["vendor"], () => (__webpack_require__("./js/main.tsx")))
/******/ 	__webpack_exports__ = __webpack_require__.O(__webpack_exports__);
/******/ 	
/******/ })()
;
//# sourceMappingURL=app.js.map