""""""
#------------------------------------------------------------------------------
# Description    : SCPI interface
# Git repository : https://gitlab.com/qblox/packages/software/qblox_instruments.git
# Copyright (C) Qblox BV (2020)
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT MODIFY THIS FILE MANUALLY!
#------------------------------------------------------------------------------


#-- include --------------------------------------------------------------------

import sys
import os

#Add SCPI support
from pulsar_qcm.pulsar_qcm_scpi_ifc import pulsar_qcm_scpi_ifc

#-- class ----------------------------------------------------------------------

class pulsar_qcm_scpi_ifc_private(pulsar_qcm_scpi_ifc):
    """
    This interface provides an API for mandatory, required and regular Pulsar SCPI calls and
    adds functionality for calls that should be hidden for regular users.
    """

    #---------------------------------------------------------------------------
    def __init__(self, transport_inst, debug = 0):
        """
        Creates private SCPI interface object

        Parameters
        ----------
        transport_inst : :class:`~ieee488_2.transport`
            Transport class responsible for the lowest level of communication (e.g. ethernet).
        debug : int
            Debug level (0 = normal, 1 = no version check, >1 = no error checking).

        Returns
        ----------
        scpi_ifc : :class:`~pulsar_qcm.pulsar_qcm_scpi_ifc`
            SCPI interface.

        Raises
        ----------
        Exception
            Debug level is 0 and there is a version mismatch.
        """

        #Initialize parent class
        super(pulsar_qcm_scpi_ifc_private, self).__init__(transport_inst, debug)

    #---------------------------------------------------------------------------
    def get_private_scpi_commands(self):
        """
        Get private SCPI commands (hidden from regular users).

        Parameters
        ----------

        Returns
        ----------
        str
            Concatinated list of strings separated by the semicolon character. Each command consists of nine strings respectively ordered as:

            - SCPI command pattern
            - SCPI input type
            - SCPI output type
            - Python function
            - Python input types (comma separated)
            - Python input variable names (comma separated)
            - Python output types (comma separated)
            - User access level (0 = public, >=1 = private)
            - Comment

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*PRVT_CMDS?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_cb_eeprom(self, type, rev, board_num, dev_num):
        """
        Set board type, revision and serial number and device serial number in carier board EEPROM.

        Parameters
        ----------
        type : str
            Board type string.
        rev : str
            Board revision string.
        board_num : str
            Board serial number string.
        dev_num : str
            Device serial number string.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['str', 'str', 'str', 'str'])

        #SCPI call
        try:
            self._write('CARRier:EEPROM "{}","{}","{}","{}"'.format(type, rev, board_num, dev_num))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_cb_eeprom(self):
        """
        Get board type, revision and serial number and device serial number in carier board EEPROM.

        Parameters
        ----------

        Returns
        ----------
        str
            Board type string.
        str
            Board revision string.
        str
            Board serial number string.
        str
            Device serial number string.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('CARRier:EEPROM?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_afe_eeprom(self, type, rev, board_num, dev_num):
        """
        Set board type, revision and serial number and device serial number in analog frontend board EEPROM.

        Parameters
        ----------
        type : str
            Board type string.
        rev : str
            Board revision string.
        board_num : str
            Board serial number string.
        dev_num : str
            Device serial number string.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['str', 'str', 'str', 'str'])

        #SCPI call
        try:
            self._write('*AFE_EEPROM "{}","{}","{}","{}"'.format(type, rev, board_num, dev_num))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_afe_eeprom(self):
        """
        Get board type, revision and serial number and device serial number in analog frontend board EEPROM.

        Parameters
        ----------

        Returns
        ----------
        str
            Board type string.
        str
            Board revision string.
        str
            Board serial number string.
        str
            Device serial number string.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*AFE_EEPROM?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def set_extio_eeprom(self, type, rev, board_num, dev_num):
        """
        Set board type, revision and serial number and device serial number in EXTIO board EEPROM.

        Parameters
        ----------
        type : str
            Board type string.
        rev : str
            Board revision string.
        board_num : str
            Board serial number string.
        dev_num : str
            Device serial number string.

        Returns
        ----------

        Raises
        ----------
        Exception
            Invalid input parameter type.
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #Check input types.
        self._check_in_type(locals(), ['str', 'str', 'str', 'str'])

        #SCPI call
        try:
            self._write('*EXTIO_EEPROM "{}","{}","{}","{}"'.format(type, rev, board_num, dev_num))
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

    #---------------------------------------------------------------------------
    def get_extio_eeprom(self):
        """
        Get board type, revision and serial number and device serial number in EXTIO board EEPROM.

        Parameters
        ----------

        Returns
        ----------
        str
            Board type string.
        str
            Board revision string.
        str
            Board serial number string.
        str
            Device serial number string.

        Raises
        ----------
        Exception
            An error is reported in system error and debug <= 1.
            All errors are read from system error and listed in the exception.
        """

        #SCPI call
        try:
            var0 = self._read('*EXTIO_EEPROM?')

            return var0
        except Exception as err:
            self._check_error_queue(err)
        finally:
            self._check_error_queue()

