# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AddressableResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'ConfigMapEnvSourceResponse',
    'ConfigMapKeySelectorResponse',
    'ConfigMapVolumeSourceResponse',
    'ContainerPortResponse',
    'ContainerResponse',
    'DomainMappingSpecResponse',
    'DomainMappingStatusResponse',
    'EnvFromSourceResponse',
    'EnvVarResponse',
    'EnvVarSourceResponse',
    'ExecActionResponse',
    'ExecutionReferenceResponse',
    'ExecutionSpecResponse',
    'ExecutionTemplateSpecResponse',
    'ExprResponse',
    'GRPCActionResponse',
    'GoogleCloudRunV1ConditionResponse',
    'HTTPGetActionResponse',
    'HTTPHeaderResponse',
    'JobSpecResponse',
    'JobStatusResponse',
    'KeyToPathResponse',
    'LocalObjectReferenceResponse',
    'ObjectMetaResponse',
    'OwnerReferenceResponse',
    'ProbeResponse',
    'ResourceRecordResponse',
    'ResourceRequirementsResponse',
    'RevisionSpecResponse',
    'RevisionTemplateResponse',
    'SecretEnvSourceResponse',
    'SecretKeySelectorResponse',
    'SecretVolumeSourceResponse',
    'SecurityContextResponse',
    'ServiceSpecResponse',
    'ServiceStatusResponse',
    'TCPSocketActionResponse',
    'TaskSpecResponse',
    'TaskTemplateSpecResponse',
    'TrafficTargetResponse',
    'VolumeMountResponse',
    'VolumeResponse',
]

@pulumi.output_type
class AddressableResponse(dict):
    """
    Information for connecting over HTTP(s).
    """
    def __init__(__self__, *,
                 url: str):
        """
        Information for connecting over HTTP(s).
        """
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ConfigMapEnvSourceResponse(dict):
    """
    Not supported by Cloud Run. ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run. ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The ConfigMap to select from.
        :param bool optional: Specify whether the ConfigMap must be defined.
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the ConfigMap must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapKeySelectorResponse(dict):
    """
    Not supported by Cloud Run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run.
        :param str key: Not supported by Cloud Run.
        :param 'LocalObjectReferenceResponse' local_object_reference: Not supported by Cloud Run.
        :param str name: Not supported by Cloud Run.
        :param bool optional: Not supported by Cloud Run.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapVolumeSourceResponse(dict):
    """
    Not supported by Cloud Run. Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run. Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
        :param int default_mode: (Optional) Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: (Optional) If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        :param str name: Name of the config.
        :param bool optional: (Optional) Specify whether the Secret or its keys must be defined.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        (Optional) Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0644. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        (Optional) If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified that is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        (Optional) Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ContainerPortResponse(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: int,
                 name: str,
                 protocol: str):
        """
        ContainerPort represents a network port in a single container.
        :param int container_port: Port number the container listens on. This must be a valid port number, 0 < x < 65536.
        :param str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        :param str protocol: Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Port number the container listens on. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol for port. Must be "TCP". Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerResponse(dict):
    """
    A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Sequence['outputs.EnvVarResponse'],
                 env_from: Sequence['outputs.EnvFromSourceResponse'],
                 image: str,
                 image_pull_policy: str,
                 liveness_probe: 'outputs.ProbeResponse',
                 name: str,
                 ports: Sequence['outputs.ContainerPortResponse'],
                 readiness_probe: 'outputs.ProbeResponse',
                 resources: 'outputs.ResourceRequirementsResponse',
                 security_context: 'outputs.SecurityContextResponse',
                 startup_probe: 'outputs.ProbeResponse',
                 termination_message_path: str,
                 termination_message_policy: str,
                 volume_mounts: Sequence['outputs.VolumeMountResponse'],
                 working_dir: str):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[str] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence['EnvVarResponse'] env: List of environment variables to set in the container.
        :param Sequence['EnvFromSourceResponse'] env_from: Not supported by Cloud Run.
        :param str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'ProbeResponse' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param str name: Name of the container specified as a DNS_LABEL. Currently unused in Cloud Run. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names
        :param Sequence['ContainerPortResponse'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        :param 'ProbeResponse' readiness_probe: Not supported by Cloud Run.
        :param 'ResourceRequirementsResponse' resources: Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param 'SecurityContextResponse' security_context: Not supported by Cloud Run.
        :param 'ProbeResponse' startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not receive traffic if the probe fails. If not provided, a default startup probe with TCP socket action is used. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param str termination_message_path: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log.
        :param str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param Sequence['VolumeMountResponse'] volume_mounts: Volume to mount into the container's filesystem. Only supports SecretVolumeSources. Pod volumes to mount into the container's filesystem.
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "env_from", env_from)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "liveness_probe", liveness_probe)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "readiness_probe", readiness_probe)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_context", security_context)
        pulumi.set(__self__, "startup_probe", startup_probe)
        pulumi.set(__self__, "termination_message_path", termination_message_path)
        pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Sequence['outputs.EnvVarResponse']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Sequence['outputs.EnvFromSourceResponse']:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "env_from")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> 'outputs.ProbeResponse':
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the container specified as a DNS_LABEL. Currently unused in Cloud Run. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-label-names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.ContainerPortResponse']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible. If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> 'outputs.ProbeResponse':
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.ResourceRequirementsResponse':
        """
        Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> 'outputs.SecurityContextResponse':
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> 'outputs.ProbeResponse':
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not receive traffic if the probe fails. If not provided, a default startup probe with TCP socket action is used. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> str:
        """
        Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log.
        """
        return pulumi.get(self, "termination_message_path")

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> str:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.VolumeMountResponse']:
        """
        Volume to mount into the container's filesystem. Only supports SecretVolumeSources. Pod volumes to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class DomainMappingSpecResponse(dict):
    """
    The desired state of the Domain Mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateMode":
            suggest = "certificate_mode"
        elif key == "forceOverride":
            suggest = "force_override"
        elif key == "routeName":
            suggest = "route_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_mode: str,
                 force_override: bool,
                 route_name: str):
        """
        The desired state of the Domain Mapping.
        :param str certificate_mode: The mode of the certificate.
        :param bool force_override: If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        :param str route_name: The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        pulumi.set(__self__, "certificate_mode", certificate_mode)
        pulumi.set(__self__, "force_override", force_override)
        pulumi.set(__self__, "route_name", route_name)

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> str:
        """
        The mode of the certificate.
        """
        return pulumi.get(self, "certificate_mode")

    @property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> bool:
        """
        If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        """
        return pulumi.get(self, "force_override")

    @property
    @pulumi.getter(name="routeName")
    def route_name(self) -> str:
        """
        The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        return pulumi.get(self, "route_name")


@pulumi.output_type
class DomainMappingStatusResponse(dict):
    """
    The current state of the Domain Mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mappedRouteName":
            suggest = "mapped_route_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "resourceRecords":
            suggest = "resource_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.GoogleCloudRunV1ConditionResponse'],
                 mapped_route_name: str,
                 observed_generation: int,
                 resource_records: Sequence['outputs.ResourceRecordResponse'],
                 url: str):
        """
        The current state of the Domain Mapping.
        :param Sequence['GoogleCloudRunV1ConditionResponse'] conditions: Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        :param str mapped_route_name: The name of the route that the mapping currently points to.
        :param int observed_generation: ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param Sequence['ResourceRecordResponse'] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        :param str url: Optional. Not supported by Cloud Run.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "resource_records", resource_records)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GoogleCloudRunV1ConditionResponse']:
        """
        Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> str:
        """
        The name of the route that the mapping currently points to.
        """
        return pulumi.get(self, "mapped_route_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Sequence['outputs.ResourceRecordResponse']:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        """
        return pulumi.get(self, "resource_records")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Optional. Not supported by Cloud Run.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class EnvFromSourceResponse(dict):
    """
    Not supported by Cloud Run. EnvFromSource represents the source of a set of ConfigMaps
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvFromSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: 'outputs.ConfigMapEnvSourceResponse',
                 prefix: str,
                 secret_ref: 'outputs.SecretEnvSourceResponse'):
        """
        Not supported by Cloud Run. EnvFromSource represents the source of a set of ConfigMaps
        :param 'ConfigMapEnvSourceResponse' config_map_ref: The ConfigMap to select from
        :param str prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        :param 'SecretEnvSourceResponse' secret_ref: The Secret to select from
        """
        pulumi.set(__self__, "config_map_ref", config_map_ref)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> 'outputs.ConfigMapEnvSourceResponse':
        """
        The ConfigMap to select from
        """
        return pulumi.get(self, "config_map_ref")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> 'outputs.SecretEnvSourceResponse':
        """
        The Secret to select from
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class EnvVarResponse(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_from: 'outputs.EnvVarSourceResponse'):
        """
        EnvVar represents an environment variable present in a Container.
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param str value: Value of the environment variable. Defaults to "". Variable references are not supported in Cloud Run.
        :param 'EnvVarSourceResponse' value_from: Source for the environment variable's value. Only supports secret_key_ref. Cannot be used if value is not empty.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the environment variable. Defaults to "". Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> 'outputs.EnvVarSourceResponse':
        """
        Source for the environment variable's value. Only supports secret_key_ref. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class EnvVarSourceResponse(dict):
    """
    EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapKeyRef":
            suggest = "config_map_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_key_ref: 'outputs.ConfigMapKeySelectorResponse',
                 secret_key_ref: 'outputs.SecretKeySelectorResponse'):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorResponse' config_map_key_ref: Not supported by Cloud Run. Not supported in Cloud Run.
        :param 'SecretKeySelectorResponse' secret_key_ref: Selects a key (version) of a secret in Secret Manager.
        """
        pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> 'outputs.ConfigMapKeySelectorResponse':
        """
        Not supported by Cloud Run. Not supported in Cloud Run.
        """
        return pulumi.get(self, "config_map_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.SecretKeySelectorResponse':
        """
        Selects a key (version) of a secret in Secret Manager.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ExecActionResponse(dict):
    """
    Not supported by Cloud Run. ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Sequence[str]):
        """
        Not supported by Cloud Run. ExecAction describes a "run in container" action.
        :param Sequence[str] command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class ExecutionReferenceResponse(dict):
    """
    Reference to an Execution. Use /Executions.GetExecution with the given name to get full execution including the latest status.
    """
    def __init__(__self__, *,
                 completion_timestamp: str,
                 creation_timestamp: str,
                 name: str):
        """
        Reference to an Execution. Use /Executions.GetExecution with the given name to get full execution including the latest status.
        :param str completion_timestamp: Optional. Completion timestamp of the execution.
        :param str creation_timestamp: Optional. Creation timestamp of the execution.
        :param str name: Optional. Name of the execution.
        """
        pulumi.set(__self__, "completion_timestamp", completion_timestamp)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTimestamp")
    def completion_timestamp(self) -> str:
        """
        Optional. Completion timestamp of the execution.
        """
        return pulumi.get(self, "completion_timestamp")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        Optional. Creation timestamp of the execution.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. Name of the execution.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ExecutionSpecResponse(dict):
    """
    ExecutionSpec describes how the execution will look.
    """
    def __init__(__self__, *,
                 parallelism: int,
                 task_count: int,
                 template: 'outputs.TaskTemplateSpecResponse'):
        """
        ExecutionSpec describes how the execution will look.
        :param int parallelism: Optional. Specifies the maximum desired number of tasks the execution should run at given time. Must be <= task_count. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed, i.e. when the work left to do is less than max parallelism.
        :param int task_count: Optional. Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution.
        :param 'TaskTemplateSpecResponse' template: Optional. The template used to create tasks for this execution.
        """
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "task_count", task_count)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Optional. Specifies the maximum desired number of tasks the execution should run at given time. Must be <= task_count. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> int:
        """
        Optional. Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution.
        """
        return pulumi.get(self, "task_count")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.TaskTemplateSpecResponse':
        """
        Optional. The template used to create tasks for this execution.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ExecutionTemplateSpecResponse(dict):
    """
    ExecutionTemplateSpec describes the metadata and spec an Execution should have when created from a job. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
    """
    def __init__(__self__, *,
                 metadata: 'outputs.ObjectMetaResponse',
                 spec: 'outputs.ExecutionSpecResponse'):
        """
        ExecutionTemplateSpec describes the metadata and spec an Execution should have when created from a job. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
        :param 'ObjectMetaResponse' metadata: Optional. Optional metadata for this Execution, including labels and annotations. The following annotation keys set properties of the created execution: * `run.googleapis.com/cloudsql-instances` sets Cloud SQL connections. Multiple values should be comma separated. * `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress. Supported values are `all-traffic`, `all` (deprecated), and `private-ranges-only`. `all-traffic` and `all` provide the same functionality. `all` is deprecated but will continue to be supported. Prefer `all-traffic`.
        :param 'ExecutionSpecResponse' spec: ExecutionSpec holds the desired configuration for executions of this job.
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.ObjectMetaResponse':
        """
        Optional. Optional metadata for this Execution, including labels and annotations. The following annotation keys set properties of the created execution: * `run.googleapis.com/cloudsql-instances` sets Cloud SQL connections. Multiple values should be comma separated. * `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress. Supported values are `all-traffic`, `all` (deprecated), and `private-ranges-only`. `all-traffic` and `all` provide the same functionality. `all` is deprecated but will continue to be supported. Prefer `all-traffic`.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ExecutionSpecResponse':
        """
        ExecutionSpec holds the desired configuration for executions of this job.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GRPCActionResponse(dict):
    """
    GRPCAction describes an action involving a GRPC port.
    """
    def __init__(__self__, *,
                 port: int,
                 service: str):
        """
        GRPCAction describes an action involving a GRPC port.
        :param int port: Port number of the gRPC service. Number must be in the range 1 to 65535.
        :param str service: Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number of the gRPC service. Number must be in the range 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md). If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleCloudRunV1ConditionResponse(dict):
    """
    Conditions show the status of reconciliation progress on a given resource. Most resource use a top-level condition type "Ready" or "Completed" to show overall status with other conditions to checkpoint each stage of reconciliation. Note that if metadata.Generation does not equal status.ObservedGeneration, the conditions shown may not be relevant for the current spec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudRunV1ConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudRunV1ConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudRunV1ConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        Conditions show the status of reconciliation progress on a given resource. Most resource use a top-level condition type "Ready" or "Completed" to show overall status with other conditions to checkpoint each stage of reconciliation. Note that if metadata.Generation does not equal status.ObservedGeneration, the conditions shown may not be relevant for the current spec.
        :param str last_transition_time: Optional. Last time the condition transitioned from one status to another.
        :param str message: Optional. Human readable message indicating details about the current status.
        :param str reason: Optional. One-word CamelCase reason for the condition's last transition. These are intended to be stable, unique values which the client may use to trigger error handling logic, whereas messages which may be changed later by the server.
        :param str severity: Optional. How to interpret this condition. One of Error, Warning, or Info. Conditions of severity Info do not contribute to resource readiness.
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready" or "Completed": True when the Resource is ready.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Optional. Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Optional. Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Optional. One-word CamelCase reason for the condition's last transition. These are intended to be stable, unique values which the client may use to trigger error handling logic, whereas messages which may be changed later by the server.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Optional. How to interpret this condition. One of Error, Warning, or Info. Conditions of severity Info do not contribute to resource readiness.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready" or "Completed": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HTTPGetActionResponse(dict):
    """
    HTTPGetAction describes an action based on HTTP Get requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPGetActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 http_headers: Sequence['outputs.HTTPHeaderResponse'],
                 path: str,
                 scheme: str):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param str host: Not supported by Cloud Run.
        :param Sequence['HTTPHeaderResponse'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param str path: Path to access on the HTTP server.
        :param str scheme: Not supported by Cloud Run.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.HTTPHeaderResponse']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class HTTPHeaderResponse(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobSpecResponse(dict):
    """
    JobSpec describes how the job will look.
    """
    def __init__(__self__, *,
                 template: 'outputs.ExecutionTemplateSpecResponse'):
        """
        JobSpec describes how the job will look.
        :param 'ExecutionTemplateSpecResponse' template: Optional. Describes the execution that will be created when running a job.
        """
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.ExecutionTemplateSpecResponse':
        """
        Optional. Describes the execution that will be created when running a job.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    JobStatus represents the current state of a Job.
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.GoogleCloudRunV1ConditionResponse'],
                 execution_count: int,
                 latest_created_execution: 'outputs.ExecutionReferenceResponse',
                 observed_generation: int):
        """
        JobStatus represents the current state of a Job.
        :param Sequence['GoogleCloudRunV1ConditionResponse'] conditions: Conditions communicate information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world. Job-specific conditions include: * `Ready`: `True` when the job is ready to be executed.
        :param int execution_count: Number of executions created for this job.
        :param 'ExecutionReferenceResponse' latest_created_execution: A pointer to the most recently created execution for this job. This is set regardless of the eventual state of the execution.
        :param int observed_generation: The 'generation' of the job that was last processed by the controller.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "execution_count", execution_count)
        pulumi.set(__self__, "latest_created_execution", latest_created_execution)
        pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GoogleCloudRunV1ConditionResponse']:
        """
        Conditions communicate information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world. Job-specific conditions include: * `Ready`: `True` when the job is ready to be executed.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="executionCount")
    def execution_count(self) -> int:
        """
        Number of executions created for this job.
        """
        return pulumi.get(self, "execution_count")

    @property
    @pulumi.getter(name="latestCreatedExecution")
    def latest_created_execution(self) -> 'outputs.ExecutionReferenceResponse':
        """
        A pointer to the most recently created execution for this job. This is set regardless of the eventual state of the execution.
        """
        return pulumi.get(self, "latest_created_execution")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        The 'generation' of the job that was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")


@pulumi.output_type
class KeyToPathResponse(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: str,
                 mode: int,
                 path: str):
        """
        Maps a string key to a path within a volume.
        :param str key: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version. The key to project.
        :param int mode: (Optional) Mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param str path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version. The key to project.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        (Optional) Mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class LocalObjectReferenceResponse(dict):
    """
    Not supported by Cloud Run. LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Not supported by Cloud Run. LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param str name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ObjectMetaResponse(dict):
    """
    k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "creationTimestamp":
            suggest = "creation_timestamp"
        elif key == "deletionGracePeriodSeconds":
            suggest = "deletion_grace_period_seconds"
        elif key == "deletionTimestamp":
            suggest = "deletion_timestamp"
        elif key == "generateName":
            suggest = "generate_name"
        elif key == "ownerReferences":
            suggest = "owner_references"
        elif key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 cluster_name: str,
                 creation_timestamp: str,
                 deletion_grace_period_seconds: int,
                 deletion_timestamp: str,
                 finalizers: Sequence[str],
                 generate_name: str,
                 generation: int,
                 labels: Mapping[str, str],
                 name: str,
                 namespace: str,
                 owner_references: Sequence['outputs.OwnerReferenceResponse'],
                 resource_version: str,
                 self_link: str,
                 uid: str):
        """
        k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param Mapping[str, str] annotations: Unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. In Cloud Run, annotations with 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted, and the accepted annotations will be different depending on the resource type. * `autoscaling.knative.dev/maxScale`: Revision. * `autoscaling.knative.dev/minScale`: Revision. * `run.googleapis.com/binary-authorization-breakglass`: Service, Job, * `run.googleapis.com/binary-authorization`: Service, Job, Execution. * `run.googleapis.com/client-name`: All resources. * `run.googleapis.com/cloudsql-instances`: Revision, Execution. * `run.googleapis.com/cpu-throttling`: Revision. * `run.googleapis.com/custom-audiences`: Service. * `run.googleapis.com/description`: Service. * `run.googleapis.com/encryption-key-shutdown-hours`: Revision * `run.googleapis.com/encryption-key`: Revision, Execution. * `run.googleapis.com/execution-environment`: Revision, Execution. * `run.googleapis.com/gc-traffic-tags`: Service. * `run.googleapis.com/ingress`: Service. * `run.googleapis.com/network-interfaces`: Revision, Execution. * `run.googleapis.com/post-key-revocation-action-type`: Revision. * `run.googleapis.com/secrets`: Revision, Execution. * `run.googleapis.com/secure-session-agent`: Revision. * `run.googleapis.com/sessionAffinity`: Revision. * `run.googleapis.com/startup-cpu-boost`: Revision. * `run.googleapis.com/vpc-access-connector`: Revision, Execution. * `run.googleapis.com/vpc-access-egress`: Revision, Execution. Execution. More info: https://kubernetes.io/docs/user-guide/annotations
        :param str cluster_name: Not supported by Cloud Run
        :param str creation_timestamp: UTC timestamp representing the server time when this object was created. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param int deletion_grace_period_seconds: Not supported by Cloud Run
        :param str deletion_timestamp: The read-only soft deletion timestamp for this resource. In Cloud Run, users are not able to set this field. Instead, they must call the corresponding Delete API.
        :param Sequence[str] finalizers: Not supported by Cloud Run
        :param str generate_name: Not supported by Cloud Run
        :param int generation: A system-provided sequence number representing a specific generation of the desired state.
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: https://kubernetes.io/docs/user-guide/labels
        :param str name: The name of the resource. In Cloud Run, name is required when creating top-level resources (Service, Job), must be unique within a Cloud Run project/region, and cannot be changed once created. More info: https://kubernetes.io/docs/user-guide/identifiers#names If ObjectMeta is part of a CreateServiceRequest, name must contain fewer than 50 characters.
        :param str namespace: Defines the space within each name must be unique within a Cloud Run region. In Cloud Run, it must be project ID or number.
        :param Sequence['OwnerReferenceResponse'] owner_references: Not supported by Cloud Run
        :param str resource_version: Opaque, system-generated value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server or omit the value to disable conflict-detection. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param str self_link: URL representing this object.
        :param str uid: Unique, system-generated identifier for this resource. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        pulumi.set(__self__, "finalizers", finalizers)
        pulumi.set(__self__, "generate_name", generate_name)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "owner_references", owner_references)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. In Cloud Run, annotations with 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted, and the accepted annotations will be different depending on the resource type. * `autoscaling.knative.dev/maxScale`: Revision. * `autoscaling.knative.dev/minScale`: Revision. * `run.googleapis.com/binary-authorization-breakglass`: Service, Job, * `run.googleapis.com/binary-authorization`: Service, Job, Execution. * `run.googleapis.com/client-name`: All resources. * `run.googleapis.com/cloudsql-instances`: Revision, Execution. * `run.googleapis.com/cpu-throttling`: Revision. * `run.googleapis.com/custom-audiences`: Service. * `run.googleapis.com/description`: Service. * `run.googleapis.com/encryption-key-shutdown-hours`: Revision * `run.googleapis.com/encryption-key`: Revision, Execution. * `run.googleapis.com/execution-environment`: Revision, Execution. * `run.googleapis.com/gc-traffic-tags`: Service. * `run.googleapis.com/ingress`: Service. * `run.googleapis.com/network-interfaces`: Revision, Execution. * `run.googleapis.com/post-key-revocation-action-type`: Revision. * `run.googleapis.com/secrets`: Revision, Execution. * `run.googleapis.com/secure-session-agent`: Revision. * `run.googleapis.com/sessionAffinity`: Revision. * `run.googleapis.com/startup-cpu-boost`: Revision. * `run.googleapis.com/vpc-access-connector`: Revision, Execution. * `run.googleapis.com/vpc-access-egress`: Revision, Execution. Execution. More info: https://kubernetes.io/docs/user-guide/annotations
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Not supported by Cloud Run
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        UTC timestamp representing the server time when this object was created. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> int:
        """
        Not supported by Cloud Run
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> str:
        """
        The read-only soft deletion timestamp for this resource. In Cloud Run, users are not able to set this field. Instead, they must call the corresponding Delete API.
        """
        return pulumi.get(self, "deletion_timestamp")

    @property
    @pulumi.getter
    def finalizers(self) -> Sequence[str]:
        """
        Not supported by Cloud Run
        """
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> str:
        """
        Not supported by Cloud Run
        """
        return pulumi.get(self, "generate_name")

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        A system-provided sequence number representing a specific generation of the desired state.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: https://kubernetes.io/docs/user-guide/labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource. In Cloud Run, name is required when creating top-level resources (Service, Job), must be unique within a Cloud Run project/region, and cannot be changed once created. More info: https://kubernetes.io/docs/user-guide/identifiers#names If ObjectMeta is part of a CreateServiceRequest, name must contain fewer than 50 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Defines the space within each name must be unique within a Cloud Run region. In Cloud Run, it must be project ID or number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Sequence['outputs.OwnerReferenceResponse']:
        """
        Not supported by Cloud Run
        """
        return pulumi.get(self, "owner_references")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        Opaque, system-generated value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server or omit the value to disable conflict-detection. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        URL representing this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Unique, system-generated identifier for this resource. More info: https://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class OwnerReferenceResponse(dict):
    """
    This is not supported or used by Cloud Run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "blockOwnerDeletion":
            suggest = "block_owner_deletion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OwnerReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: str,
                 block_owner_deletion: bool,
                 controller: bool,
                 kind: str,
                 name: str,
                 uid: str):
        """
        This is not supported or used by Cloud Run.
        :param str api_version: This is not supported or used by Cloud Run.
        :param bool block_owner_deletion: This is not supported or used by Cloud Run.
        :param bool controller: This is not supported or used by Cloud Run.
        :param str kind: This is not supported or used by Cloud Run.
        :param str name: This is not supported or used by Cloud Run.
        :param str uid: This is not supported or used by Cloud Run.
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        pulumi.set(__self__, "controller", controller)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> str:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> bool:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "block_owner_deletion")

    @property
    @pulumi.getter
    def controller(self) -> bool:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        This is not supported or used by Cloud Run.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ProbeResponse(dict):
    """
    Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: 'outputs.ExecActionResponse',
                 failure_threshold: int,
                 grpc: 'outputs.GRPCActionResponse',
                 http_get: 'outputs.HTTPGetActionResponse',
                 initial_delay_seconds: int,
                 period_seconds: int,
                 success_threshold: int,
                 tcp_socket: 'outputs.TCPSocketActionResponse',
                 timeout_seconds: int):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param 'ExecActionResponse' exec_: Not supported by Cloud Run.
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'GRPCActionResponse' grpc: GRPCAction specifies an action involving a GRPC port.
        :param 'HTTPGetActionResponse' http_get: HTTPGet specifies the http request to perform.
        :param int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeout_seconds.
        :param int success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 if set.
        :param 'TCPSocketActionResponse' tcp_socket: TCPSocket specifies an action involving a TCP port.
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than period_seconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpc", grpc)
        pulumi.set(__self__, "http_get", http_get)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "tcp_socket", tcp_socket)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.ExecActionResponse':
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> 'outputs.GRPCActionResponse':
        """
        GRPCAction specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> 'outputs.HTTPGetActionResponse':
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeout_seconds.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 if set.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> 'outputs.TCPSocketActionResponse':
        """
        TCPSocket specifies an action involving a TCP port.
        """
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than period_seconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ResourceRecordResponse(dict):
    """
    A DNS resource record.
    """
    def __init__(__self__, *,
                 name: str,
                 rrdata: str,
                 type: str):
        """
        A DNS resource record.
        :param str name: Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        :param str rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param str type: Resource record type. Example: `AAAA`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rrdata", rrdata)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rrdata(self) -> str:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource record type. Example: `AAAA`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    ResourceRequirements describes the compute resource requirements.
    """
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 requests: Mapping[str, str]):
        """
        ResourceRequirements describes the compute resource requirements.
        :param Mapping[str, str] limits: Only memory and CPU are supported. Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] requests: Only memory and CPU are supported. Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Only memory and CPU are supported. Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        Only memory and CPU are supported. Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class RevisionSpecResponse(dict):
    """
    RevisionSpec holds the desired state of the Revision (from the client).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerConcurrency":
            suggest = "container_concurrency"
        elif key == "enableServiceLinks":
            suggest = "enable_service_links"
        elif key == "imagePullSecrets":
            suggest = "image_pull_secrets"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RevisionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RevisionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RevisionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_concurrency: int,
                 containers: Sequence['outputs.ContainerResponse'],
                 enable_service_links: bool,
                 image_pull_secrets: Sequence['outputs.LocalObjectReferenceResponse'],
                 service_account_name: str,
                 timeout_seconds: int,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        :param int container_concurrency: ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. If not specified, defaults to 80.
        :param Sequence['ContainerResponse'] containers: Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided. The runtime contract is documented here: https://github.com/knative/specs/blob/main/specs/serving/runtime-contract.md
        :param bool enable_service_links: Not supported by Cloud Run.
        :param Sequence['LocalObjectReferenceResponse'] image_pull_secrets: Not supported by Cloud Run.
        :param str service_account_name: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param int timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Cloud Run: defaults to 300 seconds (5 minutes). Maximum allowed value is 3600 seconds (1 hour).
        """
        pulumi.set(__self__, "container_concurrency", container_concurrency)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "enable_service_links", enable_service_links)
        pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> int:
        """
        ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. If not specified, defaults to 80.
        """
        return pulumi.get(self, "container_concurrency")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided. The runtime contract is documented here: https://github.com/knative/specs/blob/main/specs/serving/runtime-contract.md
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="enableServiceLinks")
    def enable_service_links(self) -> bool:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "enable_service_links")

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Sequence['outputs.LocalObjectReferenceResponse']:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "image_pull_secrets")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Cloud Run: defaults to 300 seconds (5 minutes). Maximum allowed value is 3600 seconds (1 hour).
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        return pulumi.get(self, "volumes")


@pulumi.output_type
class RevisionTemplateResponse(dict):
    """
    RevisionTemplateSpec describes the data a revision should have when created from a template. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
    """
    def __init__(__self__, *,
                 metadata: 'outputs.ObjectMetaResponse',
                 spec: 'outputs.RevisionSpecResponse'):
        """
        RevisionTemplateSpec describes the data a revision should have when created from a template. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
        :param 'ObjectMetaResponse' metadata: Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. The following annotation keys set properties of the created revision: * `autoscaling.knative.dev/minScale` sets the minimum number of instances. * `autoscaling.knative.dev/maxScale` sets the maximum number of instances. * `run.googleapis.com/cloudsql-instances` sets Cloud SQL connections. Multiple values should be comma separated. * `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress. Supported values are `all-traffic`, `all` (deprecated), and `private-ranges-only`. `all-traffic` and `all` provide the same functionality. `all` is deprecated but will continue to be supported. Prefer `all-traffic`.
        :param 'RevisionSpecResponse' spec: RevisionSpec holds the desired state of the Revision (from the client).
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.ObjectMetaResponse':
        """
        Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. The following annotation keys set properties of the created revision: * `autoscaling.knative.dev/minScale` sets the minimum number of instances. * `autoscaling.knative.dev/maxScale` sets the maximum number of instances. * `run.googleapis.com/cloudsql-instances` sets Cloud SQL connections. Multiple values should be comma separated. * `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress. Supported values are `all-traffic`, `all` (deprecated), and `private-ranges-only`. `all-traffic` and `all` provide the same functionality. `all` is deprecated but will continue to be supported. Prefer `all-traffic`.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.RevisionSpecResponse':
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class SecretEnvSourceResponse(dict):
    """
    Not supported by Cloud Run. SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Not supported by Cloud Run. SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The Secret to select from.
        :param bool optional: Specify whether the Secret must be defined
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Secret to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretKeySelectorResponse(dict):
    """
    SecretKeySelector selects a key of a Secret.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        SecretKeySelector selects a key of a Secret.
        :param str key: A Cloud Secret Manager secret version. Must be 'latest' for the latest version or an integer for a specific version. The key of the secret to select from. Must be a valid secret key.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. The name of the secret in the pod's namespace to select from.
        :param bool optional: Specify whether the Secret or its key must be defined.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A Cloud Secret Manager secret version. Must be 'latest' for the latest version or an integer for a specific version. The key of the secret to select from. Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. The name of the secret in the pod's namespace to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret or its key must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretVolumeSourceResponse(dict):
    """
    A volume representing a secret stored in Google Secret Manager. The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret_name. The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 optional: bool,
                 secret_name: str):
        """
        A volume representing a secret stored in Google Secret Manager. The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secret_name. The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
        :param int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0444. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: A list of secret versions to mount in the volume. If no items are specified, the volume will expose a file with the same name as the secret name. The contents of the file will be the data in the latest version of the secret. If items are specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify both a key and a path.
        :param bool optional: Not supported by Cloud Run.
        :param str secret_name: The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. Name of the secret in the container's namespace to use.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 01 and 0777 (octal). If 0 or not set, it will default to 0444. Directories within the path are not affected by this setting. Notes * Internally, a umask of 0222 will be applied to any non-zero value. * This is an integer representation of the mode bits. So, the octal integer value should look exactly as the chmod numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        A list of secret versions to mount in the volume. If no items are specified, the volume will expose a file with the same name as the secret name. The contents of the file will be the data in the latest version of the secret. If items are specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify both a key and a path.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project. If the secret is in another project, you must define an alias. An alias definition has the form: :projects//secrets/. If multiple alias definitions are needed, they must be separated by commas. The alias definitions must be set on the run.googleapis.com/secrets annotation. Name of the secret in the container's namespace to use.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class SecurityContextResponse(dict):
    """
    Not supported by Cloud Run. SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_as_user: int):
        """
        Not supported by Cloud Run. SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
        :param int run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
        """
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class ServiceSpecResponse(dict):
    """
    ServiceSpec holds the desired state of the Route (from the client), which is used to manipulate the underlying Route and Configuration(s).
    """
    def __init__(__self__, *,
                 template: 'outputs.RevisionTemplateResponse',
                 traffic: Sequence['outputs.TrafficTargetResponse']):
        """
        ServiceSpec holds the desired state of the Route (from the client), which is used to manipulate the underlying Route and Configuration(s).
        :param 'RevisionTemplateResponse' template: Holds the latest specification for the Revision to be stamped out.
        :param Sequence['TrafficTargetResponse'] traffic: Specifies how to distribute traffic over a collection of Knative Revisions and Configurations to the Service's main URL.
        """
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter
    def template(self) -> 'outputs.RevisionTemplateResponse':
        """
        Holds the latest specification for the Revision to be stamped out.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def traffic(self) -> Sequence['outputs.TrafficTargetResponse']:
        """
        Specifies how to distribute traffic over a collection of Knative Revisions and Configurations to the Service's main URL.
        """
        return pulumi.get(self, "traffic")


@pulumi.output_type
class ServiceStatusResponse(dict):
    """
    The current state of the Service. Output only.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestCreatedRevisionName":
            suggest = "latest_created_revision_name"
        elif key == "latestReadyRevisionName":
            suggest = "latest_ready_revision_name"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: 'outputs.AddressableResponse',
                 conditions: Sequence['outputs.GoogleCloudRunV1ConditionResponse'],
                 latest_created_revision_name: str,
                 latest_ready_revision_name: str,
                 observed_generation: int,
                 traffic: Sequence['outputs.TrafficTargetResponse'],
                 url: str):
        """
        The current state of the Service. Output only.
        :param 'AddressableResponse' address: Similar to url, information on where the service is available on HTTP.
        :param Sequence['GoogleCloudRunV1ConditionResponse'] conditions: Conditions communicate information about ongoing/complete reconciliation processes that bring the `spec` inline with the observed state of the world. Service-specific conditions include: * `ConfigurationsReady`: `True` when the underlying Configuration is ready. * `RoutesReady`: `True` when the underlying Route is ready. * `Ready`: `True` when all underlying resources are ready.
        :param str latest_created_revision_name: Name of the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        :param str latest_ready_revision_name: Name of the latest Revision from this Service's Configuration that has had its `Ready` condition become `True`.
        :param int observed_generation: Returns the generation last fully processed by the system. This will only match metadata.generation when reconciliation is complete. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param Sequence['TrafficTargetResponse'] traffic: Holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        :param str url: URL that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "traffic", traffic)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def address(self) -> 'outputs.AddressableResponse':
        """
        Similar to url, information on where the service is available on HTTP.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GoogleCloudRunV1ConditionResponse']:
        """
        Conditions communicate information about ongoing/complete reconciliation processes that bring the `spec` inline with the observed state of the world. Service-specific conditions include: * `ConfigurationsReady`: `True` when the underlying Configuration is ready. * `RoutesReady`: `True` when the underlying Route is ready. * `Ready`: `True` when all underlying resources are ready.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> str:
        """
        Name of the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        """
        return pulumi.get(self, "latest_created_revision_name")

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> str:
        """
        Name of the latest Revision from this Service's Configuration that has had its `Ready` condition become `True`.
        """
        return pulumi.get(self, "latest_ready_revision_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        Returns the generation last fully processed by the system. This will only match metadata.generation when reconciliation is complete. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def traffic(self) -> Sequence['outputs.TrafficTargetResponse']:
        """
        Holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        """
        return pulumi.get(self, "traffic")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class TCPSocketActionResponse(dict):
    """
    TCPSocketAction describes an action based on opening a socket
    """
    def __init__(__self__, *,
                 host: str,
                 port: int):
        """
        TCPSocketAction describes an action based on opening a socket
        :param str host: Not supported by Cloud Run.
        :param int port: Port number to access on the container. Number must be in the range 1 to 65535.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Not supported by Cloud Run.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class TaskSpecResponse(dict):
    """
    TaskSpec is a description of a task.
    """
    def __init__(__self__, *,
                 containers: Sequence['outputs.ContainerResponse'],
                 max_retries: int,
                 service_account_name: str,
                 timeout_seconds: str,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        TaskSpec is a description of a task.
        :param Sequence['ContainerResponse'] containers: Optional. List of containers belonging to the task. We disallow a number of fields on this Container. Only a single container may be provided.
        :param int max_retries: Optional. Number of retries allowed per task, before marking this job failed.
        :param str service_account_name: Optional. Email address of the IAM service account associated with the task of a job execution. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param str timeout_seconds: Optional. Duration in seconds the task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        :param Sequence['VolumeResponse'] volumes: Optional. List of volumes that can be mounted by containers belonging to the task. More info: https://kubernetes.io/docs/concepts/storage/volumes
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Optional. List of containers belonging to the task. We disallow a number of fields on this Container. Only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> int:
        """
        Optional. Number of retries allowed per task, before marking this job failed.
        """
        return pulumi.get(self, "max_retries")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Optional. Email address of the IAM service account associated with the task of a job execution. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> str:
        """
        Optional. Duration in seconds the task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Optional. List of volumes that can be mounted by containers belonging to the task. More info: https://kubernetes.io/docs/concepts/storage/volumes
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class TaskTemplateSpecResponse(dict):
    """
    TaskTemplateSpec describes the data a task should have when created from a template.
    """
    def __init__(__self__, *,
                 spec: 'outputs.TaskSpecResponse'):
        """
        TaskTemplateSpec describes the data a task should have when created from a template.
        :param 'TaskSpecResponse' spec: Optional. Specification of the desired behavior of the task. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.TaskSpecResponse':
        """
        Optional. Specification of the desired behavior of the task. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class TrafficTargetResponse(dict):
    """
    TrafficTarget holds a single entry of the routing table for a Route.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationName":
            suggest = "configuration_name"
        elif key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_name: str,
                 latest_revision: bool,
                 percent: int,
                 revision_name: str,
                 tag: str,
                 url: str):
        """
        TrafficTarget holds a single entry of the routing table for a Route.
        :param str configuration_name: ConfigurationName of a configuration to whose latest revision which will be sent this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, traffic will automatically migrate from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        :param bool latest_revision: Optional. LatestRevision may be provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty in spec. When shown in status, this indicates that the RevisionName was resolved from a spec's ConfigurationName.
        :param int percent: Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified.
        :param str revision_name: RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName.
        :param str tag: Optional. Tag is used to expose a dedicated url for referencing this target exclusively.
        :param str url: URL displays the URL for accessing tagged traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. https://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        pulumi.set(__self__, "configuration_name", configuration_name)
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision_name", revision_name)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> str:
        """
        ConfigurationName of a configuration to whose latest revision which will be sent this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, traffic will automatically migrate from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        """
        return pulumi.get(self, "configuration_name")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> bool:
        """
        Optional. LatestRevision may be provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty in spec. When shown in status, this indicates that the RevisionName was resolved from a spec's ConfigurationName.
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> str:
        """
        RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName.
        """
        return pulumi.get(self, "revision_name")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Optional. Tag is used to expose a dedicated url for referencing this target exclusively.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL displays the URL for accessing tagged traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. https://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc.)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class VolumeMountResponse(dict):
    """
    VolumeMount describes a mounting of a Volume within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: bool,
                 sub_path: str):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param str name: The name of the volume. There must be a corresponding Volume with the same name.
        :param bool read_only: Only true is accepted for Secret Volumes. Defaults to true for Secrets Volumes.
        :param str sub_path: Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the volume. There must be a corresponding Volume with the same name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        Only true is accepted for Secret Volumes. Defaults to true for Secrets Volumes.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> str:
        """
        Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume represents a named volume in a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map: 'outputs.ConfigMapVolumeSourceResponse',
                 name: str,
                 secret: 'outputs.SecretVolumeSourceResponse'):
        """
        Volume represents a named volume in a container.
        :param 'ConfigMapVolumeSourceResponse' config_map: Not supported in Cloud Run.
        :param str name: Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is reserved.
        :param 'SecretVolumeSourceResponse' secret: The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secretName.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> 'outputs.ConfigMapVolumeSourceResponse':
        """
        Not supported in Cloud Run.
        """
        return pulumi.get(self, "config_map")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is reserved.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> 'outputs.SecretVolumeSourceResponse':
        """
        The secret's value will be presented as the content of a file whose name is defined in the item path. If no items are defined, the name of the file is the secretName.
        """
        return pulumi.get(self, "secret")


