# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TemplatesVersionArgs', 'TemplatesVersion']

@pulumi.input_type
class TemplatesVersionArgs:
    def __init__(__self__, *,
                 integrationtemplate_id: pulumi.Input[str],
                 product_id: pulumi.Input[str],
                 database_persistence_policy: Optional[pulumi.Input['TemplatesVersionDatabasePersistencePolicy']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 parent_integration_version_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 task_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]] = None,
                 teardown: Optional[pulumi.Input['EnterpriseCrmEventbusProtoTeardownArgs']] = None,
                 template_parameters: Optional[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']] = None,
                 trigger_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]] = None,
                 user_label: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TemplatesVersion resource.
        :param pulumi.Input['TemplatesVersionDatabasePersistencePolicy'] database_persistence_policy: Optional. Flag to disable database persistence for execution data, including event execution info, execution export info, execution metadata index and execution param index.
        :param pulumi.Input[str] description: Optional. The templateversion description. Permitted format is alphanumeric with underscores and no spaces.
        :param pulumi.Input[str] last_modifier_email: Optional. The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[str] parent_integration_version_id: Optional. ID of the IntegrationVersion that was used to create this IntegrationTemplateVersion
        :param pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]] task_configs: Optional. Task configuration for the IntegrationTemplateVersion. It's optional, but the IntegrationTemplateVersion doesn't do anything without task_configs.
        :param pulumi.Input['EnterpriseCrmEventbusProtoTeardownArgs'] teardown: Optional. Contains a graph of tasks that will be executed before putting the event in a terminal state (SUCCEEDED/FAILED/FATAL), regardless of success or failure, similar to "finally" in code.
        :param pulumi.Input['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs'] template_parameters: Optional. Parameters that are expected to be passed to the IntegrationTemplateVersion when an event is triggered. This consists of all the parameters that are expected in the IntegrationTemplateVersion execution. This gives the user the ability to provide default values, add information like PII and also provide data types of each parameter.
        :param pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]] trigger_configs: Optional. Trigger configurations.
        :param pulumi.Input[str] user_label: Optional. A user-defined label that annotates an integration version. Typically, this is only set when the integration version is created.
        """
        pulumi.set(__self__, "integrationtemplate_id", integrationtemplate_id)
        pulumi.set(__self__, "product_id", product_id)
        if database_persistence_policy is not None:
            pulumi.set(__self__, "database_persistence_policy", database_persistence_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_modifier_email is not None:
            pulumi.set(__self__, "last_modifier_email", last_modifier_email)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if parent_integration_version_id is not None:
            pulumi.set(__self__, "parent_integration_version_id", parent_integration_version_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if task_configs is not None:
            pulumi.set(__self__, "task_configs", task_configs)
        if teardown is not None:
            pulumi.set(__self__, "teardown", teardown)
        if template_parameters is not None:
            pulumi.set(__self__, "template_parameters", template_parameters)
        if trigger_configs is not None:
            pulumi.set(__self__, "trigger_configs", trigger_configs)
        if user_label is not None:
            pulumi.set(__self__, "user_label", user_label)

    @property
    @pulumi.getter(name="integrationtemplateId")
    def integrationtemplate_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "integrationtemplate_id")

    @integrationtemplate_id.setter
    def integrationtemplate_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "integrationtemplate_id", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="databasePersistencePolicy")
    def database_persistence_policy(self) -> Optional[pulumi.Input['TemplatesVersionDatabasePersistencePolicy']]:
        """
        Optional. Flag to disable database persistence for execution data, including event execution info, execution export info, execution metadata index and execution param index.
        """
        return pulumi.get(self, "database_persistence_policy")

    @database_persistence_policy.setter
    def database_persistence_policy(self, value: Optional[pulumi.Input['TemplatesVersionDatabasePersistencePolicy']]):
        pulumi.set(self, "database_persistence_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The templateversion description. Permitted format is alphanumeric with underscores and no spaces.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @last_modifier_email.setter
    def last_modifier_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modifier_email", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="parentIntegrationVersionId")
    def parent_integration_version_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. ID of the IntegrationVersion that was used to create this IntegrationTemplateVersion
        """
        return pulumi.get(self, "parent_integration_version_id")

    @parent_integration_version_id.setter
    def parent_integration_version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_integration_version_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="taskConfigs")
    def task_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]]:
        """
        Optional. Task configuration for the IntegrationTemplateVersion. It's optional, but the IntegrationTemplateVersion doesn't do anything without task_configs.
        """
        return pulumi.get(self, "task_configs")

    @task_configs.setter
    def task_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]]):
        pulumi.set(self, "task_configs", value)

    @property
    @pulumi.getter
    def teardown(self) -> Optional[pulumi.Input['EnterpriseCrmEventbusProtoTeardownArgs']]:
        """
        Optional. Contains a graph of tasks that will be executed before putting the event in a terminal state (SUCCEEDED/FAILED/FATAL), regardless of success or failure, similar to "finally" in code.
        """
        return pulumi.get(self, "teardown")

    @teardown.setter
    def teardown(self, value: Optional[pulumi.Input['EnterpriseCrmEventbusProtoTeardownArgs']]):
        pulumi.set(self, "teardown", value)

    @property
    @pulumi.getter(name="templateParameters")
    def template_parameters(self) -> Optional[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']]:
        """
        Optional. Parameters that are expected to be passed to the IntegrationTemplateVersion when an event is triggered. This consists of all the parameters that are expected in the IntegrationTemplateVersion execution. This gives the user the ability to provide default values, add information like PII and also provide data types of each parameter.
        """
        return pulumi.get(self, "template_parameters")

    @template_parameters.setter
    def template_parameters(self, value: Optional[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']]):
        pulumi.set(self, "template_parameters", value)

    @property
    @pulumi.getter(name="triggerConfigs")
    def trigger_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]]:
        """
        Optional. Trigger configurations.
        """
        return pulumi.get(self, "trigger_configs")

    @trigger_configs.setter
    def trigger_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]]):
        pulumi.set(self, "trigger_configs", value)

    @property
    @pulumi.getter(name="userLabel")
    def user_label(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A user-defined label that annotates an integration version. Typically, this is only set when the integration version is created.
        """
        return pulumi.get(self, "user_label")

    @user_label.setter
    def user_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_label", value)


class TemplatesVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_persistence_policy: Optional[pulumi.Input['TemplatesVersionDatabasePersistencePolicy']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 integrationtemplate_id: Optional[pulumi.Input[str]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 parent_integration_version_id: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 task_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]]] = None,
                 teardown: Optional[pulumi.Input[pulumi.InputType['EnterpriseCrmEventbusProtoTeardownArgs']]] = None,
                 template_parameters: Optional[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']]] = None,
                 trigger_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]]] = None,
                 user_label: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an IntegrationTemplateVersion.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['TemplatesVersionDatabasePersistencePolicy'] database_persistence_policy: Optional. Flag to disable database persistence for execution data, including event execution info, execution export info, execution metadata index and execution param index.
        :param pulumi.Input[str] description: Optional. The templateversion description. Permitted format is alphanumeric with underscores and no spaces.
        :param pulumi.Input[str] last_modifier_email: Optional. The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        :param pulumi.Input[str] parent_integration_version_id: Optional. ID of the IntegrationVersion that was used to create this IntegrationTemplateVersion
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]] task_configs: Optional. Task configuration for the IntegrationTemplateVersion. It's optional, but the IntegrationTemplateVersion doesn't do anything without task_configs.
        :param pulumi.Input[pulumi.InputType['EnterpriseCrmEventbusProtoTeardownArgs']] teardown: Optional. Contains a graph of tasks that will be executed before putting the event in a terminal state (SUCCEEDED/FAILED/FATAL), regardless of success or failure, similar to "finally" in code.
        :param pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']] template_parameters: Optional. Parameters that are expected to be passed to the IntegrationTemplateVersion when an event is triggered. This consists of all the parameters that are expected in the IntegrationTemplateVersion execution. This gives the user the ability to provide default values, add information like PII and also provide data types of each parameter.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]] trigger_configs: Optional. Trigger configurations.
        :param pulumi.Input[str] user_label: Optional. A user-defined label that annotates an integration version. Typically, this is only set when the integration version is created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplatesVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an IntegrationTemplateVersion.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param TemplatesVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplatesVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_persistence_policy: Optional[pulumi.Input['TemplatesVersionDatabasePersistencePolicy']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 integrationtemplate_id: Optional[pulumi.Input[str]] = None,
                 last_modifier_email: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 parent_integration_version_id: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 task_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTaskConfigArgs']]]]] = None,
                 teardown: Optional[pulumi.Input[pulumi.InputType['EnterpriseCrmEventbusProtoTeardownArgs']]] = None,
                 template_parameters: Optional[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoWorkflowParametersArgs']]] = None,
                 trigger_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnterpriseCrmFrontendsEventbusProtoTriggerConfigArgs']]]]] = None,
                 user_label: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplatesVersionArgs.__new__(TemplatesVersionArgs)

            __props__.__dict__["database_persistence_policy"] = database_persistence_policy
            __props__.__dict__["description"] = description
            if integrationtemplate_id is None and not opts.urn:
                raise TypeError("Missing required property 'integrationtemplate_id'")
            __props__.__dict__["integrationtemplate_id"] = integrationtemplate_id
            __props__.__dict__["last_modifier_email"] = last_modifier_email
            __props__.__dict__["location"] = location
            __props__.__dict__["parent_integration_version_id"] = parent_integration_version_id
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["project"] = project
            __props__.__dict__["task_configs"] = task_configs
            __props__.__dict__["teardown"] = teardown
            __props__.__dict__["template_parameters"] = template_parameters
            __props__.__dict__["trigger_configs"] = trigger_configs
            __props__.__dict__["user_label"] = user_label
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["snapshot_number"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["integrationtemplate_id", "location", "product_id", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TemplatesVersion, __self__).__init__(
            'google-native:integrations/v1alpha:TemplatesVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TemplatesVersion':
        """
        Get an existing TemplatesVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TemplatesVersionArgs.__new__(TemplatesVersionArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["database_persistence_policy"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["integrationtemplate_id"] = None
        __props__.__dict__["last_modifier_email"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["parent_integration_version_id"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["snapshot_number"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["task_configs"] = None
        __props__.__dict__["teardown"] = None
        __props__.__dict__["template_parameters"] = None
        __props__.__dict__["trigger_configs"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["user_label"] = None
        return TemplatesVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Auto-generated.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="databasePersistencePolicy")
    def database_persistence_policy(self) -> pulumi.Output[str]:
        """
        Optional. Flag to disable database persistence for execution data, including event execution info, execution export info, execution metadata index and execution param index.
        """
        return pulumi.get(self, "database_persistence_policy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. The templateversion description. Permitted format is alphanumeric with underscores and no spaces.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="integrationtemplateId")
    def integrationtemplate_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "integrationtemplate_id")

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> pulumi.Output[str]:
        """
        Optional. The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Auto-generated primary key. Format: projects/{project}/locations/{location}/products/{product}/integrationtemplates/{integrationtemplate}/versions/{version}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentIntegrationVersionId")
    def parent_integration_version_id(self) -> pulumi.Output[str]:
        """
        Optional. ID of the IntegrationVersion that was used to create this IntegrationTemplateVersion
        """
        return pulumi.get(self, "parent_integration_version_id")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="snapshotNumber")
    def snapshot_number(self) -> pulumi.Output[str]:
        """
        An increasing sequence that is set when a new snapshot is created.
        """
        return pulumi.get(self, "snapshot_number")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Optional. Generated by eventbus. User should not set it as an input.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskConfigs")
    def task_configs(self) -> pulumi.Output[Sequence['outputs.EnterpriseCrmFrontendsEventbusProtoTaskConfigResponse']]:
        """
        Optional. Task configuration for the IntegrationTemplateVersion. It's optional, but the IntegrationTemplateVersion doesn't do anything without task_configs.
        """
        return pulumi.get(self, "task_configs")

    @property
    @pulumi.getter
    def teardown(self) -> pulumi.Output['outputs.EnterpriseCrmEventbusProtoTeardownResponse']:
        """
        Optional. Contains a graph of tasks that will be executed before putting the event in a terminal state (SUCCEEDED/FAILED/FATAL), regardless of success or failure, similar to "finally" in code.
        """
        return pulumi.get(self, "teardown")

    @property
    @pulumi.getter(name="templateParameters")
    def template_parameters(self) -> pulumi.Output['outputs.EnterpriseCrmFrontendsEventbusProtoWorkflowParametersResponse']:
        """
        Optional. Parameters that are expected to be passed to the IntegrationTemplateVersion when an event is triggered. This consists of all the parameters that are expected in the IntegrationTemplateVersion execution. This gives the user the ability to provide default values, add information like PII and also provide data types of each parameter.
        """
        return pulumi.get(self, "template_parameters")

    @property
    @pulumi.getter(name="triggerConfigs")
    def trigger_configs(self) -> pulumi.Output[Sequence['outputs.EnterpriseCrmFrontendsEventbusProtoTriggerConfigResponse']]:
        """
        Optional. Trigger configurations.
        """
        return pulumi.get(self, "trigger_configs")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Auto-generated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userLabel")
    def user_label(self) -> pulumi.Output[str]:
        """
        Optional. A user-defined label that annotates an integration version. Typically, this is only set when the integration version is created.
        """
        return pulumi.get(self, "user_label")

