# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['SfdcInstanceArgs', 'SfdcInstance']

@pulumi.input_type
class SfdcInstanceArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 auth_config_id: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_authority: Optional[pulumi.Input[str]] = None,
                 sfdc_org_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SfdcInstance resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auth_config_id: A list of AuthConfigs that can be tried to open the channel to SFDC
        :param pulumi.Input[str] description: A description of the sfdc instance.
        :param pulumi.Input[str] display_name: User selected unique name/alias to easily reference an instance.
        :param pulumi.Input[str] name: Resource name of the SFDC instance projects/{project}/locations/{location}/sfdcInstances/{sfdcInstance}.
        :param pulumi.Input[str] service_authority: URL used for API calls after authentication (the login authority is configured within the referenced AuthConfig).
        :param pulumi.Input[str] sfdc_org_id: The SFDC Org Id. This is defined in salesforce.
        """
        pulumi.set(__self__, "product_id", product_id)
        if auth_config_id is not None:
            pulumi.set(__self__, "auth_config_id", auth_config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_authority is not None:
            pulumi.set(__self__, "service_authority", service_authority)
        if sfdc_org_id is not None:
            pulumi.set(__self__, "sfdc_org_id", sfdc_org_id)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="authConfigId")
    def auth_config_id(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of AuthConfigs that can be tried to open the channel to SFDC
        """
        return pulumi.get(self, "auth_config_id")

    @auth_config_id.setter
    def auth_config_id(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auth_config_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the sfdc instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User selected unique name/alias to easily reference an instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of the SFDC instance projects/{project}/locations/{location}/sfdcInstances/{sfdcInstance}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceAuthority")
    def service_authority(self) -> Optional[pulumi.Input[str]]:
        """
        URL used for API calls after authentication (the login authority is configured within the referenced AuthConfig).
        """
        return pulumi.get(self, "service_authority")

    @service_authority.setter
    def service_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_authority", value)

    @property
    @pulumi.getter(name="sfdcOrgId")
    def sfdc_org_id(self) -> Optional[pulumi.Input[str]]:
        """
        The SFDC Org Id. This is defined in salesforce.
        """
        return pulumi.get(self, "sfdc_org_id")

    @sfdc_org_id.setter
    def sfdc_org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sfdc_org_id", value)


class SfdcInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config_id: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_authority: Optional[pulumi.Input[str]] = None,
                 sfdc_org_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an sfdc instance record. Store the sfdc instance in Spanner. Returns the sfdc instance.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auth_config_id: A list of AuthConfigs that can be tried to open the channel to SFDC
        :param pulumi.Input[str] description: A description of the sfdc instance.
        :param pulumi.Input[str] display_name: User selected unique name/alias to easily reference an instance.
        :param pulumi.Input[str] name: Resource name of the SFDC instance projects/{project}/locations/{location}/sfdcInstances/{sfdcInstance}.
        :param pulumi.Input[str] service_authority: URL used for API calls after authentication (the login authority is configured within the referenced AuthConfig).
        :param pulumi.Input[str] sfdc_org_id: The SFDC Org Id. This is defined in salesforce.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SfdcInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an sfdc instance record. Store the sfdc instance in Spanner. Returns the sfdc instance.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param SfdcInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SfdcInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config_id: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_authority: Optional[pulumi.Input[str]] = None,
                 sfdc_org_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SfdcInstanceArgs.__new__(SfdcInstanceArgs)

            __props__.__dict__["auth_config_id"] = auth_config_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["project"] = project
            __props__.__dict__["service_authority"] = service_authority
            __props__.__dict__["sfdc_org_id"] = sfdc_org_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "product_id", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SfdcInstance, __self__).__init__(
            'google-native:integrations/v1alpha:SfdcInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SfdcInstance':
        """
        Get an existing SfdcInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SfdcInstanceArgs.__new__(SfdcInstanceArgs)

        __props__.__dict__["auth_config_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["delete_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["service_authority"] = None
        __props__.__dict__["sfdc_org_id"] = None
        __props__.__dict__["update_time"] = None
        return SfdcInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authConfigId")
    def auth_config_id(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of AuthConfigs that can be tried to open the channel to SFDC
        """
        return pulumi.get(self, "auth_config_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the instance is created
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Time when the instance was deleted. Empty if not deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description of the sfdc instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        User selected unique name/alias to easily reference an instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of the SFDC instance projects/{project}/locations/{location}/sfdcInstances/{sfdcInstance}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceAuthority")
    def service_authority(self) -> pulumi.Output[str]:
        """
        URL used for API calls after authentication (the login authority is configured within the referenced AuthConfig).
        """
        return pulumi.get(self, "service_authority")

    @property
    @pulumi.getter(name="sfdcOrgId")
    def sfdc_org_id(self) -> pulumi.Output[str]:
        """
        The SFDC Org Id. This is defined in salesforce.
        """
        return pulumi.get(self, "sfdc_org_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the instance was last updated
        """
        return pulumi.get(self, "update_time")

