# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['SfdcChannelArgs', 'SfdcChannel']

@pulumi.input_type
class SfdcChannelArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[str],
                 sfdc_instance_id: pulumi.Input[str],
                 channel_topic: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_replay_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SfdcChannel resource.
        :param pulumi.Input[str] channel_topic: The Channel topic defined by salesforce once an channel is opened
        :param pulumi.Input[str] description: The description for this channel
        :param pulumi.Input[str] display_name: Client level unique name/alias to easily reference a channel.
        :param pulumi.Input[bool] is_active: Indicated if a channel has any active integrations referencing it. Set to false when the channel is created, and set to true if there is any integration published with the channel configured in it.
        :param pulumi.Input[str] last_replay_id: Last sfdc messsage replay id for channel
        :param pulumi.Input[str] name: Resource name of the SFDC channel projects/{project}/locations/{location}/sfdcInstances/{sfdc_instance}/sfdcChannels/{sfdc_channel}.
        """
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "sfdc_instance_id", sfdc_instance_id)
        if channel_topic is not None:
            pulumi.set(__self__, "channel_topic", channel_topic)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_active is not None:
            pulumi.set(__self__, "is_active", is_active)
        if last_replay_id is not None:
            pulumi.set(__self__, "last_replay_id", last_replay_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="sfdcInstanceId")
    def sfdc_instance_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "sfdc_instance_id")

    @sfdc_instance_id.setter
    def sfdc_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sfdc_instance_id", value)

    @property
    @pulumi.getter(name="channelTopic")
    def channel_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The Channel topic defined by salesforce once an channel is opened
        """
        return pulumi.get(self, "channel_topic")

    @channel_topic.setter
    def channel_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_topic", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for this channel
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Client level unique name/alias to easily reference a channel.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicated if a channel has any active integrations referencing it. Set to false when the channel is created, and set to true if there is any integration published with the channel configured in it.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="lastReplayId")
    def last_replay_id(self) -> Optional[pulumi.Input[str]]:
        """
        Last sfdc messsage replay id for channel
        """
        return pulumi.get(self, "last_replay_id")

    @last_replay_id.setter
    def last_replay_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_replay_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of the SFDC channel projects/{project}/locations/{location}/sfdcInstances/{sfdc_instance}/sfdcChannels/{sfdc_channel}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class SfdcChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_topic: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_replay_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sfdc_instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an sfdc channel record. Store the sfdc channel in Spanner. Returns the sfdc channel.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] channel_topic: The Channel topic defined by salesforce once an channel is opened
        :param pulumi.Input[str] description: The description for this channel
        :param pulumi.Input[str] display_name: Client level unique name/alias to easily reference a channel.
        :param pulumi.Input[bool] is_active: Indicated if a channel has any active integrations referencing it. Set to false when the channel is created, and set to true if there is any integration published with the channel configured in it.
        :param pulumi.Input[str] last_replay_id: Last sfdc messsage replay id for channel
        :param pulumi.Input[str] name: Resource name of the SFDC channel projects/{project}/locations/{location}/sfdcInstances/{sfdc_instance}/sfdcChannels/{sfdc_channel}.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SfdcChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an sfdc channel record. Store the sfdc channel in Spanner. Returns the sfdc channel.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param SfdcChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SfdcChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_topic: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_replay_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 sfdc_instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SfdcChannelArgs.__new__(SfdcChannelArgs)

            __props__.__dict__["channel_topic"] = channel_topic
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_active"] = is_active
            __props__.__dict__["last_replay_id"] = last_replay_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["project"] = project
            if sfdc_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'sfdc_instance_id'")
            __props__.__dict__["sfdc_instance_id"] = sfdc_instance_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "product_id", "project", "sfdc_instance_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SfdcChannel, __self__).__init__(
            'google-native:integrations/v1alpha:SfdcChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SfdcChannel':
        """
        Get an existing SfdcChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SfdcChannelArgs.__new__(SfdcChannelArgs)

        __props__.__dict__["channel_topic"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["delete_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["is_active"] = None
        __props__.__dict__["last_replay_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["product_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["sfdc_instance_id"] = None
        __props__.__dict__["update_time"] = None
        return SfdcChannel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelTopic")
    def channel_topic(self) -> pulumi.Output[str]:
        """
        The Channel topic defined by salesforce once an channel is opened
        """
        return pulumi.get(self, "channel_topic")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the channel is created
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Time when the channel was deleted. Empty if not deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description for this channel
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Client level unique name/alias to easily reference a channel.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[bool]:
        """
        Indicated if a channel has any active integrations referencing it. Set to false when the channel is created, and set to true if there is any integration published with the channel configured in it.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="lastReplayId")
    def last_replay_id(self) -> pulumi.Output[str]:
        """
        Last sfdc messsage replay id for channel
        """
        return pulumi.get(self, "last_replay_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of the SFDC channel projects/{project}/locations/{location}/sfdcInstances/{sfdc_instance}/sfdcChannels/{sfdc_channel}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sfdcInstanceId")
    def sfdc_instance_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "sfdc_instance_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the channel was last updated
        """
        return pulumi.get(self, "update_time")

