# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetTemplatesVersionResult',
    'AwaitableGetTemplatesVersionResult',
    'get_templates_version',
    'get_templates_version_output',
]

@pulumi.output_type
class GetTemplatesVersionResult:
    def __init__(__self__, create_time=None, database_persistence_policy=None, description=None, last_modifier_email=None, name=None, parent_integration_version_id=None, snapshot_number=None, status=None, task_configs=None, teardown=None, template_parameters=None, trigger_configs=None, update_time=None, user_label=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if database_persistence_policy and not isinstance(database_persistence_policy, str):
            raise TypeError("Expected argument 'database_persistence_policy' to be a str")
        pulumi.set(__self__, "database_persistence_policy", database_persistence_policy)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if last_modifier_email and not isinstance(last_modifier_email, str):
            raise TypeError("Expected argument 'last_modifier_email' to be a str")
        pulumi.set(__self__, "last_modifier_email", last_modifier_email)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_integration_version_id and not isinstance(parent_integration_version_id, str):
            raise TypeError("Expected argument 'parent_integration_version_id' to be a str")
        pulumi.set(__self__, "parent_integration_version_id", parent_integration_version_id)
        if snapshot_number and not isinstance(snapshot_number, str):
            raise TypeError("Expected argument 'snapshot_number' to be a str")
        pulumi.set(__self__, "snapshot_number", snapshot_number)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if task_configs and not isinstance(task_configs, list):
            raise TypeError("Expected argument 'task_configs' to be a list")
        pulumi.set(__self__, "task_configs", task_configs)
        if teardown and not isinstance(teardown, dict):
            raise TypeError("Expected argument 'teardown' to be a dict")
        pulumi.set(__self__, "teardown", teardown)
        if template_parameters and not isinstance(template_parameters, dict):
            raise TypeError("Expected argument 'template_parameters' to be a dict")
        pulumi.set(__self__, "template_parameters", template_parameters)
        if trigger_configs and not isinstance(trigger_configs, list):
            raise TypeError("Expected argument 'trigger_configs' to be a list")
        pulumi.set(__self__, "trigger_configs", trigger_configs)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if user_label and not isinstance(user_label, str):
            raise TypeError("Expected argument 'user_label' to be a str")
        pulumi.set(__self__, "user_label", user_label)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Auto-generated.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="databasePersistencePolicy")
    def database_persistence_policy(self) -> str:
        """
        Optional. Flag to disable database persistence for execution data, including event execution info, execution export info, execution metadata index and execution param index.
        """
        return pulumi.get(self, "database_persistence_policy")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. The templateversion description. Permitted format is alphanumeric with underscores and no spaces.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModifierEmail")
    def last_modifier_email(self) -> str:
        """
        Optional. The last modifier's email address. Generated based on the End User Credentials/LOAS role of the user making the call.
        """
        return pulumi.get(self, "last_modifier_email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Auto-generated primary key. Format: projects/{project}/locations/{location}/products/{product}/integrationtemplates/{integrationtemplate}/versions/{version}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentIntegrationVersionId")
    def parent_integration_version_id(self) -> str:
        """
        Optional. ID of the IntegrationVersion that was used to create this IntegrationTemplateVersion
        """
        return pulumi.get(self, "parent_integration_version_id")

    @property
    @pulumi.getter(name="snapshotNumber")
    def snapshot_number(self) -> str:
        """
        An increasing sequence that is set when a new snapshot is created.
        """
        return pulumi.get(self, "snapshot_number")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Optional. Generated by eventbus. User should not set it as an input.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskConfigs")
    def task_configs(self) -> Sequence['outputs.EnterpriseCrmFrontendsEventbusProtoTaskConfigResponse']:
        """
        Optional. Task configuration for the IntegrationTemplateVersion. It's optional, but the IntegrationTemplateVersion doesn't do anything without task_configs.
        """
        return pulumi.get(self, "task_configs")

    @property
    @pulumi.getter
    def teardown(self) -> 'outputs.EnterpriseCrmEventbusProtoTeardownResponse':
        """
        Optional. Contains a graph of tasks that will be executed before putting the event in a terminal state (SUCCEEDED/FAILED/FATAL), regardless of success or failure, similar to "finally" in code.
        """
        return pulumi.get(self, "teardown")

    @property
    @pulumi.getter(name="templateParameters")
    def template_parameters(self) -> 'outputs.EnterpriseCrmFrontendsEventbusProtoWorkflowParametersResponse':
        """
        Optional. Parameters that are expected to be passed to the IntegrationTemplateVersion when an event is triggered. This consists of all the parameters that are expected in the IntegrationTemplateVersion execution. This gives the user the ability to provide default values, add information like PII and also provide data types of each parameter.
        """
        return pulumi.get(self, "template_parameters")

    @property
    @pulumi.getter(name="triggerConfigs")
    def trigger_configs(self) -> Sequence['outputs.EnterpriseCrmFrontendsEventbusProtoTriggerConfigResponse']:
        """
        Optional. Trigger configurations.
        """
        return pulumi.get(self, "trigger_configs")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Auto-generated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userLabel")
    def user_label(self) -> str:
        """
        Optional. A user-defined label that annotates an integration version. Typically, this is only set when the integration version is created.
        """
        return pulumi.get(self, "user_label")


class AwaitableGetTemplatesVersionResult(GetTemplatesVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTemplatesVersionResult(
            create_time=self.create_time,
            database_persistence_policy=self.database_persistence_policy,
            description=self.description,
            last_modifier_email=self.last_modifier_email,
            name=self.name,
            parent_integration_version_id=self.parent_integration_version_id,
            snapshot_number=self.snapshot_number,
            status=self.status,
            task_configs=self.task_configs,
            teardown=self.teardown,
            template_parameters=self.template_parameters,
            trigger_configs=self.trigger_configs,
            update_time=self.update_time,
            user_label=self.user_label)


def get_templates_version(integrationtemplate_id: Optional[str] = None,
                          location: Optional[str] = None,
                          product_id: Optional[str] = None,
                          project: Optional[str] = None,
                          version_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTemplatesVersionResult:
    """
    Returns an IntegrationTemplateVersion in the specified project.
    """
    __args__ = dict()
    __args__['integrationtemplateId'] = integrationtemplate_id
    __args__['location'] = location
    __args__['productId'] = product_id
    __args__['project'] = project
    __args__['versionId'] = version_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:integrations/v1alpha:getTemplatesVersion', __args__, opts=opts, typ=GetTemplatesVersionResult).value

    return AwaitableGetTemplatesVersionResult(
        create_time=__ret__.create_time,
        database_persistence_policy=__ret__.database_persistence_policy,
        description=__ret__.description,
        last_modifier_email=__ret__.last_modifier_email,
        name=__ret__.name,
        parent_integration_version_id=__ret__.parent_integration_version_id,
        snapshot_number=__ret__.snapshot_number,
        status=__ret__.status,
        task_configs=__ret__.task_configs,
        teardown=__ret__.teardown,
        template_parameters=__ret__.template_parameters,
        trigger_configs=__ret__.trigger_configs,
        update_time=__ret__.update_time,
        user_label=__ret__.user_label)


@_utilities.lift_output_func(get_templates_version)
def get_templates_version_output(integrationtemplate_id: Optional[pulumi.Input[str]] = None,
                                 location: Optional[pulumi.Input[str]] = None,
                                 product_id: Optional[pulumi.Input[str]] = None,
                                 project: Optional[pulumi.Input[Optional[str]]] = None,
                                 version_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTemplatesVersionResult]:
    """
    Returns an IntegrationTemplateVersion in the specified project.
    """
    ...
