# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConnectionProfileResult',
    'AwaitableGetConnectionProfileResult',
    'get_connection_profile',
    'get_connection_profile_output',
]

@pulumi.output_type
class GetConnectionProfileResult:
    def __init__(__self__, cloudsql=None, create_time=None, display_name=None, error=None, labels=None, mysql=None, name=None, provider=None, state=None, update_time=None):
        if cloudsql and not isinstance(cloudsql, dict):
            raise TypeError("Expected argument 'cloudsql' to be a dict")
        pulumi.set(__self__, "cloudsql", cloudsql)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if error and not isinstance(error, dict):
            raise TypeError("Expected argument 'error' to be a dict")
        pulumi.set(__self__, "error", error)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if mysql and not isinstance(mysql, dict):
            raise TypeError("Expected argument 'mysql' to be a dict")
        pulumi.set(__self__, "mysql", mysql)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider and not isinstance(provider, str):
            raise TypeError("Expected argument 'provider' to be a str")
        pulumi.set(__self__, "provider", provider)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def cloudsql(self) -> 'outputs.CloudSqlConnectionProfileResponse':
        """
        A CloudSQL database connection profile.
        """
        return pulumi.get(self, "cloudsql")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The timestamp when the resource was created. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        The error details in case of state FAILED.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def mysql(self) -> 'outputs.MySqlConnectionProfileResponse':
        """
        A MySQL database connection profile.
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The database provider.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current connection profile state (e.g. DRAFT, READY, or FAILED).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The timestamp when the resource was last updated. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")


class AwaitableGetConnectionProfileResult(GetConnectionProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionProfileResult(
            cloudsql=self.cloudsql,
            create_time=self.create_time,
            display_name=self.display_name,
            error=self.error,
            labels=self.labels,
            mysql=self.mysql,
            name=self.name,
            provider=self.provider,
            state=self.state,
            update_time=self.update_time)


def get_connection_profile(connection_profile_id: Optional[str] = None,
                           location: Optional[str] = None,
                           project: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionProfileResult:
    """
    Gets details of a single connection profile.
    """
    __args__ = dict()
    __args__['connectionProfileId'] = connection_profile_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:datamigration/v1beta1:getConnectionProfile', __args__, opts=opts, typ=GetConnectionProfileResult).value

    return AwaitableGetConnectionProfileResult(
        cloudsql=__ret__.cloudsql,
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        error=__ret__.error,
        labels=__ret__.labels,
        mysql=__ret__.mysql,
        name=__ret__.name,
        provider=__ret__.provider,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_connection_profile)
def get_connection_profile_output(connection_profile_id: Optional[pulumi.Input[str]] = None,
                                  location: Optional[pulumi.Input[str]] = None,
                                  project: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionProfileResult]:
    """
    Gets details of a single connection profile.
    """
    ...
