# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AutoscalingSettingsArgs',
    'BigQueryIODetailsArgs',
    'BigTableIODetailsArgs',
    'ComponentSourceArgs',
    'ComponentTransformArgs',
    'DatastoreIODetailsArgs',
    'DebugOptionsArgs',
    'DiskArgs',
    'DisplayDataArgs',
    'EnvironmentArgs',
    'ExecutionStageStateArgs',
    'ExecutionStageSummaryArgs',
    'FileIODetailsArgs',
    'JobExecutionInfoArgs',
    'JobMetadataArgs',
    'PackageArgs',
    'PipelineDescriptionArgs',
    'PubSubIODetailsArgs',
    'RuntimeEnvironmentArgs',
    'SdkHarnessContainerImageArgs',
    'SdkVersionArgs',
    'SpannerIODetailsArgs',
    'StageSourceArgs',
    'StepArgs',
    'TaskRunnerSettingsArgs',
    'TransformSummaryArgs',
    'WorkerPoolArgs',
    'WorkerSettingsArgs',
]

@pulumi.input_type
class AutoscalingSettingsArgs:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input['AutoscalingSettingsAlgorithm']] = None,
                 max_num_workers: Optional[pulumi.Input[int]] = None):
        """
        Settings for WorkerPool autoscaling.
        :param pulumi.Input['AutoscalingSettingsAlgorithm'] algorithm: The algorithm to use for autoscaling.
        :param pulumi.Input[int] max_num_workers: The maximum number of workers to cap scaling at.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if max_num_workers is not None:
            pulumi.set(__self__, "max_num_workers", max_num_workers)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['AutoscalingSettingsAlgorithm']]:
        """
        The algorithm to use for autoscaling.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['AutoscalingSettingsAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="maxNumWorkers")
    def max_num_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of workers to cap scaling at.
        """
        return pulumi.get(self, "max_num_workers")

    @max_num_workers.setter
    def max_num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_num_workers", value)


@pulumi.input_type
class BigQueryIODetailsArgs:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 table: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a BigQuery connector used by the job.
        :param pulumi.Input[str] dataset: Dataset accessed in the connection.
        :param pulumi.Input[str] project: Project accessed in the connection.
        :param pulumi.Input[str] query: Query used to access data in the connection.
        :param pulumi.Input[str] table: Table accessed in the connection.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset accessed in the connection.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project accessed in the connection.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Query used to access data in the connection.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        Table accessed in the connection.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class BigTableIODetailsArgs:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 table_id: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a Cloud Bigtable connector used by the job.
        :param pulumi.Input[str] instance_id: InstanceId accessed in the connection.
        :param pulumi.Input[str] project: ProjectId accessed in the connection.
        :param pulumi.Input[str] table_id: TableId accessed in the connection.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if table_id is not None:
            pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        InstanceId accessed in the connection.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> Optional[pulumi.Input[str]]:
        """
        TableId accessed in the connection.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_id", value)


@pulumi.input_type
class ComponentSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 original_transform_or_collection: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Description of an interstitial value between transforms in an execution stage.
        :param pulumi.Input[str] name: Dataflow service generated name for this source.
        :param pulumi.Input[str] original_transform_or_collection: User name for the original user transform or collection with which this source is most closely associated.
        :param pulumi.Input[str] user_name: Human-readable name for this transform; may be user or system generated.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if original_transform_or_collection is not None:
            pulumi.set(__self__, "original_transform_or_collection", original_transform_or_collection)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originalTransformOrCollection")
    def original_transform_or_collection(self) -> Optional[pulumi.Input[str]]:
        """
        User name for the original user transform or collection with which this source is most closely associated.
        """
        return pulumi.get(self, "original_transform_or_collection")

    @original_transform_or_collection.setter
    def original_transform_or_collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_transform_or_collection", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this transform; may be user or system generated.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class ComponentTransformArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 original_transform: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Description of a transform executed as part of an execution stage.
        :param pulumi.Input[str] name: Dataflow service generated name for this source.
        :param pulumi.Input[str] original_transform: User name for the original user transform with which this transform is most closely associated.
        :param pulumi.Input[str] user_name: Human-readable name for this transform; may be user or system generated.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if original_transform is not None:
            pulumi.set(__self__, "original_transform", original_transform)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originalTransform")
    def original_transform(self) -> Optional[pulumi.Input[str]]:
        """
        User name for the original user transform with which this transform is most closely associated.
        """
        return pulumi.get(self, "original_transform")

    @original_transform.setter
    def original_transform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_transform", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this transform; may be user or system generated.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class DatastoreIODetailsArgs:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a Datastore connector used by the job.
        :param pulumi.Input[str] namespace: Namespace used in the connection.
        :param pulumi.Input[str] project: ProjectId accessed in the connection.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace used in the connection.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class DebugOptionsArgs:
    def __init__(__self__, *,
                 enable_hot_key_logging: Optional[pulumi.Input[bool]] = None):
        """
        Describes any options that have an effect on the debugging of pipelines.
        :param pulumi.Input[bool] enable_hot_key_logging: When true, enables the logging of the literal hot key to the user's Cloud Logging.
        """
        if enable_hot_key_logging is not None:
            pulumi.set(__self__, "enable_hot_key_logging", enable_hot_key_logging)

    @property
    @pulumi.getter(name="enableHotKeyLogging")
    def enable_hot_key_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, enables the logging of the literal hot key to the user's Cloud Logging.
        """
        return pulumi.get(self, "enable_hot_key_logging")

    @enable_hot_key_logging.setter
    def enable_hot_key_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_hot_key_logging", value)


@pulumi.input_type
class DiskArgs:
    def __init__(__self__, *,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 mount_point: Optional[pulumi.Input[str]] = None,
                 size_gb: Optional[pulumi.Input[int]] = None):
        """
        Describes the data disk used by a workflow job.
        :param pulumi.Input[str] disk_type: Disk storage type, as defined by Google Compute Engine. This must be a disk type appropriate to the project and zone in which the workers will run. If unknown or unspecified, the service will attempt to choose a reasonable default. For example, the standard persistent disk type is a resource name typically ending in "pd-standard". If SSD persistent disks are available, the resource name typically ends with "pd-ssd". The actual valid values are defined the Google Compute Engine API, not by the Cloud Dataflow API; consult the Google Compute Engine documentation for more information about determining the set of available disk types for a particular project and zone. Google Compute Engine Disk types are local to a particular project in a particular zone, and so the resource name will typically look something like this: compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
        :param pulumi.Input[str] mount_point: Directory in a VM where disk is mounted.
        :param pulumi.Input[int] size_gb: Size of disk in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if mount_point is not None:
            pulumi.set(__self__, "mount_point", mount_point)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Disk storage type, as defined by Google Compute Engine. This must be a disk type appropriate to the project and zone in which the workers will run. If unknown or unspecified, the service will attempt to choose a reasonable default. For example, the standard persistent disk type is a resource name typically ending in "pd-standard". If SSD persistent disks are available, the resource name typically ends with "pd-ssd". The actual valid values are defined the Google Compute Engine API, not by the Cloud Dataflow API; consult the Google Compute Engine documentation for more information about determining the set of available disk types for a particular project and zone. Google Compute Engine Disk types are local to a particular project in a particular zone, and so the resource name will typically look something like this: compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> Optional[pulumi.Input[str]]:
        """
        Directory in a VM where disk is mounted.
        """
        return pulumi.get(self, "mount_point")

    @mount_point.setter
    def mount_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_point", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of disk in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_gb", value)


@pulumi.input_type
class DisplayDataArgs:
    def __init__(__self__, *,
                 bool_value: Optional[pulumi.Input[bool]] = None,
                 duration_value: Optional[pulumi.Input[str]] = None,
                 float_value: Optional[pulumi.Input[float]] = None,
                 int64_value: Optional[pulumi.Input[str]] = None,
                 java_class_value: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 short_str_value: Optional[pulumi.Input[str]] = None,
                 str_value: Optional[pulumi.Input[str]] = None,
                 timestamp_value: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Data provided with a pipeline or transform to provide descriptive info.
        :param pulumi.Input[bool] bool_value: Contains value if the data is of a boolean type.
        :param pulumi.Input[str] duration_value: Contains value if the data is of duration type.
        :param pulumi.Input[float] float_value: Contains value if the data is of float type.
        :param pulumi.Input[str] int64_value: Contains value if the data is of int64 type.
        :param pulumi.Input[str] java_class_value: Contains value if the data is of java class type.
        :param pulumi.Input[str] key: The key identifying the display data. This is intended to be used as a label for the display data when viewed in a dax monitoring system.
        :param pulumi.Input[str] label: An optional label to display in a dax UI for the element.
        :param pulumi.Input[str] namespace: The namespace for the key. This is usually a class name or programming language namespace (i.e. python module) which defines the display data. This allows a dax monitoring system to specially handle the data and perform custom rendering.
        :param pulumi.Input[str] short_str_value: A possible additional shorter value to display. For example a java_class_name_value of com.mypackage.MyDoFn will be stored with MyDoFn as the short_str_value and com.mypackage.MyDoFn as the java_class_name value. short_str_value can be displayed and java_class_name_value will be displayed as a tooltip.
        :param pulumi.Input[str] str_value: Contains value if the data is of string type.
        :param pulumi.Input[str] timestamp_value: Contains value if the data is of timestamp type.
        :param pulumi.Input[str] url: An optional full URL.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if duration_value is not None:
            pulumi.set(__self__, "duration_value", duration_value)
        if float_value is not None:
            pulumi.set(__self__, "float_value", float_value)
        if int64_value is not None:
            pulumi.set(__self__, "int64_value", int64_value)
        if java_class_value is not None:
            pulumi.set(__self__, "java_class_value", java_class_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if short_str_value is not None:
            pulumi.set(__self__, "short_str_value", short_str_value)
        if str_value is not None:
            pulumi.set(__self__, "str_value", str_value)
        if timestamp_value is not None:
            pulumi.set(__self__, "timestamp_value", timestamp_value)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[pulumi.Input[bool]]:
        """
        Contains value if the data is of a boolean type.
        """
        return pulumi.get(self, "bool_value")

    @bool_value.setter
    def bool_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bool_value", value)

    @property
    @pulumi.getter(name="durationValue")
    def duration_value(self) -> Optional[pulumi.Input[str]]:
        """
        Contains value if the data is of duration type.
        """
        return pulumi.get(self, "duration_value")

    @duration_value.setter
    def duration_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration_value", value)

    @property
    @pulumi.getter(name="floatValue")
    def float_value(self) -> Optional[pulumi.Input[float]]:
        """
        Contains value if the data is of float type.
        """
        return pulumi.get(self, "float_value")

    @float_value.setter
    def float_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "float_value", value)

    @property
    @pulumi.getter(name="int64Value")
    def int64_value(self) -> Optional[pulumi.Input[str]]:
        """
        Contains value if the data is of int64 type.
        """
        return pulumi.get(self, "int64_value")

    @int64_value.setter
    def int64_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "int64_value", value)

    @property
    @pulumi.getter(name="javaClassValue")
    def java_class_value(self) -> Optional[pulumi.Input[str]]:
        """
        Contains value if the data is of java class type.
        """
        return pulumi.get(self, "java_class_value")

    @java_class_value.setter
    def java_class_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "java_class_value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key identifying the display data. This is intended to be used as a label for the display data when viewed in a dax monitoring system.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        An optional label to display in a dax UI for the element.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace for the key. This is usually a class name or programming language namespace (i.e. python module) which defines the display data. This allows a dax monitoring system to specially handle the data and perform custom rendering.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="shortStrValue")
    def short_str_value(self) -> Optional[pulumi.Input[str]]:
        """
        A possible additional shorter value to display. For example a java_class_name_value of com.mypackage.MyDoFn will be stored with MyDoFn as the short_str_value and com.mypackage.MyDoFn as the java_class_name value. short_str_value can be displayed and java_class_name_value will be displayed as a tooltip.
        """
        return pulumi.get(self, "short_str_value")

    @short_str_value.setter
    def short_str_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_str_value", value)

    @property
    @pulumi.getter(name="strValue")
    def str_value(self) -> Optional[pulumi.Input[str]]:
        """
        Contains value if the data is of string type.
        """
        return pulumi.get(self, "str_value")

    @str_value.setter
    def str_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "str_value", value)

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> Optional[pulumi.Input[str]]:
        """
        Contains value if the data is of timestamp type.
        """
        return pulumi.get(self, "timestamp_value")

    @timestamp_value.setter
    def timestamp_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestamp_value", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        An optional full URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 cluster_manager_api_service: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 debug_options: Optional[pulumi.Input['DebugOptionsArgs']] = None,
                 experiments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 flex_resource_scheduling_goal: Optional[pulumi.Input['EnvironmentFlexResourceSchedulingGoal']] = None,
                 internal_experiments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sdk_pipeline_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 service_kms_key_name: Optional[pulumi.Input[str]] = None,
                 service_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 temp_storage_prefix: Optional[pulumi.Input[str]] = None,
                 user_agent: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 worker_pools: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]] = None,
                 worker_region: Optional[pulumi.Input[str]] = None,
                 worker_zone: Optional[pulumi.Input[str]] = None):
        """
        Describes the environment in which a Dataflow Job runs.
        :param pulumi.Input[str] cluster_manager_api_service: The type of cluster manager API to use. If unknown or unspecified, the service will attempt to choose a reasonable default. This should be in the form of the API service name, e.g. "compute.googleapis.com".
        :param pulumi.Input[str] dataset: The dataset for the current project where various workflow related tables are stored. The supported resource type is: Google BigQuery: bigquery.googleapis.com/{dataset}
        :param pulumi.Input['DebugOptionsArgs'] debug_options: Any debugging options to be supplied to the job.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] experiments: The list of experiments to enable. This field should be used for SDK related experiments and not for service related experiments. The proper field for service related experiments is service_options.
        :param pulumi.Input['EnvironmentFlexResourceSchedulingGoal'] flex_resource_scheduling_goal: Which Flexible Resource Scheduling mode to run in.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] internal_experiments: Experimental settings.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sdk_pipeline_options: The Cloud Dataflow SDK pipeline options specified by the user. These options are passed through the service and are used to recreate the SDK pipeline options on the worker in a language agnostic and platform independent way.
        :param pulumi.Input[str] service_account_email: Identity to run virtual machines as. Defaults to the default account.
        :param pulumi.Input[str] service_kms_key_name: If set, contains the Cloud KMS key identifier used to encrypt data at rest, AKA a Customer Managed Encryption Key (CMEK). Format: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_options: The list of service options to enable. This field should be used for service related experiments only. These experiments, when graduating to GA, should be replaced by dedicated fields or become default (i.e. always on).
        :param pulumi.Input[str] temp_storage_prefix: The prefix of the resources the system should use for temporary storage. The system will append the suffix "/temp-{JOBNAME} to this resource prefix, where {JOBNAME} is the value of the job_name field. The resulting bucket and object prefix is used as the prefix of the resources used to store temporary data needed during the job execution. NOTE: This will override the value in taskrunner_settings. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_agent: A description of the process that generated the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] version: A structure describing which components and their versions of the service are required in order to run the job.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]] worker_pools: The worker pools. At least one "harness" worker pool must be specified in order for the job to have workers.
        :param pulumi.Input[str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        :param pulumi.Input[str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity.
        """
        if cluster_manager_api_service is not None:
            pulumi.set(__self__, "cluster_manager_api_service", cluster_manager_api_service)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if debug_options is not None:
            pulumi.set(__self__, "debug_options", debug_options)
        if experiments is not None:
            pulumi.set(__self__, "experiments", experiments)
        if flex_resource_scheduling_goal is not None:
            pulumi.set(__self__, "flex_resource_scheduling_goal", flex_resource_scheduling_goal)
        if internal_experiments is not None:
            pulumi.set(__self__, "internal_experiments", internal_experiments)
        if sdk_pipeline_options is not None:
            pulumi.set(__self__, "sdk_pipeline_options", sdk_pipeline_options)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if service_kms_key_name is not None:
            pulumi.set(__self__, "service_kms_key_name", service_kms_key_name)
        if service_options is not None:
            pulumi.set(__self__, "service_options", service_options)
        if temp_storage_prefix is not None:
            pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        if user_agent is not None:
            pulumi.set(__self__, "user_agent", user_agent)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if worker_pools is not None:
            pulumi.set(__self__, "worker_pools", worker_pools)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)

    @property
    @pulumi.getter(name="clusterManagerApiService")
    def cluster_manager_api_service(self) -> Optional[pulumi.Input[str]]:
        """
        The type of cluster manager API to use. If unknown or unspecified, the service will attempt to choose a reasonable default. This should be in the form of the API service name, e.g. "compute.googleapis.com".
        """
        return pulumi.get(self, "cluster_manager_api_service")

    @cluster_manager_api_service.setter
    def cluster_manager_api_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_manager_api_service", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset for the current project where various workflow related tables are stored. The supported resource type is: Google BigQuery: bigquery.googleapis.com/{dataset}
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="debugOptions")
    def debug_options(self) -> Optional[pulumi.Input['DebugOptionsArgs']]:
        """
        Any debugging options to be supplied to the job.
        """
        return pulumi.get(self, "debug_options")

    @debug_options.setter
    def debug_options(self, value: Optional[pulumi.Input['DebugOptionsArgs']]):
        pulumi.set(self, "debug_options", value)

    @property
    @pulumi.getter
    def experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of experiments to enable. This field should be used for SDK related experiments and not for service related experiments. The proper field for service related experiments is service_options.
        """
        return pulumi.get(self, "experiments")

    @experiments.setter
    def experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "experiments", value)

    @property
    @pulumi.getter(name="flexResourceSchedulingGoal")
    def flex_resource_scheduling_goal(self) -> Optional[pulumi.Input['EnvironmentFlexResourceSchedulingGoal']]:
        """
        Which Flexible Resource Scheduling mode to run in.
        """
        return pulumi.get(self, "flex_resource_scheduling_goal")

    @flex_resource_scheduling_goal.setter
    def flex_resource_scheduling_goal(self, value: Optional[pulumi.Input['EnvironmentFlexResourceSchedulingGoal']]):
        pulumi.set(self, "flex_resource_scheduling_goal", value)

    @property
    @pulumi.getter(name="internalExperiments")
    def internal_experiments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Experimental settings.
        """
        return pulumi.get(self, "internal_experiments")

    @internal_experiments.setter
    def internal_experiments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "internal_experiments", value)

    @property
    @pulumi.getter(name="sdkPipelineOptions")
    def sdk_pipeline_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Cloud Dataflow SDK pipeline options specified by the user. These options are passed through the service and are used to recreate the SDK pipeline options on the worker in a language agnostic and platform independent way.
        """
        return pulumi.get(self, "sdk_pipeline_options")

    @sdk_pipeline_options.setter
    def sdk_pipeline_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "sdk_pipeline_options", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        Identity to run virtual machines as. Defaults to the default account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="serviceKmsKeyName")
    def service_kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        If set, contains the Cloud KMS key identifier used to encrypt data at rest, AKA a Customer Managed Encryption Key (CMEK). Format: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
        """
        return pulumi.get(self, "service_kms_key_name")

    @service_kms_key_name.setter
    def service_kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_kms_key_name", value)

    @property
    @pulumi.getter(name="serviceOptions")
    def service_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of service options to enable. This field should be used for service related experiments only. These experiments, when graduating to GA, should be replaced by dedicated fields or become default (i.e. always on).
        """
        return pulumi.get(self, "service_options")

    @service_options.setter
    def service_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "service_options", value)

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix of the resources the system should use for temporary storage. The system will append the suffix "/temp-{JOBNAME} to this resource prefix, where {JOBNAME} is the value of the job_name field. The resulting bucket and object prefix is used as the prefix of the resources used to store temporary data needed during the job execution. NOTE: This will override the value in taskrunner_settings. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @temp_storage_prefix.setter
    def temp_storage_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_storage_prefix", value)

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A description of the process that generated the request.
        """
        return pulumi.get(self, "user_agent")

    @user_agent.setter
    def user_agent(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_agent", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A structure describing which components and their versions of the service are required in order to run the job.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="workerPools")
    def worker_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]]:
        """
        The worker pools. At least one "harness" worker pool must be specified in order for the job to have workers.
        """
        return pulumi.get(self, "worker_pools")

    @worker_pools.setter
    def worker_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolArgs']]]]):
        pulumi.set(self, "worker_pools", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_zone", value)


@pulumi.input_type
class ExecutionStageStateArgs:
    def __init__(__self__, *,
                 current_state_time: Optional[pulumi.Input[str]] = None,
                 execution_stage_name: Optional[pulumi.Input[str]] = None,
                 execution_stage_state: Optional[pulumi.Input['ExecutionStageStateExecutionStageState']] = None):
        """
        A message describing the state of a particular execution stage.
        :param pulumi.Input[str] current_state_time: The time at which the stage transitioned to this state.
        :param pulumi.Input[str] execution_stage_name: The name of the execution stage.
        :param pulumi.Input['ExecutionStageStateExecutionStageState'] execution_stage_state: Executions stage states allow the same set of values as JobState.
        """
        if current_state_time is not None:
            pulumi.set(__self__, "current_state_time", current_state_time)
        if execution_stage_name is not None:
            pulumi.set(__self__, "execution_stage_name", execution_stage_name)
        if execution_stage_state is not None:
            pulumi.set(__self__, "execution_stage_state", execution_stage_state)

    @property
    @pulumi.getter(name="currentStateTime")
    def current_state_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the stage transitioned to this state.
        """
        return pulumi.get(self, "current_state_time")

    @current_state_time.setter
    def current_state_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_state_time", value)

    @property
    @pulumi.getter(name="executionStageName")
    def execution_stage_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the execution stage.
        """
        return pulumi.get(self, "execution_stage_name")

    @execution_stage_name.setter
    def execution_stage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_stage_name", value)

    @property
    @pulumi.getter(name="executionStageState")
    def execution_stage_state(self) -> Optional[pulumi.Input['ExecutionStageStateExecutionStageState']]:
        """
        Executions stage states allow the same set of values as JobState.
        """
        return pulumi.get(self, "execution_stage_state")

    @execution_stage_state.setter
    def execution_stage_state(self, value: Optional[pulumi.Input['ExecutionStageStateExecutionStageState']]):
        pulumi.set(self, "execution_stage_state", value)


@pulumi.input_type
class ExecutionStageSummaryArgs:
    def __init__(__self__, *,
                 component_source: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentSourceArgs']]]] = None,
                 component_transform: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentTransformArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 input_source: Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]] = None,
                 kind: Optional[pulumi.Input['ExecutionStageSummaryKind']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_source: Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]] = None,
                 prerequisite_stage: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Description of the composing transforms, names/ids, and input/outputs of a stage of execution. Some composing transforms and sources may have been generated by the Dataflow service during execution planning.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentSourceArgs']]] component_source: Collections produced and consumed by component transforms of this stage.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentTransformArgs']]] component_transform: Transforms that comprise this execution stage.
        :param pulumi.Input[str] id: Dataflow service generated id for this stage.
        :param pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]] input_source: Input sources for this stage.
        :param pulumi.Input['ExecutionStageSummaryKind'] kind: Type of transform this stage is executing.
        :param pulumi.Input[str] name: Dataflow service generated name for this stage.
        :param pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]] output_source: Output sources for this stage.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prerequisite_stage: Other stages that must complete before this stage can run.
        """
        if component_source is not None:
            pulumi.set(__self__, "component_source", component_source)
        if component_transform is not None:
            pulumi.set(__self__, "component_transform", component_transform)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if input_source is not None:
            pulumi.set(__self__, "input_source", input_source)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_source is not None:
            pulumi.set(__self__, "output_source", output_source)
        if prerequisite_stage is not None:
            pulumi.set(__self__, "prerequisite_stage", prerequisite_stage)

    @property
    @pulumi.getter(name="componentSource")
    def component_source(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentSourceArgs']]]]:
        """
        Collections produced and consumed by component transforms of this stage.
        """
        return pulumi.get(self, "component_source")

    @component_source.setter
    def component_source(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentSourceArgs']]]]):
        pulumi.set(self, "component_source", value)

    @property
    @pulumi.getter(name="componentTransform")
    def component_transform(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentTransformArgs']]]]:
        """
        Transforms that comprise this execution stage.
        """
        return pulumi.get(self, "component_transform")

    @component_transform.setter
    def component_transform(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentTransformArgs']]]]):
        pulumi.set(self, "component_transform", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Dataflow service generated id for this stage.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="inputSource")
    def input_source(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]]:
        """
        Input sources for this stage.
        """
        return pulumi.get(self, "input_source")

    @input_source.setter
    def input_source(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]]):
        pulumi.set(self, "input_source", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['ExecutionStageSummaryKind']]:
        """
        Type of transform this stage is executing.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['ExecutionStageSummaryKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Dataflow service generated name for this stage.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputSource")
    def output_source(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]]:
        """
        Output sources for this stage.
        """
        return pulumi.get(self, "output_source")

    @output_source.setter
    def output_source(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageSourceArgs']]]]):
        pulumi.set(self, "output_source", value)

    @property
    @pulumi.getter(name="prerequisiteStage")
    def prerequisite_stage(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Other stages that must complete before this stage can run.
        """
        return pulumi.get(self, "prerequisite_stage")

    @prerequisite_stage.setter
    def prerequisite_stage(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prerequisite_stage", value)


@pulumi.input_type
class FileIODetailsArgs:
    def __init__(__self__, *,
                 file_pattern: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a File connector used by the job.
        :param pulumi.Input[str] file_pattern: File Pattern used to access files by the connector.
        """
        if file_pattern is not None:
            pulumi.set(__self__, "file_pattern", file_pattern)

    @property
    @pulumi.getter(name="filePattern")
    def file_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        File Pattern used to access files by the connector.
        """
        return pulumi.get(self, "file_pattern")

    @file_pattern.setter
    def file_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_pattern", value)


@pulumi.input_type
class JobExecutionInfoArgs:
    def __init__(__self__, *,
                 stages: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Additional information about how a Cloud Dataflow job will be executed that isn't contained in the submitted job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stages: A mapping from each stage to the information about that stage.
        """
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping from each stage to the information about that stage.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "stages", value)


@pulumi.input_type
class JobMetadataArgs:
    def __init__(__self__, *,
                 big_table_details: Optional[pulumi.Input[Sequence[pulumi.Input['BigTableIODetailsArgs']]]] = None,
                 bigquery_details: Optional[pulumi.Input[Sequence[pulumi.Input['BigQueryIODetailsArgs']]]] = None,
                 datastore_details: Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreIODetailsArgs']]]] = None,
                 file_details: Optional[pulumi.Input[Sequence[pulumi.Input['FileIODetailsArgs']]]] = None,
                 pubsub_details: Optional[pulumi.Input[Sequence[pulumi.Input['PubSubIODetailsArgs']]]] = None,
                 sdk_version: Optional[pulumi.Input['SdkVersionArgs']] = None,
                 spanner_details: Optional[pulumi.Input[Sequence[pulumi.Input['SpannerIODetailsArgs']]]] = None):
        """
        Metadata available primarily for filtering jobs. Will be included in the ListJob response and Job SUMMARY view.
        :param pulumi.Input[Sequence[pulumi.Input['BigTableIODetailsArgs']]] big_table_details: Identification of a Cloud Bigtable source used in the Dataflow job.
        :param pulumi.Input[Sequence[pulumi.Input['BigQueryIODetailsArgs']]] bigquery_details: Identification of a BigQuery source used in the Dataflow job.
        :param pulumi.Input[Sequence[pulumi.Input['DatastoreIODetailsArgs']]] datastore_details: Identification of a Datastore source used in the Dataflow job.
        :param pulumi.Input[Sequence[pulumi.Input['FileIODetailsArgs']]] file_details: Identification of a File source used in the Dataflow job.
        :param pulumi.Input[Sequence[pulumi.Input['PubSubIODetailsArgs']]] pubsub_details: Identification of a Pub/Sub source used in the Dataflow job.
        :param pulumi.Input['SdkVersionArgs'] sdk_version: The SDK version used to run the job.
        :param pulumi.Input[Sequence[pulumi.Input['SpannerIODetailsArgs']]] spanner_details: Identification of a Spanner source used in the Dataflow job.
        """
        if big_table_details is not None:
            pulumi.set(__self__, "big_table_details", big_table_details)
        if bigquery_details is not None:
            pulumi.set(__self__, "bigquery_details", bigquery_details)
        if datastore_details is not None:
            pulumi.set(__self__, "datastore_details", datastore_details)
        if file_details is not None:
            pulumi.set(__self__, "file_details", file_details)
        if pubsub_details is not None:
            pulumi.set(__self__, "pubsub_details", pubsub_details)
        if sdk_version is not None:
            pulumi.set(__self__, "sdk_version", sdk_version)
        if spanner_details is not None:
            pulumi.set(__self__, "spanner_details", spanner_details)

    @property
    @pulumi.getter(name="bigTableDetails")
    def big_table_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BigTableIODetailsArgs']]]]:
        """
        Identification of a Cloud Bigtable source used in the Dataflow job.
        """
        return pulumi.get(self, "big_table_details")

    @big_table_details.setter
    def big_table_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BigTableIODetailsArgs']]]]):
        pulumi.set(self, "big_table_details", value)

    @property
    @pulumi.getter(name="bigqueryDetails")
    def bigquery_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BigQueryIODetailsArgs']]]]:
        """
        Identification of a BigQuery source used in the Dataflow job.
        """
        return pulumi.get(self, "bigquery_details")

    @bigquery_details.setter
    def bigquery_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BigQueryIODetailsArgs']]]]):
        pulumi.set(self, "bigquery_details", value)

    @property
    @pulumi.getter(name="datastoreDetails")
    def datastore_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreIODetailsArgs']]]]:
        """
        Identification of a Datastore source used in the Dataflow job.
        """
        return pulumi.get(self, "datastore_details")

    @datastore_details.setter
    def datastore_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatastoreIODetailsArgs']]]]):
        pulumi.set(self, "datastore_details", value)

    @property
    @pulumi.getter(name="fileDetails")
    def file_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileIODetailsArgs']]]]:
        """
        Identification of a File source used in the Dataflow job.
        """
        return pulumi.get(self, "file_details")

    @file_details.setter
    def file_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileIODetailsArgs']]]]):
        pulumi.set(self, "file_details", value)

    @property
    @pulumi.getter(name="pubsubDetails")
    def pubsub_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PubSubIODetailsArgs']]]]:
        """
        Identification of a Pub/Sub source used in the Dataflow job.
        """
        return pulumi.get(self, "pubsub_details")

    @pubsub_details.setter
    def pubsub_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PubSubIODetailsArgs']]]]):
        pulumi.set(self, "pubsub_details", value)

    @property
    @pulumi.getter(name="sdkVersion")
    def sdk_version(self) -> Optional[pulumi.Input['SdkVersionArgs']]:
        """
        The SDK version used to run the job.
        """
        return pulumi.get(self, "sdk_version")

    @sdk_version.setter
    def sdk_version(self, value: Optional[pulumi.Input['SdkVersionArgs']]):
        pulumi.set(self, "sdk_version", value)

    @property
    @pulumi.getter(name="spannerDetails")
    def spanner_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SpannerIODetailsArgs']]]]:
        """
        Identification of a Spanner source used in the Dataflow job.
        """
        return pulumi.get(self, "spanner_details")

    @spanner_details.setter
    def spanner_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SpannerIODetailsArgs']]]]):
        pulumi.set(self, "spanner_details", value)


@pulumi.input_type
class PackageArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The packages that must be installed in order for a worker to run the steps of the Cloud Dataflow job that will be assigned to its worker pool. This is the mechanism by which the Cloud Dataflow SDK causes code to be loaded onto the workers. For example, the Cloud Dataflow Java SDK might use this to install jars containing the user's code and all of the various dependencies (libraries, data files, etc.) required in order for that code to run.
        :param pulumi.Input[str] location: The resource to read the package from. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket} bucket.storage.googleapis.com/
        :param pulumi.Input[str] name: The name of the package.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The resource to read the package from. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket} bucket.storage.googleapis.com/
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PipelineDescriptionArgs:
    def __init__(__self__, *,
                 display_data: Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]] = None,
                 execution_pipeline_stage: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageSummaryArgs']]]] = None,
                 original_pipeline_transform: Optional[pulumi.Input[Sequence[pulumi.Input['TransformSummaryArgs']]]] = None,
                 step_names_hash: Optional[pulumi.Input[str]] = None):
        """
        A descriptive representation of submitted pipeline as well as the executed form. This data is provided by the Dataflow service for ease of visualizing the pipeline and interpreting Dataflow provided metrics.
        :param pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]] display_data: Pipeline level display data.
        :param pulumi.Input[Sequence[pulumi.Input['ExecutionStageSummaryArgs']]] execution_pipeline_stage: Description of each stage of execution of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['TransformSummaryArgs']]] original_pipeline_transform: Description of each transform in the pipeline and collections between them.
        :param pulumi.Input[str] step_names_hash: A hash value of the submitted pipeline portable graph step names if exists.
        """
        if display_data is not None:
            pulumi.set(__self__, "display_data", display_data)
        if execution_pipeline_stage is not None:
            pulumi.set(__self__, "execution_pipeline_stage", execution_pipeline_stage)
        if original_pipeline_transform is not None:
            pulumi.set(__self__, "original_pipeline_transform", original_pipeline_transform)
        if step_names_hash is not None:
            pulumi.set(__self__, "step_names_hash", step_names_hash)

    @property
    @pulumi.getter(name="displayData")
    def display_data(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]]:
        """
        Pipeline level display data.
        """
        return pulumi.get(self, "display_data")

    @display_data.setter
    def display_data(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]]):
        pulumi.set(self, "display_data", value)

    @property
    @pulumi.getter(name="executionPipelineStage")
    def execution_pipeline_stage(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageSummaryArgs']]]]:
        """
        Description of each stage of execution of the pipeline.
        """
        return pulumi.get(self, "execution_pipeline_stage")

    @execution_pipeline_stage.setter
    def execution_pipeline_stage(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageSummaryArgs']]]]):
        pulumi.set(self, "execution_pipeline_stage", value)

    @property
    @pulumi.getter(name="originalPipelineTransform")
    def original_pipeline_transform(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransformSummaryArgs']]]]:
        """
        Description of each transform in the pipeline and collections between them.
        """
        return pulumi.get(self, "original_pipeline_transform")

    @original_pipeline_transform.setter
    def original_pipeline_transform(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransformSummaryArgs']]]]):
        pulumi.set(self, "original_pipeline_transform", value)

    @property
    @pulumi.getter(name="stepNamesHash")
    def step_names_hash(self) -> Optional[pulumi.Input[str]]:
        """
        A hash value of the submitted pipeline portable graph step names if exists.
        """
        return pulumi.get(self, "step_names_hash")

    @step_names_hash.setter
    def step_names_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_names_hash", value)


@pulumi.input_type
class PubSubIODetailsArgs:
    def __init__(__self__, *,
                 subscription: Optional[pulumi.Input[str]] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a Pub/Sub connector used by the job.
        :param pulumi.Input[str] subscription: Subscription used in the connection.
        :param pulumi.Input[str] topic: Topic accessed in the connection.
        """
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription used in the connection.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        Topic accessed in the connection.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class RuntimeEnvironmentArgs:
    def __init__(__self__, *,
                 additional_experiments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 additional_user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bypass_temp_dir_validation: Optional[pulumi.Input[bool]] = None,
                 enable_streaming_engine: Optional[pulumi.Input[bool]] = None,
                 ip_configuration: Optional[pulumi.Input['RuntimeEnvironmentIpConfiguration']] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_workers: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 temp_location: Optional[pulumi.Input[str]] = None,
                 worker_region: Optional[pulumi.Input[str]] = None,
                 worker_zone: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The environment values to set at runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_experiments: Additional experiment flags for the job, specified with the `--experiments` option.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_user_labels: Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        :param pulumi.Input[bool] bypass_temp_dir_validation: Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        :param pulumi.Input[bool] enable_streaming_engine: Whether to enable Streaming Engine for the job.
        :param pulumi.Input['RuntimeEnvironmentIpConfiguration'] ip_configuration: Configuration for VM IPs.
        :param pulumi.Input[str] kms_key_name: Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        :param pulumi.Input[str] machine_type: The machine type to use for the job. Defaults to the value from the template if not specified.
        :param pulumi.Input[int] max_workers: The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        :param pulumi.Input[str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[int] num_workers: The initial number of Google Compute Engine instances for the job.
        :param pulumi.Input[str] service_account_email: The email address of the service account to run the job as.
        :param pulumi.Input[str] subnetwork: Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        :param pulumi.Input[str] temp_location: The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        :param pulumi.Input[str] worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        :param pulumi.Input[str] worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        :param pulumi.Input[str] zone: The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        if additional_experiments is not None:
            pulumi.set(__self__, "additional_experiments", additional_experiments)
        if additional_user_labels is not None:
            pulumi.set(__self__, "additional_user_labels", additional_user_labels)
        if bypass_temp_dir_validation is not None:
            pulumi.set(__self__, "bypass_temp_dir_validation", bypass_temp_dir_validation)
        if enable_streaming_engine is not None:
            pulumi.set(__self__, "enable_streaming_engine", enable_streaming_engine)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_workers is not None:
            pulumi.set(__self__, "max_workers", max_workers)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if temp_location is not None:
            pulumi.set(__self__, "temp_location", temp_location)
        if worker_region is not None:
            pulumi.set(__self__, "worker_region", worker_region)
        if worker_zone is not None:
            pulumi.set(__self__, "worker_zone", worker_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="additionalExperiments")
    def additional_experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional experiment flags for the job, specified with the `--experiments` option.
        """
        return pulumi.get(self, "additional_experiments")

    @additional_experiments.setter
    def additional_experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_experiments", value)

    @property
    @pulumi.getter(name="additionalUserLabels")
    def additional_user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional user labels to be specified for the job. Keys and values should follow the restrictions specified in the [labeling restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) page. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1kg", "count": "3" }.
        """
        return pulumi.get(self, "additional_user_labels")

    @additional_user_labels.setter
    def additional_user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_user_labels", value)

    @property
    @pulumi.getter(name="bypassTempDirValidation")
    def bypass_temp_dir_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to bypass the safety checks for the job's temporary directory. Use with caution.
        """
        return pulumi.get(self, "bypass_temp_dir_validation")

    @bypass_temp_dir_validation.setter
    def bypass_temp_dir_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_temp_dir_validation", value)

    @property
    @pulumi.getter(name="enableStreamingEngine")
    def enable_streaming_engine(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable Streaming Engine for the job.
        """
        return pulumi.get(self, "enable_streaming_engine")

    @enable_streaming_engine.setter
    def enable_streaming_engine(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_streaming_engine", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['RuntimeEnvironmentIpConfiguration']]:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['RuntimeEnvironmentIpConfiguration']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Cloud KMS key for the job. Key format is: projects//locations//keyRings//cryptoKeys/
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The machine type to use for the job. Defaults to the value from the template if not specified.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxWorkers")
    def max_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of Google Compute Engine instances to be made available to your pipeline during execution, from 1 to 1000.
        """
        return pulumi.get(self, "max_workers")

    @max_workers.setter
    def max_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_workers", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of Google Compute Engine instances for the job.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the service account to run the job as.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. You can specify a subnetwork using either a complete URL or an abbreviated path. Expected to be of the form "https://www.googleapis.com/compute/v1/projects/HOST_PROJECT_ID/regions/REGION/subnetworks/SUBNETWORK" or "regions/REGION/subnetworks/SUBNETWORK". If the subnetwork is located in a Shared VPC network, you must use the complete URL.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="tempLocation")
    def temp_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage path to use for temporary files. Must be a valid Cloud Storage URL, beginning with `gs://`.
        """
        return pulumi.get(self, "temp_location")

    @temp_location.setter
    def temp_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_location", value)

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @worker_region.setter
    def worker_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_region", value)

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity. If both `worker_zone` and `zone` are set, `worker_zone` takes precedence.
        """
        return pulumi.get(self, "worker_zone")

    @worker_zone.setter
    def worker_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine [availability zone](https://cloud.google.com/compute/docs/regions-zones/regions-zones) for launching worker instances to run your pipeline. In the future, worker_zone will take precedence.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class SdkHarnessContainerImageArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_image: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 use_single_core_per_container: Optional[pulumi.Input[bool]] = None):
        """
        Defines an SDK harness container for executing Dataflow pipelines.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] capabilities: The set of capabilities enumerated in the above Environment proto. See also [beam_runner_api.proto](https://github.com/apache/beam/blob/master/model/pipeline/src/main/proto/org/apache/beam/model/pipeline/v1/beam_runner_api.proto)
        :param pulumi.Input[str] container_image: A docker container image that resides in Google Container Registry.
        :param pulumi.Input[str] environment_id: Environment ID for the Beam runner API proto Environment that corresponds to the current SDK Harness.
        :param pulumi.Input[bool] use_single_core_per_container: If true, recommends the Dataflow service to use only one core per SDK container instance with this image. If false (or unset) recommends using more than one core per SDK container instance with this image for efficiency. Note that Dataflow service may choose to override this property if needed.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if use_single_core_per_container is not None:
            pulumi.set(__self__, "use_single_core_per_container", use_single_core_per_container)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of capabilities enumerated in the above Environment proto. See also [beam_runner_api.proto](https://github.com/apache/beam/blob/master/model/pipeline/src/main/proto/org/apache/beam/model/pipeline/v1/beam_runner_api.proto)
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[pulumi.Input[str]]:
        """
        A docker container image that resides in Google Container Registry.
        """
        return pulumi.get(self, "container_image")

    @container_image.setter
    def container_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Environment ID for the Beam runner API proto Environment that corresponds to the current SDK Harness.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="useSingleCorePerContainer")
    def use_single_core_per_container(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, recommends the Dataflow service to use only one core per SDK container instance with this image. If false (or unset) recommends using more than one core per SDK container instance with this image for efficiency. Note that Dataflow service may choose to override this property if needed.
        """
        return pulumi.get(self, "use_single_core_per_container")

    @use_single_core_per_container.setter
    def use_single_core_per_container(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_single_core_per_container", value)


@pulumi.input_type
class SdkVersionArgs:
    def __init__(__self__, *,
                 sdk_support_status: Optional[pulumi.Input['SdkVersionSdkSupportStatus']] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 version_display_name: Optional[pulumi.Input[str]] = None):
        """
        The version of the SDK used to run the job.
        :param pulumi.Input['SdkVersionSdkSupportStatus'] sdk_support_status: The support status for this SDK version.
        :param pulumi.Input[str] version: The version of the SDK used to run the job.
        :param pulumi.Input[str] version_display_name: A readable string describing the version of the SDK.
        """
        if sdk_support_status is not None:
            pulumi.set(__self__, "sdk_support_status", sdk_support_status)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_display_name is not None:
            pulumi.set(__self__, "version_display_name", version_display_name)

    @property
    @pulumi.getter(name="sdkSupportStatus")
    def sdk_support_status(self) -> Optional[pulumi.Input['SdkVersionSdkSupportStatus']]:
        """
        The support status for this SDK version.
        """
        return pulumi.get(self, "sdk_support_status")

    @sdk_support_status.setter
    def sdk_support_status(self, value: Optional[pulumi.Input['SdkVersionSdkSupportStatus']]):
        pulumi.set(self, "sdk_support_status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the SDK used to run the job.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="versionDisplayName")
    def version_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A readable string describing the version of the SDK.
        """
        return pulumi.get(self, "version_display_name")

    @version_display_name.setter
    def version_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_display_name", value)


@pulumi.input_type
class SpannerIODetailsArgs:
    def __init__(__self__, *,
                 database_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Metadata for a Spanner connector used by the job.
        :param pulumi.Input[str] database_id: DatabaseId accessed in the connection.
        :param pulumi.Input[str] instance_id: InstanceId accessed in the connection.
        :param pulumi.Input[str] project: ProjectId accessed in the connection.
        """
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        DatabaseId accessed in the connection.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        InstanceId accessed in the connection.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class StageSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 original_transform_or_collection: Optional[pulumi.Input[str]] = None,
                 size_bytes: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Description of an input or output of an execution stage.
        :param pulumi.Input[str] name: Dataflow service generated name for this source.
        :param pulumi.Input[str] original_transform_or_collection: User name for the original user transform or collection with which this source is most closely associated.
        :param pulumi.Input[str] size_bytes: Size of the source, if measurable.
        :param pulumi.Input[str] user_name: Human-readable name for this source; may be user or system generated.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if original_transform_or_collection is not None:
            pulumi.set(__self__, "original_transform_or_collection", original_transform_or_collection)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="originalTransformOrCollection")
    def original_transform_or_collection(self) -> Optional[pulumi.Input[str]]:
        """
        User name for the original user transform or collection with which this source is most closely associated.
        """
        return pulumi.get(self, "original_transform_or_collection")

    @original_transform_or_collection.setter
    def original_transform_or_collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "original_transform_or_collection", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the source, if measurable.
        """
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_bytes", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for this source; may be user or system generated.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class StepArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Defines a particular step within a Cloud Dataflow job. A job consists of multiple steps, each of which performs some specific operation as part of the overall job. Data is typically passed from one step to another as part of the job. **Note:** The properties of this object are not stable and might change. Here's an example of a sequence of steps which together implement a Map-Reduce job: * Read a collection of data from some source, parsing the collection's elements. * Validate the elements. * Apply a user-defined function to map each element to some value and extract an element-specific key value. * Group elements with the same key into a single element with that key, transforming a multiply-keyed collection into a uniquely-keyed collection. * Write the elements out to some data sink. Note that the Cloud Dataflow service may be used to run many different types of jobs, not just Map-Reduce.
        :param pulumi.Input[str] kind: The kind of step in the Cloud Dataflow job.
        :param pulumi.Input[str] name: The name that identifies the step. This must be unique for each step with respect to all other steps in the Cloud Dataflow job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Named properties associated with the step. Each kind of predefined step has its own required set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of step in the Cloud Dataflow job.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name that identifies the step. This must be unique for each step with respect to all other steps in the Cloud Dataflow job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Named properties associated with the step. Each kind of predefined step has its own required set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class TaskRunnerSettingsArgs:
    def __init__(__self__, *,
                 alsologtostderr: Optional[pulumi.Input[bool]] = None,
                 base_task_dir: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 commandlines_file_name: Optional[pulumi.Input[str]] = None,
                 continue_on_exception: Optional[pulumi.Input[bool]] = None,
                 dataflow_api_version: Optional[pulumi.Input[str]] = None,
                 harness_command: Optional[pulumi.Input[str]] = None,
                 language_hint: Optional[pulumi.Input[str]] = None,
                 log_dir: Optional[pulumi.Input[str]] = None,
                 log_to_serialconsole: Optional[pulumi.Input[bool]] = None,
                 log_upload_location: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parallel_worker_settings: Optional[pulumi.Input['WorkerSettingsArgs']] = None,
                 streaming_worker_main_class: Optional[pulumi.Input[str]] = None,
                 task_group: Optional[pulumi.Input[str]] = None,
                 task_user: Optional[pulumi.Input[str]] = None,
                 temp_storage_prefix: Optional[pulumi.Input[str]] = None,
                 vm_id: Optional[pulumi.Input[str]] = None,
                 workflow_file_name: Optional[pulumi.Input[str]] = None):
        """
        Taskrunner configuration settings.
        :param pulumi.Input[bool] alsologtostderr: Whether to also send taskrunner log info to stderr.
        :param pulumi.Input[str] base_task_dir: The location on the worker for task-specific subdirectories.
        :param pulumi.Input[str] base_url: The base URL for the taskrunner to use when accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        :param pulumi.Input[str] commandlines_file_name: The file to store preprocessing commands in.
        :param pulumi.Input[bool] continue_on_exception: Whether to continue taskrunner if an exception is hit.
        :param pulumi.Input[str] dataflow_api_version: The API version of endpoint, e.g. "v1b3"
        :param pulumi.Input[str] harness_command: The command to launch the worker harness.
        :param pulumi.Input[str] language_hint: The suggested backend language.
        :param pulumi.Input[str] log_dir: The directory on the VM to store logs.
        :param pulumi.Input[bool] log_to_serialconsole: Whether to send taskrunner log info to Google Compute Engine VM serial console.
        :param pulumi.Input[str] log_upload_location: Indicates where to put logs. If this is not specified, the logs will not be uploaded. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
        :param pulumi.Input['WorkerSettingsArgs'] parallel_worker_settings: The settings to pass to the parallel worker harness.
        :param pulumi.Input[str] streaming_worker_main_class: The streaming worker main class name.
        :param pulumi.Input[str] task_group: The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
        :param pulumi.Input[str] task_user: The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
        :param pulumi.Input[str] temp_storage_prefix: The prefix of the resources the taskrunner should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[str] vm_id: The ID string of the VM.
        :param pulumi.Input[str] workflow_file_name: The file to store the workflow in.
        """
        if alsologtostderr is not None:
            pulumi.set(__self__, "alsologtostderr", alsologtostderr)
        if base_task_dir is not None:
            pulumi.set(__self__, "base_task_dir", base_task_dir)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if commandlines_file_name is not None:
            pulumi.set(__self__, "commandlines_file_name", commandlines_file_name)
        if continue_on_exception is not None:
            pulumi.set(__self__, "continue_on_exception", continue_on_exception)
        if dataflow_api_version is not None:
            pulumi.set(__self__, "dataflow_api_version", dataflow_api_version)
        if harness_command is not None:
            pulumi.set(__self__, "harness_command", harness_command)
        if language_hint is not None:
            pulumi.set(__self__, "language_hint", language_hint)
        if log_dir is not None:
            pulumi.set(__self__, "log_dir", log_dir)
        if log_to_serialconsole is not None:
            pulumi.set(__self__, "log_to_serialconsole", log_to_serialconsole)
        if log_upload_location is not None:
            pulumi.set(__self__, "log_upload_location", log_upload_location)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if parallel_worker_settings is not None:
            pulumi.set(__self__, "parallel_worker_settings", parallel_worker_settings)
        if streaming_worker_main_class is not None:
            pulumi.set(__self__, "streaming_worker_main_class", streaming_worker_main_class)
        if task_group is not None:
            pulumi.set(__self__, "task_group", task_group)
        if task_user is not None:
            pulumi.set(__self__, "task_user", task_user)
        if temp_storage_prefix is not None:
            pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        if vm_id is not None:
            pulumi.set(__self__, "vm_id", vm_id)
        if workflow_file_name is not None:
            pulumi.set(__self__, "workflow_file_name", workflow_file_name)

    @property
    @pulumi.getter
    def alsologtostderr(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to also send taskrunner log info to stderr.
        """
        return pulumi.get(self, "alsologtostderr")

    @alsologtostderr.setter
    def alsologtostderr(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alsologtostderr", value)

    @property
    @pulumi.getter(name="baseTaskDir")
    def base_task_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The location on the worker for task-specific subdirectories.
        """
        return pulumi.get(self, "base_task_dir")

    @base_task_dir.setter
    def base_task_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_task_dir", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base URL for the taskrunner to use when accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="commandlinesFileName")
    def commandlines_file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file to store preprocessing commands in.
        """
        return pulumi.get(self, "commandlines_file_name")

    @commandlines_file_name.setter
    def commandlines_file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commandlines_file_name", value)

    @property
    @pulumi.getter(name="continueOnException")
    def continue_on_exception(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to continue taskrunner if an exception is hit.
        """
        return pulumi.get(self, "continue_on_exception")

    @continue_on_exception.setter
    def continue_on_exception(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continue_on_exception", value)

    @property
    @pulumi.getter(name="dataflowApiVersion")
    def dataflow_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        The API version of endpoint, e.g. "v1b3"
        """
        return pulumi.get(self, "dataflow_api_version")

    @dataflow_api_version.setter
    def dataflow_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataflow_api_version", value)

    @property
    @pulumi.getter(name="harnessCommand")
    def harness_command(self) -> Optional[pulumi.Input[str]]:
        """
        The command to launch the worker harness.
        """
        return pulumi.get(self, "harness_command")

    @harness_command.setter
    def harness_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "harness_command", value)

    @property
    @pulumi.getter(name="languageHint")
    def language_hint(self) -> Optional[pulumi.Input[str]]:
        """
        The suggested backend language.
        """
        return pulumi.get(self, "language_hint")

    @language_hint.setter
    def language_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_hint", value)

    @property
    @pulumi.getter(name="logDir")
    def log_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The directory on the VM to store logs.
        """
        return pulumi.get(self, "log_dir")

    @log_dir.setter
    def log_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_dir", value)

    @property
    @pulumi.getter(name="logToSerialconsole")
    def log_to_serialconsole(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send taskrunner log info to Google Compute Engine VM serial console.
        """
        return pulumi.get(self, "log_to_serialconsole")

    @log_to_serialconsole.setter
    def log_to_serialconsole(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_to_serialconsole", value)

    @property
    @pulumi.getter(name="logUploadLocation")
    def log_upload_location(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates where to put logs. If this is not specified, the logs will not be uploaded. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "log_upload_location")

    @log_upload_location.setter
    def log_upload_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_upload_location", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="parallelWorkerSettings")
    def parallel_worker_settings(self) -> Optional[pulumi.Input['WorkerSettingsArgs']]:
        """
        The settings to pass to the parallel worker harness.
        """
        return pulumi.get(self, "parallel_worker_settings")

    @parallel_worker_settings.setter
    def parallel_worker_settings(self, value: Optional[pulumi.Input['WorkerSettingsArgs']]):
        pulumi.set(self, "parallel_worker_settings", value)

    @property
    @pulumi.getter(name="streamingWorkerMainClass")
    def streaming_worker_main_class(self) -> Optional[pulumi.Input[str]]:
        """
        The streaming worker main class name.
        """
        return pulumi.get(self, "streaming_worker_main_class")

    @streaming_worker_main_class.setter
    def streaming_worker_main_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "streaming_worker_main_class", value)

    @property
    @pulumi.getter(name="taskGroup")
    def task_group(self) -> Optional[pulumi.Input[str]]:
        """
        The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
        """
        return pulumi.get(self, "task_group")

    @task_group.setter
    def task_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_group", value)

    @property
    @pulumi.getter(name="taskUser")
    def task_user(self) -> Optional[pulumi.Input[str]]:
        """
        The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
        """
        return pulumi.get(self, "task_user")

    @task_user.setter
    def task_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_user", value)

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix of the resources the taskrunner should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @temp_storage_prefix.setter
    def temp_storage_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_storage_prefix", value)

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID string of the VM.
        """
        return pulumi.get(self, "vm_id")

    @vm_id.setter
    def vm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_id", value)

    @property
    @pulumi.getter(name="workflowFileName")
    def workflow_file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The file to store the workflow in.
        """
        return pulumi.get(self, "workflow_file_name")

    @workflow_file_name.setter
    def workflow_file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_file_name", value)


@pulumi.input_type
class TransformSummaryArgs:
    def __init__(__self__, *,
                 display_data: Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 input_collection_name: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input['TransformSummaryKind']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_collection_name: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Description of the type, names/ids, and input/outputs for a transform.
        :param pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]] display_data: Transform-specific display data.
        :param pulumi.Input[str] id: SDK generated id of this transform instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] input_collection_name: User names for all collection inputs to this transform.
        :param pulumi.Input['TransformSummaryKind'] kind: Type of transform.
        :param pulumi.Input[str] name: User provided name for this transform instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] output_collection_name: User names for all collection outputs to this transform.
        """
        if display_data is not None:
            pulumi.set(__self__, "display_data", display_data)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if input_collection_name is not None:
            pulumi.set(__self__, "input_collection_name", input_collection_name)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_collection_name is not None:
            pulumi.set(__self__, "output_collection_name", output_collection_name)

    @property
    @pulumi.getter(name="displayData")
    def display_data(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]]:
        """
        Transform-specific display data.
        """
        return pulumi.get(self, "display_data")

    @display_data.setter
    def display_data(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DisplayDataArgs']]]]):
        pulumi.set(self, "display_data", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        SDK generated id of this transform instance.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="inputCollectionName")
    def input_collection_name(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User names for all collection inputs to this transform.
        """
        return pulumi.get(self, "input_collection_name")

    @input_collection_name.setter
    def input_collection_name(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "input_collection_name", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['TransformSummaryKind']]:
        """
        Type of transform.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['TransformSummaryKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        User provided name for this transform instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputCollectionName")
    def output_collection_name(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User names for all collection outputs to this transform.
        """
        return pulumi.get(self, "output_collection_name")

    @output_collection_name.setter
    def output_collection_name(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "output_collection_name", value)


@pulumi.input_type
class WorkerPoolArgs:
    def __init__(__self__, *,
                 worker_harness_container_image: pulumi.Input[str],
                 autoscaling_settings: Optional[pulumi.Input['AutoscalingSettingsArgs']] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]] = None,
                 default_package_set: Optional[pulumi.Input['WorkerPoolDefaultPackageSet']] = None,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 disk_source_image: Optional[pulumi.Input[str]] = None,
                 disk_type: Optional[pulumi.Input[str]] = None,
                 ip_configuration: Optional[pulumi.Input['WorkerPoolIpConfiguration']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 num_threads_per_worker: Optional[pulumi.Input[int]] = None,
                 num_workers: Optional[pulumi.Input[int]] = None,
                 on_host_maintenance: Optional[pulumi.Input[str]] = None,
                 packages: Optional[pulumi.Input[Sequence[pulumi.Input['PackageArgs']]]] = None,
                 pool_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sdk_harness_container_images: Optional[pulumi.Input[Sequence[pulumi.Input['SdkHarnessContainerImageArgs']]]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 taskrunner_settings: Optional[pulumi.Input['TaskRunnerSettingsArgs']] = None,
                 teardown_policy: Optional[pulumi.Input['WorkerPoolTeardownPolicy']] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Describes one particular pool of Cloud Dataflow workers to be instantiated by the Cloud Dataflow service in order to perform the computations required by a job. Note that a workflow job may use multiple pools, in order to match the various computational requirements of the various stages of the job.
        :param pulumi.Input[str] worker_harness_container_image: Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.
        :param pulumi.Input['AutoscalingSettingsArgs'] autoscaling_settings: Settings for autoscaling of this WorkerPool.
        :param pulumi.Input[Sequence[pulumi.Input['DiskArgs']]] data_disks: Data disks that are used by a VM in this workflow.
        :param pulumi.Input['WorkerPoolDefaultPackageSet'] default_package_set: The default package set to install. This allows the service to select a default set of packages which are useful to worker harnesses written in a particular language.
        :param pulumi.Input[int] disk_size_gb: Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        :param pulumi.Input[str] disk_source_image: Fully qualified source image for disks.
        :param pulumi.Input[str] disk_type: Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a reasonable default.
        :param pulumi.Input['WorkerPoolIpConfiguration'] ip_configuration: Configuration for VM IPs.
        :param pulumi.Input[str] kind: The kind of the worker pool; currently only `harness` and `shuffle` are supported.
        :param pulumi.Input[str] machine_type: Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to choose a reasonable default.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata to set on the Google Compute Engine VMs.
        :param pulumi.Input[str] network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param pulumi.Input[int] num_threads_per_worker: The number of threads per worker harness. If empty or unspecified, the service will choose a number of threads (according to the number of cores on the selected machine type for batch, or 1 by convention for streaming).
        :param pulumi.Input[int] num_workers: Number of Google Compute Engine workers in this pool needed to execute the job. If zero or unspecified, the service will attempt to choose a reasonable default.
        :param pulumi.Input[str] on_host_maintenance: The action to take on host maintenance, as defined by the Google Compute Engine API.
        :param pulumi.Input[Sequence[pulumi.Input['PackageArgs']]] packages: Packages to be installed on workers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pool_args: Extra arguments for this worker pool.
        :param pulumi.Input[Sequence[pulumi.Input['SdkHarnessContainerImageArgs']]] sdk_harness_container_images: Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn API path. For non-cross-language pipelines this should have only one entry. Cross-language pipelines will have two or more entries.
        :param pulumi.Input[str] subnetwork: Subnetwork to which VMs will be assigned, if desired. Expected to be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param pulumi.Input['TaskRunnerSettingsArgs'] taskrunner_settings: Settings passed through to Google Compute Engine workers when using the standard Dataflow task runner. Users should ignore this field.
        :param pulumi.Input['WorkerPoolTeardownPolicy'] teardown_policy: Sets the policy for determining when to turndown worker pool. Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn down. If the workers are not torn down by the service, they will continue to run and use Google Compute Engine VM resources in the user's project until they are explicitly terminated by the user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small, manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a reasonable default.
        :param pulumi.Input[str] zone: Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        if worker_harness_container_image is not None:
            warnings.warn("""Required. Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.""", DeprecationWarning)
            pulumi.log.warn("""worker_harness_container_image is deprecated: Required. Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.""")
        pulumi.set(__self__, "worker_harness_container_image", worker_harness_container_image)
        if autoscaling_settings is not None:
            pulumi.set(__self__, "autoscaling_settings", autoscaling_settings)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if default_package_set is not None:
            pulumi.set(__self__, "default_package_set", default_package_set)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_source_image is not None:
            pulumi.set(__self__, "disk_source_image", disk_source_image)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if num_threads_per_worker is not None:
            pulumi.set(__self__, "num_threads_per_worker", num_threads_per_worker)
        if num_workers is not None:
            pulumi.set(__self__, "num_workers", num_workers)
        if on_host_maintenance is not None:
            pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        if packages is not None:
            pulumi.set(__self__, "packages", packages)
        if pool_args is not None:
            pulumi.set(__self__, "pool_args", pool_args)
        if sdk_harness_container_images is not None:
            pulumi.set(__self__, "sdk_harness_container_images", sdk_harness_container_images)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if taskrunner_settings is not None:
            pulumi.set(__self__, "taskrunner_settings", taskrunner_settings)
        if teardown_policy is not None:
            pulumi.set(__self__, "teardown_policy", teardown_policy)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="workerHarnessContainerImage")
    def worker_harness_container_image(self) -> pulumi.Input[str]:
        """
        Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.
        """
        return pulumi.get(self, "worker_harness_container_image")

    @worker_harness_container_image.setter
    def worker_harness_container_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "worker_harness_container_image", value)

    @property
    @pulumi.getter(name="autoscalingSettings")
    def autoscaling_settings(self) -> Optional[pulumi.Input['AutoscalingSettingsArgs']]:
        """
        Settings for autoscaling of this WorkerPool.
        """
        return pulumi.get(self, "autoscaling_settings")

    @autoscaling_settings.setter
    def autoscaling_settings(self, value: Optional[pulumi.Input['AutoscalingSettingsArgs']]):
        pulumi.set(self, "autoscaling_settings", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]]:
        """
        Data disks that are used by a VM in this workflow.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="defaultPackageSet")
    def default_package_set(self) -> Optional[pulumi.Input['WorkerPoolDefaultPackageSet']]:
        """
        The default package set to install. This allows the service to select a default set of packages which are useful to worker harnesses written in a particular language.
        """
        return pulumi.get(self, "default_package_set")

    @default_package_set.setter
    def default_package_set(self, value: Optional[pulumi.Input['WorkerPoolDefaultPackageSet']]):
        pulumi.set(self, "default_package_set", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="diskSourceImage")
    def disk_source_image(self) -> Optional[pulumi.Input[str]]:
        """
        Fully qualified source image for disks.
        """
        return pulumi.get(self, "disk_source_image")

    @disk_source_image.setter
    def disk_source_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_source_image", value)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['WorkerPoolIpConfiguration']]:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['WorkerPoolIpConfiguration']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of the worker pool; currently only `harness` and `shuffle` are supported.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata to set on the Google Compute Engine VMs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="numThreadsPerWorker")
    def num_threads_per_worker(self) -> Optional[pulumi.Input[int]]:
        """
        The number of threads per worker harness. If empty or unspecified, the service will choose a number of threads (according to the number of cores on the selected machine type for batch, or 1 by convention for streaming).
        """
        return pulumi.get(self, "num_threads_per_worker")

    @num_threads_per_worker.setter
    def num_threads_per_worker(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_threads_per_worker", value)

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Google Compute Engine workers in this pool needed to execute the job. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "num_workers")

    @num_workers.setter
    def num_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_workers", value)

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take on host maintenance, as defined by the Google Compute Engine API.
        """
        return pulumi.get(self, "on_host_maintenance")

    @on_host_maintenance.setter
    def on_host_maintenance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "on_host_maintenance", value)

    @property
    @pulumi.getter
    def packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PackageArgs']]]]:
        """
        Packages to be installed on workers.
        """
        return pulumi.get(self, "packages")

    @packages.setter
    def packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PackageArgs']]]]):
        pulumi.set(self, "packages", value)

    @property
    @pulumi.getter(name="poolArgs")
    def pool_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Extra arguments for this worker pool.
        """
        return pulumi.get(self, "pool_args")

    @pool_args.setter
    def pool_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pool_args", value)

    @property
    @pulumi.getter(name="sdkHarnessContainerImages")
    def sdk_harness_container_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SdkHarnessContainerImageArgs']]]]:
        """
        Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn API path. For non-cross-language pipelines this should have only one entry. Cross-language pipelines will have two or more entries.
        """
        return pulumi.get(self, "sdk_harness_container_images")

    @sdk_harness_container_images.setter
    def sdk_harness_container_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SdkHarnessContainerImageArgs']]]]):
        pulumi.set(self, "sdk_harness_container_images", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Subnetwork to which VMs will be assigned, if desired. Expected to be of the form "regions/REGION/subnetworks/SUBNETWORK".
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter(name="taskrunnerSettings")
    def taskrunner_settings(self) -> Optional[pulumi.Input['TaskRunnerSettingsArgs']]:
        """
        Settings passed through to Google Compute Engine workers when using the standard Dataflow task runner. Users should ignore this field.
        """
        return pulumi.get(self, "taskrunner_settings")

    @taskrunner_settings.setter
    def taskrunner_settings(self, value: Optional[pulumi.Input['TaskRunnerSettingsArgs']]):
        pulumi.set(self, "taskrunner_settings", value)

    @property
    @pulumi.getter(name="teardownPolicy")
    def teardown_policy(self) -> Optional[pulumi.Input['WorkerPoolTeardownPolicy']]:
        """
        Sets the policy for determining when to turndown worker pool. Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn down. If the workers are not torn down by the service, they will continue to run and use Google Compute Engine VM resources in the user's project until they are explicitly terminated by the user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small, manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "teardown_policy")

    @teardown_policy.setter
    def teardown_policy(self, value: Optional[pulumi.Input['WorkerPoolTeardownPolicy']]):
        pulumi.set(self, "teardown_policy", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class WorkerSettingsArgs:
    def __init__(__self__, *,
                 base_url: Optional[pulumi.Input[str]] = None,
                 reporting_enabled: Optional[pulumi.Input[bool]] = None,
                 service_path: Optional[pulumi.Input[str]] = None,
                 shuffle_service_path: Optional[pulumi.Input[str]] = None,
                 temp_storage_prefix: Optional[pulumi.Input[str]] = None,
                 worker_id: Optional[pulumi.Input[str]] = None):
        """
        Provides data to pass through to the worker harness.
        :param pulumi.Input[str] base_url: The base URL for accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        :param pulumi.Input[bool] reporting_enabled: Whether to send work progress updates to the service.
        :param pulumi.Input[str] service_path: The Cloud Dataflow service path relative to the root URL, for example, "dataflow/v1b3/projects".
        :param pulumi.Input[str] shuffle_service_path: The Shuffle service path relative to the root URL, for example, "shuffle/v1beta1".
        :param pulumi.Input[str] temp_storage_prefix: The prefix of the resources the system should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[str] worker_id: The ID of the worker running this pipeline.
        """
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if reporting_enabled is not None:
            pulumi.set(__self__, "reporting_enabled", reporting_enabled)
        if service_path is not None:
            pulumi.set(__self__, "service_path", service_path)
        if shuffle_service_path is not None:
            pulumi.set(__self__, "shuffle_service_path", shuffle_service_path)
        if temp_storage_prefix is not None:
            pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        if worker_id is not None:
            pulumi.set(__self__, "worker_id", worker_id)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base URL for accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="reportingEnabled")
    def reporting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to send work progress updates to the service.
        """
        return pulumi.get(self, "reporting_enabled")

    @reporting_enabled.setter
    def reporting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reporting_enabled", value)

    @property
    @pulumi.getter(name="servicePath")
    def service_path(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Dataflow service path relative to the root URL, for example, "dataflow/v1b3/projects".
        """
        return pulumi.get(self, "service_path")

    @service_path.setter
    def service_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_path", value)

    @property
    @pulumi.getter(name="shuffleServicePath")
    def shuffle_service_path(self) -> Optional[pulumi.Input[str]]:
        """
        The Shuffle service path relative to the root URL, for example, "shuffle/v1beta1".
        """
        return pulumi.get(self, "shuffle_service_path")

    @shuffle_service_path.setter
    def shuffle_service_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shuffle_service_path", value)

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix of the resources the system should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @temp_storage_prefix.setter
    def temp_storage_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "temp_storage_prefix", value)

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the worker running this pipeline.
        """
        return pulumi.get(self, "worker_id")

    @worker_id.setter
    def worker_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_id", value)


