# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetTagKeyResult',
    'AwaitableGetTagKeyResult',
    'get_tag_key',
    'get_tag_key_output',
]

@pulumi.output_type
class GetTagKeyResult:
    def __init__(__self__, create_time=None, description=None, etag=None, name=None, namespaced_name=None, parent=None, purpose=None, purpose_data=None, short_name=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespaced_name and not isinstance(namespaced_name, str):
            raise TypeError("Expected argument 'namespaced_name' to be a str")
        pulumi.set(__self__, "namespaced_name", namespaced_name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if purpose and not isinstance(purpose, str):
            raise TypeError("Expected argument 'purpose' to be a str")
        pulumi.set(__self__, "purpose", purpose)
        if purpose_data and not isinstance(purpose_data, dict):
            raise TypeError("Expected argument 'purpose_data' to be a dict")
        pulumi.set(__self__, "purpose_data", purpose_data)
        if short_name and not isinstance(short_name, str):
            raise TypeError("Expected argument 'short_name' to be a str")
        pulumi.set(__self__, "short_name", short_name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-assigned description of the TagKey. Must not exceed 256 characters. Read-write.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        Optional. Entity tag which users can pass to prevent race conditions. This field is always set in server responses. See UpdateTagKeyRequest for details.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name for a TagKey. Must be in the format `tagKeys/{tag_key_id}`, where `tag_key_id` is the generated numeric id for the TagKey.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespacedName")
    def namespaced_name(self) -> str:
        """
        Immutable. Namespaced name of the TagKey.
        """
        return pulumi.get(self, "namespaced_name")

    @property
    @pulumi.getter
    def parent(self) -> str:
        """
        Immutable. The resource name of the new TagKey's parent. Must be of the form `organizations/{org_id}`.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def purpose(self) -> str:
        """
        Optional. A purpose denotes that this Tag is intended for use in policies of a specific policy engine, and will involve that policy engine in management operations involving this Tag. A purpose does not grant a policy engine exclusive rights to the Tag, and it may be referenced by other policy engines. A purpose cannot be changed once set.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="purposeData")
    def purpose_data(self) -> Mapping[str, str]:
        """
        Optional. Purpose data corresponds to the policy system that the tag is intended for. See documentation for `Purpose` for formatting of this field. Purpose data cannot be changed once set.
        """
        return pulumi.get(self, "purpose_data")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> str:
        """
        Immutable. The user friendly name for a TagKey. The short name should be unique for TagKeys within the same tag namespace. The short name must be 1-63 characters, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "short_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Update time.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetTagKeyResult(GetTagKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagKeyResult(
            create_time=self.create_time,
            description=self.description,
            etag=self.etag,
            name=self.name,
            namespaced_name=self.namespaced_name,
            parent=self.parent,
            purpose=self.purpose,
            purpose_data=self.purpose_data,
            short_name=self.short_name,
            update_time=self.update_time)


def get_tag_key(tag_key_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagKeyResult:
    """
    Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the key does not exist or the user does not have permission to view it.
    """
    __args__ = dict()
    __args__['tagKeyId'] = tag_key_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:cloudresourcemanager/v3:getTagKey', __args__, opts=opts, typ=GetTagKeyResult).value

    return AwaitableGetTagKeyResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        etag=__ret__.etag,
        name=__ret__.name,
        namespaced_name=__ret__.namespaced_name,
        parent=__ret__.parent,
        purpose=__ret__.purpose,
        purpose_data=__ret__.purpose_data,
        short_name=__ret__.short_name,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_tag_key)
def get_tag_key_output(tag_key_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTagKeyResult]:
    """
    Retrieves a TagKey. This method will return `PERMISSION_DENIED` if the key does not exist or the user does not have permission to view it.
    """
    ...
